/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.schema.tools.processing.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.util.XSDParser;
import org.teiid.designer.schema.tools.ToolsPlugin;
import org.teiid.designer.schema.tools.model.schema.QName;
import org.teiid.designer.schema.tools.model.schema.SchemaModel;
import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.model.schema.impl.AttributeColumn;
import org.teiid.designer.schema.tools.model.schema.impl.ElementImpl;
import org.teiid.designer.schema.tools.model.schema.impl.SchemaModelImpl;
import org.teiid.designer.schema.tools.model.schema.impl.TextColumn;
import org.teiid.designer.schema.tools.model.schema.impl.TypeDefinition;
import org.teiid.designer.schema.tools.processing.SchemaProcessingException;
import org.teiid.designer.schema.tools.processing.SchemaProcessor;
import org.teiid.designer.schema.tools.processing.SchemaUtil;
import org.teiid.designer.schema.tools.processing.internal.ElementContentTraversalContext;

public class SchemaProcessorImpl
implements SchemaProcessor {
    private Map namespaces;
    private HashMap duplicateNamespaceFilter;
    private ArrayList elements;
    public ElementContentTraversalContext traverseCtx;
    private boolean representTypes = false;
    private String separator;

    public SchemaProcessorImpl(String separator) {
        this.separator = separator;
        this.clear();
    }

    @Override
    public void clear() {
        this.namespaces = new HashMap();
        this.duplicateNamespaceFilter = new HashMap();
        this.elements = new ArrayList();
        this.traverseCtx = new ElementContentTraversalContext(null, null);
    }

    @Override
    public void processSchemas(XSDSchema[] schemas) throws SchemaProcessingException {
        XSDSchema schema;
        int i = 0;
        while (i < schemas.length) {
            schema = schemas[i];
            this.processSchemaRootElements(schema, this.traverseCtx);
            ++i;
        }
        i = 0;
        while (i < schemas.length) {
            schema = schemas[i];
            this.processSchema(schema, this.traverseCtx);
            ++i;
        }
    }

    @Override
    public void processSchemaURIs(List schemaURIs) throws SchemaProcessingException {
        ArrayList<XSDSchema> schemas = new ArrayList<XSDSchema>();
        for (Object o : schemaURIs) {
            URI uri = (URI)o;
            XSDSchema schema = SchemaProcessorImpl.getSchemaFromURI(uri);
            schemas.add(schema);
        }
        XSDSchema[] xsdSchemas = new XSDSchema[schemas.size()];
        schemas.toArray(xsdSchemas);
        this.processSchemas(xsdSchemas);
    }

    public static XSDSchema getSchemaFromURI(URI uri) {
        XSDParser parser = new XSDParser(null);
        String path = null;
        if (uri.scheme() == "ACSResponse" || uri.scheme() == "ACSRequest") {
            String schemaString = uri.fragment();
            parser.parseString(schemaString);
        } else {
            path = uri.toFileString();
            parser.parse(path);
        }
        XSDSchema schema = parser.getSchema();
        if (schema.getSchemaLocation() == null) {
            schema.setSchemaLocation(path);
        }
        return schema;
    }

    private void processSchemaRootElements(XSDSchema schema, ElementContentTraversalContext traverseCtx) {
        for (Object oelem : schema.getElementDeclarations()) {
            XSDElementDeclaration elem = (XSDElementDeclaration)oelem;
            this.addRootElement(elem, traverseCtx);
        }
        for (Object otype : schema.getTypeDefinitions()) {
            XSDTypeDefinition type = (XSDTypeDefinition)otype;
            this.addRootType(type, traverseCtx);
        }
    }

    private void processSchema(XSDSchema schema, ElementContentTraversalContext traverseCtx) throws SchemaProcessingException {
        this.processNamespaces(schema);
        for (Object oelem : schema.getElementDeclarations()) {
            XSDElementDeclaration elem = (XSDElementDeclaration)oelem;
            this.processElement(elem, traverseCtx, schema);
        }
        if (this.representTypes) {
            for (Object otype : schema.getTypeDefinitions()) {
                XSDTypeDefinition type = (XSDTypeDefinition)otype;
                this.processType(type, traverseCtx, schema);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processNamespaces(XSDSchema schema) {
        schemaNamespaces = schema.getQNamePrefixToNamespaceMap();
        for (String key : schemaNamespaces.keySet()) {
            if (key == null || key.trim().equals("")) {
                key = "mmn0";
            }
            if ((value = (String)schemaNamespaces.get(key)) == null) continue;
            if (value.equals("http://www.w3.org/XML/1998/namespace")) {
                key = "xml";
            }
            i = 1;
            if (this.namespaces.get(key) != null && value.equals(this.namespaces.get(key))) continue;
            if (this.duplicateNamespaceFilter.get(value) == null) ** GOTO lbl16
            prefix = (String)this.duplicateNamespaceFilter.get(value);
            if (!prefix.startsWith("mmn")) continue;
            prefix = key;
            continue;
lbl-1000:
            // 1 sources

            {
                key = String.valueOf(key) + i++;
lbl16:
                // 2 sources

                ** while (this.namespaces.get((Object)key) != null)
            }
lbl17:
            // 1 sources

            this.namespaces.put(key, value);
            this.duplicateNamespaceFilter.put(value, key);
        }
        namespace = schema.getTargetNamespace();
        if (namespace != null && this.duplicateNamespaceFilter.get(namespace) == null) {
            if (namespace.equals("http://www.w3.org/XML/1998/namespace")) {
                this.namespaces.put("xml", namespace);
            } else {
                ctr = 0;
                if (this.namespaces.get("mmn" + ctr) != null) {
                    ++ctr;
                }
                this.namespaces.put("mmn" + ctr, namespace);
            }
        }
    }

    private void addRootElement(XSDElementDeclaration elem, ElementContentTraversalContext traverseCtx) {
        String name = elem.getName();
        String namespace = elem.getTargetNamespace();
        if (name == null) {
            return;
        }
        QName qname = SchemaUtil.getQName(namespace, name);
        if (traverseCtx.getGlobalElement(qname) != null) {
            return;
        }
        traverseCtx.putGlobalElement(qname, elem);
    }

    private void addRootType(XSDTypeDefinition type, ElementContentTraversalContext traverseCtx) {
        String name = type.getName();
        String namespace = type.getTargetNamespace();
        if (name == null) {
            return;
        }
        QName qname = SchemaUtil.getQName(namespace, name);
        if (traverseCtx.getGlobalType(qname) != null) {
            return;
        }
        traverseCtx.putGlobalType(qname, type);
    }

    @Override
    public void processType(XSDTypeDefinition type, ElementContentTraversalContext traverseCtx2, XSDSchema schema) throws SchemaProcessingException {
        String namespacePrefix = this.getNameSpacePrefix(type.getTargetNamespace());
        TypeDefinition typeDecl = new TypeDefinition(type, namespacePrefix, schema);
        String fileName = SchemaUtil.shortenFileName(schema.getSchemaLocation());
        typeDecl.setFileName(fileName);
        this.addElement(typeDecl);
        this.processAttributes(typeDecl, this.traverseCtx);
        this.processElementText(typeDecl);
        this.processElementContents(typeDecl, this.traverseCtx);
    }

    @Override
    public void processElement(XSDElementDeclaration elem, ElementContentTraversalContext traverseCtx, XSDSchema schema) throws SchemaProcessingException {
        String name = elem.getName();
        String namespace = elem.getTargetNamespace();
        String fileName = SchemaUtil.shortenFileName(schema.getSchemaLocation());
        XSDElementDeclaration refElem = this.resolveElementRef(elem, traverseCtx);
        if (name == null) {
            if (refElem != elem) {
                this.processElement(refElem, traverseCtx, schema);
                return;
            }
            ToolsPlugin.Util.log(2, ToolsPlugin.Util.getString("SchemaProcessorImpl.nullElement", new Object[0]));
            return;
        }
        if (refElem != null) {
            // empty if block
        }
        XSDTypeDefinition type = this.resolveElementType(elem, traverseCtx);
        QName qname = SchemaUtil.getQName(namespace, name);
        Map tablesForName = traverseCtx.getElementsByNameThenType(qname);
        SchemaObject element = (SchemaObject)tablesForName.get(type);
        if (element == null) {
            element = new ElementImpl(elem, this.getNameSpacePrefix(elem.getTargetNamespace()), type, schema);
            element.setFileName(fileName);
            tablesForName.put(type, element);
            this.addElement(element);
            this.processAttributes(element, traverseCtx);
            this.processElementText(element);
            this.processElementContents(element, traverseCtx);
        }
        int minOccurs = traverseCtx.calculateMinOccurs(1);
        int maxOccurs = traverseCtx.calculateMaxOccurs(1);
        element.addParent(traverseCtx.getParentTable(), minOccurs, maxOccurs);
    }

    public void addElement(SchemaObject element) {
        this.elements.add(element);
    }

    public XSDElementDeclaration resolveElementRef(XSDElementDeclaration ref, ElementContentTraversalContext traverseCtx) {
        XSDElementDeclaration elem = ref.getResolvedElementDeclaration();
        String name = elem.getName();
        String namespace = elem.getTargetNamespace();
        QName qname = SchemaUtil.getQName(namespace, name);
        Object oGlobal = traverseCtx.getGlobalElement(qname);
        XSDElementDeclaration retval = oGlobal != null ? (XSDElementDeclaration)oGlobal : elem;
        return retval;
    }

    public XSDTypeDefinition resolveElementType(XSDElementDeclaration elem, ElementContentTraversalContext traverseCtx) throws SchemaProcessingException {
        XSDTypeDefinition type = elem.getType();
        if (type == null) {
            return null;
        }
        return this.resolveType(type, traverseCtx);
    }

    private XSDTypeDefinition resolveType(XSDTypeDefinition type, ElementContentTraversalContext traverseCtx) {
        String name = type.getName();
        String namespace = type.getTargetNamespace();
        QName qname = SchemaUtil.getQName(namespace, name);
        Object oGlobal = traverseCtx.getGlobalType(qname);
        XSDTypeDefinition retval = oGlobal != null ? (XSDTypeDefinition)oGlobal : type;
        return retval;
    }

    public void processAttributes(SchemaObject element, ElementContentTraversalContext traverseCtx) throws SchemaProcessingException {
        List attrs = element.getAttributeList();
        for (Object o : attrs) {
            XSDAttributeUse attrUse = (XSDAttributeUse)o;
            XSDAttributeDeclaration attrDecl = attrUse.getAttributeDeclaration();
            AttributeColumn col = new AttributeColumn(attrDecl, this.getNameSpacePrefix(attrDecl.getTargetNamespace()), false);
            element.addAttribute(col);
        }
    }

    public String getNameSpacePrefix(String targetNamespace) {
        Map namespacePrefixes = this.getNamespacePrefixes();
        return (String)namespacePrefixes.get(targetNamespace);
    }

    public Map getNamespacePrefixes() {
        Map nsMap = this.getNamespaces();
        HashMap returnMap = new HashMap();
        for (String key : nsMap.keySet()) {
            returnMap.put(nsMap.get(key), key);
        }
        return returnMap;
    }

    @Override
    public void processElementText(SchemaObject element) {
        XSDSimpleTypeDefinition textType = element.getTextType();
        if (textType != null) {
            TextColumn col = new TextColumn(false, textType);
            element.addAttribute(col);
        }
    }

    public void processElementContents(SchemaObject element, ElementContentTraversalContext traverseCtx) throws SchemaProcessingException {
        XSDComplexTypeContent content = element.getContent();
        if (content == null || !(content instanceof XSDParticle)) {
            return;
        }
        XSDParticle particle = (XSDParticle)content;
        ElementContentTraversalContext childTraverseCtx = new ElementContentTraversalContext(element, traverseCtx);
        this.processParticle(particle, childTraverseCtx, element.getSchema());
    }

    private void processParticle(XSDParticle particle, ElementContentTraversalContext traverseCtx, XSDSchema schema) throws SchemaProcessingException {
        XSDParticleContent content = particle.getContent();
        int min = particle.getMinOccurs();
        int max = particle.getMaxOccurs();
        traverseCtx.addMinOccurs(new Integer(min));
        traverseCtx.addMaxOccurs(new Integer(max));
        if (content instanceof XSDElementDeclaration) {
            XSDElementDeclaration elem = (XSDElementDeclaration)content;
            this.processElement(elem, traverseCtx, schema);
        } else if (content instanceof XSDModelGroup) {
            XSDModelGroup group = (XSDModelGroup)content;
            this.processGroup(group, traverseCtx, schema);
        } else if (content instanceof XSDModelGroupDefinition) {
            XSDModelGroup group;
            XSDModelGroupDefinition groupDef = (XSDModelGroupDefinition)content;
            XSDModelGroupDefinition resolvedGroup = groupDef.getResolvedModelGroupDefinition();
            XSDModelGroup xSDModelGroup = group = resolvedGroup == null ? null : resolvedGroup.getModelGroup();
            if (group != null) {
                this.processGroup(group, traverseCtx, schema);
            }
        } else if (!(content instanceof XSDTerm)) {
            boolean cfr_ignored_0 = content instanceof XSDWildcard;
        }
        traverseCtx.removeMinOccurs(traverseCtx.minOccurs.size() - 1);
        traverseCtx.removeMaxOccurs(traverseCtx.maxOccurs.size() - 1);
    }

    private void processGroup(XSDModelGroup group, ElementContentTraversalContext traverseCtx, XSDSchema schema) throws SchemaProcessingException {
        int min;
        int compositor = group.getCompositor().getValue();
        switch (compositor) {
            case 0: {
                min = 0;
                break;
            }
            case 1: {
                min = 0;
                break;
            }
            case 2: {
                min = 1;
                break;
            }
            default: {
                min = 1;
            }
        }
        traverseCtx.addMinOccurs(new Integer(min));
        traverseCtx.addMaxOccurs(new Integer(1));
        EList particles = group.getParticles();
        for (Object o : particles) {
            XSDParticle particle = (XSDParticle)o;
            this.processParticle(particle, traverseCtx, schema);
        }
        traverseCtx.removeMinOccurs(traverseCtx.minOccurs.size() - 1);
        traverseCtx.removeMaxOccurs(traverseCtx.maxOccurs.size() - 1);
    }

    @Override
    public Map getNamespaces() {
        return this.namespaces;
    }

    @Override
    public SchemaModel getSchemaModel() {
        SchemaModelImpl model = new SchemaModelImpl(this.elements, this.namespaces, this.separator);
        model.setTypeAware(this.representTypes);
        return model;
    }

    @Override
    public void representTypes(boolean representTypes) {
        this.representTypes = representTypes;
    }

    @Override
    public void setNamespaces(Map namespaces) {
        this.namespaces = namespaces;
    }
}

