/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.panels;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.teiidimporter.ui.Messages;

public class AddGeneralPropertyDialog
extends MessageDialog {
    private Button btnOk;
    private final Set<String> existingNames;
    private String name;
    private String value;

    public AddGeneralPropertyDialog(Shell parentShell, Set<String> existingPropertyNames) {
        super(parentShell, Messages.AddGeneralPropertyDialog_title, null, Messages.AddGeneralPropertyDialog_message, 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.existingNames = existingPropertyNames == null ? new HashSet<String>(0) : existingPropertyNames;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.btnOk = btn;
            btn.setEnabled(false);
        }
        return btn;
    }

    protected Control createCustomArea(Composite parent) {
        Composite pnl = new Composite(parent, 0);
        pnl.setLayout((Layout)new GridLayout(2, false));
        pnl.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblName = new Label(pnl, 0);
        lblName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblName.setText(Messages.AddGeneralPropertyDialog_lblName_text);
        Text txtName = new Text(pnl, 2048);
        txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        txtName.setToolTipText(Messages.AddGeneralPropertyDialog_txtName_toolTip);
        txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddGeneralPropertyDialog.this.handleNameChanged(((Text)e.widget).getText());
            }
        });
        Label lblValue = new Label(pnl, 0);
        lblValue.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblValue.setText(Messages.AddGeneralPropertyDialog_lblValue_text);
        Text txtValue = new Text(pnl, 2048);
        txtValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        txtValue.setToolTipText(Messages.AddGeneralPropertyDialog_txtValue_toolTip);
        txtValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddGeneralPropertyDialog.this.handleValueChanged(((Text)e.widget).getText());
            }
        });
        return pnl;
    }

    public String getName() {
        CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
        return this.name;
    }

    public String getValue() {
        CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
        return this.value;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    void handleNameChanged(String newName) {
        this.name = newName;
        this.updateState();
    }

    void handleValueChanged(String newValue) {
        this.value = newValue.trim();
        this.updateState();
    }

    private void updateState() {
        String msg = this.validateName();
        if (StringUtilities.isEmpty((String)msg)) {
            msg = this.validateValue();
        }
        if (StringUtilities.isEmpty((String)msg)) {
            if (!this.btnOk.isEnabled()) {
                this.btnOk.setEnabled(true);
            }
            if (this.imageLabel.getImage() != null) {
                this.imageLabel.setImage(null);
            }
            this.imageLabel.setImage(this.getInfoImage());
            msg = Messages.AddGeneralPropertyDialog_message;
        } else {
            if (this.btnOk.isEnabled()) {
                this.btnOk.setEnabled(false);
            }
            this.imageLabel.setImage(this.getErrorImage());
        }
        this.messageLabel.setText(msg);
        this.messageLabel.pack();
    }

    private String validateName() {
        String errorMsg = AddGeneralPropertyDialog.validateName(this.name);
        if (errorMsg == null) {
            for (String existingName : this.existingNames) {
                if (!existingName.equals(this.name)) continue;
                errorMsg = NLS.bind((String)Messages.AddGeneralPropertyDialog_customPropertyAlreadyExists, (Object)this.name);
                break;
            }
        }
        return errorMsg;
    }

    private String validateValue() {
        return AddGeneralPropertyDialog.validateValue(this.value);
    }

    public static String validateName(String proposedName) {
        if (StringUtilities.isEmpty((String)proposedName)) {
            return Messages.AddGeneralPropertyDialog_emptyPropertyName;
        }
        char[] cArray = proposedName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!AddGeneralPropertyDialog.isValidChar(c)) {
                return Messages.AddGeneralPropertyDialog_invalidPropertyName;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isValidChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '.';
    }

    public static String validateValue(String proposedValue) {
        if (StringUtilities.isEmpty((String)proposedValue)) {
            return Messages.AddGeneralPropertyDialog_emptyPropertyValue;
        }
        return null;
    }
}

