/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.panels;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.teiidimporter.ui.Messages;
import org.teiid.designer.teiidimporter.ui.UiConstants;
import org.teiid.designer.teiidimporter.ui.panels.CreateDataSourcePanelListener;
import org.teiid.designer.teiidimporter.ui.panels.DataSourceDriversPanel;
import org.teiid.designer.teiidimporter.ui.panels.DataSourceManager;
import org.teiid.designer.teiidimporter.ui.panels.DataSourcePanelListener;
import org.teiid.designer.teiidimporter.ui.panels.DataSourcePropertiesPanel;
import org.teiid.designer.teiidimporter.ui.panels.DataSourcePropertiesPanelListener;
import org.teiid.designer.teiidimporter.ui.wizard.ITeiidImportServer;
import org.teiid.designer.ui.common.util.WidgetFactory;

public final class CreateDataSourcePanel
extends Composite
implements UiConstants,
Listener,
DataSourcePanelListener,
DataSourcePropertiesPanelListener {
    private ITeiidImportServer teiidImportServer;
    private DataSourceManager dataSourceManager;
    private StringNameValidator nameValidator;
    private Text dataSourceNameText;
    private String dataSourceName;
    private DataSourceDriversPanel driversPanel;
    private DataSourcePropertiesPanel propertiesPanel;
    private IStatus panelStatus;
    private List<CreateDataSourcePanelListener> listeners = new ArrayList<CreateDataSourcePanelListener>();
    private List<String> existingSourceNames = new ArrayList<String>();
    private String editDSName;
    private boolean isCreateNew = false;

    public CreateDataSourcePanel(Composite parent, ITeiidImportServer teiidImportServer, String editDSName) {
        super(parent, 0);
        this.teiidImportServer = teiidImportServer;
        this.dataSourceManager = new DataSourceManager(teiidImportServer);
        this.nameValidator = new StringNameValidator(new char[]{'_', '-'});
        this.editDSName = editDSName;
        if (this.editDSName != null) {
            this.dataSourceName = editDSName;
            this.isCreateNew = false;
        } else {
            this.isCreateNew = true;
        }
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(4, 4, true, true));
        this.initExistingDataSourceNames(teiidImportServer);
        this.createDataSourceNamePanel(this);
        if (this.isCreateNew) {
            this.createDataSourceDriversPanel(this, 5);
        }
        this.createDataSourcePropertiesGroup(this);
        if (this.isCreateNew) {
            this.driversPanel.addListener(this.propertiesPanel);
            this.driversPanel.addListener(this);
        }
        this.propertiesPanel.addListener(this);
    }

    private void initExistingDataSourceNames(ITeiidImportServer teiidImportServer) {
        this.existingSourceNames.clear();
        try {
            Collection<ITeiidDataSource> sources = teiidImportServer.getDataSources();
            for (ITeiidDataSource source : sources) {
                this.existingSourceNames.add(source.getName());
            }
        }
        catch (Exception ex) {
            UTIL.log((Throwable)ex);
        }
    }

    private void createDataSourceNamePanel(Composite parent) {
        Composite namePanel = new Composite(parent, 0);
        namePanel.setLayout((Layout)new GridLayout(2, false));
        namePanel.setLayoutData((Object)new GridData(768));
        Label dsNameLabel = new Label(namePanel, 0);
        dsNameLabel.setText(Messages.createDataSourcePanel_name);
        this.dataSourceNameText = new Text(namePanel, 2052);
        this.dataSourceNameText.setLayoutData((Object)new GridData(768));
        if (this.editDSName != null) {
            this.dataSourceNameText.setText(this.editDSName);
            this.dataSourceNameText.setBackground(Display.getCurrent().getSystemColor(19));
            this.dataSourceNameText.setEditable(false);
        }
        this.dataSourceNameText.addListener(24, (Listener)this);
        if (!this.isCreateNew) {
            Label dsDriverLabel = new Label(namePanel, 0);
            dsDriverLabel.setText(Messages.createDataSourcePanel_driver);
            Text dataSourceDriverText = new Text(namePanel, 2052);
            dataSourceDriverText.setLayoutData((Object)new GridData(768));
            dataSourceDriverText.setText(this.getDataSourceDriverName());
            dataSourceDriverText.setBackground(Display.getCurrent().getSystemColor(19));
            dataSourceDriverText.setEditable(false);
        }
    }

    private void createDataSourceDriversPanel(Composite parent, int visibleTableRows) {
        Group dsDriversGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.createDataSourcePanel_driversGroupTxt, (int)0);
        dsDriversGroup.setLayoutData((Object)new GridData(768));
        this.driversPanel = new DataSourceDriversPanel((Composite)dsDriversGroup, visibleTableRows, this.teiidImportServer);
        this.driversPanel.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(4, 4, true, true);
        gData.horizontalSpan = 1;
        this.driversPanel.setLayoutData(gData);
    }

    private void createDataSourcePropertiesGroup(Composite parent) {
        Group dsPropertiesGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.createDataSourcePanel_dataSourcePropertiesGroupTxt, (int)0);
        GridData propertiesGridData = new GridData(4, 4, true, true);
        propertiesGridData.heightHint = 250;
        propertiesGridData.minimumHeight = 250;
        dsPropertiesGroup.setLayoutData((Object)propertiesGridData);
        this.propertiesPanel = new DataSourcePropertiesPanel((Composite)dsPropertiesGroup, this.teiidImportServer, false, this.isCreateNew, this.editDSName);
        this.propertiesPanel.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(1);
        gData.horizontalSpan = 1;
        this.propertiesPanel.setLayoutData(gData);
    }

    public void handleEvent(Event event) {
        this.dataSourceName = this.dataSourceNameText.getText();
        this.updateStatus();
        this.fireStateChanged();
    }

    public void addListener(CreateDataSourcePanelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(CreateDataSourcePanelListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void fireStateChanged() {
        for (CreateDataSourcePanelListener listener : this.listeners) {
            listener.stateChanged();
        }
    }

    @Override
    public void selectionChanged(String selectedDriverName) {
        this.propertiesPanel.setDataSourceOrDriverName(selectedDriverName);
        this.updateStatus();
        this.fireStateChanged();
    }

    public IStatus getStatus() {
        return this.panelStatus;
    }

    private void updateStatus() {
        this.panelStatus = this.validateName();
        if (this.panelStatus.isOK()) {
            if (this.isCreateNew) {
                this.panelStatus = this.driversPanel.getStatus();
            }
            if (this.panelStatus.isOK()) {
                this.panelStatus = this.propertiesPanel.getStatus();
                if (this.panelStatus.isOK()) {
                    this.panelStatus = new Status(0, PLUGIN_ID, Messages.createDataSourcePanelOk);
                }
            }
        }
    }

    private IStatus validateName() {
        String dsName = this.dataSourceNameText.getText();
        if (dsName == null || dsName.isEmpty()) {
            return new Status(4, PLUGIN_ID, Messages.createDataSourcePanelErrorNameEmpty);
        }
        if (this.isCreateNew && this.existingSourceNames.contains(dsName)) {
            return new Status(4, PLUGIN_ID, Messages.createDataSourcePanelErrorNameExists);
        }
        if (!this.nameValidator.isValidName(dsName)) {
            return new Status(4, PLUGIN_ID, Messages.errorNameInvalid);
        }
        return new Status(0, PLUGIN_ID, Messages.createDataSourcePanelOk);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getDataSourceDriverName() {
        if (this.isCreateNew) {
            return this.driversPanel.getSelectedDriverName();
        }
        return this.dataSourceManager.getDataSourceDriver(this.editDSName, null);
    }

    public Properties getDataSourceProperties() {
        return this.propertiesPanel.getDataSourceProperties();
    }

    public boolean hasPropertyChanges() {
        return this.propertiesPanel.hasPropertyChanges();
    }

    @Override
    public void propertyChanged() {
        this.updateStatus();
        this.fireStateChanged();
    }
}

