/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.panels;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.teiidimporter.ui.panels.DataSourcePropertiesPanel;
import org.teiid.designer.teiidimporter.ui.panels.PropertyItem;

public class DataSourcePropertyEditingSupport
extends EditingSupport {
    private DataSourcePropertiesPanel propertyPanel;
    protected CellEditor currentEditor;
    private String[] allowedValues;
    private ICellEditorValidator validator;

    public DataSourcePropertyEditingSupport(ColumnViewer viewer, DataSourcePropertiesPanel propertyPanel) {
        super(viewer);
        this.propertyPanel = propertyPanel;
    }

    protected boolean canAddNewValue(Object element) {
        return false;
    }

    protected boolean canEdit(Object element) {
        return ((PropertyItem)element).isModifiable();
    }

    protected CellEditor getCellEditor(Object element) {
        this.allowedValues = this.refreshItems(element);
        if (this.allowedValues != null && this.allowedValues.length == 0) {
            this.allowedValues = null;
        }
        if (this.allowedValues == null) {
            PropertyItem pItem = (PropertyItem)element;
            this.currentEditor = pItem.isPassword() ? new TextCellEditor((Composite)this.getViewer().getControl(), 0x400004) : new TextCellEditor((Composite)this.getViewer().getControl(), 4);
            if (this.validator != null) {
                this.currentEditor.setValidator(this.validator);
            }
        } else {
            int style = this.canAddNewValue(element) ? 0 : 8;
            ComboBoxCellEditor comboEditor = new ComboBoxCellEditor((Composite)this.getViewer().getControl(), new String[0], style);
            comboEditor.setItems(this.allowedValues);
            this.currentEditor = comboEditor;
        }
        return this.currentEditor;
    }

    protected String getElementValue(Object element) {
        PropertyItem property = (PropertyItem)element;
        String value = property.getValue();
        if (StringUtilities.isEmpty((String)value)) {
            return property.getDefaultValue();
        }
        return value;
    }

    protected Object getValue(Object element) {
        String value = this.getElementValue(element);
        if (value == null) {
            value = "";
        }
        if (this.allowedValues == null) {
            return value;
        }
        int i = 0;
        while (i < this.allowedValues.length) {
            if (value.equals(this.allowedValues[i])) {
                return i;
            }
            ++i;
        }
        String[] temp = new String[this.allowedValues.length + 1];
        temp[0] = value;
        System.arraycopy(this.allowedValues, 0, temp, 1, this.allowedValues.length);
        this.allowedValues = temp;
        ((ComboBoxCellEditor)this.currentEditor).setItems(this.allowedValues);
        return 0;
    }

    protected String[] refreshItems(Object element) {
        return null;
    }

    protected void setElementValue(Object element, String newValue) {
        PropertyItem property = (PropertyItem)element;
        String currentValue = property.getValue();
        boolean doIt = false;
        if (StringUtilities.isEmpty((String)newValue)) {
            if (!StringUtilities.isEmpty((String)currentValue)) {
                doIt = true;
            }
        } else {
            String defaultValue = property.getDefaultValue();
            if (StringUtilities.isEmpty((String)currentValue)) {
                if (StringUtilities.isEmpty((String)defaultValue) || !defaultValue.equals(newValue)) {
                    doIt = true;
                }
            } else if (!newValue.equals(currentValue)) {
                doIt = true;
                if (!StringUtilities.isEmpty((String)defaultValue) && defaultValue.equals(newValue)) {
                    newValue = null;
                }
            }
        }
        if (doIt) {
            property.setValue(newValue);
            this.getViewer().setSelection((ISelection)new StructuredSelection(element));
            this.propertyPanel.firePropertyChanged();
        }
    }

    protected void setValue(Object element, Object value) {
        int index;
        String newValue = value instanceof Integer ? ((index = ((Integer)value).intValue()) == -1 ? ((CCombo)((ComboBoxCellEditor)this.currentEditor).getControl()).getText() : this.allowedValues[index]) : (String)value;
        this.setElementValue(element, newValue);
        this.getViewer().refresh();
    }

    public void setValidator(ICellEditorValidator validator) {
        this.validator = validator;
    }
}

