/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.panels;

import java.util.Collection;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.teiidimporter.ui.UiConstants;

public class TranslatorHelper
implements UiConstants {
    public static final String VENDOR_KEY = "org.eclipse.datatools.connectivity.db.vendor";
    public static final String VERSION_KEY = "org.eclipse.datatools.connectivity.db.version";
    public static final String GOOGLE_SOURCE_PROPERTY_KEY_AUTH_METHOD = "AuthMethod";
    public static final String GOOGLE_SOURCE_PROPERTY_VALUE_AUTH_CLIENT_LOGIN = "ClientLogin";
    public static final String GOOGLE_SOURCE_PROPERTY_VALUE_AUTH_OAUTH2 = "OAuth2";
    public static final String GOOGLE_SOURCE_PROPERTY_KEY_REFRESH_TOKEN = "RefreshToken";
    public static final String GOOGLE_SOURCE_PROPERTY_KEY_USERNAME = "Username";
    public static final String GOOGLE_SOURCE_PROPERTY_KEY_PASSWORD = "Password";
    public static final String TEIID_FILE_DRIVER = "teiid-connector-file.rar";
    public static final String TEIID_GOOGLE_DRIVER = "teiid-connector-google.rar";
    public static final String TEIID_INFINISPAN_DRIVER = "teiid-connector-infinispan.rar";
    public static final String TEIID_LDAP_DRIVER = "teiid-connector-ldap.rar";
    public static final String TEIID_SALESORCE_DRIVER = "teiid-connector-salesforce.rar";
    public static final String TEIID_WEBSERVICE_DRIVER = "teiid-connector-ws.rar";
    public static final String TEIID_FILE_DRIVER_84UP = "file";
    public static final String TEIID_GOOGLE_DRIVER_84UP = "google";
    public static final String TEIID_INFINISPAN_DRIVER_84UP = "infinispan";
    public static final String TEIID_LDAP_DRIVER_84UP = "ldap";
    public static final String TEIID_SALESORCE_DRIVER_84UP = "salesforce";
    public static final String TEIID_WEBSERVICE_DRIVER_84UP = "webservice";
    public static final String TEIID_MONGODB_DRIVER_84UP = "mongodb";
    public static final String TEIID_FILE_DRIVER_DISPLAYNAME = "FlatFile";
    public static final String TEIID_GOOGLE_DRIVER_DISPLAYNAME = "Google";
    public static final String TEIID_INFINISPAN_DRIVER_DISPLAYNAME = "Infinispan";
    public static final String TEIID_LDAP_DRIVER_DISPLAYNAME = "LDAP";
    public static final String TEIID_SALESORCE_DRIVER_DISPLAYNAME = "Salesforce";
    public static final String TEIID_WEBSERVICE_DRIVER_DISPLAYNAME = "WebService";
    public static final String TEIID_GOOGLE_CLASS = "org.teiid.resource.adapter.google.SpreadsheetManagedConnectionFactory";
    public static final String ACCESS = "access";
    public static final String DB2 = "db2";
    public static final String DERBY = "derby";
    public static final String FILE = "file";
    public static final String GOOGLE_SPREADSHEET = "google-spreadsheet";
    public static final String H2 = "h2";
    public static final String HIVE = "hive";
    public static final String HSQL = "hsql";
    public static final String INFINISPAN = "infinispan-cache";
    public static final String INFORMIX = "informix";
    public static final String INGRES = "ingres";
    public static final String INGRES93 = "ingres93";
    public static final String INTERSYSTEMS_CACHE = "intersystems-cache";
    public static final String JDBC_ANSI = "jdbc-ansi";
    public static final String JDBC_SIMPLE = "jdbc-simple";
    public static final String JPA2 = "jpa2";
    public static final String LDAP = "ldap";
    public static final String LOOPBACK = "loopback";
    public static final String MAP_CACHE = "map-cache";
    public static final String METAMATRIX = "metamatrix";
    public static final String MODESHAPE = "modeshape";
    public static final String MONGODB = "mongodb";
    public static final String MYSQL = "mysql";
    public static final String MYSQL5 = "mysql5";
    public static final String NETEZZA = "netezza";
    public static final String OLAP = "olap";
    public static final String ORACLE = "oracle";
    public static final String POSTGRES = "postgres";
    public static final String POSTGRESQL = "postgresql";
    public static final String SALESFORCE = "salesforce";
    public static final String SQLSERVER = "sqlserver";
    public static final String SYBASE = "sybase";
    public static final String TEIID = "teiid";
    public static final String TERADATA = "teradata";
    public static final String WS = "ws";
    public static final String URL_DB2 = "jdbc:db2://<host>:50000/<dbName>";
    public static final String URL_DERBY = "jdbc:derby://<host>:1527/<dbName>;create=true";
    public static final String URL_INFORMIX = "jdbc:informix-sqli://<host>:1526/<dbName>:INFORMIXSERVER=server";
    public static final String URL_INGRES = "jdbc:ingres://<host>:117/<dbName>";
    public static final String URL_MODESHAPE = "jdbc:jcr:http://<host>:8080/modeshape-rest/";
    public static final String URL_MYSQL = "jdbc:mysql://<host>:3306/<dbName>";
    public static final String URL_ORACLETHIN = "jdbc:oracle:thin:@<host>:1521:<dbName>";
    public static final String URL_POSTGRES = "jdbc:postgresql://<host>:5432/<dbName>";
    public static final String URL_SQLSERVER = "jdbc:sqlserver://<host>:1433;databaseName=<dbName>";
    public static final String URL_TEIID = "jdbc:teiid:<vdbName>@mms://<host>:31000";
    public static final String URL_JDBC = "jdbc://<host>:<port>";
    public static final String URL_SAP_HANA = "jdbc:sap://<host>:3<instance number>15";

    public static String getTranslator(String driverName, Collection<String> translatorNames, ITeiidServerVersion teiidVersion) {
        String driverNameLC;
        CoreArgCheck.isNotEmpty((String)driverName, (String)"driverName is Empty");
        CoreArgCheck.isNotEmpty(translatorNames, (String)"translatorNames is Empty");
        boolean isTeiid84OrHigher = TranslatorHelper.isTeiid84OrHigher(teiidVersion);
        if (!isTeiid84OrHigher) {
            if (driverName.equals(TEIID_FILE_DRIVER) && translatorNames.contains("file")) {
                return "file";
            }
            if (driverName.equals(TEIID_GOOGLE_DRIVER) && translatorNames.contains(GOOGLE_SPREADSHEET)) {
                return GOOGLE_SPREADSHEET;
            }
            if (driverName.equals(TEIID_INFINISPAN_DRIVER) && translatorNames.contains(INFINISPAN)) {
                return INFINISPAN;
            }
            if (driverName.equals(TEIID_LDAP_DRIVER) && translatorNames.contains("ldap")) {
                return "ldap";
            }
            if (driverName.equals(TEIID_SALESORCE_DRIVER) && translatorNames.contains("salesforce")) {
                return "salesforce";
            }
            if (driverName.equals(TEIID_WEBSERVICE_DRIVER) && translatorNames.contains(WS)) {
                return WS;
            }
        } else {
            if (driverName.equals("file") && translatorNames.contains("file")) {
                return "file";
            }
            if (driverName.equals(TEIID_GOOGLE_DRIVER_84UP) && translatorNames.contains(GOOGLE_SPREADSHEET)) {
                return GOOGLE_SPREADSHEET;
            }
            if (driverName.equals(TEIID_INFINISPAN_DRIVER_84UP) && translatorNames.contains(INFINISPAN)) {
                return INFINISPAN;
            }
            if (driverName.equals("ldap") && translatorNames.contains("ldap")) {
                return "ldap";
            }
            if (driverName.equals("salesforce") && translatorNames.contains("salesforce")) {
                return "salesforce";
            }
            if (driverName.equals(TEIID_WEBSERVICE_DRIVER_84UP) && translatorNames.contains(WS)) {
                return WS;
            }
            if (driverName.equals("mongodb") && translatorNames.contains("mongodb")) {
                return "mongodb";
            }
        }
        if ((driverNameLC = driverName.toLowerCase()).startsWith(DERBY)) {
            return DERBY;
        }
        if (driverNameLC.startsWith(MYSQL)) {
            return MYSQL;
        }
        if (driverNameLC.startsWith("ojdbc")) {
            return ORACLE;
        }
        if (driverNameLC.startsWith(DB2)) {
            return DB2;
        }
        if (driverNameLC.startsWith(POSTGRESQL)) {
            return POSTGRESQL;
        }
        if (driverNameLC.startsWith("sqljdbc")) {
            return SQLSERVER;
        }
        if (driverNameLC.startsWith(TEIID)) {
            return TEIID;
        }
        if (driverNameLC.startsWith(MODESHAPE)) {
            return MODESHAPE;
        }
        if (driverNameLC.startsWith("ifxjdbc")) {
            return INFORMIX;
        }
        if (driverNameLC.startsWith("iijdbc")) {
            return INGRES;
        }
        if (driverNameLC.startsWith("jconn")) {
            return SYBASE;
        }
        if (driverNameLC.contains(HIVE)) {
            return HIVE;
        }
        return JDBC_ANSI;
    }

    public static boolean isTeiid84OrHigher(ITeiidServerVersion teiidVersion) {
        block5: {
            String major;
            block4: {
                CoreArgCheck.isNotNull((Object)teiidVersion, (String)"teiidVersion is null");
                try {
                    major = teiidVersion.getMajor();
                    if (Integer.parseInt(major) > 7) break block4;
                    return false;
                }
                catch (Exception e) {
                    UTIL.log((Throwable)e);
                    return false;
                }
            }
            if (Integer.parseInt(major) < 9) break block5;
            return true;
        }
        String minor = teiidVersion.getMinor();
        return Integer.parseInt(minor) >= 4;
    }

    public static String getUrlTemplate(String driverName) {
        CoreArgCheck.isNotEmpty((String)driverName, (String)"driverName is Empty");
        if (driverName.startsWith(DERBY)) {
            return URL_DERBY;
        }
        if (driverName.startsWith(MYSQL)) {
            return URL_MYSQL;
        }
        if (driverName.startsWith("ojdbc")) {
            return URL_ORACLETHIN;
        }
        if (driverName.startsWith(DB2)) {
            return URL_DB2;
        }
        if (driverName.startsWith(POSTGRESQL)) {
            return URL_POSTGRES;
        }
        if (driverName.startsWith("sqljdbc")) {
            return URL_SQLSERVER;
        }
        if (driverName.startsWith("ifxjdbc")) {
            return URL_INFORMIX;
        }
        if (driverName.startsWith("iijdbc")) {
            return URL_INGRES;
        }
        if (driverName.startsWith(TEIID)) {
            return URL_TEIID;
        }
        if (driverName.startsWith(MODESHAPE)) {
            return URL_MODESHAPE;
        }
        if (driverName.startsWith("sap") || driverName.contains("ngdbc")) {
            return URL_SAP_HANA;
        }
        return URL_JDBC;
    }

    public static String getTranslator(IConnectionProfile connectionProfile) {
        Properties baseProps = connectionProfile.getBaseProperties();
        String providerId = connectionProfile.getProviderId();
        if (providerId != null) {
            if (providerId.equalsIgnoreCase("org.teiid.designer.datatools.salesforce.connectionProfile")) {
                return "salesforce";
            }
            if (providerId.equalsIgnoreCase("org.teiid.designer.datatools.profiles.ldap.LDAPConnectionProfile")) {
                return "ldap";
            }
        }
        String vendor = baseProps.getProperty(VENDOR_KEY);
        String version = baseProps.getProperty(VERSION_KEY);
        if (vendor != null) {
            if (vendor.toUpperCase().startsWith(INFORMIX.toUpperCase())) {
                return INFORMIX;
            }
            if (vendor.toUpperCase().startsWith(ORACLE.toUpperCase())) {
                return ORACLE;
            }
            if (vendor.toUpperCase().startsWith("SQL SERVER".toUpperCase())) {
                return SQLSERVER;
            }
            if (vendor.toUpperCase().startsWith(DERBY.toUpperCase())) {
                return DERBY;
            }
            if (vendor.toUpperCase().startsWith(POSTGRES.toUpperCase())) {
                return POSTGRESQL;
            }
            if (vendor.toUpperCase().startsWith(SYBASE.toUpperCase())) {
                return SYBASE;
            }
            if (vendor.toUpperCase().startsWith(TEIID.toUpperCase())) {
                return TEIID;
            }
            if (vendor.toUpperCase().startsWith(DB2.toUpperCase())) {
                return DB2;
            }
            if (vendor.toUpperCase().startsWith(MYSQL.toUpperCase())) {
                if (version != null && version.startsWith("5")) {
                    return MYSQL5;
                }
                return MYSQL;
            }
        }
        return JDBC_SIMPLE;
    }
}

