/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.runtime.spi.ITeiidDataSource;
import org.teiid.designer.teiidimporter.ui.Messages;
import org.teiid.designer.teiidimporter.ui.UiConstants;
import org.teiid.designer.teiidimporter.ui.wizard.ITeiidImportServer;

public class CopyDataSourceDialog
extends TitleAreaDialog
implements Listener,
UiConstants {
    private Text dataSourceNameText;
    private String newSourceName;
    private Collection<String> existingSourceNames = new ArrayList<String>();
    private StringNameValidator nameValidator;

    public CopyDataSourceDialog(Shell shell, ITeiidImportServer teiidImportServer) {
        super(shell);
        this.initExistingDataSourceNames(teiidImportServer);
        this.nameValidator = new StringNameValidator(new char[]{'_', '-'});
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.copyDataSourceDialog_title);
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite pnl = new Composite(parent, 0);
        pnl.setLayout((Layout)new GridLayout(1, false));
        pnl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDataSourceNamePanel(pnl);
        this.setTitle(Messages.copyDataSourceDialog_title);
        this.setErrorMessage(Messages.copyDataSourceDialogErrorNameEmpty);
        return pnl;
    }

    private void createDataSourceNamePanel(Composite parent) {
        Composite namePanel = new Composite(parent, 0);
        namePanel.setLayout((Layout)new GridLayout(2, false));
        namePanel.setLayoutData((Object)new GridData(768));
        Label dsNameLabel = new Label(namePanel, 0);
        dsNameLabel.setText(Messages.createDataSourcePanel_name);
        this.dataSourceNameText = new Text(namePanel, 2052);
        this.dataSourceNameText.setLayoutData((Object)new GridData(768));
        this.dataSourceNameText.addListener(24, (Listener)this);
    }

    private void initExistingDataSourceNames(ITeiidImportServer teiidImportServer) {
        this.existingSourceNames.clear();
        try {
            Collection<ITeiidDataSource> sources = teiidImportServer.getDataSources();
            for (ITeiidDataSource source : sources) {
                this.existingSourceNames.add(source.getName());
            }
        }
        catch (Exception ex) {
            UTIL.log((Throwable)ex);
        }
    }

    public void handleEvent(Event event) {
        this.updateStatus();
    }

    public String getNewDataSourceName() {
        assert (this.getReturnCode() == 0);
        return this.newSourceName;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    private void updateStatus() {
        this.newSourceName = this.dataSourceNameText.getText();
        IStatus status = this.validateName();
        if (status.isOK()) {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(status.getMessage());
        } else {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(status.getMessage());
        }
    }

    private IStatus validateName() {
        if (CoreStringUtil.isEmpty((String)this.newSourceName)) {
            return new Status(4, PLUGIN_ID, Messages.copyDataSourceDialogErrorNameEmpty);
        }
        if (this.existingSourceNames.contains(this.newSourceName)) {
            return new Status(4, PLUGIN_ID, Messages.copyDataSourceDialogErrorNameExists);
        }
        if (!this.nameValidator.isValidName(this.newSourceName)) {
            return new Status(4, PLUGIN_ID, Messages.errorNameInvalid);
        }
        return new Status(0, PLUGIN_ID, Messages.copyDataSourceDialogOk);
    }
}

