/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.wizard;

import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.teiidimporter.ui.Messages;
import org.teiid.designer.teiidimporter.ui.panels.CreateDataSourcePanel;
import org.teiid.designer.teiidimporter.ui.panels.CreateDataSourcePanelListener;
import org.teiid.designer.teiidimporter.ui.wizard.ITeiidImportServer;

public class CreateDataSourceDialog
extends TitleAreaDialog
implements CreateDataSourcePanelListener {
    private ITeiidImportServer teiidImportServer;
    private CreateDataSourcePanel createDataSourcePanel;
    private String editDSName;

    public CreateDataSourceDialog(Shell shell, ITeiidImportServer teiidImportServer, String editDSName) {
        super(shell);
        this.teiidImportServer = teiidImportServer;
        this.editDSName = editDSName;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (CoreStringUtil.isEmpty((String)this.editDSName)) {
            shell.setText(Messages.createDataSourceDialog_title);
        } else {
            shell.setText(Messages.editDataSourceDialog_title);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        if (CoreStringUtil.isEmpty((String)this.editDSName)) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
        return buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite pnl = new Composite(parent, 0);
        pnl.setLayout((Layout)new GridLayout(1, false));
        pnl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createDataSourcePanel = new CreateDataSourcePanel(pnl, this.teiidImportServer, this.editDSName);
        this.createDataSourcePanel.addListener(this);
        if (CoreStringUtil.isEmpty((String)this.editDSName)) {
            this.setTitle(Messages.createDataSourceDialog_title);
            this.setErrorMessage(Messages.createDataSourcePanelErrorNameEmpty);
        } else {
            this.setTitle(Messages.editDataSourceDialog_title);
            this.setMessage(Messages.editDataSourcePanelEnterChanges);
        }
        return pnl;
    }

    public String getDataSourceName() {
        assert (this.getReturnCode() == 0);
        return this.createDataSourcePanel.getDataSourceName();
    }

    public String getDataSourceDriverName() {
        assert (this.getReturnCode() == 0);
        return this.createDataSourcePanel.getDataSourceDriverName();
    }

    public Properties getDataSourceProperties() {
        assert (this.getReturnCode() == 0);
        return this.createDataSourcePanel.getDataSourceProperties();
    }

    public boolean hasPropertyChanges() {
        assert (this.getReturnCode() == 0);
        return this.createDataSourcePanel.hasPropertyChanges();
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    private void updateState() {
        IStatus status = this.createDataSourcePanel.getStatus();
        if (status.isOK()) {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
            this.setMessage(status.getMessage());
        } else {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(status.getMessage());
        }
    }

    @Override
    public void stateChanged() {
        this.updateState();
    }
}

