/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.teiidimporter.ui.Messages;
import org.teiid.designer.teiidimporter.ui.UiConstants;
import org.teiid.designer.teiidimporter.ui.panels.DataSourcePanel;
import org.teiid.designer.teiidimporter.ui.panels.DataSourcePanelListener;
import org.teiid.designer.teiidimporter.ui.panels.DataSourcePropertiesPanel;
import org.teiid.designer.teiidimporter.ui.wizard.TeiidImportManager;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.DefaultScrolledComposite;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;

public class SelectDataSourcePage
extends AbstractWizardPage
implements UiConstants,
DataSourcePanelListener {
    private static final String EMPTY_STR = "";
    private static final String SERVER_PREFIX = "Default Server: ";
    private static final List<String> DISALLOWED_SOURCES = new ArrayList<String>();
    private static final List<String> BUILTIN_TYPES;
    private TeiidImportManager importManager;
    private DataSourcePropertiesPanel propertiesPanel;
    private DataSourcePanel dataSourcePanel;

    static {
        DISALLOWED_SOURCES.add("ldap");
        DISALLOWED_SOURCES.add("mongodb");
        DISALLOWED_SOURCES.add("modeshape");
        BUILTIN_TYPES = new ArrayList<String>();
        BUILTIN_TYPES.add("file");
        BUILTIN_TYPES.add("google");
        BUILTIN_TYPES.add("infinispan");
        BUILTIN_TYPES.add("ldap");
        BUILTIN_TYPES.add("modeshape");
        BUILTIN_TYPES.add("mongodb");
        BUILTIN_TYPES.add("salesforce");
        BUILTIN_TYPES.add("solr");
        BUILTIN_TYPES.add("teiid");
        BUILTIN_TYPES.add("teiid-local");
        BUILTIN_TYPES.add("webservice");
    }

    public SelectDataSourcePage(TeiidImportManager importManager) {
        super(SelectDataSourcePage.class.getSimpleName(), Messages.selectDataSourcePage_title);
        this.importManager = importManager;
    }

    public void createControl(Composite theParent) {
        String serverString;
        Composite hostPanel = new Composite(theParent, 0);
        hostPanel.setLayoutData((Object)new GridData(768));
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        DefaultScrolledComposite scrolledComposite = new DefaultScrolledComposite(hostPanel, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        GridLayoutFactory.fillDefaults().equalWidth(false).applyTo((Composite)scrolledComposite);
        GridDataFactory.fillDefaults().grab(true, false);
        Composite pnl = scrolledComposite.getPanel();
        pnl.setLayoutData((Object)new GridData(768));
        pnl.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)hostPanel);
        if (!this.importManager.isValidImportServer()) {
            this.setErrorMessage(Messages.selectDataSourcePage_InvalidServerMsg);
            this.setPageComplete(false);
            return;
        }
        Label serverNameLabel = new Label(pnl, 0);
        try {
            serverString = this.importManager.getDisplayName();
        }
        catch (Exception exception) {
            serverString = "Unknown";
        }
        serverNameLabel.setText(SERVER_PREFIX + serverString);
        serverNameLabel.setForeground(Display.getCurrent().getSystemColor(10));
        Font bannerFont = JFaceResources.getBannerFont();
        serverNameLabel.setFont(bannerFont);
        Group infoGroup = WidgetFactory.createGroup((Composite)pnl, (String)"Importer Description", (int)2, (int)2);
        GridLayoutFactory.fillDefaults().margins(3, 2).applyTo((Composite)infoGroup);
        infoGroup.setLayoutData((Object)new GridData(768));
        Text infoText = new Text((Composite)infoGroup, 72);
        infoText.setText(Messages.selectDataSourcePage_help);
        infoText.setBackground(Display.getCurrent().getSystemColor(19));
        infoText.setForeground(Display.getCurrent().getSystemColor(10));
        GridData gd = new GridData(768);
        gd.heightHint = 39;
        gd.horizontalSpan = 1;
        infoText.setLayoutData((Object)gd);
        this.createDataSourcesGroup(pnl);
        this.createDataSourceDetailsGroup(pnl);
        this.dataSourcePanel.addListener(this.propertiesPanel);
        this.dataSourcePanel.addListener(this);
        scrolledComposite.sizeScrolledPanel();
        this.validatePage();
    }

    private void createDataSourcesGroup(Composite parent) {
        Group dataSourcesGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.selectDataSourcePage_dataSourceGroupText, (int)0);
        dataSourcesGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        ((GridData)dataSourcesGroup.getLayoutData()).heightHint = 180;
        int visibleRows = 5;
        this.dataSourcePanel = new DataSourcePanel((Composite)dataSourcesGroup, visibleRows, this.importManager);
    }

    private void createDataSourceDetailsGroup(Composite parent) {
        Group dsPropertiesGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.selectDataSourcePage_dataSourcePropertiesGroupText, (int)0);
        dsPropertiesGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.propertiesPanel = new DataSourcePropertiesPanel((Composite)dsPropertiesGroup, this.importManager, true, false, null);
        this.propertiesPanel.setLayout((Layout)new GridLayout(1, false));
        GridData gData = new GridData(1);
        gData.horizontalSpan = 1;
        this.propertiesPanel.setLayoutData(gData);
    }

    private String getSelectedDataSourceName() {
        return this.importManager.getDataSourceName();
    }

    private String getSelectedDataSourceDriverName() {
        return this.importManager.getDataSourceDriverName();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.getControl().setVisible(visible);
        } else {
            super.setVisible(visible);
        }
    }

    private boolean validatePage() {
        String driverNameLC;
        String selectedDataSource = this.getSelectedDataSourceName();
        if (selectedDataSource == null || selectedDataSource.trim().isEmpty()) {
            this.setThisPageComplete(Messages.selectDataSourcePage_NoSourceSelectedMsg, 3);
            return false;
        }
        String selectedDataSourceDriverName = this.getSelectedDataSourceDriverName();
        if (!CoreStringUtil.isEmpty((String)selectedDataSourceDriverName) && !BUILTIN_TYPES.contains(driverNameLC = selectedDataSourceDriverName.toLowerCase())) {
            this.setThisPageComplete(NLS.bind((String)Messages.selectDataSourcePage_ConsiderJDBCImporterForSourceTypeMsg, (Object)driverNameLC), 2);
            return true;
        }
        this.setThisPageComplete(EMPTY_STR, 0);
        return true;
    }

    private void setThisPageComplete(String message, int severity) {
        WizardUtil.setPageComplete((WizardPage)this, (String)message, (int)severity);
    }

    @Override
    public void selectionChanged(String selectedSourceName) {
        boolean dsChanged;
        boolean bl = this.importManager.getDataSourceName() != null ? !this.importManager.getDataSourceName().equals(this.dataSourcePanel.getSelectedDataSourceName()) : (dsChanged = true);
        if (dsChanged) {
            this.importManager.setTranslatorName(null);
        }
        this.importManager.setDataSourceName(this.dataSourcePanel.getSelectedDataSourceName());
        this.importManager.setDataSourceJndiName(this.dataSourcePanel.getSelectedDataSourceJndiName());
        this.importManager.setDataSourceDriverName(this.dataSourcePanel.getSelectedDataSourceDriver());
        this.importManager.setDataSourceProperties(this.propertiesPanel.getDataSourceProperties());
        this.validatePage();
    }
}

