/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.translators.TranslatorOverrideProperty;
import org.teiid.designer.runtime.spi.ITeiidTranslator;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.teiidimporter.ui.Messages;
import org.teiid.designer.teiidimporter.ui.UiConstants;
import org.teiid.designer.teiidimporter.ui.panels.ImportPropertiesPanel;
import org.teiid.designer.teiidimporter.ui.panels.TranslatorHelper;
import org.teiid.designer.teiidimporter.ui.wizard.TeiidImportManager;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.DefaultScrolledComposite;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.viewsupport.TranslatorOverridePropertyEditingSupport;
import org.teiid.designer.ui.viewsupport.TranslatorPropertyLabelProvider;

public class SelectTranslatorPage
extends AbstractWizardPage
implements UiConstants {
    private static final String EMPTY_STR = "";
    private static final String SERVER_PREFIX = "Default Server: ";
    private TeiidImportManager importManager;
    private Text dataSourceNameText;
    private Text dataSourceDriverText;
    private Collection<String> translatorNames = new ArrayList<String>();
    private Combo translatorNameCombo;
    private TableViewerBuilder propertiesViewerBuilder;

    public SelectTranslatorPage(TeiidImportManager importManager) {
        super(SelectTranslatorPage.class.getSimpleName(), Messages.SelectTranslatorPage_title);
        this.importManager = importManager;
    }

    public void createControl(Composite theParent) {
        String serverString;
        Composite hostPanel = new Composite(theParent, 0);
        hostPanel.setLayoutData((Object)new GridData(768));
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        DefaultScrolledComposite scrolledComposite = new DefaultScrolledComposite(hostPanel, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        GridLayoutFactory.fillDefaults().equalWidth(false).applyTo((Composite)scrolledComposite);
        GridDataFactory.fillDefaults().grab(true, false);
        Composite mainPanel = scrolledComposite.getPanel();
        mainPanel.setLayoutData((Object)new GridData(768));
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)hostPanel);
        if (!this.importManager.isValidImportServer()) {
            this.setErrorMessage(Messages.selectDataSourcePage_InvalidServerMsg);
            this.setPageComplete(false);
            return;
        }
        Label serverNameLabel = new Label(mainPanel, 0);
        try {
            serverString = this.importManager.getDisplayName();
        }
        catch (Exception exception) {
            serverString = "Unknown";
        }
        serverNameLabel.setText(SERVER_PREFIX + serverString);
        serverNameLabel.setForeground(Display.getCurrent().getSystemColor(10));
        Font bannerFont = JFaceResources.getBannerFont();
        serverNameLabel.setFont(bannerFont);
        this.createDataSourceAndTranslatorPanel(mainPanel);
        this.createImportPropertiesPanel(mainPanel);
        new ImportPropertiesPanel(mainPanel, this.importManager);
        scrolledComposite.sizeScrolledPanel();
        this.validatePage();
    }

    private void createDataSourceAndTranslatorPanel(Composite parent) {
        Group sourceGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.SelectTranslatorPage_SrcDefnGroup, (int)0, (int)1, (int)2);
        sourceGroup.setLayoutData((Object)new GridData(768));
        Label dsNameLabel = new Label((Composite)sourceGroup, 0);
        dsNameLabel.setText(Messages.SelectTranslatorPage_dsNameLabel);
        this.dataSourceNameText = new Text((Composite)sourceGroup, 2052);
        this.dataSourceNameText.setLayoutData((Object)new GridData(768));
        String dsName = this.importManager.getDataSourceName();
        if (dsName != null) {
            this.dataSourceNameText.setText(dsName);
        }
        this.dataSourceNameText.setBackground(Display.getCurrent().getSystemColor(19));
        this.dataSourceNameText.setEditable(false);
        Label dsDriverLabel = new Label((Composite)sourceGroup, 0);
        dsDriverLabel.setText(Messages.SelectTranslatorPage_dsTypeLabel);
        this.dataSourceDriverText = new Text((Composite)sourceGroup, 2052);
        this.dataSourceDriverText.setLayoutData((Object)new GridData(768));
        String dsDriver = this.importManager.getDataSourceDriverName();
        if (dsDriver != null) {
            this.dataSourceDriverText.setText(dsDriver);
        }
        this.dataSourceDriverText.setBackground(Display.getCurrent().getSystemColor(19));
        this.dataSourceDriverText.setEditable(false);
        Label translatorLabel = new Label((Composite)sourceGroup, 0);
        translatorLabel.setText(Messages.SelectTranslatorPage_translatorLabel);
        this.refreshTranslators();
        this.translatorNameCombo = WidgetFactory.createCombo((Composite)sourceGroup, (int)8, (int)768, (Object[])this.translatorNames.toArray());
        this.translatorNameCombo.setVisibleItemCount(8);
        this.translatorNameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectTranslatorPage.this.handleTranslatorChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createImportPropertiesPanel(Composite parent) {
        Group mainPanel = WidgetFactory.createGroup((Composite)parent, (String)Messages.SelectTranslatorPage_importPropertiesLabel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainPanel);
        Composite pnlOverrides = new Composite((Composite)mainPanel, 4);
        pnlOverrides.setLayout((Layout)new GridLayout(1, false));
        pnlOverrides.setLayoutData((Object)new GridData(4, 4, true, true));
        this.propertiesViewerBuilder = new TableViewerBuilder(pnlOverrides, 68352);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.propertiesViewerBuilder.getTableViewer());
        this.propertiesViewerBuilder.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                TranslatorOverrideProperty[] props;
                TranslatorOverrideProperty[] translatorOverridePropertyArray = props = SelectTranslatorPage.this.importManager.getTranslatorOverride().getProperties();
                int n = props.length;
                int n2 = 0;
                while (n2 < n) {
                    TranslatorOverrideProperty top = translatorOverridePropertyArray[n2];
                    if (top.getDefinition().getId().equalsIgnoreCase("importer.TableTypes")) {
                        if (top.getOverriddenValue() == null) {
                            top.setValue("TABLE");
                        }
                    } else if (top.getDefinition().getId().equalsIgnoreCase("importer.UseQualifiedName") && (top.getOverriddenValue() == null || top.getOverriddenValue().equalsIgnoreCase(Boolean.toString(true)))) {
                        top.setValue("false");
                    }
                    ++n2;
                }
                return SelectTranslatorPage.this.importManager.getTranslatorOverride().getProperties();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.propertiesViewerBuilder.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TranslatorOverrideProperty prop1 = (TranslatorOverrideProperty)e1;
                TranslatorOverrideProperty prop2 = (TranslatorOverrideProperty)e2;
                return super.compare(viewer, (Object)prop1.getDefinition().getDisplayName(), (Object)prop2.getDefinition().getDisplayName());
            }
        });
        TableViewerColumn column = this.propertiesViewerBuilder.createColumn(16384, 70, 100, true);
        column.getColumn().setText("Property");
        column.setLabelProvider((CellLabelProvider)new TranslatorPropertyLabelProvider(true));
        column = this.propertiesViewerBuilder.createColumn(16384, 30, 100, true);
        column.getColumn().setText("Value");
        column.setLabelProvider((CellLabelProvider)new TranslatorPropertyLabelProvider(false));
        column.setEditingSupport((EditingSupport)new ImportPropertyEditingSupport((ColumnViewer)this.propertiesViewerBuilder.getTableViewer()));
        Composite toolbarPanel = WidgetFactory.createPanel((Composite)pnlOverrides, (int)0, (int)2, (int)1, (int)1);
        org.teiid.designer.ui.common.widget.Label noteLabel = WidgetFactory.createLabel((Composite)toolbarPanel, (String)"Note: See Teiid documentation for details on importer properties");
        noteLabel.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)noteLabel);
    }

    private String getInitialTranslatorSelection() {
        if (this.importManager.getTranslatorName() != null) {
            return this.importManager.getTranslatorName();
        }
        String driverName = this.importManager.getDataSourceDriverName();
        if (this.translatorNames.isEmpty() || CoreStringUtil.isEmpty((String)driverName)) {
            return null;
        }
        ITeiidServerVersion teiidVersion = null;
        try {
            teiidVersion = this.importManager.getTeiidServerVersion();
        }
        catch (Exception ex) {
            UTIL.log((Throwable)ex);
        }
        return TranslatorHelper.getTranslator(driverName, this.translatorNames, teiidVersion);
    }

    private void refreshTranslators() {
        try {
            this.translatorNames.clear();
            Collection<ITeiidTranslator> availableTranslators = this.importManager.getTranslators();
            for (ITeiidTranslator translator : availableTranslators) {
                this.translatorNames.add(translator.getName());
            }
        }
        catch (Exception ex) {
            this.translatorNames.clear();
            UTIL.log((Throwable)ex);
        }
    }

    private void handleTranslatorChanged() {
        int selIndex = this.translatorNameCombo.getSelectionIndex();
        String translatorName = this.translatorNameCombo.getItem(selIndex);
        if (!translatorName.equalsIgnoreCase(this.importManager.getTranslatorName())) {
            this.importManager.setTranslatorName(translatorName);
            this.importManager.getOptionalImportProps().clear();
            this.propertiesViewerBuilder.setInput((Object)this);
            this.validatePage();
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            String initialTranslatorSelection;
            String dsName = this.importManager.getDataSourceName();
            String dsType = this.importManager.getDataSourceDriverName();
            if (!StringUtilities.isEmpty((String)dsName)) {
                this.dataSourceNameText.setText(dsName);
            }
            if (!StringUtilities.isEmpty((String)dsType)) {
                this.dataSourceDriverText.setText(dsType);
            }
            if ((initialTranslatorSelection = this.getInitialTranslatorSelection()) != null) {
                int indx = this.translatorNameCombo.indexOf(initialTranslatorSelection);
                if (indx != -1) {
                    this.translatorNameCombo.select(indx);
                    this.importManager.setTranslatorName(initialTranslatorSelection);
                    this.propertiesViewerBuilder.setInput((Object)this);
                } else {
                    this.importManager.setTranslatorName(null);
                }
            }
            this.validatePage();
            this.getControl().setVisible(visible);
        } else {
            super.setVisible(visible);
        }
    }

    private boolean validatePage() {
        boolean nameDriverTranslatorValid = this.validateNameDriverTranslator();
        if (!nameDriverTranslatorValid) {
            return false;
        }
        this.setThisPageComplete(EMPTY_STR, 0);
        return true;
    }

    private boolean validateNameDriverTranslator() {
        String dsName = this.importManager.getDataSourceName();
        String dsDriver = this.importManager.getDataSourceDriverName();
        String dsTranslator = this.importManager.getTranslatorName();
        if (CoreStringUtil.isEmpty((String)dsName)) {
            this.setThisPageComplete(Messages.SelectTranslatorPage_NoDataSourceNameMsg, 3);
            return false;
        }
        if (CoreStringUtil.isEmpty((String)dsDriver)) {
            this.setThisPageComplete(Messages.SelectTranslatorPage_NoDataSourceDriverMsg, 3);
            return false;
        }
        if (CoreStringUtil.isEmpty((String)dsTranslator)) {
            this.setThisPageComplete(Messages.SelectTranslatorPage_NoTranslatorMsg, 3);
            return false;
        }
        return true;
    }

    private void setThisPageComplete(String message, int severity) {
        WizardUtil.setPageComplete((WizardPage)this, (String)message, (int)severity);
    }

    class ImportPropertyEditingSupport
    extends TranslatorOverridePropertyEditingSupport {
        protected void setElementValue(Object element, String newValue) {
            TranslatorOverrideProperty property = (TranslatorOverrideProperty)element;
            String currentValue = property.getOverriddenValue();
            boolean doIt = false;
            if (StringUtilities.isEmpty((String)newValue)) {
                if (!StringUtilities.isEmpty((String)currentValue)) {
                    doIt = true;
                }
            } else {
                String defaultValue = property.getDefinition().getDefaultValue();
                if (StringUtilities.isEmpty((String)currentValue)) {
                    if (StringUtilities.isEmpty((String)defaultValue) || !defaultValue.equals(newValue)) {
                        doIt = true;
                    }
                } else if (!newValue.equals(currentValue)) {
                    doIt = true;
                    if (!StringUtilities.isEmpty((String)defaultValue) && defaultValue.equals(newValue)) {
                        newValue = null;
                    }
                }
            }
            if (doIt) {
                property.setValue(newValue);
                this.getViewer().setSelection((ISelection)new StructuredSelection(element));
            }
            SelectTranslatorPage.this.importManager.setRedeploy(doIt);
        }

        public ImportPropertyEditingSupport(ColumnViewer viewer) {
            super(viewer, null);
        }

        protected boolean canEdit(Object element) {
            return true;
        }
    }
}

