/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IWorkbenchPage;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.LoggingUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelRegistry;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.ui.UiConstants;
import org.teiid.designer.extension.ui.server.TeiidInstanceMedListener;
import org.teiid.designer.runtime.spi.IExecutionConfigurationListener;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.actions.ActionService;

public final class Activator
extends AbstractUiPlugin {
    public static final String PLUGIN_ID = "org.teiid.designer.extension.ui";
    private static Activator _plugin;
    private final Map<String, String> metamodels = new HashMap<String, String>();
    private final Map<String, String> modelTypes = new HashMap<String, String>();

    public static Activator getDefault() {
        return _plugin;
    }

    protected ActionService createActionService(IWorkbenchPage page) {
        return null;
    }

    public Set<String> getExtendableMetamodelNames() {
        return new HashSet<String>(this.metamodels.values());
    }

    public String getMetamodelName(String metamodelUri) {
        CoreArgCheck.isNotEmpty((String)metamodelUri, (String)"metamodelUri is empty");
        for (String uri : this.metamodels.keySet()) {
            if (!uri.equals(metamodelUri)) continue;
            return this.metamodels.get(uri);
        }
        return null;
    }

    public String getMetamodelUri(String metamodelName) {
        CoreArgCheck.isNotEmpty((String)metamodelName, (String)"metamodelName is empty");
        for (Map.Entry<String, String> entry : this.metamodels.entrySet()) {
            if (!entry.getValue().equals(metamodelName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getModelType(String modelTypeName) {
        CoreArgCheck.isNotEmpty((String)modelTypeName, (String)"modelTypeName is empty");
        for (Map.Entry<String, String> entry : this.modelTypes.entrySet()) {
            if (!entry.getValue().equals(modelTypeName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getModelTypeName(String modelType) {
        CoreArgCheck.isNotEmpty((String)modelType, (String)"modelType is empty");
        for (Map.Entry<String, String> entry : this.modelTypes.entrySet()) {
            if (!entry.getKey().equals(modelType)) continue;
            return entry.getValue();
        }
        return null;
    }

    public Set<String> getModelTypes(String metamodelUri) {
        return ModelerCore.getMetamodelRegistry().getModelTypes(metamodelUri);
    }

    public PluginUtil getPluginUtil() {
        return null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        _plugin = this;
        ((LoggingUtil)UiConstants.UTIL).initializePlatformLogger((Plugin)this);
        Set metamodelUris = ExtensionPlugin.getInstance().getRegistry().getExtendableMetamodelUris();
        MetamodelRegistry metamodelRegistry = ModelerCore.getMetamodelRegistry();
        for (String metamodelUri : metamodelUris) {
            String name = metamodelRegistry.getMetamodelName(metamodelUri);
            this.metamodels.put(metamodelUri, name);
            for (String modelType : metamodelRegistry.getModelTypes(metamodelUri)) {
                if (this.modelTypes.containsKey(modelType)) continue;
                this.modelTypes.put(modelType, metamodelRegistry.getModelTypeName(modelType));
            }
        }
        TeiidInstanceMedListener listener = TeiidInstanceMedListener.getInstance();
        ModelerCore.getTeiidServerManager().addListener((IExecutionConfigurationListener)listener);
    }
}

