/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.actions;

import java.io.InputStream;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.ModelExtensionAssistantAggregator;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionWriter;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.ui.Activator;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.UiConstants;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class LegacyClassnameResolution
implements IMarkerResolution {
    private static final String LEGACY_METACLASS_PREFIX = "com.metamatrix.";
    private static final String NEW_METACLASS_PREFIX = "org.teiid.designer.";

    public String getLabel() {
        return Messages.legacyClassnameResolutionLabel;
    }

    public void run(IMarker marker) {
        IResource resource = marker.getResource();
        if (ModelUtilities.isModelFile((IResource)resource)) {
            final IFile theFile = (IFile)resource;
            final ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)theFile, (boolean)false);
            if (editor != null && editor.isDirty()) {
                boolean saveEditor = MessageDialog.openQuestion((Shell)LegacyClassnameResolution.getShell(), (String)Messages.quickFixModelDirtyTitle, (String)Messages.quickFixModelDirtyMsg);
                if (!saveEditor) {
                    return;
                }
                UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                        LegacyClassnameResolution.this.fixModelMed(theFile);
                    }
                });
                return;
            }
            UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    LegacyClassnameResolution.this.fixModelMed(theFile);
                }
            });
        } else if (ModelUtilities.isMedFile((IResource)resource)) {
            final IFile theFile = (IFile)resource;
            final IEditorPart editor = UiUtil.getEditorForFile((IFile)theFile, (boolean)false);
            if (editor != null && editor.isDirty()) {
                boolean saveEditor = MessageDialog.openQuestion((Shell)LegacyClassnameResolution.getShell(), (String)Messages.quickFixMedFileDirtyTitle, (String)Messages.quickFixMedFileDirtyMsg);
                if (!saveEditor) {
                    return;
                }
                UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                        LegacyClassnameResolution.this.fixMedFile(theFile);
                    }
                });
                return;
            }
            UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    LegacyClassnameResolution.this.fixMedFile(theFile);
                }
            });
        }
    }

    private void fixModelMed(IFile modelFile) {
        ModelExtensionAssistantAggregator aggregator = ExtensionPlugin.getInstance().getModelExtensionAssistantAggregator();
        Collection supportedNamespaces = null;
        try {
            supportedNamespaces = aggregator.getSupportedNamespacePrefixes((Object)modelFile);
        }
        catch (Exception e) {
            UiConstants.UTIL.log(4, (Throwable)e, NLS.bind((String)Messages.getSupportedPrefixesErrorMsg, (Object)modelFile.getName()));
            return;
        }
        boolean modelNeedsSave = false;
        for (String namespacePrefix : supportedNamespaces) {
            ModelExtensionAssistant assistant = ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(namespacePrefix);
            if (assistant == null) {
                assistant = ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant(namespacePrefix);
            }
            assert (assistant instanceof ModelObjectExtensionAssistant) : "ModelExtensionAssistant is not a ModelObjectExtensionAssistant";
            ModelObjectExtensionAssistant mAssistant = (ModelObjectExtensionAssistant)assistant;
            ModelExtensionDefinition modelMed = null;
            try {
                modelMed = mAssistant.getModelExtensionDefinition((Object)modelFile);
            }
            catch (Exception e) {
                UiConstants.UTIL.log(4, (Throwable)e, NLS.bind((String)Messages.getModelMedErrorMsg, (Object)modelFile.getName()));
                return;
            }
            boolean medChanged = this.updateMed(modelMed);
            if (!medChanged) continue;
            try {
                mAssistant.saveModelExtensionDefinition((Object)modelFile);
            }
            catch (Exception e) {
                UiConstants.UTIL.log(4, (Throwable)e, NLS.bind((String)Messages.saveModelMedErrorMsg, (Object)modelFile.getName()));
            }
            modelNeedsSave = true;
        }
        if (modelNeedsSave) {
            try {
                ModelResource mdlResc = ModelUtilities.getModelResourceForIFile((IFile)modelFile, (boolean)false);
                if (mdlResc != null) {
                    mdlResc.save((IProgressMonitor)new NullProgressMonitor(), true);
                }
                modelFile.deleteMarkers(UiConstants.ExtensionIds.PROBLEM_MARKER, true, 2);
                modelFile.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                UiConstants.UTIL.log(4, (Throwable)e, NLS.bind((String)Messages.saveModelErrorMsg, (Object)modelFile.getName()));
            }
        }
    }

    private void fixMedFile(IFile medFile) {
        try {
            ModelExtensionDefinition med = this.parse(medFile.getContents());
            if (med != null) {
                this.updateMed(med);
                ModelExtensionDefinitionWriter medWriter = new ModelExtensionDefinitionWriter();
                InputStream medInputStream = medWriter.writeAsStream(med);
                medFile.setContents(medInputStream, false, false, (IProgressMonitor)new NullProgressMonitor());
                medFile.deleteMarkers(null, true, 2);
                medFile.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            UiConstants.UTIL.log(4, (Throwable)e, NLS.bind((String)Messages.fixMedFileClassnamesFailedMsg, (Object)medFile.getName()));
        }
    }

    private boolean updateMed(ModelExtensionDefinition med) {
        String[] extendedMCs;
        boolean wasChanged = false;
        if (med != null && (extendedMCs = med.getExtendedMetaclasses()) != null) {
            int i = 0;
            while (i < extendedMCs.length) {
                String metaclass = extendedMCs[i];
                if (metaclass != null && metaclass.startsWith(LEGACY_METACLASS_PREFIX)) {
                    String newMetaclass = metaclass.replaceAll(LEGACY_METACLASS_PREFIX, NEW_METACLASS_PREFIX);
                    med.updateMetaclass(metaclass, newMetaclass);
                    wasChanged = true;
                }
                ++i;
            }
        }
        return wasChanged;
    }

    private ModelExtensionDefinition parse(InputStream mxdContents) {
        ModelExtensionDefinition med = null;
        try {
            med = ExtensionPlugin.getInstance().parse(mxdContents);
        }
        catch (Exception exception) {
            UiConstants.UTIL.log((Object)Messages.medFileParseErrorMsg);
        }
        return med;
    }

    private static Shell getShell() {
        return Activator.getDefault().getCurrentWorkbenchWindow().getShell();
    }
}

