/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.actions;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionParser;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.extension.ui.Activator;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.UiConstants;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;

public class RegistryDeploymentValidator {
    private static boolean checkProblemMarkers(IFile mxdFile) {
        IMarker[] markers = null;
        boolean errorOccurred = false;
        try {
            markers = mxdFile.findMarkers(UiConstants.ExtensionIds.PROBLEM_MARKER, false, 2);
        }
        catch (CoreException ex) {
            org.teiid.designer.ui.UiConstants.Util.log((Throwable)ex);
            errorOccurred = true;
        }
        if (errorOccurred) {
            MessageDialog.openError((Shell)RegistryDeploymentValidator.getShell(), (String)Messages.checkMedProblemMarkersErrorTitle, (String)Messages.checkMedProblemMarkersErrorMsg);
            return true;
        }
        if (markers.length > 0) {
            MessageDialog.openError((Shell)RegistryDeploymentValidator.getShell(), (String)Messages.checkMedProblemMarkersHasErrorsTitle, (String)Messages.checkMedProblemMarkersHasErrorsMsg);
            return true;
        }
        return false;
    }

    private static IEditorPart getOpenEditor(IFile selectedMedFile) {
        IWorkbenchPage page;
        IWorkbenchWindow window = Activator.getDefault().getCurrentWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IEditorReference[] editors = page.getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                IEditorInput input;
                IEditorPart editor = editors[i].getEditor(false);
                if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput && selectedMedFile != null && selectedMedFile.equals((Object)((IFileEditorInput)input).getFile())) {
                    return editor;
                }
                ++i;
            }
        }
        return null;
    }

    public static ModelExtensionDefinition parseMed(InputStream mxdContents, boolean showInfoDialog) {
        ModelExtensionDefinition med = null;
        try {
            med = ExtensionPlugin.getInstance().parse(mxdContents);
        }
        catch (Exception exception) {
            UiConstants.UTIL.log((Object)Messages.medFileParseErrorMsg);
        }
        if (med == null && showInfoDialog) {
            RegistryDeploymentValidator.showMedNotValidDialog();
        }
        return med;
    }

    public static ModelExtensionDefinition getRegisteredMedWithNSPrefix(ModelExtensionRegistry registry, String nsPrefix) {
        return registry.getDefinition(nsPrefix);
    }

    public static ModelExtensionDefinition getRegisteredMedWithNSUri(ModelExtensionRegistry registry, String nsUri) {
        return registry.getDefinitionWithNSUri(nsUri);
    }

    private static void showMedNotValidDialog() {
        MessageDialog.openInformation((Shell)RegistryDeploymentValidator.getShell(), (String)Messages.registerMedActionInvalidMedTitle, (String)Messages.registerMedActionInvalidMedMsg);
    }

    private static void showMedNSPrefixAlreadyRegisteredDialog() {
        MessageDialog.openInformation((Shell)RegistryDeploymentValidator.getShell(), (String)Messages.registerMedActionNamespacePrefixRegisteredTitle, (String)Messages.registerMedActionNamespacePrefixRegisteredMsg);
    }

    private static boolean showMedNSPrefixAlreadyRegisteredDoUpdateDialog() {
        return MessageDialog.openConfirm((Shell)RegistryDeploymentValidator.getShell(), (String)Messages.registerMedActionNamespacePrefixRegisteredTitle, (String)Messages.registerMedActionNamespacePrefixRegisteredDoUpdateMsg);
    }

    private static void showMedNSUriAlreadyRegisteredDialog() {
        MessageDialog.openInformation((Shell)RegistryDeploymentValidator.getShell(), (String)Messages.registerMedActionNamespaceUriRegisteredTitle, (String)Messages.registerMedActionNamespaceUriRegisteredMsg);
    }

    private static void showMedNSUriConflictsWBuiltInDialog() {
        MessageDialog.openInformation((Shell)RegistryDeploymentValidator.getShell(), (String)Messages.registerMedActionNamespaceUriConflictsWBuiltInTitle, (String)Messages.registerMedActionNamespaceUriConflictsWBuiltInMsg);
    }

    private static void showMedNSPrefixConflictsWBuiltInDialog() {
        MessageDialog.openInformation((Shell)RegistryDeploymentValidator.getShell(), (String)Messages.registerMedActionNamespacePrefixConflictsWBuiltInTitle, (String)Messages.registerMedActionNamespacePrefixConflictsWBuiltInMsg);
    }

    public static void deploy(final IFile medToDeploy) {
        CoreArgCheck.isNotNull((Object)medToDeploy, (String)"medToDeploy is null");
        IEditorPart editor = RegistryDeploymentValidator.getOpenEditor(medToDeploy);
        if (editor != null && editor.isDirty()) {
            if (!MessageDialog.openQuestion((Shell)RegistryDeploymentValidator.getShell(), (String)Messages.updateMedInRegistryMedDirtyTitle, (String)Messages.updateMedInRegistryMedDirtyMsg)) {
                return;
            }
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        if (RegistryDeploymentValidator.checkProblemMarkers(medToDeploy)) {
            return;
        }
        ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
        InputStream fileContents = null;
        try {
            fileContents = medToDeploy.getContents();
        }
        catch (CoreException e) {
            UiConstants.UTIL.log(4, (Throwable)e, NLS.bind((String)Messages.medFileGetContentsErrorMsg, (Object)medToDeploy.getName()));
        }
        if (fileContents != null) {
            ModelExtensionDefinition med = null;
            try {
                ModelExtensionDefinitionParser parser = new ModelExtensionDefinitionParser(ExtensionPlugin.getInstance().getMedSchema());
                med = parser.parse(fileContents, (ModelExtensionAssistant)ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant());
                if (!parser.getErrors().isEmpty()) {
                    MessageDialog.openError((Shell)RegistryDeploymentValidator.getShell(), (String)Messages.registerMedActionFailedTitle, (String)NLS.bind((String)Messages.medFileParseErrorMsg, (Object)medToDeploy.getName()));
                    return;
                }
            }
            catch (Exception e) {
                UiConstants.UTIL.log((Throwable)e);
                MessageDialog.openError((Shell)RegistryDeploymentValidator.getShell(), (String)Messages.registerMedActionFailedTitle, (String)Messages.registerMedActionFailedMsg);
                return;
            }
            if (med != null) {
                ModelExtensionDefinition medNSPrefixMatch = RegistryDeploymentValidator.getRegisteredMedWithNSPrefix(registry, med.getNamespacePrefix());
                ModelExtensionDefinition medNSUriMatch = RegistryDeploymentValidator.getRegisteredMedWithNSUri(registry, med.getNamespaceUri());
                boolean nsPrefixConflict = false;
                boolean nsUriConflict = false;
                boolean nsPrefixAndUriConflictSameMed = false;
                boolean nsPrefixConflictMedBuiltIn = false;
                boolean nsUriConflictMedBuiltIn = false;
                if (medNSPrefixMatch != null) {
                    nsPrefixConflict = true;
                    nsPrefixConflictMedBuiltIn = medNSPrefixMatch.isBuiltIn();
                }
                if (medNSUriMatch != null) {
                    nsUriConflict = true;
                    nsUriConflictMedBuiltIn = medNSUriMatch.isBuiltIn();
                }
                if (nsPrefixConflict && nsUriConflict && medNSPrefixMatch.equals((Object)medNSUriMatch)) {
                    nsPrefixAndUriConflictSameMed = true;
                }
                if (!nsPrefixConflict && !nsUriConflict) {
                    UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            RegistryDeploymentValidator.internalRun(medToDeploy, false);
                        }
                    });
                } else if (nsPrefixConflictMedBuiltIn) {
                    RegistryDeploymentValidator.showMedNSPrefixConflictsWBuiltInDialog();
                } else if (nsUriConflictMedBuiltIn) {
                    RegistryDeploymentValidator.showMedNSUriConflictsWBuiltInDialog();
                } else if (nsPrefixConflict && (!nsUriConflict || nsUriConflict && nsPrefixAndUriConflictSameMed)) {
                    if (med.equals((Object)medNSPrefixMatch)) {
                        RegistryDeploymentValidator.showMedNSPrefixAlreadyRegisteredDialog();
                    } else {
                        boolean doUpdate = RegistryDeploymentValidator.showMedNSPrefixAlreadyRegisteredDoUpdateDialog();
                        if (doUpdate) {
                            UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    RegistryDeploymentValidator.internalRun(medToDeploy, true);
                                }
                            });
                        }
                    }
                } else if (nsUriConflict) {
                    RegistryDeploymentValidator.showMedNSUriAlreadyRegisteredDialog();
                }
            }
        }
    }

    static void internalRun(IFile medToRegister, boolean isUpdate) {
        boolean wasAdded = true;
        try {
            if (isUpdate) {
                RegistryDeploymentValidator.updateExtensionInRegistry(medToRegister);
            } else {
                RegistryDeploymentValidator.addExtensionToRegistry(medToRegister);
            }
        }
        catch (Exception e) {
            wasAdded = false;
            UiConstants.UTIL.log(4, (Throwable)e, NLS.bind((String)Messages.medRegistryAddErrorMsg, (Object)medToRegister.getName()));
            MessageDialog.openInformation((Shell)RegistryDeploymentValidator.getShell(), (String)Messages.registerMedActionFailedTitle, (String)Messages.registerMedActionFailedMsg);
        }
        if (wasAdded) {
            MessageDialog.openInformation((Shell)RegistryDeploymentValidator.getShell(), (String)Messages.registerMedActionSuccessTitle, (String)Messages.registerMedActionSuccessMsg);
        }
    }

    private static void addExtensionToRegistry(IFile medFile) throws Exception {
        ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
        registry.addDefinition(medFile.getContents(), (ModelExtensionAssistant)ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant());
    }

    private static void updateExtensionInRegistry(IFile medFile) throws Exception {
        ModelExtensionDefinition med;
        ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
        if (registry.isNamespacePrefixRegistered((med = RegistryDeploymentValidator.parseMed(medFile.getContents(), false)).getNamespacePrefix())) {
            registry.removeDefinition(med.getNamespacePrefix());
        }
        RegistryDeploymentValidator.addExtensionToRegistry(medFile);
    }

    private static Shell getShell() {
        return Activator.getDefault().getCurrentWorkbenchWindow().getShell();
    }
}

