/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.teiid.core.designer.util.ArrayUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionValidator;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.ui.Activator;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.editors.ErrorMessage;

final class EditAllowedValueDialog
extends FormDialog {
    private ScrolledForm scrolledForm;
    private Button btnOk;
    private final String runtimeType;
    private String[] existingValues;
    private String allowedValue;
    private String valueBeingEdited;
    private final ErrorMessage valueError;

    public EditAllowedValueDialog(Shell parentShell, ModelExtensionPropertyDefinition.Type runtimeType, String[] existingValues) {
        super(parentShell);
        this.runtimeType = runtimeType == null ? null : runtimeType.toString();
        this.allowedValue = "";
        this.valueError = new ErrorMessage();
        if (ArrayUtil.isNullOrEmpty((Object[])existingValues)) {
            this.existingValues = CoreStringUtil.Constants.EMPTY_STRING_ARRAY;
        } else {
            this.existingValues = new String[existingValues.length];
            int i = 0;
            String[] stringArray = existingValues;
            int n = existingValues.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                this.existingValues[i++] = value;
                ++n2;
            }
        }
    }

    public EditAllowedValueDialog(Shell parentShell, ModelExtensionPropertyDefinition.Type runtimeType, String[] existingValues, String valueBeingEdited) {
        this(parentShell, runtimeType, existingValues);
        CoreArgCheck.isNotNull((Object)valueBeingEdited, (String)"valueBeingEdited is null");
        this.allowedValue = this.valueBeingEdited = valueBeingEdited;
        ArrayList<String> temp = new ArrayList<String>(Arrays.asList(this.existingValues));
        if (temp.remove(this.valueBeingEdited)) {
            this.existingValues = temp.toArray(new String[temp.size()]);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.isEditMode()) {
            newShell.setText(Messages.editAllowedValueDialogTitle);
        } else {
            newShell.setText(Messages.addAllowedValueDialogTitle);
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.btnOk = btn;
            btn.setEnabled(false);
        }
        return btn;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.scrolledForm = managedForm.getForm();
        this.scrolledForm.setText(Messages.allowedValueDialogMessageTitle);
        this.scrolledForm.setImage(Activator.getDefault().getImage("icons/model-extension-definition-editor.png"));
        this.scrolledForm.setMessage(Messages.allowedValueDialogMessage, 0);
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(this.scrolledForm.getForm());
        Composite body = this.scrolledForm.getBody();
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        body.setLayout((Layout)layout);
        Label lblValue = toolkit.createLabel(body, Messages.allowedValueLabel, 0);
        lblValue.setLayoutData((Object)new TableWrapData(2, 32));
        Text txtValue = toolkit.createText(body, null, 2048);
        this.valueError.setControl((Control)txtValue);
        txtValue.setLayoutData((Object)new TableWrapData(256, 32));
        txtValue.setToolTipText(Messages.allowedValueToolTip);
        if (this.isEditMode()) {
            txtValue.setText(this.valueBeingEdited);
        }
        txtValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditAllowedValueDialog.this.handleValueChanged(((Text)e.widget).getText());
            }
        });
    }

    public String getAllowedValue() {
        return this.allowedValue;
    }

    void handleValueChanged(String newValue) {
        this.allowedValue = newValue;
        this.valueError.setStatus(ModelExtensionDefinitionValidator.validatePropertyAllowedValue((String)this.runtimeType, (String)this.allowedValue));
        if (!this.valueError.isError()) {
            String[] temp = new String[this.existingValues.length + 1];
            System.arraycopy(this.existingValues, 0, temp, 0, this.existingValues.length);
            temp[this.existingValues.length] = newValue;
            this.valueError.setStatus(ModelExtensionDefinitionValidator.validatePropertyAllowedValues((String)this.runtimeType, (String[])temp));
        }
        this.updateState();
    }

    private boolean isEditMode() {
        return !CoreStringUtil.isEmpty((String)this.valueBeingEdited);
    }

    private void updateState() {
        if (this.valueError.isError()) {
            if (this.btnOk.isEnabled()) {
                this.btnOk.setEnabled(false);
            }
        } else {
            boolean enable = true;
            if (this.isEditMode()) {
                boolean bl = enable = !CoreStringUtil.equals((String)this.allowedValue, (String)this.valueBeingEdited);
            }
            if (this.btnOk.getEnabled() != enable) {
                this.btnOk.setEnabled(enable);
            }
        }
        this.valueError.update(this.scrolledForm.getMessageManager());
        if (this.valueError.isOk() && !Messages.allowedValueDialogMessage.equals(this.scrolledForm.getMessage())) {
            this.scrolledForm.setMessage(Messages.allowedValueDialogMessage, 1);
            this.scrolledForm.setMessage(Messages.allowedValueDialogMessage, 0);
        }
    }
}

