/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.custom.CCombo;
import org.teiid.designer.extension.ExtensionConstants;
import org.teiid.designer.extension.ui.editors.CComboProposalProvider;

class LocaleProposalProvider
extends CComboProposalProvider {
    private final char[] firstChars;
    private List<Locale> locales = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));

    LocaleProposalProvider(CCombo combo) {
        super(combo);
        Collections.sort(this.locales, ExtensionConstants.LOCALE_COMPARATOR);
        HashSet<Character> temp = new HashSet<Character>();
        String chars = "";
        for (Locale locale : this.locales) {
            char c = locale.getDisplayName().charAt(0);
            if (!temp.add(Character.valueOf(c))) continue;
            chars = String.valueOf(chars) + c;
            if (!Character.isLetter(c)) continue;
            chars = Character.isUpperCase(c) ? String.valueOf(chars) + Character.toLowerCase(c) : String.valueOf(chars) + Character.toUpperCase(c);
        }
        this.firstChars = chars.toCharArray();
    }

    @Override
    protected char[] getActivationChars() {
        return this.firstChars;
    }

    @Override
    protected List<String> proposalsFor(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return Collections.emptyList();
        }
        String lowerCasePattern = pattern.toLowerCase();
        ArrayList<String> matches = new ArrayList<String>(6);
        boolean foundMatch = false;
        for (Locale locale : this.locales) {
            String displayName = locale.getDisplayName();
            String lowerCaseDisplayName = displayName.toLowerCase();
            if (lowerCaseDisplayName.startsWith(lowerCasePattern)) {
                matches.add(displayName);
                foundMatch = true;
                continue;
            }
            if (foundMatch) break;
        }
        return matches;
    }
}

