/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.teiid.designer.extension.ui.editors.MedEditorPage;
import org.teiid.designer.extension.ui.editors.MedSelectionProvider;
import org.teiid.designer.extension.ui.editors.MedSelectionSynchronizer;
import org.teiid.designer.extension.ui.editors.ModelExtensionDefinitionEditor;
import org.teiid.designer.extension.ui.model.MedContentProvider;
import org.teiid.designer.extension.ui.model.MedLabelProvider;
import org.teiid.designer.extension.ui.model.MedModelNode;

public class MedOutlinePage
extends ContentOutlinePage {
    private ModelExtensionDefinitionEditor medEditor;
    private MedSelectionProvider selectionProvider;

    public MedOutlinePage(ModelExtensionDefinitionEditor editor) {
        this.medEditor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setAutoExpandLevel(3);
        viewer.setContentProvider((IContentProvider)new MedContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new MedLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        MedSelectionSynchronizer selectionSynchronizer = this.getSelectionSynchronizer();
        this.selectionProvider = new OutlineSelectionProvider((Viewer)viewer);
        selectionSynchronizer.addSelectionProvider(this.selectionProvider);
        viewer.setInput((Object)this.medEditor);
    }

    public void dispose() {
        this.getSelectionSynchronizer().removeSelectionProvider(this.selectionProvider);
        super.dispose();
    }

    MedSelectionSynchronizer getSelectionSynchronizer() {
        return this.medEditor.getSelectionSynchronizer();
    }

    public void setFocus() {
        super.setFocus();
        this.selectionProvider.setSelection((ISelection)this.getSelectionSynchronizer().getSelection());
    }

    public void setSelection(ISelection selection) {
    }

    class OutlineSelectionProvider
    implements MedSelectionProvider {
        private final List<ISelectionChangedListener> listeners;
        private final Viewer viewer;

        public OutlineSelectionProvider(Viewer viewer) {
            this.viewer = viewer;
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    OutlineSelectionProvider.this.fireSelectionChanged(event);
                }
            });
            this.listeners = new ArrayList<ISelectionChangedListener>(1);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        void fireSelectionChanged(SelectionChangedEvent viewerEvent) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, viewerEvent.getSelection());
            for (ISelectionChangedListener listener : this.listeners) {
                listener.selectionChanged(event);
            }
        }

        @Override
        public MedEditorPage getMedEditorPage() {
            return null;
        }

        @Override
        public MedModelNode getSelectedNode(MedModelNode.ModelType type) {
            IStructuredSelection selection = (IStructuredSelection)this.getSelection();
            if (!selection.isEmpty()) {
                MedModelNode modelNode = (MedModelNode)selection.getFirstElement();
                if (modelNode.getType() == type) {
                    return modelNode;
                }
                modelNode = modelNode.getParent();
                while (modelNode != null) {
                    if (modelNode.getType() == type) {
                        return modelNode;
                    }
                    modelNode = modelNode.getParent();
                }
            }
            return null;
        }

        public ISelection getSelection() {
            return this.viewer.getSelection();
        }

        @Override
        public boolean isApplicable(IStructuredSelection selection) {
            return true;
        }

        @Override
        public void refresh() {
            this.viewer.refresh();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            if (!selection.equals(this.viewer.getSelection())) {
                this.viewer.setSelection(selection);
            }
        }
    }
}

