/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.model;

import java.util.Collection;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;

public class MedModelNode {
    private static final MedModelNode[] NO_KIDS = new MedModelNode[0];
    private Object data;
    private MedModelNode[] kids;
    private final MedModelNode parent;
    private final ModelType type;

    public static MedModelNode createDescriptionNode(MedModelNode medNode) {
        CoreArgCheck.isTrue((boolean)medNode.isMed(), (String)"node is not a MED node");
        return new MedModelNode(medNode, ModelType.DESCRIPTION);
    }

    public static MedModelNode createMedNode(ModelExtensionDefinition med) {
        CoreArgCheck.isNotNull((Object)med, (String)"MED is null");
        return new MedModelNode(med);
    }

    public static MedModelNode createMetaclassNode(MedModelNode medNode, String metaclass) {
        CoreArgCheck.isTrue((boolean)medNode.isMed(), (String)"node is not a MED node");
        CoreArgCheck.isNotNull((Object)metaclass, (String)"metaclass is null");
        return new MedModelNode(medNode, ModelType.METACLASS, metaclass);
    }

    public static MedModelNode createMetamodelUriNode(MedModelNode medNode) {
        CoreArgCheck.isTrue((boolean)medNode.isMed(), (String)"node is not a MED node");
        return new MedModelNode(medNode, ModelType.METAMODEL_URI);
    }

    public static MedModelNode createModelTypesNode(MedModelNode medNode) {
        CoreArgCheck.isTrue((boolean)medNode.isMed(), (String)"node is not a MED node");
        return new MedModelNode(medNode, ModelType.MODEL_TYPES);
    }

    public static MedModelNode createNamespacePrefixNode(MedModelNode medNode) {
        CoreArgCheck.isTrue((boolean)medNode.isMed(), (String)"node is not a MED node");
        return new MedModelNode(medNode, ModelType.NAMESPACE_PREFIX);
    }

    public static MedModelNode createNamespaceUriNode(MedModelNode medNode) {
        CoreArgCheck.isTrue((boolean)medNode.isMed(), (String)"node is not a MED node");
        return new MedModelNode(medNode, ModelType.NAMESPACE_URI);
    }

    public static MedModelNode createPropertyNode(MedModelNode metaclassNode, ModelExtensionPropertyDefinition propDefn) {
        CoreArgCheck.isTrue((boolean)metaclassNode.isMetaclass(), (String)"node is not a metaclass node");
        CoreArgCheck.isNotNull((Object)propDefn, (String)"propDefn is null");
        return new MedModelNode(metaclassNode, ModelType.PROPERTY_DEFINITION, propDefn);
    }

    public static MedModelNode createVersionNode(MedModelNode medNode) {
        CoreArgCheck.isTrue((boolean)medNode.isMed(), (String)"node is not a MED node");
        return new MedModelNode(medNode, ModelType.VERSION);
    }

    private MedModelNode(MedModelNode parent, ModelType type) {
        this.parent = parent;
        this.type = type;
    }

    private MedModelNode(MedModelNode parent, ModelType type, Object data) {
        this(parent, type);
        this.data = data;
    }

    private MedModelNode(ModelExtensionDefinition med) {
        this(null, ModelType.MODEL_EXTENSION_DEFINITION, med);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        MedModelNode that = (MedModelNode)obj;
        if (this.type != that.type) {
            return false;
        }
        if (this.parent == null ? that.parent != null : !this.parent.equals(that.parent)) {
            return false;
        }
        return !(this.data == null ? that.data != null : !this.data.equals(that.data));
    }

    public MedModelNode[] getChildren() {
        if (this.kids == null) {
            if (this.isMed()) {
                String[] metaclasses = this.getMed().getExtendedMetaclasses();
                int i = 0;
                this.kids = new MedModelNode[6 + metaclasses.length];
                this.kids[i++] = MedModelNode.createNamespacePrefixNode(this);
                this.kids[i++] = MedModelNode.createNamespaceUriNode(this);
                this.kids[i++] = MedModelNode.createMetamodelUriNode(this);
                this.kids[i++] = MedModelNode.createModelTypesNode(this);
                this.kids[i++] = MedModelNode.createVersionNode(this);
                this.kids[i++] = MedModelNode.createDescriptionNode(this);
                String[] stringArray = metaclasses;
                int n = metaclasses.length;
                int n2 = 0;
                while (n2 < n) {
                    String metaclass = stringArray[n2];
                    this.kids[i++] = MedModelNode.createMetaclassNode(this, metaclass);
                    ++n2;
                }
            } else if (this.isMetaclass()) {
                Collection propDefns = this.getMed().getPropertyDefinitions((String)this.data);
                this.kids = new MedModelNode[propDefns.size()];
                int i = 0;
                for (ModelExtensionPropertyDefinition propDefn : propDefns) {
                    this.kids[i++] = MedModelNode.createPropertyNode(this, propDefn);
                }
            } else {
                this.kids = NO_KIDS;
            }
        }
        return this.kids;
    }

    public Object getData() {
        if (this.isNamespacePrefix()) {
            return this.getMed().getNamespacePrefix();
        }
        if (this.isNamespaceUri()) {
            return this.getMed().getNamespaceUri();
        }
        if (this.isMetamodelUri()) {
            return this.getMed().getMetamodelUri();
        }
        if (this.isModelTypes()) {
            return this.getMed().getSupportedModelTypes();
        }
        if (this.isDescription()) {
            return this.getMed().getDescription();
        }
        if (this.isVersion()) {
            return this.getMed().getVersion();
        }
        return this.data;
    }

    public MedModelNode getDescriptionNode() {
        if (this.isDescription()) {
            return this;
        }
        MedModelNode medNode = this.getMedNode();
        MedModelNode[] medModelNodeArray = medNode.getChildren();
        int n = medModelNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MedModelNode kid = medModelNodeArray[n2];
            if (kid.isDescription()) {
                return kid;
            }
            ++n2;
        }
        assert (false) : "description model node not found";
        return null;
    }

    public ModelExtensionDefinition getMed() {
        MedModelNode medNode = this.getMedNode();
        return (ModelExtensionDefinition)medNode.getData();
    }

    public MedModelNode getMedNode() {
        if (this.isMed()) {
            return this;
        }
        return this.getParent().getMedNode();
    }

    public String getMetaclass() {
        CoreArgCheck.isTrue((this.isMetaclass() || this.isPropertyDefinition() ? 1 : 0) != 0, null);
        if (this.isMetaclass()) {
            return this.getData().toString();
        }
        assert (this.isPropertyDefinition()) : "node is not a property definition model node";
        return this.getParent().getMetaclass();
    }

    public MedModelNode getMetaclassNode(String metaclass) {
        MedModelNode medNode = this.getMedNode();
        MedModelNode[] medModelNodeArray = medNode.getChildren();
        int n = medModelNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MedModelNode child = medModelNodeArray[n2];
            if (child.isMetaclass() && child.getMetaclass().equals(metaclass)) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    public MedModelNode getMetamodelUriNode() {
        if (this.isMetamodelUri()) {
            return this;
        }
        MedModelNode medNode = this.getMedNode();
        MedModelNode[] medModelNodeArray = medNode.getChildren();
        int n = medModelNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MedModelNode kid = medModelNodeArray[n2];
            if (kid.isMetamodelUri()) {
                return kid;
            }
            ++n2;
        }
        assert (false) : "metamodel URi model node not found";
        return null;
    }

    public MedModelNode getModelTypesNode() {
        if (this.isModelTypes()) {
            return this;
        }
        MedModelNode medNode = this.getMedNode();
        MedModelNode[] medModelNodeArray = medNode.getChildren();
        int n = medModelNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MedModelNode kid = medModelNodeArray[n2];
            if (kid.isModelTypes()) {
                return kid;
            }
            ++n2;
        }
        assert (false) : "model types model node not found";
        return null;
    }

    public MedModelNode getNamespacePrefixNode() {
        if (this.isNamespacePrefix()) {
            return this;
        }
        MedModelNode medNode = this.getMedNode();
        MedModelNode[] medModelNodeArray = medNode.getChildren();
        int n = medModelNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MedModelNode kid = medModelNodeArray[n2];
            if (kid.isNamespacePrefix()) {
                return kid;
            }
            ++n2;
        }
        assert (false) : "namespace prefix model node not found";
        return null;
    }

    public MedModelNode getNamespaceUriNode() {
        if (this.isNamespaceUri()) {
            return this;
        }
        MedModelNode medNode = this.getMedNode();
        MedModelNode[] medModelNodeArray = medNode.getChildren();
        int n = medModelNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MedModelNode kid = medModelNodeArray[n2];
            if (kid.isNamespaceUri()) {
                return kid;
            }
            ++n2;
        }
        assert (false) : "namespace URi model node not found";
        return null;
    }

    public MedModelNode getParent() {
        return this.parent;
    }

    public ModelExtensionPropertyDefinition getPropertyDefinition() {
        CoreArgCheck.isTrue((boolean)this.isPropertyDefinition(), null);
        return (ModelExtensionPropertyDefinition)this.getData();
    }

    public MedModelNode getPropertyDefinitionNode(String metaclass, ModelExtensionPropertyDefinition propDefn) {
        MedModelNode metaclassNode = this.getMetaclassNode(metaclass);
        if (metaclassNode != null) {
            MedModelNode[] medModelNodeArray = metaclassNode.getChildren();
            int n = medModelNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MedModelNode propDefnNode = medModelNodeArray[n2];
                if (propDefn.equals(propDefnNode.getPropertyDefinition())) {
                    return propDefnNode;
                }
                ++n2;
            }
        }
        return null;
    }

    public ModelType getType() {
        return this.type;
    }

    public MedModelNode getVersionNode() {
        if (this.isVersion()) {
            return this;
        }
        MedModelNode medNode = this.getMedNode();
        MedModelNode[] medModelNodeArray = medNode.getChildren();
        int n = medModelNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MedModelNode kid = medModelNodeArray[n2];
            if (kid.isVersion()) {
                return kid;
            }
            ++n2;
        }
        assert (false) : "version model node not found";
        return null;
    }

    public int hashCode() {
        int result = HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.type});
        result = HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.parent});
        return HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getData()});
    }

    public boolean isDescription() {
        return this.type == ModelType.DESCRIPTION;
    }

    public boolean isMed() {
        return this.type == ModelType.MODEL_EXTENSION_DEFINITION;
    }

    public boolean isMetaclass() {
        return this.type == ModelType.METACLASS;
    }

    public boolean isMetamodelUri() {
        return this.type == ModelType.METAMODEL_URI;
    }

    public boolean isModelTypes() {
        return this.type == ModelType.MODEL_TYPES;
    }

    public boolean isNamespacePrefix() {
        return this.type == ModelType.NAMESPACE_PREFIX;
    }

    public boolean isNamespaceUri() {
        return this.type == ModelType.NAMESPACE_URI;
    }

    public boolean isPropertyDefinition() {
        return this.type == ModelType.PROPERTY_DEFINITION;
    }

    public boolean isVersion() {
        return this.type == ModelType.VERSION;
    }

    public static enum ModelType {
        DESCRIPTION,
        METACLASS,
        METAMODEL_URI,
        MODEL_EXTENSION_DEFINITION,
        MODEL_TYPES,
        NAMESPACE_PREFIX,
        NAMESPACE_URI,
        PROPERTY_DEFINITION,
        VERSION;

    }
}

