/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.views;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.extension.ExtensionConstants;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionParser;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionWriter;
import org.teiid.designer.extension.registry.ExtensionDefinitionsManager;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.extension.registry.RegistryEvent;
import org.teiid.designer.extension.registry.RegistryListener;
import org.teiid.designer.extension.ui.Activator;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.actions.RegistryDeploymentValidator;
import org.teiid.designer.extension.ui.wizards.NewMedWizard;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.util.ErrorHandler;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;

public final class ModelExtensionRegistryView
extends ViewPart
implements ExtensionConstants {
    private IAction cloneMedAction;
    private IAction viewMedAction;
    private IAction findMedReferencesAction;
    private IAction registerMedAction;
    private final ModelExtensionRegistry registry;
    private IAction unregisterMedAction;
    private TableViewerBuilder viewerBuilder;
    private RegistryListener registryListener = new RegistryListener(){

        public void process(RegistryEvent event) {
            ModelExtensionRegistryView.this.handleRegistryChanged(event);
        }
    };
    private ISelectionStatusValidator medSelectionValidator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] theSelection) {
            StatusInfo result = null;
            boolean valid = true;
            if (theSelection != null && theSelection.length > 0) {
                int i = 0;
                while (i < theSelection.length) {
                    if (!(theSelection[i] instanceof IFile) || !ModelExtensionRegistryView.this.isMedFile((IResource)((IFile)theSelection[i]))) {
                        valid = false;
                        break;
                    }
                    ++i;
                }
            } else {
                valid = false;
            }
            result = valid ? new StatusInfo(ExtensionConstants.PLUGIN_ID) : new StatusInfo(ExtensionConstants.PLUGIN_ID, 4, Messages.selectMedDialogNotMedSelectionMsg);
            return result;
        }
    };

    public ModelExtensionRegistryView() {
        ModelExtensionRegistry modelExtensionRegistry = this.registry = Platform.isRunning() ? ExtensionPlugin.getInstance().getRegistry() : null;
        if (this.registry != null) {
            this.registry.addListener(this.registryListener);
        }
    }

    public void dispose() {
        if (this.registry != null) {
            this.registry.removeListener(this.registryListener);
        }
        super.dispose();
    }

    private void configureColumn(TableViewerColumn viewerColumn, int columnIndex, String headerText, String headerToolTip, boolean resizable) {
        TableColumn column = viewerColumn.getColumn();
        column.setText(headerText);
        column.setToolTipText(headerToolTip);
        column.setMoveable(false);
        column.setResizable(resizable);
    }

    private void configureMenu(IMenuManager menuMgr) {
        menuMgr.add(this.findMedReferencesAction);
    }

    private void configureToolBar(IToolBarManager toolBarMgr) {
        toolBarMgr.add(this.registerMedAction);
        toolBarMgr.add(this.unregisterMedAction);
        toolBarMgr.add(this.cloneMedAction);
        toolBarMgr.add(this.viewMedAction);
        toolBarMgr.update(true);
    }

    private void createActions() {
        this.cloneMedAction = new Action(Messages.cloneMedActionText, 2048){

            public void run() {
                ModelExtensionRegistryView.this.handleCloneMed();
            }
        };
        this.cloneMedAction.setToolTipText(Messages.cloneMedActionToolTip);
        this.cloneMedAction.setEnabled(false);
        this.cloneMedAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.viewMedAction = new Action(Messages.viewMedActionText, 2048){

            public void run() {
                ModelExtensionRegistryView.this.handleViewMed();
            }
        };
        this.viewMedAction.setToolTipText(Messages.viewMedActionToolTip);
        this.viewMedAction.setEnabled(false);
        this.viewMedAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/viewMed.gif"));
        this.findMedReferencesAction = new Action(Messages.findMedReferencesActionText, 2048){

            public void run() {
                ModelExtensionRegistryView.this.handleFindMedReferences();
            }
        };
        this.findMedReferencesAction.setToolTipText(Messages.findMedReferencesActionToolTip);
        this.findMedReferencesAction.setEnabled(false);
        try {
            URL imageUrl = new URL("platform:/plugin/org.eclipse.search/icons/full/etool16/search.gif");
            this.findMedReferencesAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)imageUrl));
        }
        catch (Exception e) {
            ErrorHandler.toExceptionDialog((Throwable)e);
        }
        this.registerMedAction = new Action(Messages.registerMedActionText, 2048){

            public void run() {
                ModelExtensionRegistryView.this.handleRegisterMed();
            }
        };
        this.registerMedAction.setToolTipText(Messages.registerMedActionToolTip);
        this.registerMedAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/registry-med-update.png"));
        this.unregisterMedAction = new Action(Messages.unregisterMedActionText, 2048){

            public void run() {
                ModelExtensionRegistryView.this.handleUnregisterMed();
            }
        };
        this.unregisterMedAction.setToolTipText(Messages.unregisterMedActionToolTip);
        this.unregisterMedAction.setEnabled(false);
        this.unregisterMedAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/unregister-med.png"));
    }

    private void createColumns() {
        TableViewerColumn column = this.viewerBuilder.createColumn(0x1000000, 5, 25, true);
        this.configureColumn(column, 0, Messages.builtInColumnText, Messages.builtInColumnToolTip, false);
        column = this.viewerBuilder.createColumn(0x1000000, 5, 25, true);
        this.configureColumn(column, 1, Messages.importedColumnText, Messages.importedColumnToolTip, false);
        column = this.viewerBuilder.createColumn(16384, 14, 30, true);
        this.configureColumn(column, 2, Messages.namespacePrefixColumnText, Messages.namespacePrefixColumnToolTip, true);
        column = this.viewerBuilder.createColumn(16384, 14, 30, true);
        this.configureColumn(column, 3, Messages.namespaceUriColumnText, Messages.namespaceUriColumnToolTip, true);
        column = this.viewerBuilder.createColumn(16384, 14, 30, true);
        this.configureColumn(column, 4, Messages.extendedMetamodelUriColumnText, Messages.metamodelUriColumnToolTip, true);
        column = this.viewerBuilder.createColumn(16384, 14, 30, true);
        this.configureColumn(column, 5, Messages.modelTypeColumnText, Messages.modelTypesColumnToolTip, true);
        column = this.viewerBuilder.createColumn(131072, 5, 10, true);
        this.configureColumn(column, 6, Messages.versionColumnText, Messages.versionColumnToolTip, true);
        column = this.viewerBuilder.createColumn(16384, 22, 40, true);
        this.configureColumn(column, 7, Messages.descriptionColumnText, Messages.descriptionColumnToolTip, true);
    }

    private MenuManager createContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.add(this.registerMedAction);
        mgr.add(this.unregisterMedAction);
        mgr.add(this.cloneMedAction);
        mgr.add(this.viewMedAction);
        return mgr;
    }

    public void createPartControl(Composite parent) {
        Composite pnlMain = new Composite(parent, 2048);
        pnlMain.setLayout((Layout)new GridLayout());
        pnlMain.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewerBuilder = new TableViewerBuilder(pnlMain, 66304);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewerBuilder.getTableViewer());
        this.createColumns();
        this.viewerBuilder.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object med1, Object med2) {
                if (!$assertionsDisabled && !(med1 instanceof ModelExtensionDefinition)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !(med1 instanceof ModelExtensionDefinition)) {
                    throw new AssertionError();
                }
                return super.compare(viewer, (Object)((ModelExtensionDefinition)med1).getNamespacePrefix(), (Object)((ModelExtensionDefinition)med2).getNamespacePrefix());
            }
        });
        this.viewerBuilder.setLabelProvider((IBaseLabelProvider)new MedLabelProvider());
        this.viewerBuilder.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                ArrayList<ModelExtensionDefinition> definitions = new ArrayList<ModelExtensionDefinition>();
                for (ModelExtensionDefinition med : ModelExtensionRegistryView.this.getModelExtensionDefinitions()) {
                    if (!med.getModelExtensionAssistant().supportsMedOperation("SHOW_IN_REGISTRY", null)) continue;
                    definitions.add(med);
                }
                return definitions.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewerBuilder.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModelExtensionRegistryView.this.handleMedSelected();
            }
        });
        this.viewerBuilder.setInput((Object)this);
        this.createActions();
        MenuManager mgr = this.createContextMenu();
        Menu menu = mgr.createContextMenu((Control)this.viewerBuilder.getControl());
        this.viewerBuilder.getControl().setMenu(menu);
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.configureMenu(actionBars.getMenuManager());
        this.configureToolBar(actionBars.getToolBarManager());
        this.registerGlobalActions(this.getViewSite().getActionBars());
    }

    Collection<ModelExtensionDefinition> getModelExtensionDefinitions() {
        if (this.registry != null) {
            return this.registry.getAllDefinitions();
        }
        return Collections.emptyList();
    }

    private ModelExtensionDefinition getSelectedMed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewerBuilder.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        assert (selection.size() == 1) : "selection size is not zero or one";
        assert (selection.getFirstElement() instanceof ModelExtensionDefinition) : "selected object is not a MED";
        return (ModelExtensionDefinition)selection.getFirstElement();
    }

    public String getTitleToolTip() {
        return NLS.bind((String)Messages.registryViewToolTip, (Object)this.registry.getAllDefinitions().size());
    }

    void handleCloneMed() {
        ModelExtensionDefinition selectedMed = this.getSelectedMed();
        assert (selectedMed != null) : "Clone MED action should not be enabled if there is no selection";
        NewMedWizard wizard = new NewMedWizard(Messages.copyMedWizardTitle, selectedMed);
        wizard.init(UiPlugin.getDefault().getCurrentWorkbenchWindow().getWorkbench(), null);
        WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        wizardDialog.setBlockOnOpen(true);
        wizardDialog.open();
    }

    void handleViewMed() {
        ModelExtensionDefinition selectedMed = this.getSelectedMed();
        assert (selectedMed != null) : "Clone MED action should not be enabled if there is no selection";
        IFile medFile = null;
        try {
            if (selectedMed.isBuiltIn()) {
                medFile = this.copyMedToBuiltInProject("", selectedMed);
            } else if (selectedMed.isImported()) {
                String definitionsPath = ExtensionPlugin.getInstance().getUserDefinitionsPath();
                ExtensionDefinitionsManager manager = new ExtensionDefinitionsManager(definitionsPath);
                File defnFile = manager.saveDefinition(new ModelExtensionDefinitionWriter(), selectedMed);
                if (defnFile != null) {
                    medFile = this.linkMedToBuiltInProject("imported", defnFile);
                }
            } else {
                medFile = this.findWorkspaceMedMatch(selectedMed.getNamespacePrefix());
            }
            if (medFile != null) {
                IWorkbenchPage page = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage();
                IDE.openEditor((IWorkbenchPage)page, (IFile)medFile);
            } else {
                MessageDialog.openError((Shell)ModelExtensionRegistryView.getShell(), (String)Messages.openMedViewFailedTitle, (String)NLS.bind((String)Messages.openMedCouldNotViewFile, (Object)selectedMed.getNamespacePrefix()));
            }
        }
        catch (Exception ex) {
            ErrorHandler.toExceptionDialog((Throwable)ex);
        }
    }

    private IFile findWorkspaceMedMatch(String nsPrefix) {
        IFile medFileMatch = null;
        Collection projects = DotProjectUtils.getOpenModelProjects();
        for (IProject project : projects) {
            Collection projFiles = DotProjectUtils.getAllProjectResources((IProject)project);
            for (IFile projFile : projFiles) {
                String fileExt = projFile.getFileExtension();
                if (fileExt == null || !"mxd".equalsIgnoreCase(fileExt) || !this.medFileMatches(projFile, nsPrefix)) continue;
                medFileMatch = projFile;
                break;
            }
            if (medFileMatch != null) break;
        }
        return medFileMatch;
    }

    private boolean medFileMatches(IFile medFile, String nsPrefix) {
        InputStream fileContents = null;
        try {
            fileContents = medFile.getContents();
        }
        catch (CoreException e) {
            ErrorHandler.toExceptionDialog((String)NLS.bind((String)Messages.medFileGetContentsErrorMsg, (Object)medFile.getName()), (Throwable)e);
            return false;
        }
        if (fileContents == null) {
            return false;
        }
        ModelExtensionDefinition med = null;
        try {
            ModelExtensionDefinitionParser parser = new ModelExtensionDefinitionParser(ExtensionPlugin.getInstance().getMedSchema());
            med = parser.parse(fileContents, (ModelExtensionAssistant)ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant());
            if (!parser.getErrors().isEmpty()) {
                MessageDialog.openError((Shell)ModelExtensionRegistryView.getShell(), (String)Messages.registerMedActionFailedTitle, (String)NLS.bind((String)Messages.medFileParseErrorMsg, (Object)medFile.getName()));
                return false;
            }
        }
        catch (Exception e) {
            ErrorHandler.toExceptionDialog((String)Messages.registerMedActionFailedMsg, (Throwable)e);
            return false;
        }
        if (med == null) {
            return false;
        }
        String medFileNsPrefix = med.getNamespacePrefix();
        if (medFileNsPrefix == null) {
            return false;
        }
        return medFileNsPrefix.equals(nsPrefix);
    }

    private void createDirectories(IPath filePath, IProject project) throws CoreException {
        if (filePath.segmentCount() == 1) {
            return;
        }
        StringBuilder directory = new StringBuilder();
        NullProgressMonitor monitor = new NullProgressMonitor();
        String[] stringArray = filePath.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (filePath.lastSegment().equals(segment)) break;
            directory.append(File.separator).append(segment);
            Path folderPath = new Path(directory.toString());
            IFolder folder = project.getFolder((IPath)folderPath);
            if (folder != null && !folder.exists()) {
                folder.create(false, true, (IProgressMonitor)monitor);
            }
            ++n2;
        }
    }

    private IFile getFileFromBuiltInProject(IPath filePath) throws Exception {
        IProject builtInProject = ModelerCore.getWorkspace().getRoot().getProject("BuiltInMedsProject");
        if (builtInProject == null) {
            return null;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        builtInProject.refreshLocal(2, (IProgressMonitor)monitor);
        if (!builtInProject.exists()) {
            builtInProject.create((IProgressMonitor)monitor);
        }
        builtInProject.open((IProgressMonitor)monitor);
        return builtInProject.getFile(filePath);
    }

    private IFile linkMedToBuiltInProject(String subDirectory, File mxdFile) throws Exception {
        if (mxdFile == null || !mxdFile.exists()) {
            return null;
        }
        StringBuilder mxdPathBuilder = new StringBuilder(subDirectory);
        mxdPathBuilder.append(File.separator).append(mxdFile.getName());
        Path mxdLinkPath = new Path(mxdPathBuilder.toString());
        IFile mxdLink = this.getFileFromBuiltInProject((IPath)mxdLinkPath);
        IProject project = mxdLink.getProject();
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (mxdLink.exists()) {
            mxdLink.delete(true, (IProgressMonitor)monitor);
        }
        this.createDirectories((IPath)mxdLinkPath, project);
        mxdLink.createLink((IPath)new Path(mxdFile.getAbsolutePath()), 0, null);
        ResourceAttributes attributes = mxdLink.getResourceAttributes();
        attributes.setReadOnly(true);
        mxdLink.setResourceAttributes(attributes);
        project.refreshLocal(2, (IProgressMonitor)monitor);
        return mxdLink;
    }

    private IFile copyMedToBuiltInProject(String subDirectory, ModelExtensionDefinition medDefinition) throws Exception {
        String medName = medDefinition.getNamespacePrefix().toLowerCase();
        StringBuilder mxdPathBuilder = new StringBuilder(subDirectory);
        mxdPathBuilder.append(File.separator).append(medName).append(".mxd");
        Path mxdFilePath = new Path(mxdPathBuilder.toString());
        IFile mxdFile = this.getFileFromBuiltInProject((IPath)mxdFilePath);
        IProject project = mxdFile.getProject();
        if (mxdFile.exists()) {
            return mxdFile;
        }
        try (InputStream medInputStream = null;){
            this.createDirectories((IPath)mxdFilePath, project);
            ModelExtensionDefinitionWriter medWriter = new ModelExtensionDefinitionWriter();
            medInputStream = medWriter.writeAsStream(medDefinition);
            NullProgressMonitor monitor = new NullProgressMonitor();
            mxdFile.create(medInputStream, false, (IProgressMonitor)monitor);
            ResourceAttributes attributes = mxdFile.getResourceAttributes();
            attributes.setReadOnly(true);
            mxdFile.setResourceAttributes(attributes);
            project.refreshLocal(2, (IProgressMonitor)monitor);
            IFile iFile = mxdFile;
            return iFile;
        }
    }

    void handleFindMedReferences() {
        ModelExtensionDefinition selectedMed = this.getSelectedMed();
        assert (selectedMed != null) : "Find MED references action should not be enabled if there is no selection";
    }

    void handleMedSelected() {
        ModelExtensionDefinition selectedMed = this.getSelectedMed();
        if (selectedMed == null) {
            this.viewMedAction.setEnabled(false);
            this.cloneMedAction.setEnabled(false);
            this.findMedReferencesAction.setEnabled(false);
            this.unregisterMedAction.setEnabled(false);
        } else {
            this.viewMedAction.setEnabled(true);
            this.cloneMedAction.setEnabled(true);
            if (selectedMed.isBuiltIn()) {
                this.unregisterMedAction.setEnabled(false);
            } else {
                this.unregisterMedAction.setEnabled(true);
            }
        }
    }

    void handleRegisterMed() {
        IFile mxdFile = this.selectWorkspaceMed();
        if (mxdFile != null) {
            RegistryDeploymentValidator.deploy(mxdFile);
        }
    }

    private IFile selectWorkspaceMed() {
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IContainer) {
                    return true;
                }
                IFile file = (IFile)element;
                return ModelExtensionRegistryView.this.isMedFile((IResource)file);
            }
        };
        ModelingResourceFilter wsFilter = new ModelingResourceFilter(filter);
        wsFilter.setShowHiddenProjects(false);
        wsFilter.addFilter((ViewerFilter)new ModelProjectFilter());
        Object[] models = WidgetUtil.showWorkspaceObjectSelectionDialog((String)Messages.selectMedDialogTitle, (String)Messages.selectMedDialogMsg, (boolean)false, null, (ViewerFilter)wsFilter, (ISelectionStatusValidator)this.medSelectionValidator, (ILabelProvider)new ModelExplorerLabelProvider());
        if (models.length > 0 && models[0] instanceof IFile) {
            return (IFile)models[0];
        }
        return null;
    }

    public boolean isMedFile(IResource resource) {
        return "mxd".equals(resource.getFileExtension());
    }

    void handleRegistryChanged(final RegistryEvent event) {
        final ModelExtensionDefinition med = event.getDefinition();
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (event.isAdd()) {
                    ModelExtensionRegistryView.this.viewerBuilder.add((Object)med);
                } else if (event.isChange()) {
                    ModelExtensionRegistryView.this.viewerBuilder.getTableViewer().refresh((Object)med);
                } else if (event.isRemove()) {
                    ModelExtensionRegistryView.this.viewerBuilder.getTableViewer().remove((Object)med);
                }
            }
        }, (boolean)true);
    }

    void handleUnregisterMed() {
        ModelExtensionDefinition selectedMed = this.getSelectedMed();
        assert (selectedMed != null) : "Unregister MED action should not be enabled if there is no selection";
        boolean continueRemove = MessageDialog.openConfirm((Shell)ModelExtensionRegistryView.getShell(), (String)Messages.unregisterMedConfirmTitle, (String)Messages.unregisterMedConfirmMsg);
        if (continueRemove) {
            this.registry.removeDefinition(selectedMed.getNamespacePrefix());
        }
    }

    private void registerGlobalActions(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.cloneMedAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.unregisterMedAction);
        Action unsupportedAction = new Action(){

            public void setEnabled(boolean theEnabled) {
                super.setEnabled(false);
            }
        };
        unsupportedAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)unsupportedAction);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)unsupportedAction);
        actionBars.updateActionBars();
    }

    public void setFocus() {
        if (this.viewerBuilder != null && !this.viewerBuilder.getControl().isDisposed()) {
            this.viewerBuilder.getControl().setFocus();
        }
    }

    private static Shell getShell() {
        return UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }

    static interface ColumnIndexes {
        public static final int BUILT_IN = 0;
        public static final int IMPORTED = 1;
        public static final int NAMESPACE_PREFIX = 2;
        public static final int NAMESPACE_URI = 3;
        public static final int METAMODEL_URI = 4;
        public static final int MODEL_TYPES = 5;
        public static final int VERSION = 6;
        public static final int DESCRIPTION = 7;
    }

    class MedLabelProvider
    extends StyledCellLabelProvider {
        MedLabelProvider() {
        }

        private Image getImage(int columnIndex, ModelExtensionDefinition element) {
            switch (columnIndex) {
                case 0: {
                    if (!element.isBuiltIn()) break;
                    return Activator.getDefault().getImage("icons/checkmark.gif");
                }
                case 1: {
                    if (!element.isImported()) break;
                    return Activator.getDefault().getImage("icons/checkmark.gif");
                }
            }
            return null;
        }

        private String getText(int columnIndex, ModelExtensionDefinition element) {
            switch (columnIndex) {
                case 0: 
                case 1: {
                    return "";
                }
                case 2: {
                    return element.getNamespacePrefix();
                }
                case 3: {
                    return element.getNamespaceUri();
                }
                case 4: {
                    String metamodelUri = element.getMetamodelUri();
                    return Activator.getDefault().getMetamodelName(metamodelUri);
                }
                case 5: {
                    Set modelTypes = element.getSupportedModelTypes();
                    if (modelTypes.isEmpty()) {
                        return Messages.allModelTypesAreSupported;
                    }
                    StringBuilder text = new StringBuilder();
                    boolean firstTime = true;
                    for (String modelType : modelTypes) {
                        if (firstTime) {
                            firstTime = false;
                        } else {
                            text.append(" ").append(",");
                        }
                        text.append(Activator.getDefault().getModelTypeName(modelType));
                    }
                    return text.toString();
                }
                case 6: {
                    return Integer.toString(element.getVersion());
                }
                case 7: {
                    return element.getDescription();
                }
            }
            assert (false) : "Unknown column index of " + columnIndex;
            return null;
        }

        public void update(ViewerCell cell) {
            assert (cell.getElement() instanceof ModelExtensionDefinition);
            int columnIndex = cell.getColumnIndex();
            ModelExtensionDefinition element = (ModelExtensionDefinition)cell.getElement();
            String text = this.getText(columnIndex, element);
            Image img = this.getImage(columnIndex, element);
            if (text != null) {
                cell.setText(text);
            }
            if (img != null) {
                cell.setImage(img);
            }
            super.update(cell);
        }

        protected void paint(Event event, Object element) {
            TableItem tableItem = (TableItem)event.item;
            Image img = tableItem.getImage(event.index);
            if (img == null) {
                super.paint(event, element);
                return;
            }
            Rectangle bounds = tableItem.getBounds(event.index);
            Rectangle imgBounds = img.getBounds();
            bounds.width /= 2;
            bounds.width -= imgBounds.width / 2;
            bounds.height /= 2;
            bounds.height -= imgBounds.height / 2;
            int x = bounds.width > 0 ? bounds.x + bounds.width : bounds.x;
            int y = bounds.height > 0 ? bounds.y + bounds.height : bounds.y;
            event.gc.drawImage(img, x, y);
        }
    }

    class ModelProjectFilter
    extends ViewerFilter {
        ModelProjectFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IProject) {
                boolean result = false;
                try {
                    result = ((IProject)element).isOpen() && !((IProject)element).hasNature("org.teiid.designer.core.hiddenProjectNature") && ((IProject)element).hasNature("org.teiid.designer.core.modelNature");
                }
                catch (CoreException e) {
                    ErrorHandler.toExceptionDialog((CoreException)e);
                }
                return result;
            }
            return true;
        }
    }
}

