/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionHeader;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.UiConstants;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;

public class AvailableModelExtensionDefinitionsDialog
extends SelectionStatusDialog {
    private ModelResource modelResource;
    private ModelExtensionRegistry registry;
    private List<ModelExtensionDefinition> availableMedsList;
    private List<ModelExtensionDefinition> selectedMedsList;
    private TableViewerBuilder tableViewerBuilder;

    public AvailableModelExtensionDefinitionsDialog(Shell shell, ModelResource resource, List<ModelExtensionDefinitionHeader> currentModelHeaders) {
        super(shell);
        this.setTitle(Messages.availableMedsDialogTitle);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setStatusLineAboveButtons(true);
        this.registry = Platform.isRunning() ? ExtensionPlugin.getInstance().getRegistry() : null;
        this.modelResource = resource;
        this.availableMedsList = this.getAddableMEDs(this.modelResource, currentModelHeaders);
        this.selectedMedsList = new ArrayList<ModelExtensionDefinition>();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData compositeGridData = new GridData(768);
        composite.setLayoutData((Object)compositeGridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        Label messageLabel = new Label(composite, 0);
        messageLabel.setText(Messages.availableMedsDialogMsg);
        Group tableGroup = WidgetFactory.createGroup((Composite)composite, (String)Messages.availableMedsDialogTableLabel);
        tableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTableViewer((Composite)tableGroup);
        return composite;
    }

    public void create() {
        super.create();
        this.updateDialogMessage(Messages.availableMedsDialogNotDoneMsg, true);
    }

    public List<ModelExtensionDefinition> getSelectedModelExtensionDefinitions() {
        return this.selectedMedsList;
    }

    protected void computeResult() {
        this.setResult(((IStructuredSelection)this.tableViewerBuilder.getSelection()).toList());
    }

    private void updateDialogMessage(String sMessage, boolean bIsError) {
        int iStatusCode = 0;
        if (bIsError) {
            iStatusCode = 4;
        }
        StatusInfo status = new StatusInfo(UiConstants.PLUGIN_ID, iStatusCode, sMessage);
        this.updateStatus((IStatus)status);
    }

    private List<ModelExtensionDefinition> getAddableMEDs(ModelResource modelResource, List<ModelExtensionDefinitionHeader> currentModelHeaders) {
        ArrayList<ModelExtensionDefinition> resultList = new ArrayList<ModelExtensionDefinition>();
        IFile file = (IFile)modelResource.getResource();
        Collection allDefinitions = this.registry.getAllDefinitions();
        for (ModelExtensionDefinition med : allDefinitions) {
            ModelExtensionAssistant assistant = med.getModelExtensionAssistant();
            if (!assistant.supportsMedOperation("ADD_MED_TO_MODEL", (Object)file) || this.headerListContains(currentModelHeaders, med.getNamespacePrefix(), med.getVersion())) continue;
            resultList.add(med);
        }
        return resultList;
    }

    private boolean headerListContains(List<ModelExtensionDefinitionHeader> currentModelHeaders, String namespacePrefix, int version) {
        boolean contains = false;
        for (ModelExtensionDefinitionHeader header : currentModelHeaders) {
            if (!namespacePrefix.equals(header.getNamespacePrefix()) || version != header.getVersion()) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private void createTableViewer(Composite parent) {
        this.tableViewerBuilder = new TableViewerBuilder(parent, 66306);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewerBuilder.getTableViewer());
        this.createColumns();
        this.tableViewerBuilder.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object med1, Object med2) {
                if (!$assertionsDisabled && !(med1 instanceof ModelExtensionDefinition)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !(med2 instanceof ModelExtensionDefinition)) {
                    throw new AssertionError();
                }
                return super.compare(viewer, (Object)((ModelExtensionDefinition)med1).getNamespacePrefix(), (Object)((ModelExtensionDefinition)med1).getNamespacePrefix());
            }
        });
        this.tableViewerBuilder.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return AvailableModelExtensionDefinitionsDialog.this.getAvailableMeds().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewerBuilder.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AvailableModelExtensionDefinitionsDialog.this.handleMedSelectionChanged();
            }
        });
        this.tableViewerBuilder.setInput(this.availableMedsList);
    }

    void handleMedSelectionChanged() {
        this.selectedMedsList.clear();
        int[] selectedMedIndices = this.tableViewerBuilder.getTable().getSelectionIndices();
        if (selectedMedIndices.length > 0) {
            int i = 0;
            while (i < selectedMedIndices.length) {
                this.selectedMedsList.add(this.availableMedsList.get(selectedMedIndices[i]));
                ++i;
            }
            this.updateDialogMessage(Messages.availableMedsDialogDoneMsg, false);
        } else {
            this.updateDialogMessage(Messages.availableMedsDialogNotDoneMsg, true);
        }
    }

    private void createColumns() {
        TableViewerColumn column = this.tableViewerBuilder.createColumn(16384, 40, 30, true);
        this.configureColumn(column, 0, ColumnHeaders.NAMESPACE_PREFIX, true);
        column = this.tableViewerBuilder.createColumn(131072, 10, 20, true);
        this.configureColumn(column, 1, ColumnHeaders.VERSION, true);
        TableViewerColumn lastColumn = this.tableViewerBuilder.createColumn(16384, 50, 100, true);
        this.configureColumn(lastColumn, 2, ColumnHeaders.DESCRIPTION, true);
    }

    private void configureColumn(TableViewerColumn viewerColumn, int columnIndex, String headerText, boolean resizable) {
        viewerColumn.setLabelProvider((CellLabelProvider)new MedLabelProvider(columnIndex));
        TableColumn column = viewerColumn.getColumn();
        column.setText(headerText);
        column.setMoveable(false);
        column.setResizable(resizable);
    }

    List<ModelExtensionDefinition> getAvailableMeds() {
        return this.availableMedsList;
    }

    static interface ColumnHeaders {
        public static final String NAMESPACE_PREFIX = Messages.namespacePrefixColumnText;
        public static final String VERSION = Messages.versionColumnText;
        public static final String DESCRIPTION = Messages.descriptionColumnText;
    }

    static interface ColumnIndexes {
        public static final int NAMESPACE_PREFIX = 0;
        public static final int VERSION = 1;
        public static final int DESCRIPTION = 2;
    }

    class MedLabelProvider
    extends ColumnLabelProvider {
        private final int columnIndex;

        public MedLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            assert (element instanceof ModelExtensionDefinition);
            ModelExtensionDefinition med = (ModelExtensionDefinition)element;
            if (this.columnIndex == 0) {
                return med.getNamespacePrefix();
            }
            if (this.columnIndex == 1) {
                return Integer.toString(med.getVersion());
            }
            if (this.columnIndex == 2) {
                return med.getDescription();
            }
            assert (false) : "Unknown column index of " + this.columnIndex;
            return null;
        }
    }
}

