/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.ModelExtensionAssistantAggregator;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionHeader;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.extension.ui.Activator;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.wizards.AvailableModelExtensionDefinitionsDialog;
import org.teiid.designer.extension.ui.wizards.MedHeadersEditManager;
import org.teiid.designer.extension.ui.wizards.NewMedWizard;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class CurrentModelExtensionDefnsPage
extends WizardPage
implements InternalUiConstants.Widgets {
    private final ModelExtensionRegistry registry;
    private static final int STATUS_OK = 0;
    private static final int STATUS_NO_LOCATION = 1;
    private static final int STATUS_NO_MODELNAME = 2;
    ModelResource modelResource;
    Text locationText;
    Text modelNameText;
    private TableViewerBuilder tableViewerBuilder;
    private MedHeadersEditManager editManager;
    private Collection<ModelExtensionDefinition> modelMeds;
    private Button addMedButton;
    private Button removeMedButton;
    private Button saveMedButton;
    private Button updateMedButton;
    protected int currentStatus = 0;

    public CurrentModelExtensionDefnsPage(ModelResource rsrc) {
        super("CurrentModelExtensionDefnsPage");
        this.setTitle(Messages.currentMedsPageTitle);
        this.setDescription(Messages.currentMedsPageTitle);
        this.registry = Platform.isRunning() ? ExtensionPlugin.getInstance().getRegistry() : null;
        this.modelResource = rsrc;
        this.editManager = new MedHeadersEditManager(this.getModelExtensionDefnHeaders(this.modelResource));
    }

    private List<ModelExtensionDefinitionHeader> getModelExtensionDefnHeaders(ModelResource modelResource) {
        ArrayList<ModelExtensionDefinitionHeader> headers = new ArrayList<ModelExtensionDefinitionHeader>();
        try {
            ModelExtensionAssistantAggregator aggregator = ExtensionPlugin.getInstance().getModelExtensionAssistantAggregator();
            Collection supportedNamespaces = aggregator.getSupportedNamespacePrefixes((Object)modelResource);
            this.modelMeds = new ArrayList<ModelExtensionDefinition>(supportedNamespaces.size());
            for (String namespacePrefix : supportedNamespaces) {
                ModelObjectExtensionAssistant modelAssistant = ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant(namespacePrefix);
                ModelExtensionAssistant registryAssistant = this.getRegistry().getModelExtensionAssistant(namespacePrefix);
                boolean addMed = true;
                if (registryAssistant != null && registryAssistant instanceof ModelObjectExtensionAssistant) {
                    addMed = ((ModelObjectExtensionAssistant)registryAssistant).supportsMedOperation("SHOW_CONTAINED_IN_MODEL", (Object)modelResource);
                }
                if (!addMed) continue;
                ModelExtensionDefinition med = modelAssistant.getModelExtensionDefinition((Object)this.modelResource);
                this.modelMeds.add(med);
                headers.add(med.getHeader());
            }
        }
        catch (Exception e) {
            ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
        }
        return headers;
    }

    List<ModelExtensionDefinitionHeader> getCurrentHeaders() {
        return this.editManager.getCurrentHeaders();
    }

    public List<ModelExtensionDefinition> getModelExtensionDefnsToAdd() {
        return this.editManager.getModelExtensionDefnsToAdd();
    }

    public List<String> getNamespacesToRemove() {
        return this.editManager.getNamespacesToRemove();
    }

    public List<String> getNamespacesToUpdate() {
        return this.editManager.getNamespacesToUpdate();
    }

    public ModelResource getSelectedModelResource() {
        return this.modelResource;
    }

    private ModelExtensionRegistry getRegistry() {
        return this.registry;
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        Composite topComposite = new Composite(parent, 0);
        GridData topCompositeGridData = new GridData(768);
        topComposite.setLayoutData((Object)topCompositeGridData);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 3;
        topComposite.setLayout((Layout)topLayout);
        GridData gd = null;
        Label locationLabel = new Label(topComposite, 0);
        locationLabel.setText(Messages.currentMedsPageModelLocationLabel);
        this.locationText = new Text(topComposite, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.locationText.setLayoutData((Object)gd);
        this.locationText.setBackground(locationLabel.getBackground());
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CurrentModelExtensionDefnsPage.this.updateStatus();
            }
        });
        this.locationText.setEditable(false);
        Label modelNameLabel = new Label(topComposite, 0);
        modelNameLabel.setText(Messages.currentMedsPageModelNameLabel);
        this.modelNameText = new Text(topComposite, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.modelNameText.setLayoutData((Object)gd);
        this.modelNameText.setBackground(modelNameLabel.getBackground());
        this.modelNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CurrentModelExtensionDefnsPage.this.updateStatus();
            }
        });
        this.modelNameText.setEditable(false);
        Composite bottomComposite = new Composite(parent, 0);
        bottomComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout bottomLayout = new GridLayout(2, false);
        bottomLayout.horizontalSpacing = 0;
        bottomComposite.setLayout((Layout)bottomLayout);
        this.createTableViewer(bottomComposite);
        this.createTableButtonComposite(bottomComposite);
        this.setControl((Control)parent);
        this.updateModelDisplay();
        this.updateStatus();
        bottomComposite.setFocus();
    }

    private void updateModelDisplay() {
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CurrentModelExtensionDefnsPage.this.modelResource == null) {
                    return;
                }
                IContainer parentContainer = (IContainer)CurrentModelExtensionDefnsPage.this.modelResource.getParent().getResource();
                if (parentContainer != null && parentContainer.getProject() != null) {
                    IProject project = parentContainer.getProject();
                    CurrentModelExtensionDefnsPage.this.locationText.setText(String.valueOf(project.getName()) + File.separator + parentContainer.getProjectRelativePath().toString());
                }
                CurrentModelExtensionDefnsPage.this.modelNameText.setText(CurrentModelExtensionDefnsPage.this.modelResource.getPath().removeFileExtension().lastSegment());
            }
        });
    }

    void updateStatus() {
        String location = this.getModelLocation();
        if (CoreStringUtil.isEmpty((String)location)) {
            this.setMessage(Messages.currentMedsPageNoModelLocationMsg, 3);
            this.currentStatus = 1;
            this.setPageComplete(false);
            return;
        }
        String modelNameText = this.getModelName();
        if (modelNameText.length() == 0) {
            this.currentStatus = 2;
            this.setMessage(Messages.currentMedsPageNoModelNameMsg, 3);
            return;
        }
        this.setMessage(Messages.currentMedsPageDone, 0);
        this.setPageComplete(true);
    }

    boolean canExtend(IFile theFile) {
        boolean result = false;
        Collection meds = this.registry.getAllDefinitions();
        for (ModelExtensionDefinition med : meds) {
            ModelExtensionAssistant assistant = med.getModelExtensionAssistant();
            if (!assistant.supportsMedOperation("ADD_MED_TO_MODEL", (Object)theFile) && !assistant.supportsMedOperation("DELETE_MED_FROM_MODEL", (Object)theFile)) continue;
            result = true;
            break;
        }
        return result;
    }

    boolean isMetamodelExtendable(ModelResource modelResource) {
        if (this.registry != null && modelResource != null) {
            String selectedModelURI = ModelIdentifier.getPrimaryMetamodelURI((Object)modelResource);
            return this.registry.isExtendable(selectedModelURI);
        }
        return false;
    }

    public String getModelLocation() {
        String result = this.locationText.getText().trim();
        return result;
    }

    public String getModelName() {
        String result = this.modelNameText.getText().trim();
        return result;
    }

    private void createTableViewer(Composite parent) {
        Group tableGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.currentMedsPageTableLabel);
        tableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewerBuilder = new TableViewerBuilder((Composite)tableGroup, 67588);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewerBuilder.getTableViewer());
        this.createColumns();
        this.tableViewerBuilder.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object medHeader1, Object medHeader2) {
                if (!$assertionsDisabled && !(medHeader1 instanceof ModelExtensionDefinitionHeader)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !(medHeader2 instanceof ModelExtensionDefinitionHeader)) {
                    throw new AssertionError();
                }
                return super.compare(viewer, (Object)((ModelExtensionDefinitionHeader)medHeader1).getNamespacePrefix(), (Object)((ModelExtensionDefinitionHeader)medHeader2).getNamespacePrefix());
            }
        });
        this.tableViewerBuilder.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return CurrentModelExtensionDefnsPage.this.getCurrentHeaders().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewerBuilder.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CurrentModelExtensionDefnsPage.this.handleMedSelectionChanged();
            }
        });
        this.tableViewerBuilder.setInput(this.editManager.getCurrentHeaders());
    }

    void handleMedSelectionChanged() {
        this.setButtonStates();
    }

    private void createColumns() {
        TableViewerColumn column = this.tableViewerBuilder.createColumn(131072, 5, 20, true);
        this.configureColumn(column, 0, ColumnHeaders.REGISTERED, ColumnToolTips.REGISTERED, false);
        column = this.tableViewerBuilder.createColumn(131072, 5, 20, true);
        this.configureColumn(column, 1, ColumnHeaders.DIFFERENT, ColumnToolTips.DIFFERENT, false);
        column = this.tableViewerBuilder.createColumn(16384, 30, 50, true);
        this.configureColumn(column, 2, ColumnHeaders.NAMESPACE_PREFIX, ColumnToolTips.NAMESPACE_PREFIX, true);
        column = this.tableViewerBuilder.createColumn(131072, 5, 20, true);
        this.configureColumn(column, 3, ColumnHeaders.VERSION, ColumnToolTips.VERSION, true);
        TableViewerColumn lastColumn = this.tableViewerBuilder.createColumn(16384, 30, 50, true);
        this.configureColumn(lastColumn, 4, ColumnHeaders.DESCRIPTION, ColumnToolTips.DESCRIPTION, true);
    }

    private void configureColumn(TableViewerColumn viewerColumn, int columnIndex, String headerText, String headerToolTip, boolean resizable) {
        viewerColumn.setLabelProvider((CellLabelProvider)new MedLabelProvider(columnIndex));
        TableColumn column = viewerColumn.getColumn();
        column.setText(headerText);
        column.setToolTipText(headerToolTip);
        column.setMoveable(false);
        column.setResizable(resizable);
    }

    private Composite createTableButtonComposite(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        buttonComposite.setLayout((Layout)layout);
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginTop = 5;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(1, 128, false, false));
        this.addMedButton = new Button(buttonComposite, 8);
        this.addMedButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.addMedButton.setText(Messages.currentMedsPageAddMedButton);
        this.addMedButton.setToolTipText(Messages.currentMedsPageAddMedTooltip);
        this.addMedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrentModelExtensionDefnsPage.this.handleAddMed();
            }
        });
        this.addMedButton.setEnabled(true);
        this.removeMedButton = new Button(buttonComposite, 8);
        this.removeMedButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.removeMedButton.setText(Messages.currentMedsPageRemoveMedButton);
        this.removeMedButton.setToolTipText(Messages.currentMedsPageRemoveMedTooltip);
        this.removeMedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrentModelExtensionDefnsPage.this.handleRemoveMed();
            }
        });
        this.removeMedButton.setEnabled(false);
        this.saveMedButton = new Button(buttonComposite, 8);
        this.saveMedButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.saveMedButton.setText(Messages.currentMedsPageSaveMedButton);
        this.saveMedButton.setToolTipText(Messages.currentMedsPageSaveMedTooltip);
        this.saveMedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrentModelExtensionDefnsPage.this.handleSaveMed();
            }
        });
        this.saveMedButton.setEnabled(false);
        this.updateMedButton = new Button(buttonComposite, 8);
        this.updateMedButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.updateMedButton.setText(Messages.currentMedsPageUpdateMedButton);
        this.updateMedButton.setToolTipText(Messages.currentMedsPageUpdateMedTooltip);
        this.updateMedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrentModelExtensionDefnsPage.this.handleUpdateMed();
            }
        });
        this.updateMedButton.setEnabled(false);
        return buttonComposite;
    }

    private void setButtonStates() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewerBuilder.getSelection();
        boolean medSelected = !selection.isEmpty();
        boolean enableRemove = false;
        boolean enableSave = false;
        boolean enableUpdate = false;
        if (medSelected) {
            ModelExtensionDefinitionHeader medHeader = (ModelExtensionDefinitionHeader)selection.getFirstElement();
            ModelExtensionDefinition registryMed = this.getRegistry().getDefinition(medHeader.getNamespacePrefix());
            if (registryMed == null || registryMed.getModelExtensionAssistant().supportsMedOperation("DELETE_MED_FROM_MODEL", (Object)this.modelResource.getResource())) {
                enableRemove = true;
            }
            if (!this.isRegistered(medHeader) || this.isDifferent(medHeader)) {
                enableSave = true;
                enableUpdate = true;
            }
        }
        if (this.removeMedButton.getEnabled() != enableRemove) {
            this.removeMedButton.setEnabled(enableRemove);
        }
        if (this.saveMedButton.getEnabled() != enableSave) {
            this.saveMedButton.setEnabled(enableSave);
        }
        if (this.updateMedButton.getEnabled() != enableUpdate) {
            this.updateMedButton.setEnabled(enableUpdate);
        }
    }

    ModelExtensionDefinition getModelMed(String namespacePrefix) {
        if (this.modelMeds != null) {
            for (ModelExtensionDefinition med : this.modelMeds) {
                if (!med.getNamespacePrefix().equals(namespacePrefix)) continue;
                return med;
            }
        }
        return null;
    }

    boolean isDifferent(ModelExtensionDefinitionHeader medHeader) {
        if (this.isRegistered(medHeader)) {
            String namespacePrefix = medHeader.getNamespacePrefix();
            ModelExtensionDefinition modelMed = this.getModelMed(namespacePrefix);
            if (modelMed == null) {
                return false;
            }
            if (!this.getRegistry().getDefinition(namespacePrefix).equals((Object)modelMed)) {
                return !this.editManager.getNamespacesToUpdate().contains(namespacePrefix);
            }
        }
        return false;
    }

    boolean isRegistered(ModelExtensionDefinitionHeader medHeader) {
        boolean isRegistered = false;
        if (medHeader != null) {
            String namespacePrefix = medHeader.getNamespacePrefix();
            if (this.getRegistry().isNamespacePrefixRegistered(namespacePrefix)) {
                isRegistered = true;
            }
        }
        return isRegistered;
    }

    void handleAddMed() {
        AvailableModelExtensionDefinitionsDialog dialog = new AvailableModelExtensionDefinitionsDialog(this.getShell(), this.modelResource, this.editManager.getCurrentHeaders());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            List<ModelExtensionDefinition> dialogMeds = dialog.getSelectedModelExtensionDefinitions();
            this.editManager.addModelExtensionDefinitions(dialogMeds);
            this.tableViewerBuilder.getTableViewer().refresh();
        }
    }

    void handleRemoveMed() {
        assert (!this.tableViewerBuilder.getSelection().isEmpty()) : "remove MED handler called when no MED is selected";
        boolean confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.currentMedsPageRemoveDialogTitle, (String)Messages.currentMedsPageRemoveDialogMsg);
        if (confirmed) {
            IStructuredSelection selection = (IStructuredSelection)this.tableViewerBuilder.getSelection();
            ModelExtensionDefinitionHeader medHeader = (ModelExtensionDefinitionHeader)selection.getFirstElement();
            String namespacePrefix = medHeader.getNamespacePrefix();
            this.editManager.removeModelExtensionDefinition(namespacePrefix);
            this.tableViewerBuilder.getTableViewer().refresh();
        }
    }

    void handleSaveMed() {
        assert (!this.tableViewerBuilder.getSelection().isEmpty()) : "save MED handler called when no MED is selected";
        IStructuredSelection selection = (IStructuredSelection)this.tableViewerBuilder.getSelection();
        ModelExtensionDefinitionHeader medHeader = (ModelExtensionDefinitionHeader)selection.getFirstElement();
        ModelObjectExtensionAssistant defaultAssistant = ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant(medHeader.getNamespacePrefix());
        ModelExtensionDefinition unregisteredMed = null;
        try {
            unregisteredMed = defaultAssistant.getModelExtensionDefinition((Object)this.modelResource);
        }
        catch (Exception e) {
            ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
        }
        NewMedWizard wizard = new NewMedWizard(Messages.copyMedWizardTitle, unregisteredMed);
        wizard.init(UiPlugin.getDefault().getCurrentWorkbenchWindow().getWorkbench(), null);
        WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        wizardDialog.setBlockOnOpen(true);
        wizardDialog.open();
        this.tableViewerBuilder.getTable().deselectAll();
        this.setButtonStates();
        this.editManager = new MedHeadersEditManager(this.getModelExtensionDefnHeaders(this.modelResource));
        this.tableViewerBuilder.getTableViewer().refresh();
    }

    void handleUpdateMed() {
        assert (!this.tableViewerBuilder.getSelection().isEmpty()) : "update MED handler called when no MED is selected";
        boolean confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.currentMedsPageUpdateMedDialogTitle, (String)Messages.currentMedsPageUpdateMedDialogMsg);
        if (confirmed) {
            IStructuredSelection selection = (IStructuredSelection)this.tableViewerBuilder.getSelection();
            ModelExtensionDefinitionHeader medHeader = (ModelExtensionDefinitionHeader)selection.getFirstElement();
            String namespacePrefix = medHeader.getNamespacePrefix();
            this.editManager.updateModelExtensionDefinition(this.registry.getDefinition(namespacePrefix));
            this.tableViewerBuilder.getTableViewer().refresh();
        }
    }

    static interface ColumnHeaders {
        public static final String REGISTERED = Messages.registeredColumnText;
        public static final String DIFFERENT = Messages.medsDifferentColumnText;
        public static final String NAMESPACE_PREFIX = Messages.namespacePrefixColumnText;
        public static final String VERSION = Messages.versionColumnText;
        public static final String DESCRIPTION = Messages.descriptionColumnText;
    }

    static interface ColumnIndexes {
        public static final int REGISTERED = 0;
        public static final int DIFFERENT = 1;
        public static final int NAMESPACE_PREFIX = 2;
        public static final int VERSION = 3;
        public static final int DESCRIPTION = 4;
    }

    static interface ColumnToolTips {
        public static final String REGISTERED = Messages.registeredColumnToolTip;
        public static final String DIFFERENT = Messages.medsDifferentColumnToolTip;
        public static final String NAMESPACE_PREFIX = Messages.namespacePrefixColumnToolTip;
        public static final String VERSION = Messages.versionColumnToolTip;
        public static final String DESCRIPTION = Messages.descriptionColumnToolTip;
    }

    class MedLabelProvider
    extends ColumnLabelProvider {
        private final int columnIndex;

        public MedLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public Image getImage(Object element) {
            assert (element instanceof ModelExtensionDefinitionHeader);
            ModelExtensionDefinitionHeader medHeader = (ModelExtensionDefinitionHeader)element;
            if (this.columnIndex == 0 ? CurrentModelExtensionDefnsPage.this.isRegistered(medHeader) : this.columnIndex == 1 && CurrentModelExtensionDefnsPage.this.isDifferent(medHeader)) {
                return Activator.getDefault().getImage("icons/checkmark.gif");
            }
            return null;
        }

        public String getText(Object element) {
            assert (element instanceof ModelExtensionDefinitionHeader);
            ModelExtensionDefinitionHeader header = (ModelExtensionDefinitionHeader)element;
            if (this.columnIndex == 0 || this.columnIndex == 1) {
                return null;
            }
            if (this.columnIndex == 2) {
                return header.getNamespacePrefix();
            }
            if (this.columnIndex == 3) {
                return Integer.toString(header.getVersion());
            }
            if (this.columnIndex == 4) {
                return header.getDescription();
            }
            assert (false) : "Unknown column index of " + this.columnIndex;
            return null;
        }
    }
}

