/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionHeader;

public class MedHeadersEditManager {
    private List<ModelExtensionDefinitionHeader> currentMedHeaderList;
    private List<ModelExtensionDefinitionHeader> originalMedHeaderList;
    private List<ModelExtensionDefinition> medsToAddList;
    private List<String> namespacesToRemoveList;
    private List<String> namespacesToUpdateList;

    public MedHeadersEditManager(List<ModelExtensionDefinitionHeader> headerList) {
        CoreArgCheck.isNotNull(headerList, (String)"headerList is null");
        this.originalMedHeaderList = headerList;
        this.currentMedHeaderList = new ArrayList<ModelExtensionDefinitionHeader>(headerList);
        this.medsToAddList = new ArrayList<ModelExtensionDefinition>();
        this.namespacesToRemoveList = new ArrayList<String>();
        this.namespacesToUpdateList = new ArrayList<String>();
    }

    public void addModelExtensionDefinition(ModelExtensionDefinition med) {
        CoreArgCheck.isNotNull((Object)med, (String)"med is null");
        ModelExtensionDefinitionHeader medHeader = med.getHeader();
        if (!this.currentMedHeaderList.contains(medHeader)) {
            this.currentMedHeaderList.add(medHeader);
            if (!this.originalMedHeaderList.contains(medHeader)) {
                this.medsToAddList.add(med);
            }
        }
        String nsPrefix = med.getNamespacePrefix();
        this.namespacesToRemoveList.remove(nsPrefix);
    }

    public void addModelExtensionDefinitions(List<ModelExtensionDefinition> medList) {
        CoreArgCheck.isNotNull(medList, (String)"medList is null");
        for (ModelExtensionDefinition med : medList) {
            this.addModelExtensionDefinition(med);
        }
    }

    public void updateModelExtensionDefinition(ModelExtensionDefinition med) {
        CoreArgCheck.isNotNull((Object)med, (String)"med is null");
        ModelExtensionDefinitionHeader updateMedHeader = med.getHeader();
        for (ModelExtensionDefinitionHeader header : this.currentMedHeaderList) {
            if (!header.getNamespacePrefix().equals(updateMedHeader.getNamespacePrefix())) continue;
            this.currentMedHeaderList.remove(header);
            this.currentMedHeaderList.add(updateMedHeader);
            break;
        }
        this.namespacesToUpdateList.add(updateMedHeader.getNamespacePrefix());
    }

    public void removeModelExtensionDefinition(String nsPrefix) {
        int addListIndex;
        CoreArgCheck.isNotNull((Object)nsPrefix, (String)"Namespace Prefix is null");
        if (this.getListIndexOfNamespace(this.originalMedHeaderList, nsPrefix) != -1) {
            this.namespacesToRemoveList.add(nsPrefix);
        }
        if ((addListIndex = this.getListIndexOfNamespace(this.getHeaderList(this.medsToAddList), nsPrefix)) != -1) {
            this.medsToAddList.remove(addListIndex);
        }
        this.namespacesToUpdateList.remove(nsPrefix);
        int currentListIndex = this.getListIndexOfNamespace(this.currentMedHeaderList, nsPrefix);
        if (currentListIndex != -1) {
            this.currentMedHeaderList.remove(currentListIndex);
        }
    }

    public List<ModelExtensionDefinitionHeader> getCurrentHeaders() {
        return this.currentMedHeaderList;
    }

    public List<ModelExtensionDefinitionHeader> getOriginalHeaders() {
        return this.originalMedHeaderList;
    }

    public List<ModelExtensionDefinition> getModelExtensionDefnsToAdd() {
        return this.medsToAddList;
    }

    public List<String> getNamespacesToRemove() {
        return this.namespacesToRemoveList;
    }

    public List<String> getNamespacesToUpdate() {
        return this.namespacesToUpdateList;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("\nMED Headers Edit Manager: \n");
        text.append("Original Headers: \n");
        for (ModelExtensionDefinitionHeader header : this.originalMedHeaderList) {
            text.append("  NSPrefix: " + header.getNamespacePrefix() + ", Version: " + header.getVersion() + '\n');
        }
        text.append("Current Headers: \n");
        for (ModelExtensionDefinitionHeader header : this.currentMedHeaderList) {
            text.append("  NSPrefix: " + header.getNamespacePrefix() + ", Version: " + header.getVersion() + '\n');
        }
        text.append("MEDs to ADD: \n");
        for (ModelExtensionDefinition med : this.medsToAddList) {
            text.append("  NSPrefix: " + med.getNamespacePrefix() + ", Version: " + med.getVersion() + '\n');
        }
        text.append("NsPrefixes to REMOVE: \n");
        for (String nsPrefix : this.namespacesToRemoveList) {
            text.append("  NSPrefix: " + nsPrefix + '\n');
        }
        text.append("NsPrefixes to UPDATE: \n");
        for (String nsPrefix : this.namespacesToUpdateList) {
            text.append("  NSPrefix: " + nsPrefix + '\n');
        }
        return text.toString();
    }

    private List<ModelExtensionDefinitionHeader> getHeaderList(List<ModelExtensionDefinition> medList) {
        CoreArgCheck.isNotNull(medList, (String)"medList is null");
        ArrayList<ModelExtensionDefinitionHeader> headerList = new ArrayList<ModelExtensionDefinitionHeader>(medList.size());
        for (ModelExtensionDefinition med : medList) {
            headerList.add(med.getHeader());
        }
        return headerList;
    }

    private int getListIndexOfNamespace(List<ModelExtensionDefinitionHeader> medHeaderList, String namespace) {
        int resultIndex = -1;
        int i = 0;
        while (i < medHeaderList.size()) {
            ModelExtensionDefinitionHeader med = medHeaderList.get(i);
            if (med.getNamespacePrefix().equals(namespace)) {
                resultIndex = i;
                break;
            }
            ++i;
        }
        return resultIndex;
    }
}

