/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;

public class NewMedMainPage
extends AbstractWizardPage
implements InternalUiConstants.Widgets {
    private static final int COLUMN_COUNT = 3;
    private static final StringNameValidator nameValidator = new StringNameValidator(1, 255);
    private IContainer folderLocation;
    private String medName;
    private ISelectionStatusValidator projectValidator = new ModelProjectSelectionStatusValidator();
    private Text nameText;
    private Text folderText;
    private Button btnFolderBrowse;
    private Button openInEditorCB;

    public NewMedMainPage(IContainer folderLocation) {
        super(NewMedMainPage.class.getSimpleName(), Messages.newMedMainPageTitle);
        this.folderLocation = folderLocation;
    }

    public void createControl(Composite theParent) {
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        pnlMain.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)pnlMain);
        this.createMainPanel(pnlMain);
        this.validatePage();
    }

    private Composite createMainPanel(Composite parent) {
        WidgetFactory.createLabel((Composite)parent, (String)Messages.newMedWizardFolderLabel);
        String name = this.folderLocation == null ? null : this.folderLocation.getFullPath().makeRelative().toString();
        this.folderText = WidgetFactory.createTextField((Composite)parent, (int)768, (int)1, (String)name, (int)8);
        this.folderText.setToolTipText(Messages.newMedMainPageLocationTooltip);
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewMedMainPage.this.folderModified();
            }
        });
        this.btnFolderBrowse = WidgetFactory.createButton((Composite)parent, (String)BROWSE_BUTTON);
        this.btnFolderBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewMedMainPage.this.browseFolderButtonSelected();
            }
        });
        WidgetFactory.createLabel((Composite)parent, (String)Messages.newMedWizardNameLabel);
        this.nameText = WidgetFactory.createTextField((Composite)parent, (int)256, (int)2);
        this.nameText.setToolTipText(Messages.newMedMainPageMedNameTooltip);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewMedMainPage.this.nameModified();
            }
        });
        this.openInEditorCB = WidgetFactory.createCheckBox((Composite)parent, (String)Messages.newMedMainPageOpenInEditorLabel, (int)1032, (int)3, (boolean)Boolean.TRUE);
        this.openInEditorCB.setToolTipText(Messages.newMedMainPageOpenInEditorTooltip);
        if (this.folderLocation == null) {
            this.btnFolderBrowse.setFocus();
        } else {
            this.nameText.setFocus();
        }
        return parent;
    }

    public IContainer getFolderLocation() {
        return this.folderLocation;
    }

    public String getMedName() {
        if (!this.medName.endsWith(".mxd")) {
            this.medName = String.valueOf(this.medName) + ".mxd";
        }
        return this.medName;
    }

    public boolean openInEditorChecked() {
        return this.openInEditorCB.getSelection();
    }

    void browseFolderButtonSelected() {
        this.folderLocation = WidgetUtil.showFolderSelectionDialog((IContainer)this.folderLocation, (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)this.projectValidator);
        if (this.folderLocation != null) {
            this.folderText.setText(this.folderLocation.getFullPath().makeRelative().toString());
            if (CoreStringUtil.isEmpty((String)this.nameText.getText())) {
                this.nameText.setFocus();
            }
        }
        this.validatePage();
    }

    void folderModified() {
        this.validatePage();
    }

    void nameModified() {
        this.validatePage();
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void validatePage() {
        try {
            IContainer folder = WizardUtil.validateFileAndFolder((Text)this.nameText, (Text)this.folderText, (WizardPage)this, (String)".mxd", (boolean)false);
            if (this.getMessageType() == 3) {
                return;
            }
            IStatus status = this.projectValidator.validate(new Object[]{folder});
            String proposedName = this.nameText.getText();
            if (!status.isOK()) {
                if (folder != null) {
                    this.setErrorMessage(status.getMessage());
                    this.setPageComplete(false);
                }
            } else if (!nameValidator.isValidName(proposedName)) {
                this.setErrorMessage(Messages.newMedWizardMedNameErrorMsg);
                this.setPageComplete(false);
            } else {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
            if (this.isPageComplete()) {
                this.medName = proposedName;
                this.folderLocation = folder;
            }
        }
        catch (CoreException err) {
            ModelerCore.Util.log(4, (Throwable)err, err.getMessage());
            WizardUtil.setPageComplete((WizardPage)this, (String)err.getLocalizedMessage(), (int)3);
        }
    }
}

