/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.ui.wizards;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.DotProjectUtils;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionWriter;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.NamespaceProvider;
import org.teiid.designer.extension.ui.Messages;
import org.teiid.designer.extension.ui.wizards.NewMedDetailsPage;
import org.teiid.designer.extension.ui.wizards.NewMedMainPage;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.common.wizard.NoOpenProjectsWizardPage;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;

public final class NewMedWizard
extends AbstractWizard
implements INewWizard,
CoreStringUtil.Constants {
    private NewMedMainPage newMedMainPage;
    private NewMedDetailsPage newMedDetailsPage;
    private final ModelExtensionDefinition medBeingCopied;

    public NewMedWizard() {
        this(Messages.newMedWizardTitle, null);
    }

    public NewMedWizard(String wizardTitle, ModelExtensionDefinition medBeingCopied) {
        super((AbstractUIPlugin)UiPlugin.getDefault(), wizardTitle, null);
        this.medBeingCopied = medBeingCopied;
    }

    ModelExtensionDefinition accessMed() {
        return this.medBeingCopied;
    }

    public boolean finish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        IContainer folderLoc = NewMedWizard.this.newMedMainPage.getFolderLocation();
                        String medName = NewMedWizard.this.newMedMainPage.getMedName();
                        IFile createdMedFile = folderLoc.getFile((IPath)new Path(medName));
                        ModelExtensionDefinitionWriter medWriter = new ModelExtensionDefinitionWriter();
                        ModelExtensionDefinition med = NewMedWizard.this.createDefaultMed();
                        String namespacePrefix = NewMedWizard.this.newMedDetailsPage.getNamespacePrefix();
                        String namespaceUri = NewMedWizard.this.newMedDetailsPage.getNamespaceUri();
                        String metamodelUri = NewMedWizard.this.newMedDetailsPage.getMetamodelUri();
                        int versionInt = NewMedWizard.this.newMedDetailsPage.getVersionInt();
                        String description = NewMedWizard.this.newMedDetailsPage.getDescription();
                        Collection<String> supportedModelTypes = NewMedWizard.this.newMedDetailsPage.getSupportedModelTypes();
                        med.setNamespacePrefix(namespacePrefix);
                        med.setNamespaceUri(namespaceUri);
                        med.setMetamodelUri(metamodelUri);
                        med.setVersion(versionInt);
                        med.setDescription(description);
                        for (String modelType : supportedModelTypes) {
                            med.addModelType(modelType);
                        }
                        if (NewMedWizard.this.accessMed() != null) {
                            ModelExtensionDefinition medToCopy = NewMedWizard.this.accessMed();
                            for (Map.Entry entry : medToCopy.getPropertyDefinitions().entrySet()) {
                                String metaclass = (String)entry.getKey();
                                for (ModelExtensionPropertyDefinition propDefn : (Collection)entry.getValue()) {
                                    ModelExtensionPropertyDefinition copiedProp = (ModelExtensionPropertyDefinition)propDefn.clone();
                                    copiedProp.setNamespaceProvider((NamespaceProvider)med);
                                    med.addPropertyDefinition(metaclass, copiedProp);
                                }
                            }
                        }
                        InputStream medInputStream = medWriter.writeAsStream(med);
                        createdMedFile.create(medInputStream, false, monitor);
                        folderLoc.refreshLocal(2, monitor);
                        if (NewMedWizard.this.newMedMainPage.openInEditorChecked()) {
                            IWorkbenchPage page = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage();
                            IDE.openEditor((IWorkbenchPage)page, (IFile)createdMedFile);
                        }
                    }
                    catch (Exception err) {
                        throw new InvocationTargetException(err);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, op);
            return true;
        }
        catch (Throwable err) {
            if (err instanceof InvocationTargetException) {
                err = ((InvocationTargetException)err).getTargetException();
            }
            ModelerCore.Util.log(4, err, err.getMessage());
            WidgetUtil.showError((String)Messages.newMedWizardCreateFileErrorMsg);
            return false;
        }
    }

    ModelExtensionDefinition createDefaultMed() {
        ModelObjectExtensionAssistant assistant = ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant();
        ModelExtensionDefinition newMed = new ModelExtensionDefinition((ModelExtensionAssistant)assistant);
        return newMed;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IContainer folderLocation = null;
        if (selection != null && !selection.isEmpty()) {
            folderLocation = ModelUtil.getContainer((Object)selection.getFirstElement());
        } else {
            Collection openModelProjects;
            IProject newProject;
            if (!ModelerUiViewUtils.workspaceHasOpenModelProjects() && (newProject = ModelerUiViewUtils.queryUserToCreateModelProject()) != null) {
                folderLocation = newProject;
            }
            if (!(openModelProjects = DotProjectUtils.getOpenModelProjects()).isEmpty()) {
                folderLocation = (IContainer)openModelProjects.iterator().next();
            }
        }
        if (folderLocation == null || !this.folderInModelProject(folderLocation)) {
            this.addPage((IWizardPage)NoOpenProjectsWizardPage.getStandardPage());
        } else {
            this.newMedMainPage = new NewMedMainPage(folderLocation);
            this.newMedDetailsPage = new NewMedDetailsPage(this.medBeingCopied);
            this.addPage((IWizardPage)this.newMedMainPage);
            this.addPage((IWizardPage)this.newMedDetailsPage);
        }
    }

    private boolean folderInModelProject(IContainer folderLoc) {
        boolean result = false;
        if (folderLoc != null) {
            IProject project = folderLoc.getProject();
            try {
                if (project != null && project.getNature("org.teiid.designer.core.modelNature") != null) {
                    result = true;
                }
            }
            catch (CoreException ex) {
                ModelerCore.Util.log(4, (Throwable)ex, ex.getMessage());
            }
        }
        return result;
    }

    Composite createEmptyPageControl(Composite parent) {
        return new Composite(parent, 0);
    }
}

