/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.branding.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.fusesource.ide.branding.Activator;
import org.fusesource.ide.branding.wizards.NewCamelXmlWizardPage;
import org.fusesource.ide.branding.wizards.WizardMessages;
import org.fusesource.ide.foundation.core.util.Objects;
import org.fusesource.ide.foundation.core.util.Strings;

public class NewCamelXmlWizard
extends Wizard
implements INewWizard {
    private NewCamelXmlWizardPage page;
    private ISelection selection;

    public NewCamelXmlWizard() {
        this.setWindowTitle(WizardMessages.NewCamelXMLWizard_wizardTitle);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/new_camel_context_wizard.png"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewCamelXmlWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        final String format = this.page.getXmlFormat();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewCamelXmlWizard.this.doFinish(containerName, fileName, format, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, String format, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(NLS.bind((String)WizardMessages.NewCamelXMLWizard_beginTaskMessage, (Object)fileName), 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            throw new CoreException(Activator.getLogger().createStatus(4, 4, "RouteContainer \"" + containerName + "\" does not exist.", null));
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream(format);
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName(WizardMessages.NewCamelXMLWizard_endTaskMessage);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream(String format) {
        boolean spring = true;
        boolean osgi = false;
        boolean trace = true;
        String camelContext = "camelContext";
        String namespace = "http://camel.apache.org/schema/spring";
        if (!Strings.isBlank((String)format)) {
            if (Objects.equal((Object)format, (Object)NewCamelXmlWizardPage.blueprintFormat)) {
                namespace = "http://camel.apache.org/schema/blueprint";
                spring = false;
                osgi = true;
            } else if (Objects.equal((Object)format, (Object)NewCamelXmlWizardPage.routesFormat)) {
                camelContext = "routes";
                spring = false;
                osgi = false;
                trace = false;
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (spring) {
            builder.append("<beans xmlns=\"http://www.springframework.org/schema/beans\"\n");
            builder.append("       xmlns:camel=\"" + namespace + "\"\n");
            builder.append("       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            builder.append("       xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-3.0.xsd\n");
            builder.append("       http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd\">\n");
        } else if (osgi) {
            builder.append("<blueprint xmlns=\"http://www.osgi.org/xmlns/blueprint/v1.0.0\"\n");
            builder.append("       xmlns:camel=\"" + namespace + "\"\n");
            builder.append("       xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            builder.append("       xsi:schemaLocation=\"http://www.osgi.org/xmlns/blueprint/v1.0.0 https://www.osgi.org/xmlns/blueprint/v1.0.0/blueprint.xsd\n");
            builder.append("       http://camel.apache.org/schema/blueprint http://camel.apache.org/schema/blueprint/camel-blueprint.xsd\">\n");
        }
        builder.append("\n");
        builder.append("  <");
        builder.append(camelContext);
        builder.append(" xmlns=\"");
        builder.append(namespace);
        builder.append("\"");
        if (trace) {
            builder.append(" trace=\"false\"");
        }
        builder.append(">\n");
        builder.append("    <route>\n");
        boolean includeSampleRoute = false;
        if (includeSampleRoute) {
            builder.append("      <from uri=\"seda:start\"/>\n");
            builder.append("      <to uri=\"seda:finish\"/>\n");
        }
        builder.append("    </route>\n");
        builder.append("  </");
        builder.append(camelContext);
        builder.append(">\n");
        builder.append("\n");
        if (spring) {
            builder.append("</beans>\n");
        } else if (osgi) {
            builder.append("</blueprint>\n");
        }
        return new ByteArrayInputStream(builder.toString().getBytes());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

