/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.branding.wizards.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.fusesource.ide.branding.Activator;
import org.fusesource.ide.branding.wizards.project.ArchetypeDetails;
import org.fusesource.ide.branding.wizards.project.SelectionUtil;
import org.fusesource.ide.foundation.ui.archetypes.ArchetypeHelper;

public abstract class AbstractFuseProjectWizard
extends Wizard {
    protected IStructuredSelection selection;
    protected List<IWorkingSet> workingSets = new ArrayList<IWorkingSet>();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        IWorkingSet workingSet = SelectionUtil.getSelectedWorkingSet(selection);
        if (workingSet != null) {
            this.workingSets.add(workingSet);
        }
    }

    public void createProject(InputStream archetypeJarIn, File outputDir, String groupId, String artifactId, String version, String packageName) {
        this.createProject(archetypeJarIn, outputDir, groupId, artifactId, version, packageName, null);
    }

    private void createProject(InputStream archetypeJarIn, File outputDir, String groupId, String artifactId, String version, String packageName, Map<String, String> requiredProperties) {
        ArchetypeHelper helper = new ArchetypeHelper(archetypeJarIn, outputDir, groupId, artifactId, version);
        if (packageName != null && packageName.length() > 0) {
            helper.setPackageName(packageName);
        }
        if (requiredProperties != null) {
            helper.setOverrideProperties(requiredProperties);
        }
        Activator.getLogger().debug("Creating archetype for outputDir: " + outputDir);
        try {
            helper.execute();
        }
        catch (IOException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        Activator.getLogger().debug("Done!");
    }

    protected void createProject(ArchetypeDetails archetype, File outputDir, String packageName, String groupId, String artifactId, String version) throws IOException {
        this.createProject(archetype.getResource().openStream(), outputDir, groupId, artifactId, version, packageName, archetype.getRequiredProperties());
    }
}

