/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.branding.wizards.project;

import java.net.URL;
import java.util.Map;
import org.fusesource.ide.foundation.core.util.Objects;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.foundation.ui.archetypes.Archetype;

public class ArchetypeDetails
implements Comparable<ArchetypeDetails> {
    private final Archetype archetype;
    private String groupId;
    private String artifactId;
    private String version;
    private String description;
    private String repository;
    private URL resource;
    private String fullName;
    private Map<String, String> requiredProperties;

    public ArchetypeDetails(Archetype archetype) {
        this.archetype = archetype;
        this.groupId = archetype.getGroupId();
        this.artifactId = archetype.getArtifactId();
        this.version = archetype.getVersion();
        this.description = archetype.getDescription();
        this.fullName = String.valueOf(this.artifactId) + "-" + this.version + ".jar";
    }

    public boolean contains(String currentFilter) {
        return Strings.contains((String)currentFilter, (String[])new String[]{this.groupId, this.artifactId, this.version});
    }

    @Override
    public int compareTo(ArchetypeDetails that) {
        int answer = Objects.compare((Object)this.groupId, (Object)that.groupId);
        if (answer == 0 && (answer = Objects.compare((Object)this.artifactId, (Object)that.artifactId)) == 0) {
            answer = Objects.compare((Object)this.version, (Object)that.version);
        }
        return answer;
    }

    public Archetype getArchetype() {
        return this.archetype;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public URL getResource() {
        return this.resource;
    }

    public void setResource(URL resource) {
        this.resource = resource;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Map<String, String> getRequiredProperties() {
        return this.requiredProperties;
    }

    public void setRequiredProperties(Map<String, String> requiredProperties) {
        this.requiredProperties = requiredProperties;
    }
}

