/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.branding.wizards.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.fusesource.ide.branding.Activator;
import org.fusesource.ide.branding.wizards.WizardMessages;
import org.fusesource.ide.branding.wizards.project.AbstractCreateProjectJob;
import org.fusesource.ide.branding.wizards.project.AbstractFuseProjectWizard;
import org.fusesource.ide.branding.wizards.project.ArchetypeDetails;
import org.fusesource.ide.branding.wizards.project.FuseProjectWizardArchetypePage;
import org.fusesource.ide.branding.wizards.project.FuseProjectWizardLocationPage;
import org.fusesource.ide.branding.wizards.project.SelectionUtil;
import org.fusesource.ide.maven.MavenFacade;

public class FuseProjectWizard
extends AbstractFuseProjectWizard
implements INewWizard {
    protected FuseProjectWizardLocationPage locationPage;
    private FuseProjectWizardArchetypePage archetypePage;

    public FuseProjectWizard() {
        this.setWindowTitle(WizardMessages.wizardProjectTitle);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/new_fuse_project_wizard.png"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.locationPage = new FuseProjectWizardLocationPage(WizardMessages.wizardProjectPageProjectTitle, WizardMessages.wizardProjectPageProjectDescription, this.workingSets){

            protected void createAdditionalControls(Composite container) {
                Label label = new Label(container, 0);
                GridData labelData = new GridData(4, 128, false, false, 3, 1);
                labelData.heightHint = 10;
                label.setLayoutData((Object)labelData);
            }

            public IWizardPage getNextPage() {
                return FuseProjectWizard.this.getPage("MavenProjectWizardArchetypePage");
            }
        };
        this.locationPage.setLocationPath(SelectionUtil.getSelectedLocation(this.selection));
        this.archetypePage = new FuseProjectWizardArchetypePage();
        this.addPage((IWizardPage)this.locationPage);
        this.addPage((IWizardPage)this.archetypePage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public boolean performFinish() {
        final String projectName = this.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = this.locationPage.isInWorkspace() ? null : this.locationPage.getLocationPath();
        final IWorkspaceRoot root = workspace.getRoot();
        final IPath rootPath = this.locationPage.isInWorkspace() ? root.getLocation().append(projectName) : location;
        final File pomFile = rootPath.append("pom.xml").toFile();
        boolean pomExists = pomFile.exists();
        final IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (pomExists) {
            MessageDialog.openError((Shell)this.getShell(), (String)NLS.bind((String)WizardMessages.wizardProjectJobFailed, (Object)projectName), (String)WizardMessages.wizardProjectErrorPomAlreadyExists);
            return false;
        }
        final String groupId = this.archetypePage.getGroupId();
        final String artifactId = this.archetypePage.getArtifactId();
        final String version = this.archetypePage.getVersion();
        final ArchetypeDetails archetype = this.archetypePage.getArchetype();
        if (archetype.getRequiredProperties() != null) {
            ArrayList<String> invalidValues = new ArrayList<String>();
            for (Map.Entry<String, String> paramEntry : archetype.getRequiredProperties().entrySet()) {
                if (paramEntry.getValue() != null && paramEntry.getValue().trim().length() != 0) continue;
                invalidValues.add(paramEntry.getKey());
            }
            if (invalidValues.size() > 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)WizardMessages.FuseProjectWizardArchetypePage_missingPropTitle, (String)NLS.bind((String)WizardMessages.FuseProjectWizardArchetypePage_missingProp, (Object)((Object)invalidValues).toString()));
                return false;
            }
        }
        final String javaPackage = this.archetypePage.getJavaPackage();
        this.archetypePage.getProperties();
        Activator.getLogger().debug("About to create project: " + projectName + " from archetype: " + archetype + " for " + groupId + ": " + artifactId + ":" + version + " at " + rootPath);
        String jobName = NLS.bind((String)WizardMessages.wizardProjectJobCreating, (Object)projectName);
        AbstractCreateProjectJob job = new AbstractCreateProjectJob(jobName, this.workingSets){

            @Override
            protected List<IProject> doCreateMavenProjects(IProgressMonitor monitor) throws CoreException {
                try {
                    File outputDir = rootPath.toFile();
                    FuseProjectWizard.this.createProject(archetype, outputDir, javaPackage, groupId, artifactId, version);
                    IProject project = root.getProject(projectName);
                    MavenFacade facade = new MavenFacade();
                    facade.importProjects(monitor, pomFile, projectName, groupId, artifactId, version);
                    FuseProjectWizard.this.enforceNatures(project, (IProgressMonitor)new NullProgressMonitor());
                    MavenUpdateRequest mur = new MavenUpdateRequest(false, true);
                    mur.addPomFile(project);
                    MavenPlugin.getMavenProjectRegistry().refresh(mur);
                    return Arrays.asList(project);
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.fusesource.ide.plugin.wizards", 0, NLS.bind((String)WizardMessages.failedToOpenArchetype, (Object)e.getMessage()), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
        };
        IPerspectiveDescriptor finalPersp = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("org.fusesource.ide.branding.perspective");
        IPerspectiveDescriptor currentPersp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
        final boolean switchPerspective = currentPersp.getId().equals(finalPersp.getId()) ? false : this.confirmPerspectiveSwitch(workbenchWindow, finalPersp);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                final IStatus result = event.getResult();
                if (!result.isOK()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)FuseProjectWizard.this.getShell(), (String)NLS.bind((String)WizardMessages.wizardProjectJobFailed, (Object)projectName), (String)result.getMessage());
                        }
                    });
                } else {
                    IProject project = root.getProject(projectName);
                    if (switchPerspective) {
                        FuseProjectWizard.this.switchToFusePerspective(workbenchWindow);
                    }
                    FuseProjectWizard.this.openCamelContextFile(project);
                }
            }
        });
        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
        job.setRule(rule);
        job.schedule();
        return true;
    }

    private void enforceNatures(IProject project, IProgressMonitor monitor) throws CoreException {
        try {
            IProjectDescription projectDescription = project.getDescription();
            String[] ids = projectDescription.getNatureIds();
            boolean camelNatureFound = false;
            boolean javaNatureFound = false;
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (id.equals("org.eclipse.jdt.core.javanature")) {
                    javaNatureFound = true;
                } else if (id.equals("org.fusesource.ide.project.RiderProjectNature")) {
                    camelNatureFound = true;
                }
                ++n2;
            }
            int toAdd = 0;
            if (!camelNatureFound) {
                ++toAdd;
            }
            if (!javaNatureFound) {
                ++toAdd;
            }
            String[] newIds = new String[ids.length + toAdd];
            System.arraycopy(ids, 0, newIds, 0, ids.length);
            if (!camelNatureFound && !javaNatureFound) {
                newIds[ids.length] = "org.fusesource.ide.project.RiderProjectNature";
                newIds[newIds.length - 1] = "org.eclipse.jdt.core.javanature";
            } else if (!camelNatureFound) {
                newIds[ids.length] = "org.fusesource.ide.project.RiderProjectNature";
            } else if (!javaNatureFound) {
                newIds[ids.length] = "org.eclipse.jdt.core.javanature";
            }
            projectDescription.setNatureIds(newIds);
            project.setDescription(projectDescription, monitor);
            IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
            MavenPlugin.getMavenProjectRegistry();
            MavenUpdateRequest request = new MavenUpdateRequest(false, true);
            request.addPomFile(project.getFile("pom.xml"));
            configurationManager.updateProjectConfiguration(request, monitor);
        }
        catch (CoreException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    public String getProjectName() {
        return this.locationPage != null ? this.locationPage.getProjectName() : null;
    }

    private void switchToFusePerspective(final IWorkbenchWindow workbenchWindow) {
        IPerspectiveDescriptor activePerspective = workbenchWindow.getActivePage().getPerspective();
        if (activePerspective == null || !activePerspective.getId().equals("org.fusesource.ide.branding.perspective")) {
            workbenchWindow.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        workbenchWindow.getWorkbench().showPerspective("org.fusesource.ide.branding.perspective", workbenchWindow);
                    }
                    catch (WorkbenchException e) {
                        Activator.getLogger().error((Throwable)e);
                    }
                }
            });
        }
    }

    private boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPersp) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String pspm = store.getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!"prompt".equals(pspm)) {
            return "always".equals(pspm);
        }
        String desc = finalPersp.getDescription();
        String message = desc == null || desc.length() == 0 ? NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessage, (Object)finalPersp.getLabel()) : NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessageWithDesc, (Object[])new String[]{finalPersp.getLabel(), desc});
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)ResourceMessages.NewProject_perspSwitchTitle, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)"SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        int result = dialog.getReturnCode();
        if (dialog.getToggleState()) {
            String preferenceValue = result == 2 ? "OPEN_PERSPECTIVE_REPLACE" : "NO_NEW_PERSPECTIVE";
            PrefUtil.getAPIPreferenceStore().setValue("PROJECT_OPEN_NEW_PERSPECTIVE", preferenceValue);
        }
        return result == 2;
    }

    private void openCamelContextFile(IProject project) {
        if (project != null) {
            final IFile[] holder = new IFile[1];
            try {
                project.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        IFile file;
                        if (resource instanceof IFile && (file = (IFile)resource).getContentDescription() != null && "org.fusesource.ide.camel.editor.camelContentType".equals(file.getContentDescription().getContentType().getId())) {
                            holder[0] = file;
                        }
                        return holder[0] == null;
                    }
                });
            }
            catch (CoreException e1) {
                Activator.getLogger().error((Throwable)e1);
            }
            if (holder[0] != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)holder[0], (boolean)OpenStrategy.activateOnOpen());
                        }
                        catch (PartInitException e) {
                            Activator.getLogger().error("Cannot open camel context file in editor", (Throwable)e);
                        }
                    }
                });
            }
        }
    }
}

