/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.branding.wizards.project;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class SelectionUtil {
    public static final int UNSUPPORTED = 0;
    public static final int PROJECT_WITH_NATURE = 1;
    public static final int PROJECT_WITHOUT_NATURE = 2;
    public static final int POM_FILE = 4;
    public static final int JAR_FILE = 8;
    public static final int WORKING_SET = 16;

    public static int getSelectionType(IStructuredSelection selection) {
        int type = 0;
        if (selection != null) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                int elementType = SelectionUtil.getElementType(it.next());
                if (elementType == 0) {
                    return 0;
                }
                type |= elementType;
            }
        }
        return type;
    }

    public static int getElementType(Object element) {
        IWorkingSet workingSet = SelectionUtil.getType(element, IWorkingSet.class);
        if (workingSet != null) {
            return 16;
        }
        return 0;
    }

    public static <T> T getType(Object element, Class<T> type) {
        Object adapter;
        if (element == null) {
            return null;
        }
        if (type.isInstance(element)) {
            return (T)element;
        }
        if (element instanceof IAdaptable && (adapter = ((IAdaptable)element).getAdapter(type)) != null) {
            return (T)adapter;
        }
        return (T)Platform.getAdapterManager().getAdapter(element, type);
    }

    public static IPath getSelectedLocation(IStructuredSelection selection) {
        Object element = selection == null ? null : selection.getFirstElement();
        IPath path = SelectionUtil.getType(element, IPath.class);
        if (path != null) {
            return path;
        }
        IResource resource = SelectionUtil.getType(element, IResource.class);
        if (resource != null) {
            return resource.getLocation();
        }
        return null;
    }

    public static IWorkingSet getSelectedWorkingSet(IStructuredSelection selection) {
        Object element;
        Object object = element = selection == null ? null : selection.getFirstElement();
        if (element == null) {
            return null;
        }
        IWorkingSet workingSet = SelectionUtil.getType(element, IWorkingSet.class);
        if (workingSet != null) {
            return workingSet;
        }
        IResource resource = SelectionUtil.getType(element, IResource.class);
        if (resource != null) {
            return SelectionUtil.getWorkingSet(resource.getProject());
        }
        return null;
    }

    public static IWorkingSet getWorkingSet(Object element) {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] iWorkingSetArray = workingSetManager.getWorkingSets();
        int n = iWorkingSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            IAdaptable[] iAdaptableArray = workingSet.getElements();
            int n3 = iAdaptableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAdaptable adaptable = iAdaptableArray[n4];
                if (adaptable.getAdapter(IResource.class) == element) {
                    return workingSet;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static List<IWorkingSet> getAssignedWorkingSets(Object element) {
        ArrayList<IWorkingSet> list = new ArrayList<IWorkingSet>();
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] iWorkingSetArray = workingSetManager.getWorkingSets();
        int n = iWorkingSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            IAdaptable[] iAdaptableArray = workingSet.getElements();
            int n3 = iAdaptableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAdaptable adaptable = iAdaptableArray[n4];
                if (adaptable.getAdapter(IResource.class) == element) {
                    list.add(workingSet);
                }
                ++n4;
            }
            ++n2;
        }
        return list;
    }

    private static IEditorPart getActiveEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page.getActiveEditor();
        }
        return null;
    }
}

