/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.modeshape.jcr.ui.JcrUiConstants;
import org.jboss.tools.modeshape.jcr.ui.JcrUiMessages;
import org.jboss.tools.modeshape.jcr.ui.JcrUiUtils;
import org.jboss.tools.modeshape.jcr.ui.dnd.JcrClipboard;
import org.jboss.tools.modeshape.ui.graphics.GraphicsUtils;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static Activator _sharedInstance;
    private JcrClipboard clipboard;
    private IResourceChangeListener listener;

    public static Activator getSharedInstance() {
        return _sharedInstance;
    }

    void addCndBuilder(final IProject project) {
        try {
            final IProjectDescription desc = project.getDescription();
            ICommand[] currentBuildCommands = desc.getBuildSpec();
            int i = 0;
            while (i < currentBuildCommands.length) {
                if (JcrUiConstants.WorkspaceIds.CND_PROJECT_BUILDER.equals(currentBuildCommands[i].getBuilderName())) {
                    return;
                }
                ++i;
            }
            ICommand command = desc.newCommand();
            command.setBuilderName(JcrUiConstants.WorkspaceIds.CND_PROJECT_BUILDER);
            ICommand[] updatedBuildCommands = new ICommand[currentBuildCommands.length + 1];
            System.arraycopy(currentBuildCommands, 0, updatedBuildCommands, 1, currentBuildCommands.length);
            updatedBuildCommands[0] = command;
            desc.setBuildSpec(updatedBuildCommands);
            this.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        project.setDescription(desc, null);
                    }
                    catch (CoreException e) {
                        Activator.this.getLog().log((IStatus)new Status(4, JcrUiConstants.PLUGIN_ID, NLS.bind((String)JcrUiMessages.errorAddingCndBuilderCommandToProject, (Object)project.getName()), (Throwable)e));
                    }
                }
            });
        }
        catch (Exception e) {
            this.getLog().log((IStatus)new Status(4, JcrUiConstants.PLUGIN_ID, NLS.bind((String)JcrUiMessages.errorAddingCndBuilderCommandToProject, (Object)project.getName()), (Throwable)e));
        }
    }

    public JcrClipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = new JcrClipboard(this.getWorkbench().getDisplay());
        }
        return this.clipboard;
    }

    public final Image getImage(String pathToImage) {
        return GraphicsUtils.getImage((AbstractUIPlugin)this, (String)pathToImage);
    }

    public final ImageDescriptor getImageDescriptor(String pathToImage) {
        this.getImage(pathToImage);
        return this.getImageRegistry().getDescriptor(pathToImage);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        _sharedInstance = this;
        this.listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    try {
                        delta.accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) {
                                IResource resource = delta.getResource();
                                if (resource.getType() == 1 && delta.getKind() == 1 && JcrUiUtils.isCndFile(resource)) {
                                    Activator.this.addCndBuilder(delta.getResource().getProject());
                                    return false;
                                }
                                return true;
                            }
                        });
                    }
                    catch (CoreException e) {
                        Activator.this.getLog().log((IStatus)new Status(4, JcrUiConstants.PLUGIN_ID, NLS.bind((String)JcrUiMessages.errorProcessingResourceChangeEvent, (Object)delta.getResource().getName()), (Throwable)e));
                    }
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener);
        this.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public void postShutdown(IWorkbench workbench) {
            }

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                JcrClipboard clipboard = Activator.this.getClipboard();
                if (clipboard != null) {
                    clipboard.clearContents();
                    clipboard.dispose();
                }
                workbench.removeWorkbenchListener((IWorkbenchListener)this);
                return true;
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        if (this.listener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        }
        super.stop(context);
    }
}

