/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.cnd;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.jboss.tools.modeshape.jcr.ChildNodeDefinition;
import org.jboss.tools.modeshape.jcr.ItemDefinition;
import org.jboss.tools.modeshape.jcr.ItemOwnerProvider;
import org.jboss.tools.modeshape.jcr.JcrModelObject;
import org.jboss.tools.modeshape.jcr.Messages;
import org.jboss.tools.modeshape.jcr.MultiValidationStatus;
import org.jboss.tools.modeshape.jcr.NamespaceMapping;
import org.jboss.tools.modeshape.jcr.NodeTypeDefinition;
import org.jboss.tools.modeshape.jcr.PropertyDefinition;
import org.jboss.tools.modeshape.jcr.QualifiedName;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.ValidationStatus;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;
import org.jboss.tools.modeshape.jcr.cnd.CndValidator;
import org.jboss.tools.modeshape.jcr.cnd.CommentedCndElement;
import org.jboss.tools.modeshape.jcr.cnd.CompactNodeTypeDefinition;
import org.jboss.tools.modeshape.jcr.ui.Activator;
import org.jboss.tools.modeshape.jcr.ui.JcrUiConstants;
import org.jboss.tools.modeshape.jcr.ui.JcrUiUtils;
import org.jboss.tools.modeshape.jcr.ui.cnd.ChildNodeDialog;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndEditor;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndEditorActionBarContributor;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndEditorPage;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndMessages;
import org.jboss.tools.modeshape.jcr.ui.cnd.NamespaceMappingDialog;
import org.jboss.tools.modeshape.jcr.ui.cnd.PropertyDialog;
import org.jboss.tools.modeshape.jcr.ui.cnd.QualifiedNameDialog;
import org.jboss.tools.modeshape.jcr.ui.cnd.QualifiedNameEditor;
import org.jboss.tools.modeshape.jcr.ui.cnd.QualifiedNameProposalProvider;
import org.jboss.tools.modeshape.jcr.ui.dnd.ChildNodeDefinitionTransfer;
import org.jboss.tools.modeshape.jcr.ui.dnd.JcrClipboard;
import org.jboss.tools.modeshape.jcr.ui.dnd.NamespaceMappingTransfer;
import org.jboss.tools.modeshape.jcr.ui.dnd.NodeTypeDefinitionTransfer;
import org.jboss.tools.modeshape.jcr.ui.dnd.PropertyDefinitionTransfer;
import org.jboss.tools.modeshape.ui.UiMessages;
import org.jboss.tools.modeshape.ui.UiUtils;
import org.jboss.tools.modeshape.ui.actions.DelegateAction;
import org.jboss.tools.modeshape.ui.forms.ErrorMessage;
import org.jboss.tools.modeshape.ui.forms.FormUtils;
import org.jboss.tools.modeshape.ui.forms.MessageFormDialog;
import org.jboss.tools.modeshape.ui.graphics.GraphicsUtils;
import org.jboss.tools.modeshape.ui.viewers.CheckBoxLabelProvider;

public class CndFormsEditorPage
extends CndEditorPage
implements PropertyChangeListener {
    private IAction addChildNode;
    private IAction addNamespace;
    private IAction addNodeType;
    private IAction addProperty;
    private IAction copyChildNode;
    private IAction copyNamespace;
    private IAction copyNodeType;
    private IAction copyProperty;
    private IAction addSuperType;
    private Button btnAbstract;
    private Button btnMixin;
    private Button btnOrderable;
    private Button btnQueryable;
    private CCombo cbxPrimaryItem;
    private Section childNodeSection;
    private MenuManager childNodeStatusBarMenuManager;
    private TableViewer childNodeViewer;
    private IAction deleteChildNode;
    private IAction deleteNamespace;
    private IAction deleteNodeType;
    private IAction deleteProperty;
    private IAction deleteSuperType;
    private Section detailsSection;
    private IAction editChildNode;
    private IAction editNamespace;
    private IAction editProperty;
    private IAction editSuperType;
    private QualifiedNameEditor nameEditor;
    private Section namespaceSection;
    private TableViewer namespaceViewer;
    private String nodeTypeNameFilterPattern;
    private Section nodeTypeSection;
    private MenuManager nodeTypeStatusBarMenuManager;
    private TableViewer nodeTypeViewer;
    private IAction openChildNodeDeclaringNodeType;
    private IAction openPropertyDeclaringNodeType;
    private IAction pasteChildNode;
    private IAction pasteNamespace;
    private IAction pasteNodeType;
    private IAction pasteProperty;
    private Section propertiesSection;
    private MenuManager propertyStatusBarMenuManager;
    private TableViewer propertyViewer;
    private NodeTypeDefinition selectedNodeType;
    private IAction showInheritedChildNodes;
    private IAction showInheritedProperties;
    private TableViewer superTypesViewer;
    private Text txtComment;
    private Text txtFilter;
    private JcrClipboard clipboard;

    protected CndFormsEditorPage(CndEditor cndEditor) {
        super(cndEditor, JcrUiConstants.EditorIds.CND_FORMS_PAGE, CndMessages.cndEditorFormsPageTitle);
    }

    void addChildNode(NodeTypeDefinition nodeTypeDefinition, ChildNodeDefinition newChildNodeDefinition) {
        if (nodeTypeDefinition.addChildNodeDefinition(newChildNodeDefinition)) {
            this.childNodeViewer.setSelection((ISelection)new StructuredSelection((Object)newChildNodeDefinition), true);
            UiUtils.pack((TableViewer[])new TableViewer[]{this.childNodeViewer});
            if (!this.childNodeSection.isExpanded()) {
                this.childNodeSection.setExpanded(true);
            }
            FormToolkit.ensureVisible((Control)this.childNodeViewer.getTable());
        } else {
            MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorAddingChildNode, (Object)newChildNodeDefinition.getName()));
        }
    }

    void addNamespace(NamespaceMapping newNamespaceMapping) {
        if (this.getCnd().addNamespaceMapping(newNamespaceMapping)) {
            this.namespaceViewer.setSelection((ISelection)new StructuredSelection((Object)newNamespaceMapping), true);
            UiUtils.pack((TableViewer[])new TableViewer[]{this.namespaceViewer});
            if (!this.namespaceSection.isExpanded()) {
                this.namespaceSection.setExpanded(true);
            }
            FormToolkit.ensureVisible((Control)this.namespaceViewer.getTable());
        } else {
            MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorAddingNamespaceMapping, (Object)newNamespaceMapping));
        }
    }

    void addNodeType(NodeTypeDefinition newNodeTypeDefinition) {
        if (this.getCnd().addNodeTypeDefinition(newNodeTypeDefinition)) {
            this.nodeTypeViewer.setSelection((ISelection)new StructuredSelection((Object)newNodeTypeDefinition), true);
            UiUtils.pack((TableViewer[])new TableViewer[]{this.nodeTypeViewer});
            FormToolkit.ensureVisible((Control)this.nodeTypeViewer.getTable());
        } else {
            MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorAddingNodeType, (Object)newNodeTypeDefinition.getName()));
        }
    }

    void addProperty(NodeTypeDefinition nodeTypeDefinition, PropertyDefinition newPropertyDefinition) {
        if (nodeTypeDefinition.addPropertyDefinition(newPropertyDefinition)) {
            this.propertyViewer.setSelection((ISelection)new StructuredSelection((Object)newPropertyDefinition), true);
            UiUtils.pack((TableViewer[])new TableViewer[]{this.propertyViewer});
            if (!this.propertiesSection.isExpanded()) {
                this.propertiesSection.setExpanded(true);
            }
            FormToolkit.ensureVisible((Control)this.propertyViewer.getTable());
        } else {
            MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorAddingProperty, (Object)newPropertyDefinition.getName()));
        }
    }

    @Override
    protected void createBody(Composite body, FormToolkit toolkit) {
        this.createNamespaceSection(this.getManagedForm(), toolkit, body);
        this.createNodeTypeSection(this.getManagedForm(), toolkit, body);
        this.clipboard = Activator.getSharedInstance().getClipboard();
        this.populateUi();
        this.getCndEditor().getMessageManager().removeAllMessages();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                if (CndFormsEditorPage.this.getCndEditor().getPartName().equals(part.getTitle())) {
                    CndFormsEditorPage.this.updateEnabledState();
                    CndFormsEditorPage.this.updateStatusBar();
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
                CndEditorActionBarContributor contributor = CndFormsEditorPage.this.getActionContributor();
                contributor.setChildNode(null);
                contributor.setChildNodeStatusMenuManager(null);
                contributor.setNodeType(null);
                contributor.setNodeTypeStatusMenuManager(null);
                contributor.setProperty(null);
                contributor.setPropertyStatusMenuManager(null);
                CndFormsEditorPage.this.getActionContributor().getActionBars().getStatusLineManager().update(true);
            }

            public void partOpened(IWorkbenchPart part) {
            }
        });
        IWorkbenchHelpSystem helpSystem = Activator.getSharedInstance().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)body, JcrUiConstants.HelpContexts.CND_FORMS_EDITOR_HELP_CONTEXT);
    }

    private void createChildNodeActions() {
        this.addChildNode = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleAddChildNode();
            }
        };
        this.addChildNode.setEnabled(false);
        this.addChildNode.setToolTipText(CndMessages.addChildNodeToolTip);
        this.addChildNode.setImageDescriptor(JcrUiUtils.getNewImageDescriptor());
        this.copyChildNode = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleCopyChildNode();
            }
        };
        this.copyChildNode.setEnabled(false);
        this.copyChildNode.setToolTipText(CndMessages.copyChildNodeToolTip);
        this.copyChildNode.setImageDescriptor(GraphicsUtils.getSharedImageDescriptor((String)"IMG_TOOL_COPY"));
        this.deleteChildNode = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleDeleteChildNode();
            }
        };
        this.deleteChildNode.setEnabled(false);
        this.deleteChildNode.setToolTipText(CndMessages.deleteChildNodeToolTip);
        this.deleteChildNode.setImageDescriptor(JcrUiUtils.getDeleteImageDescriptor());
        this.editChildNode = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleEditChildNode();
            }
        };
        this.editChildNode.setEnabled(false);
        this.editChildNode.setToolTipText(CndMessages.editChildNodeToolTip);
        this.editChildNode.setImageDescriptor(JcrUiUtils.getEditImageDescriptor());
        this.pasteChildNode = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handlePasteChildNode();
            }
        };
        this.pasteChildNode.setEnabled(false);
        this.pasteChildNode.setToolTipText(CndMessages.pasteChildNodeToolTip);
        this.pasteChildNode.setImageDescriptor(GraphicsUtils.getSharedImageDescriptor((String)"IMG_TOOL_PASTE"));
        this.showInheritedChildNodes = new Action("", 2){

            public void run() {
                CndFormsEditorPage.this.handleShowInheritedChildNodesChanged();
            }
        };
        this.showInheritedChildNodes.setToolTipText(CndMessages.showInheritedChildNodesToolTip);
        this.showInheritedChildNodes.setImageDescriptor(Activator.getSharedInstance().getImageDescriptor("icons/show-inherited-16x.gif"));
        this.openChildNodeDeclaringNodeType = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleSelectPropertyDeclaringNodeType();
            }
        };
        this.openChildNodeDeclaringNodeType.setEnabled(false);
        this.openChildNodeDeclaringNodeType.setToolTipText(CndMessages.openDeclaringNodeTypeToolTip);
        this.openChildNodeDeclaringNodeType.setImageDescriptor(Activator.getSharedInstance().getImageDescriptor("icons/open-declaring-node-type-16x.gif"));
    }

    private void createChildNodeSection(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        int sectionStyle = 8642;
        if (this.memento == null) {
            sectionStyle &= 0xFFFFFFBF;
        } else {
            Boolean expanded = this.memento.getBoolean("CHILD_NODE_SECTION_EXPANDED");
            if (expanded != null && !expanded.booleanValue()) {
                sectionStyle &= 0xFFFFFFBF;
            }
        }
        this.childNodeSection = FormUtils.createSection((IManagedForm)managedForm, (FormToolkit)toolkit, (Composite)parent, (String)CndMessages.cndEditorChildNodeSectionTitle, (String)CndMessages.cndEditorChildNodeSectionDescription, (int)sectionStyle, (boolean)true);
        toolkit.paintBordersFor((Composite)this.childNodeSection);
        this.createChildNodeActions();
        Composite container = toolkit.createComposite((Composite)this.childNodeSection);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.childNodeSection.setClient((Control)container);
        toolkit.paintBordersFor(container);
        FormUtils.createToolBar((Composite)container, (FormToolkit)toolkit, (IAction[])new IAction[]{this.addChildNode, this.editChildNode, this.deleteChildNode, this.copyChildNode, this.pasteChildNode, this.showInheritedChildNodes, this.openChildNodeDeclaringNodeType}, (int[])new int[]{3, 6});
        Table table = FormUtils.createTable((FormToolkit)toolkit, (Composite)container);
        ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * 5;
        MenuManager menuManager = new MenuManager();
        this.childNodeStatusBarMenuManager = new MenuManager();
        DelegateAction action = new DelegateAction(CndMessages.addChildNodeMenuText, this.addChildNode);
        menuManager.add((IAction)action);
        this.childNodeStatusBarMenuManager.add((IAction)action);
        action = new DelegateAction(CndMessages.editChildNodeMenuText, this.editChildNode);
        menuManager.add((IAction)action);
        this.childNodeStatusBarMenuManager.add((IAction)action);
        action = new DelegateAction(CndMessages.deleteChildNodeMenuText, this.deleteChildNode);
        menuManager.add((IAction)action);
        this.childNodeStatusBarMenuManager.add((IAction)action);
        menuManager.add((IContributionItem)new Separator());
        this.childNodeStatusBarMenuManager.add((IContributionItem)new Separator());
        action = new DelegateAction(CndMessages.copyChildNodeMenuText, this.copyChildNode);
        menuManager.add((IAction)action);
        this.childNodeStatusBarMenuManager.add((IAction)action);
        action = new DelegateAction(CndMessages.pasteChildNodeMenuText, this.pasteChildNode);
        menuManager.add((IAction)action);
        this.childNodeStatusBarMenuManager.add((IAction)action);
        menuManager.add((IContributionItem)new Separator());
        this.childNodeStatusBarMenuManager.add((IContributionItem)new Separator());
        action = new DelegateAction(CndMessages.openDeclaringNodeTypeMenuText, this.openChildNodeDeclaringNodeType);
        menuManager.add((IAction)action);
        this.childNodeStatusBarMenuManager.add((IAction)action);
        table.setMenu(menuManager.createContextMenu((Control)table));
        this.getActionContributor().setChildNodeStatusMenuManager(this.childNodeStatusBarMenuManager);
        this.getActionContributor().setChildNodeStatusDoubleClickAction(this.editChildNode);
        this.createChildNodeViewer(table);
        IWorkbenchHelpSystem helpSystem = Activator.getSharedInstance().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.childNodeSection, JcrUiConstants.HelpContexts.CHILD_NODES_TABLE_HELP_CONTEXT);
    }

    private void createChildNodeViewer(Table childNodeTable) {
        this.childNodeViewer = new TableViewer(childNodeTable);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.childNodeViewer);
        this.childNodeViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                NodeTypeDefinition nodeTypeDefinition = CndFormsEditorPage.this.getSelectedNodeType();
                if (nodeTypeDefinition != null) {
                    try {
                        return CndFormsEditorPage.this.getCnd().getChildNodeDefinitions(nodeTypeDefinition.getName(), CndFormsEditorPage.this.shouldShowInheritedChildNodes()).toArray();
                    }
                    catch (Exception e) {
                        Activator.getSharedInstance().getLog().log((IStatus)new Status(4, JcrUiConstants.PLUGIN_ID, NLS.bind((String)CndMessages.errorObtainingInheritedItemDefinitions, (Object)nodeTypeDefinition.getName()), (Throwable)e));
                    }
                }
                return Utils.EMPTY_OBJECT_ARRAY;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        final IAction editAction = this.editChildNode;
        this.childNodeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (editAction.isEnabled()) {
                    CndFormsEditorPage.this.handleEditChildNode();
                }
            }
        });
        this.childNodeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CndFormsEditorPage.this.handleChildNodeSelected();
            }
        });
        TableViewerColumn nameColumn = new TableViewerColumn(this.childNodeViewer, 16384);
        class ChildNodeLabelProvider
        extends ColumnLabelProvider {
            private final int columnIndex;

            public ChildNodeLabelProvider(int columnIndex) {
                this.columnIndex = columnIndex;
            }

            public Color getBackground(Object element) {
                NodeTypeDefinition nodeTypeDefinition;
                ChildNodeDefinition childNodeDefinition = (ChildNodeDefinition)element;
                if (CndFormsEditorPage.this.shouldShowInheritedChildNodes() && !Utils.equivalent((String)(nodeTypeDefinition = CndFormsEditorPage.this.getSelectedNodeType()).getName(), (String)childNodeDefinition.getDeclaringNodeTypeDefinitionName().get())) {
                    return CndFormsEditorPage.this.getShell().getDisplay().getSystemColor(19);
                }
                return super.getBackground(element);
            }

            public Font getFont(Object element) {
                NodeTypeDefinition nodeTypeDefinition;
                ChildNodeDefinition childNodeDefinition = (ChildNodeDefinition)element;
                if (CndFormsEditorPage.this.shouldShowInheritedChildNodes() && !Utils.equivalent((String)(nodeTypeDefinition = CndFormsEditorPage.this.getSelectedNodeType()).getName(), (String)childNodeDefinition.getDeclaringNodeTypeDefinitionName().get())) {
                    return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.textfont");
                }
                return super.getFont(element);
            }

            public String getText(Object element) {
                ChildNodeDefinition childNodeDefinition = (ChildNodeDefinition)element;
                if (this.columnIndex == 0) {
                    return childNodeDefinition.getName();
                }
                CndElement.NotationType notationType = CndElement.NotationType.LONG;
                if (this.columnIndex == 4) {
                    if (!Utils.equivalent((String)CndFormsEditorPage.this.getSelectedNodeType().getName(), (String)childNodeDefinition.getDeclaringNodeTypeDefinitionName().get())) {
                        return childNodeDefinition.getDeclaringNodeTypeDefinitionName().get();
                    }
                    return "";
                }
                if (this.columnIndex == 2) {
                    return childNodeDefinition.getDefaultType().getDefaultType().get();
                }
                if (this.columnIndex == 1) {
                    Object[] requiredTypes = childNodeDefinition.getRequiredPrimaryTypeNames();
                    if (Utils.isEmpty((Object[])requiredTypes)) {
                        return "";
                    }
                    return UiUtils.join(Arrays.asList(requiredTypes), null);
                }
                if (!$assertionsDisabled && this.columnIndex != 3) {
                    throw new AssertionError((Object)"Unexpected child node column index");
                }
                return childNodeDefinition.getAttributesCndNotation(notationType);
            }

            public String getToolTipText(Object element) {
                ChildNodeDefinition childNodeDefinition = (ChildNodeDefinition)element;
                return childNodeDefinition.toCndNotation(CndElement.NotationType.LONG);
            }
        }
        UiUtils.configureColumn((TableViewerColumn)nameColumn, (CellLabelProvider)new ChildNodeLabelProvider(0), (String)CndMessages.nameHeaderText, (String)CndMessages.childNodeNameToolTip, (boolean)false, (boolean)true);
        TableViewerColumn typeColumn = new TableViewerColumn(this.childNodeViewer, 16384);
        UiUtils.configureColumn((TableViewerColumn)typeColumn, (CellLabelProvider)new ChildNodeLabelProvider(1), (String)CndMessages.requiredTypesHeaderText, (String)CndMessages.childNodeRequiredTypesToolTip, (boolean)false, (boolean)true);
        TableViewerColumn defaultValuesColumn = new TableViewerColumn(this.childNodeViewer, 16384);
        UiUtils.configureColumn((TableViewerColumn)defaultValuesColumn, (CellLabelProvider)new ChildNodeLabelProvider(2), (String)CndMessages.defaultTypeHeaderText, (String)CndMessages.childNodeDefaultTypeToolTip, (boolean)false, (boolean)true);
        TableViewerColumn attributesColumn = new TableViewerColumn(this.childNodeViewer, 16384);
        UiUtils.configureColumn((TableViewerColumn)attributesColumn, (CellLabelProvider)new ChildNodeLabelProvider(3), (String)CndMessages.attributesHeaderText, (String)CndMessages.childNodeAttributesToolTip, (boolean)false, (boolean)true);
        TableViewerColumn nodeTypeColumn = new TableViewerColumn(this.childNodeViewer, 16384);
        UiUtils.configureColumn((TableViewerColumn)nodeTypeColumn, (CellLabelProvider)new ChildNodeLabelProvider(4), (String)CndMessages.declaringNodeTypeHeaderText, (String)CndMessages.declaringNodeTypeToolTip, (boolean)false, (boolean)true);
        TableViewerColumn commentColumn = new TableViewerColumn(this.childNodeViewer, 131072);
        UiUtils.configureColumn((TableViewerColumn)commentColumn, (CellLabelProvider)new CommentLabelProvider((ColumnViewer)this.childNodeViewer), (String)CndMessages.commentedHeaderText, (String)CndMessages.commentedToolTip, (boolean)false, (boolean)false);
        this.childNodeViewer.setSorter(new ViewerSorter(){

            public void sort(Viewer viewer, Object[] elements) {
                Arrays.sort(elements);
            }
        });
    }

    private void createDetailsSection(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        this.detailsSection = FormUtils.createSection((IManagedForm)managedForm, (FormToolkit)toolkit, (Composite)parent, (String)CndMessages.cndEditorDetailsSectionTitle, (String)CndMessages.cndEditorDetailsSectionDescription, (int)8576, (boolean)false);
        toolkit.paintBordersFor((Composite)this.detailsSection);
        Composite detailsContainer = toolkit.createComposite((Composite)this.detailsSection);
        detailsContainer.setLayout((Layout)new GridLayout(2, true));
        detailsContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.detailsSection.setClient((Control)detailsContainer);
        toolkit.paintBordersFor(detailsContainer);
        Composite leftContainer = toolkit.createComposite(detailsContainer);
        leftContainer.setLayout((Layout)new GridLayout(2, false));
        leftContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        toolkit.paintBordersFor(leftContainer);
        this.nameEditor = new QualifiedNameEditor(leftContainer, 0, toolkit, Messages.nodeTypeDefinitionName, this.getCnd().getNamespacePrefixes(), null);
        ((GridData)this.nameEditor.getLayoutData()).horizontalSpan = 2;
        this.nameEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                CndFormsEditorPage.this.handleNodeTypeNameChanged(e.text);
            }
        });
        this.refreshNameControls();
        Group attributesContainer = new Group(leftContainer, 32);
        attributesContainer.setText(CndMessages.attributesHeaderText);
        attributesContainer.setLayout((Layout)new GridLayout(2, true));
        attributesContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)attributesContainer.getLayoutData()).horizontalSpan = 2;
        toolkit.adapt((Composite)attributesContainer);
        toolkit.paintBordersFor((Composite)attributesContainer);
        this.btnAbstract = toolkit.createButton((Composite)attributesContainer, CndMessages.abstractAttribute, 32);
        this.btnAbstract.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CndFormsEditorPage.this.handleAbstractChanged(((Button)e.widget).getSelection());
            }
        });
        this.btnAbstract.setToolTipText(CndMessages.abstractAttributeToolTip);
        this.btnMixin = toolkit.createButton((Composite)attributesContainer, CndMessages.mixinAttribute, 32);
        this.btnMixin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CndFormsEditorPage.this.handleMixinChanged(((Button)e.widget).getSelection());
            }
        });
        this.btnMixin.setToolTipText(CndMessages.mixinAttributeToolTip);
        this.btnOrderable = toolkit.createButton((Composite)attributesContainer, CndMessages.orderableAttribute, 32);
        this.btnOrderable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CndFormsEditorPage.this.handleOrderableChanged(((Button)e.widget).getSelection());
            }
        });
        this.btnOrderable.setToolTipText(CndMessages.orderableAttributeToolTip);
        this.btnQueryable = toolkit.createButton((Composite)attributesContainer, CndMessages.queryableAttribute, 32);
        this.btnQueryable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CndFormsEditorPage.this.handleQueryableChanged(((Button)e.widget).getSelection());
            }
        });
        this.btnQueryable.setToolTipText(CndMessages.queryableAttributeToolTip);
        Composite primaryItemContainer = toolkit.createComposite((Composite)attributesContainer);
        primaryItemContainer.setLayout((Layout)new GridLayout(2, false));
        primaryItemContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)primaryItemContainer.getLayoutData()).horizontalSpan = 2;
        toolkit.paintBordersFor(primaryItemContainer);
        Label lblPrimaryItem = toolkit.createLabel(primaryItemContainer, CndMessages.primaryItemLabel, 0);
        lblPrimaryItem.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.cbxPrimaryItem = new CCombo(primaryItemContainer, 0x800808);
        this.cbxPrimaryItem.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.cbxPrimaryItem.getLayoutData()).heightHint = this.cbxPrimaryItem.getItemHeight() + 4;
        this.cbxPrimaryItem.setToolTipText(CndMessages.primaryItemToolTip);
        toolkit.adapt((Control)this.cbxPrimaryItem, true, false);
        this.cbxPrimaryItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newPrimaryItem = ((CCombo)e.widget).getText();
                if (CndMessages.notAssignedItemChoice.equals(newPrimaryItem)) {
                    newPrimaryItem = "";
                }
                CndFormsEditorPage.this.handlePrimaryItemChanged(newPrimaryItem);
            }
        });
        this.refreshAttributeControls();
        Composite rightContainer = toolkit.createComposite(detailsContainer);
        rightContainer.setLayout((Layout)new GridLayout(2, false));
        rightContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        toolkit.paintBordersFor(rightContainer);
        Label label = toolkit.createLabel(rightContainer, CndMessages.supertypesLabel);
        label.setLayoutData((Object)new GridData(1, 128, false, false));
        this.createSuperTypesActions();
        ToolBarManager toolBarManager = new ToolBarManager(0x800100);
        ToolBar toolBar = toolBarManager.createControl(rightContainer);
        toolBar.setLayoutData((Object)new GridData(131072, 128, false, false));
        toolkit.adapt((Composite)toolBar);
        Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolBar.setCursor(handCursor);
        toolBarManager.add(this.addSuperType);
        toolBarManager.add(this.editSuperType);
        toolBarManager.add(this.deleteSuperType);
        toolBarManager.update(true);
        Table table = FormUtils.createTable((FormToolkit)toolkit, (Composite)rightContainer);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        GridData gd = (GridData)table.getLayoutData();
        gd.horizontalSpan = 2;
        gd.heightHint = table.getItemHeight() * 4;
        gd.widthHint = UiUtils.convertWidthInCharsToPixels((Control)table, (int)40);
        table.setToolTipText(CndMessages.supertypesToolTip);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new DelegateAction(CndMessages.addSuperTypeMenuText, this.addSuperType));
        menuManager.add((IAction)new DelegateAction(CndMessages.editSuperTypeMenuText, this.editSuperType));
        menuManager.add((IAction)new DelegateAction(CndMessages.deleteSuperTypeMenuText, this.deleteSuperType));
        table.setMenu(menuManager.createContextMenu((Control)table));
        this.createSuperTypesViewer(table);
        this.refreshSuperTypes();
        Composite commentsContainer = toolkit.createComposite(detailsContainer);
        commentsContainer.setLayout((Layout)new GridLayout());
        commentsContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)commentsContainer.getLayoutData()).horizontalSpan = 2;
        toolkit.paintBordersFor(commentsContainer);
        Label lblComment = toolkit.createLabel(commentsContainer, CndMessages.commentLabel, 0);
        lblComment.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.txtComment = toolkit.createText(commentsContainer, null, 2818);
        this.txtComment.setToolTipText(CndMessages.commentedToolTip);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.verticalIndent += ((GridLayout)detailsContainer.getLayout()).verticalSpacing;
        gd2.heightHint = this.txtComment.getLineHeight() * 3;
        gd2.widthHint = UiUtils.convertWidthInCharsToPixels((Control)this.txtComment, (int)80);
        this.txtComment.setLayoutData((Object)gd2);
        this.txtComment.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CndFormsEditorPage.this.handleCommentChanged(((Text)e.widget).getText());
            }
        });
        this.refreshComments();
    }

    private void createNamespaceActions() {
        this.addNamespace = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleAddNamespace();
            }
        };
        this.addNamespace.setToolTipText(CndMessages.addNamespaceToolTip);
        this.addNamespace.setImageDescriptor(JcrUiUtils.getNewImageDescriptor());
        this.copyNamespace = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleCopyNamespace();
            }
        };
        this.copyNamespace.setEnabled(false);
        this.copyNamespace.setToolTipText(CndMessages.copyNamespaceToolTip);
        this.copyNamespace.setImageDescriptor(GraphicsUtils.getSharedImageDescriptor((String)"IMG_TOOL_COPY"));
        this.deleteNamespace = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleDeleteNamespace();
            }
        };
        this.deleteNamespace.setEnabled(false);
        this.deleteNamespace.setToolTipText(CndMessages.deleteNamespaceToolTip);
        this.deleteNamespace.setImageDescriptor(JcrUiUtils.getDeleteImageDescriptor());
        this.editNamespace = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleEditNamespace();
            }
        };
        this.editNamespace.setEnabled(false);
        this.editNamespace.setToolTipText(CndMessages.editNamespaceToolTip);
        this.editNamespace.setImageDescriptor(JcrUiUtils.getEditImageDescriptor());
        this.pasteNamespace = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handlePasteNamespace();
            }
        };
        this.pasteNamespace.setEnabled(false);
        this.pasteNamespace.setToolTipText(CndMessages.pasteNamespaceToolTip);
        this.pasteNamespace.setImageDescriptor(GraphicsUtils.getSharedImageDescriptor((String)"IMG_TOOL_PASTE"));
    }

    private void createNamespaceSection(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        int sectionStyle = 8642;
        if (this.memento == null) {
            sectionStyle &= 0xFFFFFFBF;
        } else {
            Boolean expanded = this.memento.getBoolean("NAMESPACE_SECTION_EXPANDED");
            if (expanded != null && !expanded.booleanValue()) {
                sectionStyle &= 0xFFFFFFBF;
            }
        }
        this.namespaceSection = FormUtils.createSection((IManagedForm)managedForm, (FormToolkit)toolkit, (Composite)parent, (String)CndMessages.cndEditorNamespacesSectionTitle, (String)CndMessages.cndEditorNamespacesSectionDescription, (int)sectionStyle, (boolean)false);
        toolkit.paintBordersFor((Composite)this.namespaceSection);
        this.createNamespaceActions();
        Composite container = toolkit.createComposite((Composite)this.namespaceSection);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 128, true, false));
        this.namespaceSection.setClient((Control)container);
        toolkit.paintBordersFor(container);
        FormUtils.createToolBar((Composite)container, (FormToolkit)toolkit, (IAction[])new IAction[]{this.addNamespace, this.editNamespace, this.deleteNamespace, this.copyNamespace, this.pasteNamespace}, (int[])new int[]{3});
        Table table = FormUtils.createTable((FormToolkit)toolkit, (Composite)container);
        table.setLayoutData((Object)new GridData(4, 128, true, false));
        ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * 5;
        ((GridData)table.getLayoutData()).minimumHeight = table.getItemHeight() * 5;
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new DelegateAction(CndMessages.addNamespaceMenuText, this.addNamespace));
        menuManager.add((IAction)new DelegateAction(CndMessages.editNamespaceMenuText, this.editNamespace));
        menuManager.add((IAction)new DelegateAction(CndMessages.deleteNamespaceMenuText, this.deleteNamespace));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new DelegateAction(CndMessages.copyNamespaceMenuText, this.copyNamespace));
        menuManager.add((IAction)new DelegateAction(CndMessages.pasteNamespaceMenuText, this.pasteNamespace));
        table.setMenu(menuManager.createContextMenu((Control)table));
        this.createNamespaceViewer(table);
        IWorkbenchHelpSystem helpSystem = Activator.getSharedInstance().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.namespaceSection, JcrUiConstants.HelpContexts.NAMESPACES_TABLE_HELP_CONTEXT);
    }

    private void createNamespaceViewer(Table namespaceTable) {
        this.namespaceViewer = new TableViewer(namespaceTable);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.namespaceViewer);
        this.namespaceViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return CndFormsEditorPage.this.getCnd().getNamespaceMappings().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        final IAction editAction = this.editNamespace;
        this.namespaceViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (editAction.isEnabled()) {
                    CndFormsEditorPage.this.handleEditNamespace();
                }
            }
        });
        this.namespaceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CndFormsEditorPage.this.handleNamespaceSelected();
            }
        });
        TableViewerColumn prefixColumn = new TableViewerColumn(this.namespaceViewer, 16384);
        class NamespaceLabelProvider
        extends ColumnLabelProvider {
            private final int columnIndex;

            public NamespaceLabelProvider(int columnIndex) {
                this.columnIndex = columnIndex;
            }

            public String getText(Object element) {
                NamespaceMapping namespaceMapping = (NamespaceMapping)element;
                if (this.columnIndex == 0) {
                    return namespaceMapping.getPrefix();
                }
                if (this.columnIndex == 1) {
                    return namespaceMapping.getUri();
                }
                return "";
            }

            public String getToolTipText(Object element) {
                NamespaceMapping namespaceMapping = (NamespaceMapping)element;
                return namespaceMapping.toCndNotation(CndElement.NotationType.LONG);
            }
        }
        UiUtils.configureColumn((TableViewerColumn)prefixColumn, (CellLabelProvider)new NamespaceLabelProvider(0), (String)CndMessages.namespacePrefixHeaderText, (String)CndMessages.namespacePrefixToolTip, (boolean)false, (boolean)true);
        TableViewerColumn uriColumn = new TableViewerColumn(this.namespaceViewer, 16384);
        UiUtils.configureColumn((TableViewerColumn)uriColumn, (CellLabelProvider)new NamespaceLabelProvider(1), (String)CndMessages.namespaceUriHeaderText, (String)CndMessages.namespaceUriToolTip, (boolean)false, (boolean)true);
        TableViewerColumn commentColumn = new TableViewerColumn(this.namespaceViewer, 131072);
        UiUtils.configureColumn((TableViewerColumn)commentColumn, (CellLabelProvider)new CommentLabelProvider((ColumnViewer)this.namespaceViewer), (String)CndMessages.commentedHeaderText, (String)CndMessages.commentedToolTip, (boolean)false, (boolean)false);
        this.namespaceViewer.setSorter(new ViewerSorter(){

            public void sort(Viewer viewer, Object[] elements) {
                Arrays.sort(elements);
            }
        });
    }

    private void createNodeTypeActions() {
        this.addNodeType = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleAddNodeType();
            }
        };
        this.addNodeType.setToolTipText(CndMessages.addNodeTypeToolTip);
        this.addNodeType.setImageDescriptor(JcrUiUtils.getNewImageDescriptor());
        this.copyNodeType = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleCopyNodeType();
            }
        };
        this.copyNodeType.setEnabled(false);
        this.copyNodeType.setToolTipText(CndMessages.copyNodeTypeToolTip);
        this.copyNodeType.setImageDescriptor(GraphicsUtils.getSharedImageDescriptor((String)"IMG_TOOL_COPY"));
        this.deleteNodeType = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleDeleteNodeType();
            }
        };
        this.deleteNodeType.setEnabled(false);
        this.deleteNodeType.setToolTipText(CndMessages.deleteNodeTypeToolTip);
        this.deleteNodeType.setImageDescriptor(JcrUiUtils.getDeleteImageDescriptor());
        this.pasteNodeType = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handlePasteNodeType();
            }
        };
        this.pasteNodeType.setEnabled(false);
        this.pasteNodeType.setToolTipText(CndMessages.pasteNodeTypeToolTip);
        this.pasteNodeType.setImageDescriptor(GraphicsUtils.getSharedImageDescriptor((String)"IMG_TOOL_PASTE"));
    }

    private void createNodeTypeSection(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        this.nodeTypeSection = FormUtils.createSection((IManagedForm)managedForm, (FormToolkit)toolkit, (Composite)parent, (String)CndMessages.cndEditorNodeTypeSectionTitle, (String)CndMessages.cndEditorNodeTypeSectionDescription, (int)8640, (boolean)false);
        toolkit.paintBordersFor((Composite)this.nodeTypeSection);
        this.createNodeTypeActions();
        SashForm splitter = new SashForm((Composite)this.nodeTypeSection, 256);
        toolkit.adapt((Composite)splitter);
        splitter.setLayoutData((Object)new GridData(4, 4, true, true));
        splitter.setBackground(toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR"));
        this.nodeTypeSection.setClient((Control)splitter);
        Composite leftContainer = toolkit.createComposite((Composite)splitter);
        leftContainer.setLayout((Layout)new GridLayout());
        leftContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.paintBordersFor(leftContainer);
        FormUtils.createToolBar((Composite)leftContainer, (FormToolkit)toolkit, (IAction[])new IAction[]{this.addNodeType, this.deleteNodeType, this.copyNodeType, this.pasteNodeType}, (int[])new int[]{2});
        this.txtFilter = toolkit.createText(leftContainer, "", 2432);
        this.txtFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtFilter.setMessage(CndMessages.nodeTypeNamePatternMessage);
        this.txtFilter.setFont(JFaceResources.getDialogFont());
        this.txtFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CndFormsEditorPage.this.handleNodeTypeNameFilterModified(((Text)e.widget).getText());
            }
        });
        Composite viewerContainer = toolkit.createComposite(leftContainer);
        viewerContainer.setLayout((Layout)new GridLayout());
        viewerContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.paintBordersFor(viewerContainer);
        Table table = FormUtils.createTable((FormToolkit)toolkit, (Composite)viewerContainer);
        table.setLinesVisible(false);
        ((GridData)table.getLayoutData()).widthHint = UiUtils.convertWidthInCharsToPixels((Control)table, (int)30);
        this.createNodeTypeViewer(table);
        Composite container = toolkit.createComposite((Composite)splitter);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.paintBordersFor(container);
        this.createDetailsSection(managedForm, toolkit, container);
        this.createPropertySection(managedForm, toolkit, container);
        this.createChildNodeSection(managedForm, toolkit, container);
        MenuManager menuManager = new MenuManager();
        this.nodeTypeStatusBarMenuManager = new MenuManager();
        DelegateAction action = new DelegateAction(CndMessages.addNodeTypeMenuText, this.addNodeType);
        menuManager.add((IAction)action);
        this.nodeTypeStatusBarMenuManager.add((IAction)action);
        action = new DelegateAction(CndMessages.deleteNodeTypeMenuText, this.deleteNodeType);
        menuManager.add((IAction)action);
        this.nodeTypeStatusBarMenuManager.add((IAction)action);
        menuManager.add((IContributionItem)new Separator());
        this.nodeTypeStatusBarMenuManager.add((IContributionItem)new Separator());
        action = new DelegateAction(CndMessages.copyNodeTypeMenuText, this.copyNodeType);
        menuManager.add((IAction)action);
        this.nodeTypeStatusBarMenuManager.add((IAction)action);
        action = new DelegateAction(CndMessages.pasteNodeTypeMenuText, this.pasteNodeType);
        menuManager.add((IAction)action);
        this.nodeTypeStatusBarMenuManager.add((IAction)action);
        action = new DelegateAction(CndMessages.pastePropertyMenuText, this.pasteProperty);
        menuManager.add((IAction)action);
        this.nodeTypeStatusBarMenuManager.add((IAction)action);
        action = new DelegateAction(CndMessages.pasteChildNodeMenuText, this.pasteChildNode);
        menuManager.add((IAction)action);
        this.nodeTypeStatusBarMenuManager.add((IAction)action);
        table = this.nodeTypeViewer.getTable();
        table.setMenu(menuManager.createContextMenu((Control)table));
        this.getActionContributor().setNodeTypeStatusMenuManager(this.nodeTypeStatusBarMenuManager);
        splitter.setWeights(new int[]{20, 80});
        IWorkbenchHelpSystem helpSystem = Activator.getSharedInstance().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.nodeTypeSection, JcrUiConstants.HelpContexts.NODE_TYPES_TABLE_HELP_CONTEXT);
    }

    private void createNodeTypeViewer(Table nodeTypeTable) {
        this.nodeTypeViewer = new TableViewer(nodeTypeTable);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.nodeTypeViewer);
        this.nodeTypeViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return CndFormsEditorPage.this.getCnd().getNodeTypeDefinitions().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.nodeTypeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CndFormsEditorPage.this.handleNodeTypeSelected();
            }
        });
        TableViewerColumn nameColumn = new TableViewerColumn(this.nodeTypeViewer, 16384);
        class NodeTypeLabelProvider
        extends ColumnLabelProvider {
            NodeTypeLabelProvider() {
            }

            public String getText(Object element) {
                NodeTypeDefinition nodeTypeDefinition = (NodeTypeDefinition)element;
                String name = nodeTypeDefinition.getName();
                if (Utils.isEmpty((String)name)) {
                    name = Messages.missingName;
                }
                return name;
            }

            public String getToolTipText(Object element) {
                NodeTypeDefinition nodeTypeDefinition = (NodeTypeDefinition)element;
                return nodeTypeDefinition.toCndNotation(CndElement.NotationType.LONG);
            }
        }
        UiUtils.configureColumn((TableViewerColumn)nameColumn, (CellLabelProvider)new NodeTypeLabelProvider(), (String)CndMessages.nodeTypeNameHeaderText, (String)CndMessages.nodeTypeNameToolTip, (boolean)false, (boolean)true);
        this.nodeTypeViewer.setSorter(new ViewerSorter(){

            public void sort(Viewer viewer, Object[] elements) {
                Arrays.sort(elements);
            }
        });
        this.nodeTypeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String pattern = CndFormsEditorPage.this.getNodeTypeNameFilterPattern();
                if (Utils.isEmpty((String)pattern)) {
                    return true;
                }
                NodeTypeDefinition nodeTypeDefinition = (NodeTypeDefinition)element;
                String name = nodeTypeDefinition.getName();
                if (Utils.isEmpty((String)name)) {
                    return false;
                }
                return name.contains(pattern);
            }
        });
    }

    private void createPropertyActions() {
        this.addProperty = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleAddProperty();
            }
        };
        this.addProperty.setEnabled(false);
        this.addProperty.setToolTipText(CndMessages.addPropertyToolTip);
        this.addProperty.setImageDescriptor(JcrUiUtils.getNewImageDescriptor());
        this.copyProperty = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleCopyProperty();
            }
        };
        this.copyProperty.setEnabled(false);
        this.copyProperty.setToolTipText(CndMessages.copyPropertyToolTip);
        this.copyProperty.setImageDescriptor(GraphicsUtils.getSharedImageDescriptor((String)"IMG_TOOL_COPY"));
        this.deleteProperty = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleDeleteProperty();
            }
        };
        this.deleteProperty.setEnabled(false);
        this.deleteProperty.setToolTipText(CndMessages.deletePropertyToolTip);
        this.deleteProperty.setImageDescriptor(JcrUiUtils.getDeleteImageDescriptor());
        this.editProperty = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleEditProperty();
            }
        };
        this.editProperty.setEnabled(false);
        this.editProperty.setToolTipText(CndMessages.editPropertyToolTip);
        this.editProperty.setImageDescriptor(JcrUiUtils.getEditImageDescriptor());
        this.pasteProperty = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handlePasteProperty();
            }
        };
        this.pasteProperty.setEnabled(false);
        this.pasteProperty.setToolTipText(CndMessages.pastePropertyToolTip);
        this.pasteProperty.setImageDescriptor(GraphicsUtils.getSharedImageDescriptor((String)"IMG_TOOL_PASTE"));
        this.showInheritedProperties = new Action("", 2){

            public void run() {
                CndFormsEditorPage.this.handleShowInheritedPropertiesChanged();
            }
        };
        this.showInheritedProperties.setToolTipText(CndMessages.showInheritedPropertiesToolTip);
        this.showInheritedProperties.setImageDescriptor(Activator.getSharedInstance().getImageDescriptor("icons/show-inherited-16x.gif"));
        this.openPropertyDeclaringNodeType = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleSelectPropertyDeclaringNodeType();
            }
        };
        this.openPropertyDeclaringNodeType.setEnabled(false);
        this.openPropertyDeclaringNodeType.setToolTipText(CndMessages.openDeclaringNodeTypeToolTip);
        this.openPropertyDeclaringNodeType.setImageDescriptor(Activator.getSharedInstance().getImageDescriptor("icons/open-declaring-node-type-16x.gif"));
    }

    private void createPropertySection(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        int sectionStyle = 8642;
        if (this.memento == null) {
            sectionStyle &= 0xFFFFFFBF;
        } else {
            Boolean expanded = this.memento.getBoolean("PROPERTY_SECTION_EXPANDED");
            if (expanded != null && !expanded.booleanValue()) {
                sectionStyle &= 0xFFFFFFBF;
            }
        }
        this.propertiesSection = FormUtils.createSection((IManagedForm)managedForm, (FormToolkit)toolkit, (Composite)parent, (String)CndMessages.cndEditorPropertySectionTitle, (String)CndMessages.cndEditorPropertySectionDescription, (int)sectionStyle, (boolean)true);
        toolkit.paintBordersFor((Composite)this.propertiesSection);
        this.createPropertyActions();
        Composite container = toolkit.createComposite((Composite)this.propertiesSection);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.propertiesSection.setClient((Control)container);
        toolkit.paintBordersFor(container);
        FormUtils.createToolBar((Composite)container, (FormToolkit)toolkit, (IAction[])new IAction[]{this.addProperty, this.editProperty, this.deleteProperty, this.copyProperty, this.pasteProperty, this.showInheritedProperties, this.openPropertyDeclaringNodeType}, (int[])new int[]{3, 6});
        Table table = FormUtils.createTable((FormToolkit)toolkit, (Composite)container);
        ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * 5;
        MenuManager menuManager = new MenuManager();
        this.propertyStatusBarMenuManager = new MenuManager();
        DelegateAction action = new DelegateAction(CndMessages.addPropertyMenuText, this.addProperty);
        menuManager.add((IAction)action);
        this.propertyStatusBarMenuManager.add((IAction)action);
        action = new DelegateAction(CndMessages.editPropertyMenuText, this.editProperty);
        menuManager.add((IAction)action);
        this.propertyStatusBarMenuManager.add((IAction)action);
        action = new DelegateAction(CndMessages.deletePropertyMenuText, this.deleteProperty);
        menuManager.add((IAction)action);
        this.propertyStatusBarMenuManager.add((IAction)action);
        menuManager.add((IContributionItem)new Separator());
        this.propertyStatusBarMenuManager.add((IContributionItem)new Separator());
        action = new DelegateAction(CndMessages.copyPropertyMenuText, this.copyProperty);
        menuManager.add((IAction)action);
        this.propertyStatusBarMenuManager.add((IAction)action);
        action = new DelegateAction(CndMessages.pastePropertyMenuText, this.pasteProperty);
        menuManager.add((IAction)action);
        this.propertyStatusBarMenuManager.add((IAction)action);
        menuManager.add((IContributionItem)new Separator());
        this.propertyStatusBarMenuManager.add((IContributionItem)new Separator());
        action = new DelegateAction(CndMessages.openDeclaringNodeTypeMenuText, this.openPropertyDeclaringNodeType);
        menuManager.add((IAction)action);
        this.propertyStatusBarMenuManager.add((IAction)action);
        table.setMenu(menuManager.createContextMenu((Control)table));
        this.getActionContributor().setPropertyStatusMenuManager(this.propertyStatusBarMenuManager);
        this.getActionContributor().setPropertyStatusDoubleClickAction(this.editProperty);
        this.createPropertyViewer(table);
        IWorkbenchHelpSystem helpSystem = Activator.getSharedInstance().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.propertiesSection, JcrUiConstants.HelpContexts.PROPERTIES_TABLE_HELP_CONTEXT);
    }

    private void createPropertyViewer(Table propertyTable) {
        this.propertyViewer = new TableViewer(propertyTable);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.propertyViewer);
        this.propertyViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                NodeTypeDefinition nodeTypeDefinition = CndFormsEditorPage.this.getSelectedNodeType();
                if (nodeTypeDefinition != null) {
                    try {
                        return CndFormsEditorPage.this.getCnd().getPropertyDefinitions(nodeTypeDefinition.getName(), CndFormsEditorPage.this.shouldShowInheritedProperties()).toArray();
                    }
                    catch (Exception e) {
                        Activator.getSharedInstance().getLog().log((IStatus)new Status(4, JcrUiConstants.PLUGIN_ID, NLS.bind((String)CndMessages.errorObtainingInheritedItemDefinitions, (Object)nodeTypeDefinition.getName()), (Throwable)e));
                    }
                }
                return Utils.EMPTY_OBJECT_ARRAY;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        final IAction editAction = this.editProperty;
        this.propertyViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (editAction.isEnabled()) {
                    CndFormsEditorPage.this.handleEditProperty();
                }
            }
        });
        this.propertyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CndFormsEditorPage.this.handlePropertySelected();
            }
        });
        TableViewerColumn nameColumn = new TableViewerColumn(this.propertyViewer, 16384);
        class PropertyLabelProvider
        extends ColumnLabelProvider {
            private final int columnIndex;

            public PropertyLabelProvider(int columnIndex) {
                this.columnIndex = columnIndex;
            }

            public Color getBackground(Object element) {
                NodeTypeDefinition nodeTypeDefinition;
                PropertyDefinition propertyDefinition = (PropertyDefinition)element;
                if (CndFormsEditorPage.this.shouldShowInheritedProperties() && !Utils.equivalent((String)(nodeTypeDefinition = CndFormsEditorPage.this.getSelectedNodeType()).getName(), (String)propertyDefinition.getDeclaringNodeTypeDefinitionName().get())) {
                    return CndFormsEditorPage.this.getShell().getDisplay().getSystemColor(19);
                }
                return super.getBackground(element);
            }

            public Font getFont(Object element) {
                NodeTypeDefinition nodeTypeDefinition;
                PropertyDefinition propertyDefinition = (PropertyDefinition)element;
                if (CndFormsEditorPage.this.shouldShowInheritedProperties() && !Utils.equivalent((String)(nodeTypeDefinition = CndFormsEditorPage.this.getSelectedNodeType()).getName(), (String)propertyDefinition.getDeclaringNodeTypeDefinitionName().get())) {
                    return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.textfont");
                }
                return super.getFont(element);
            }

            public String getText(Object element) {
                PropertyDefinition propertyDefinition = (PropertyDefinition)element;
                if (this.columnIndex == 0) {
                    return propertyDefinition.getName();
                }
                CndElement.NotationType notationType = CndElement.NotationType.LONG;
                if (this.columnIndex == 1) {
                    return propertyDefinition.getType().toString();
                }
                if (this.columnIndex == 3) {
                    return propertyDefinition.getAttributesCndNotation(notationType);
                }
                if (this.columnIndex == 4) {
                    if (!Utils.equivalent((String)CndFormsEditorPage.this.getSelectedNodeType().getName(), (String)propertyDefinition.getDeclaringNodeTypeDefinitionName().get())) {
                        return propertyDefinition.getDeclaringNodeTypeDefinitionName().get();
                    }
                    return "";
                }
                if (this.columnIndex == 2) {
                    List defaultValues = propertyDefinition.getDefaultValuesAsStrings();
                    if (Utils.isEmpty((Collection)defaultValues)) {
                        return "";
                    }
                    return UiUtils.join((Collection)defaultValues, null);
                }
                if (!$assertionsDisabled && this.columnIndex != 5) {
                    throw new AssertionError((Object)"Unexpected property column index");
                }
                Object[] constraints = propertyDefinition.getValueConstraints();
                if (Utils.isEmpty((Object[])constraints)) {
                    return "";
                }
                return UiUtils.join(Arrays.asList(constraints), null);
            }

            public String getToolTipText(Object element) {
                PropertyDefinition propertyDefinition = (PropertyDefinition)element;
                return propertyDefinition.toCndNotation(CndElement.NotationType.LONG);
            }
        }
        UiUtils.configureColumn((TableViewerColumn)nameColumn, (CellLabelProvider)new PropertyLabelProvider(0), (String)CndMessages.nameHeaderText, (String)CndMessages.propertyNameToolTip, (boolean)false, (boolean)true);
        TableViewerColumn typeColumn = new TableViewerColumn(this.propertyViewer, 16384);
        UiUtils.configureColumn((TableViewerColumn)typeColumn, (CellLabelProvider)new PropertyLabelProvider(1), (String)CndMessages.typeHeaderText, (String)CndMessages.propertyTypeToolTip, (boolean)false, (boolean)true);
        TableViewerColumn defaultValuesColumn = new TableViewerColumn(this.propertyViewer, 16384);
        UiUtils.configureColumn((TableViewerColumn)defaultValuesColumn, (CellLabelProvider)new PropertyLabelProvider(2), (String)CndMessages.defaultValuesHeaderText, (String)CndMessages.propertyDefaultValuesToolTip, (boolean)false, (boolean)true);
        TableViewerColumn attributesColumn = new TableViewerColumn(this.propertyViewer, 16384);
        UiUtils.configureColumn((TableViewerColumn)attributesColumn, (CellLabelProvider)new PropertyLabelProvider(3), (String)CndMessages.attributesHeaderText, (String)CndMessages.propertyAttributesToolTip, (boolean)false, (boolean)true);
        TableViewerColumn constraintsColumn = new TableViewerColumn(this.propertyViewer, 16384);
        UiUtils.configureColumn((TableViewerColumn)constraintsColumn, (CellLabelProvider)new PropertyLabelProvider(5), (String)CndMessages.valueConstraintsHeaderText, (String)CndMessages.propertyValueConstraintsToolTip, (boolean)false, (boolean)true);
        TableViewerColumn nodeTypeColumn = new TableViewerColumn(this.propertyViewer, 16384);
        UiUtils.configureColumn((TableViewerColumn)nodeTypeColumn, (CellLabelProvider)new PropertyLabelProvider(4), (String)CndMessages.declaringNodeTypeHeaderText, (String)CndMessages.declaringNodeTypeToolTip, (boolean)false, (boolean)true);
        TableViewerColumn commentColumn = new TableViewerColumn(this.propertyViewer, 131072);
        UiUtils.configureColumn((TableViewerColumn)commentColumn, (CellLabelProvider)new CommentLabelProvider((ColumnViewer)this.propertyViewer), (String)CndMessages.commentedHeaderText, (String)CndMessages.commentedToolTip, (boolean)false, (boolean)false);
        this.propertyViewer.setSorter(new ViewerSorter(){

            public void sort(Viewer viewer, Object[] elements) {
                Arrays.sort(elements);
            }
        });
    }

    private void createSuperTypesActions() {
        this.addSuperType = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleAddSuperType();
            }
        };
        this.addSuperType.setEnabled(false);
        this.addSuperType.setToolTipText(CndMessages.addSuperTypeToolTip);
        this.addSuperType.setImageDescriptor(JcrUiUtils.getNewImageDescriptor());
        this.deleteSuperType = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleDeleteSuperType();
            }
        };
        this.deleteSuperType.setEnabled(false);
        this.deleteSuperType.setToolTipText(CndMessages.deleteSuperTypeToolTip);
        this.deleteSuperType.setImageDescriptor(JcrUiUtils.getDeleteImageDescriptor());
        this.editSuperType = new Action(""){

            public void run() {
                CndFormsEditorPage.this.handleEditSuperType();
            }
        };
        this.editSuperType.setEnabled(false);
        this.editSuperType.setToolTipText(CndMessages.editSuperTypeToolTip);
        this.editSuperType.setImageDescriptor(JcrUiUtils.getEditImageDescriptor());
    }

    private void createSuperTypesViewer(Table superTypesTable) {
        this.superTypesViewer = new TableViewer(superTypesTable);
        this.superTypesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.superTypesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                NodeTypeDefinition nodeTypeDefinition = CndFormsEditorPage.this.getSelectedNodeType();
                if (nodeTypeDefinition == null) {
                    return Utils.EMPTY_OBJECT_ARRAY;
                }
                return nodeTypeDefinition.getDeclaredSupertypeNames();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        final IAction editAction = this.editSuperType;
        this.superTypesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (editAction.isEnabled()) {
                    CndFormsEditorPage.this.handleEditSuperType();
                }
            }
        });
        this.superTypesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CndFormsEditorPage.this.handleSuperTypeSelected();
            }
        });
    }

    CndEditorActionBarContributor getActionContributor() {
        return (CndEditorActionBarContributor)this.getEditor().getEditorSite().getActionBarContributor();
    }

    Collection<QualifiedName> getChildNodeNames() {
        assert (this.getSelectedNodeType() != null) : "getChildNodeNames called but no selected node type";
        List childNodes = this.getSelectedNodeType().getChildNodeDefinitions();
        if (childNodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QualifiedName> childNodeNames = new ArrayList<QualifiedName>(childNodes.size());
        for (ChildNodeDefinition childNode : childNodes) {
            if (Utils.isEmpty((String)childNode.getName())) continue;
            childNodeNames.add(childNode.getQualifiedName());
        }
        return childNodeNames;
    }

    String getNodeTypeNameFilterPattern() {
        return this.nodeTypeNameFilterPattern;
    }

    Collection<QualifiedName> getNodeTypeNames() {
        List nodeTypes = this.getCnd().getNodeTypeDefinitions();
        if (nodeTypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QualifiedName> nodeTypeNames = new ArrayList<QualifiedName>(nodeTypes.size());
        for (NodeTypeDefinition nodeType : nodeTypes) {
            if (Utils.isEmpty((String)nodeType.getName())) continue;
            nodeTypeNames.add(nodeType.getQualifiedName());
        }
        return nodeTypeNames;
    }

    Collection<QualifiedName> getPropertyNames() {
        assert (this.getSelectedNodeType() != null) : "getPropertyNames called but no selected node type";
        List propDefns = this.getSelectedNodeType().getPropertyDefinitions();
        if (propDefns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QualifiedName> propDefnNames = new ArrayList<QualifiedName>(propDefns.size());
        for (PropertyDefinition propDefn : propDefns) {
            if (Utils.isEmpty((String)propDefn.getName())) continue;
            propDefnNames.add(propDefn.getQualifiedName());
        }
        return propDefnNames;
    }

    private QualifiedNameProposalProvider getProposalProvider() {
        return new QualifiedNameProposalProvider(){

            @Override
            protected List<QualifiedName> qnameStartsWith(String qualifier, String namePattern) {
                List nodeTypes = CndFormsEditorPage.this.getCnd().getMatchingNodeTypeDefinitions(qualifier, true);
                if (nodeTypes.isEmpty()) {
                    return Collections.emptyList();
                }
                ArrayList<QualifiedName> matches = new ArrayList<QualifiedName>();
                boolean acceptAll = Utils.isEmpty((String)namePattern);
                for (NodeTypeDefinition nodeType : nodeTypes) {
                    QualifiedName qname = nodeType.getQualifiedName();
                    if (!acceptAll && (Utils.isEmpty((String)qname.getUnqualifiedName()) || !qname.getUnqualifiedName().startsWith(namePattern))) continue;
                    matches.add(qname);
                }
                return matches;
            }
        };
    }

    private ChildNodeDefinition getSelectedChildNode() {
        IStructuredSelection selection = (IStructuredSelection)this.childNodeViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        assert (selection.size() == 1) : "child node viewer should not allow multiple selections";
        assert (selection.getFirstElement() instanceof ChildNodeDefinition) : "selection was not a ChildNodeDefinition";
        return (ChildNodeDefinition)selection.getFirstElement();
    }

    private NamespaceMapping getSelectedNamespace() {
        IStructuredSelection selection = (IStructuredSelection)this.namespaceViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        assert (selection.size() == 1) : "child node viewer should not allow multiple selections";
        assert (selection.getFirstElement() instanceof NamespaceMapping) : "selection was not a NamespaceMapping";
        return (NamespaceMapping)selection.getFirstElement();
    }

    NodeTypeDefinition getSelectedNodeType() {
        IStructuredSelection selection = (IStructuredSelection)this.nodeTypeViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        assert (selection.size() == 1) : "node type viewer should not allow multiple selections";
        assert (selection.getFirstElement() instanceof NodeTypeDefinition) : "selection was not a NodeTypeDefinition";
        return (NodeTypeDefinition)selection.getFirstElement();
    }

    private PropertyDefinition getSelectedProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.propertyViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        assert (selection.size() == 1) : "property viewer should not allow multiple selections";
        assert (selection.getFirstElement() instanceof PropertyDefinition) : "selection was not a PropertyDefinition";
        return (PropertyDefinition)selection.getFirstElement();
    }

    private String getSelectedSuperType() {
        IStructuredSelection selection = (IStructuredSelection)this.superTypesViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        assert (selection.size() == 1) : "super types viewer should not allow multiple selections";
        assert (selection.getFirstElement() instanceof String) : "selection was not a string";
        return (String)selection.getFirstElement();
    }

    void handleAbstractChanged(boolean newValue) {
        this.getSelectedNodeType().setAbstract(newValue);
    }

    void handleAddChildNode() {
        assert (this.getSelectedNodeType() != null) : "add child node handler called but there is no selected node type";
        ChildNodeDialog dialog = new ChildNodeDialog(this.getShell(), (ItemOwnerProvider)this.getSelectedNodeType(), this.getChildNodeNames(), this.getCnd().getNamespacePrefixes());
        dialog.setRequiredTypeProposalProvider(this.getProposalProvider());
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            ChildNodeDefinition newChildNodeDefinition = dialog.getChildNodeDefinition();
            this.addChildNode(this.getSelectedNodeType(), newChildNodeDefinition);
        }
    }

    void handleAddNamespace() {
        NamespaceMappingDialog dialog = new NamespaceMappingDialog(this.getShell(), this.getCnd().getNamespaceMappings());
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            NamespaceMapping newNamespaceMapping = dialog.getNamespaceMapping();
            this.addNamespace(newNamespaceMapping);
        }
    }

    void handleAddNodeType() {
        QualifiedNameDialog dialog = new QualifiedNameDialog(this.getShell(), CndMessages.newNodeTypeDialogTitle, Messages.nodeTypeDefinitionName, this.getCnd().getNamespacePrefixes());
        dialog.setExistingQNames(this.getNodeTypeNames());
        dialog.setProposalProvider(QualifiedNameProposalProvider.NO_PROPOSALS_PROVIDER);
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            QualifiedName newNodeTypeName = dialog.getQualifiedName();
            NodeTypeDefinition newNodeTypeDefinition = new NodeTypeDefinition();
            newNodeTypeDefinition.setName(newNodeTypeName.get());
            this.addNodeType(newNodeTypeDefinition);
        }
    }

    void handleAddProperty() {
        assert (this.getSelectedNodeType() != null) : "add property handler called but there is no selected node type";
        NodeTypeDefinition nodeTypeDefinition = this.getSelectedNodeType();
        PropertyDialog dialog = new PropertyDialog(this.getShell(), (ItemOwnerProvider)this.getSelectedNodeType(), this.getPropertyNames(), this.getCnd().getNamespacePrefixes(), nodeTypeDefinition.isQueryable());
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            PropertyDefinition newPropertyDefinition = dialog.getPropertyDefinition();
            this.addProperty(nodeTypeDefinition, newPropertyDefinition);
        }
    }

    void handleAddSuperType() {
        assert (this.getSelectedNodeType() != null) : "add supertype button is enabled when there is no selected node type";
        QualifiedNameDialog dialog = new QualifiedNameDialog(this.getShell(), CndMessages.newSuperTypeDialogTitle, Messages.superTypeName, this.getCnd().getNamespacePrefixes());
        dialog.setExistingQNames(this.getSelectedNodeType().getSupertypes());
        dialog.setProposalProvider(this.getProposalProvider());
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            QualifiedName newSupertype;
            NodeTypeDefinition nodeTypeDefinition = this.getSelectedNodeType();
            if (nodeTypeDefinition.addSuperType((newSupertype = dialog.getQualifiedName()).get())) {
                this.superTypesViewer.setSelection((ISelection)new StructuredSelection((Object)newSupertype.get()), true);
                FormToolkit.ensureVisible((Control)this.superTypesViewer.getTable());
            } else {
                MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorAddingSupertype, (Object)newSupertype));
            }
        }
    }

    void handleChildNodeSelected() {
        boolean enableDeclaredChildNode;
        boolean enable;
        boolean bl = enable = this.getSelectedNodeType() != null;
        if (this.addChildNode.isEnabled() != enable) {
            this.addChildNode.setEnabled(enable);
        }
        ChildNodeDefinition selectedChildNode = this.getSelectedChildNode();
        this.getActionContributor().setChildNode(selectedChildNode);
        boolean enableWithChildNodeSelected = enable && selectedChildNode != null;
        boolean enableInheritedChildNode = enableWithChildNodeSelected && !this.getSelectedNodeType().hasDeclaredChildNodeDefinition(this.getSelectedChildNode().getName());
        boolean bl2 = enableDeclaredChildNode = enableWithChildNodeSelected && this.getSelectedNodeType().hasDeclaredChildNodeDefinition(this.getSelectedChildNode().getName());
        if (this.editChildNode.isEnabled() != enableDeclaredChildNode) {
            this.editChildNode.setEnabled(enableDeclaredChildNode);
        }
        if (this.deleteChildNode.isEnabled() != enableDeclaredChildNode) {
            this.deleteChildNode.setEnabled(enableDeclaredChildNode);
        }
        if (this.copyChildNode.isEnabled() != enableDeclaredChildNode) {
            this.copyChildNode.setEnabled(enableDeclaredChildNode);
        }
        if (this.openChildNodeDeclaringNodeType.isEnabled() != enableInheritedChildNode) {
            this.openChildNodeDeclaringNodeType.setEnabled(enableInheritedChildNode);
        }
    }

    @Override
    public void handleCndReloaded() {
        if (this.propertyViewer != null) {
            this.refreshNamespaceControls();
            this.refreshNodeTypeControls();
        }
    }

    void handleCommentChanged(String newComment) {
        NodeTypeDefinition nodeType = this.getSelectedNodeType();
        if (nodeType != null) {
            nodeType.setComment(newComment);
        }
    }

    void handleCopyChildNode() {
        assert (this.getSelectedChildNode() != null) : "copy child node button enabled and there is no child node selected";
        ChildNodeDefinition selected = this.getSelectedChildNode();
        this.clipboard.setContents((JcrModelObject)selected, ChildNodeDefinitionTransfer.get());
        if (!this.pasteChildNode.isEnabled() && !this.isReadonly()) {
            this.pasteChildNode.setEnabled(true);
        }
    }

    void handleCopyNamespace() {
        assert (this.getSelectedNamespace() != null) : "copy namespace button enabled and there is no namespace selected";
        NamespaceMapping selected = this.getSelectedNamespace();
        this.clipboard.setContents((JcrModelObject)selected, NamespaceMappingTransfer.get());
        if (!this.pasteNamespace.isEnabled() && !this.isReadonly()) {
            this.pasteNamespace.setEnabled(true);
        }
    }

    void handleCopyNodeType() {
        assert (this.getSelectedNodeType() != null) : "copy node type button enabled and there is no node type selected";
        NodeTypeDefinition selected = this.getSelectedNodeType();
        this.clipboard.setContents((JcrModelObject)selected, NodeTypeDefinitionTransfer.get());
        if (!this.pasteNodeType.isEnabled() && !this.isReadonly()) {
            this.pasteNodeType.setEnabled(true);
        }
    }

    void handleCopyProperty() {
        assert (this.getSelectedProperty() != null) : "copy property button enabled and there is no property selected";
        PropertyDefinition selected = this.getSelectedProperty();
        this.clipboard.setContents((JcrModelObject)selected, PropertyDefinitionTransfer.get());
        if (!this.pasteProperty.isEnabled() && !this.isReadonly()) {
            this.pasteProperty.setEnabled(true);
        }
    }

    void handleDeleteChildNode() {
        assert (this.getSelectedNodeType() != null) : "Delete child node button is enabled and there is no node type selected";
        assert (this.getSelectedChildNode() != null) : "Delete child node button is enabled and there is no child node selected";
        ChildNodeDefinition childNodeDefinition = this.getSelectedChildNode();
        String name = childNodeDefinition.getName();
        if (Utils.isEmpty((String)name)) {
            name = Messages.missingName;
        }
        if (MessageFormDialog.openQuestion((Shell)this.getShell(), (String)CndMessages.deleteChildNodeDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.deleteChildNodeDialogMessage, (Object)name)) && !this.getSelectedNodeType().removeChildNodeDefinition(childNodeDefinition)) {
            MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorDeletingChildNode, (Object)name));
        }
    }

    void handleDeleteNamespace() {
        assert (this.getSelectedNamespace() != null) : "Delete namespace button is enabled and there is no namespace selected";
        NamespaceMapping namespaceMapping = this.getSelectedNamespace();
        String prefix = namespaceMapping.getPrefix();
        if (Utils.isEmpty((String)prefix)) {
            prefix = CndMessages.missingValue;
        }
        if (MessageFormDialog.openQuestion((Shell)this.getShell(), (String)CndMessages.deleteNamespaceDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.deleteNamespaceDialogMessage, (Object)prefix)) && !this.getCnd().removeNamespaceMapping(namespaceMapping)) {
            MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorDeletingNamespace, (Object)prefix));
        }
    }

    void handleDeleteNodeType() {
        assert (this.getSelectedNodeType() != null) : "Delete node type button is enabled and there is no node type selected";
        NodeTypeDefinition nodeTypeDefinition = this.getSelectedNodeType();
        String name = nodeTypeDefinition.getName();
        if (Utils.isEmpty((String)name)) {
            name = Messages.missingName;
        }
        if (MessageFormDialog.openQuestion((Shell)this.getShell(), (String)CndMessages.deleteNodeTypeDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.deleteNodeTypeDialogMessage, (Object)name)) && !this.getCnd().removeNodeTypeDefinition(nodeTypeDefinition)) {
            MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorDeletingNodeType, (Object)name));
        }
    }

    void handleDeleteProperty() {
        assert (this.getSelectedNodeType() != null) : "Delete property button is enabled and there is no node type selected";
        assert (this.getSelectedProperty() != null) : "Delete property button is enabled and there is no property selected";
        PropertyDefinition propertyDefinition = this.getSelectedProperty();
        String name = propertyDefinition.getName();
        if (Utils.isEmpty((String)name)) {
            name = Messages.missingName;
        }
        if (MessageFormDialog.openQuestion((Shell)this.getShell(), (String)CndMessages.deletePropertyDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.deletePropertyDialogMessage, (Object)name)) && !this.getSelectedNodeType().removePropertyDefinition(propertyDefinition)) {
            MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorDeletingProperty, (Object)name));
        }
    }

    void handleDeleteSuperType() {
        assert (this.getSelectedNodeType() != null) : "Delete super type button is enabled and there is no node type selected";
        assert (this.getSelectedSuperType() != null) : "Delete super type button is enabled and there is no super type selected";
        String superTypeName = this.getSelectedSuperType();
        if (Utils.isEmpty((String)superTypeName)) {
            superTypeName = Messages.missingName;
        }
        if (MessageFormDialog.openQuestion((Shell)this.getShell(), (String)CndMessages.deleteSuperTypeDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.deleteSuperTypeDialogMessage, (Object)superTypeName)) && !this.getSelectedNodeType().removeSuperType(superTypeName)) {
            MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorDeletingSupertype, (Object)superTypeName));
        }
    }

    void handleEditChildNode() {
        assert (this.getSelectedNodeType() != null) : "edit child node handler called but there is no selected node type";
        assert (this.getSelectedChildNode() != null) : "edit child node handler has been called when there is no child node selected";
        if (!this.childNodeSection.isExpanded()) {
            this.childNodeSection.setExpanded(true);
        }
        ChildNodeDefinition childNodeBeingEdited = this.getSelectedChildNode();
        ChildNodeDialog dialog = new ChildNodeDialog(this.getShell(), (ItemOwnerProvider)this.getSelectedNodeType(), this.getChildNodeNames(), this.getCnd().getNamespacePrefixes(), childNodeBeingEdited);
        dialog.setRequiredTypeProposalProvider(this.getProposalProvider());
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            NodeTypeDefinition nodeTypeDefinition = this.getSelectedNodeType();
            ChildNodeDefinition newChildNodeDefinition = dialog.getChildNodeDefinition();
            boolean removed = false;
            boolean added = false;
            if (nodeTypeDefinition.removeChildNodeDefinition(childNodeBeingEdited)) {
                removed = true;
                if (nodeTypeDefinition.addChildNodeDefinition(newChildNodeDefinition)) {
                    added = true;
                }
                UiUtils.pack((TableViewer[])new TableViewer[]{this.childNodeViewer});
            }
            if (!removed || !added) {
                MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorEditingChildNode, (Object[])new Object[]{childNodeBeingEdited.getName(), removed, added}));
            }
        }
    }

    void handleEditNamespace() {
        assert (this.getSelectedNamespace() != null) : "Edit namespace handler has been called when there is no namespace selected";
        NamespaceMapping selectedNamespace = this.getSelectedNamespace();
        NamespaceMappingDialog dialog = new NamespaceMappingDialog(this.getShell(), this.getCnd().getNamespaceMappings(), selectedNamespace);
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            NamespaceMapping modifiedNamespaceMapping = dialog.getNamespaceMapping();
            boolean removed = false;
            boolean added = false;
            if (this.getCnd().removeNamespaceMapping(selectedNamespace)) {
                removed = true;
                if (this.getCnd().addNamespaceMapping(modifiedNamespaceMapping)) {
                    added = true;
                }
                UiUtils.pack((TableViewer[])new TableViewer[]{this.namespaceViewer});
            }
            if (!removed || !added) {
                MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorEditingNamespaceMapping, (Object[])new Object[]{modifiedNamespaceMapping, removed, added}));
            }
        }
    }

    void handleEditProperty() {
        assert (this.getSelectedNodeType() != null) : "Edit property handler called but there is no selected node type";
        assert (this.getSelectedProperty() != null) : "Edit property handler has been called when there is no property selected";
        NodeTypeDefinition nodeTypeDefinition = this.getSelectedNodeType();
        PropertyDefinition propertyBeingEdited = this.getSelectedProperty();
        PropertyDialog dialog = new PropertyDialog(this.getShell(), (ItemOwnerProvider)this.getSelectedNodeType(), this.getPropertyNames(), this.getCnd().getNamespacePrefixes(), nodeTypeDefinition.isQueryable(), propertyBeingEdited);
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            PropertyDefinition newPropertyDefinition = dialog.getPropertyDefinition();
            boolean removed = false;
            boolean added = false;
            if (nodeTypeDefinition.removePropertyDefinition(propertyBeingEdited)) {
                removed = true;
                if (nodeTypeDefinition.addPropertyDefinition(newPropertyDefinition)) {
                    added = true;
                }
                UiUtils.pack((TableViewer[])new TableViewer[]{this.propertyViewer});
            }
            if (!removed || !added) {
                MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorEditingProperty, (Object[])new Object[]{propertyBeingEdited.getName(), removed, added}));
            }
        }
    }

    void handleEditSuperType() {
        assert (this.getSelectedSuperType() != null) : "Edit super type handler has been called when there is no super type selected";
        String selectedSupertype = this.getSelectedSuperType();
        QualifiedNameDialog dialog = new QualifiedNameDialog(this.getShell(), CndMessages.editSuperTypeDialogTitle, Messages.superTypeName, this.getCnd().getNamespacePrefixes(), QualifiedName.parse((String)selectedSupertype));
        dialog.setExistingQNames(this.getSelectedNodeType().getSupertypes());
        dialog.setProposalProvider(this.getProposalProvider());
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            NodeTypeDefinition nodeTypeDefinition = this.getSelectedNodeType();
            QualifiedName modifiedSuperType = dialog.getQualifiedName();
            boolean removed = false;
            boolean added = false;
            if (nodeTypeDefinition.removeSuperType(selectedSupertype)) {
                removed = true;
                if (nodeTypeDefinition.addSuperType(modifiedSuperType.get())) {
                    added = true;
                }
            }
            if (!removed || !added) {
                MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorEditingSupertype, (Object[])new Object[]{modifiedSuperType, removed, added}));
            }
        }
    }

    void handleMixinChanged(boolean newValue) {
        this.getSelectedNodeType().setMixin(newValue);
    }

    void handleNamespaceSelected() {
        boolean enable;
        boolean bl = enable = this.getSelectedNamespace() != null;
        if (this.editNamespace.isEnabled() != enable) {
            this.editNamespace.setEnabled(enable);
        }
        if (this.deleteNamespace.isEnabled() != enable) {
            this.deleteNamespace.setEnabled(enable);
        }
        if (this.copyNamespace.isEnabled() != enable) {
            this.copyNamespace.setEnabled(enable);
        }
    }

    void handleNodeTypeNameChanged(String newNodeTypeName) {
        if (this.getSelectedNodeType() != null) {
            this.getSelectedNodeType().setName(newNodeTypeName);
        }
    }

    void handleNodeTypeNameFilterModified(String namePattern) {
        this.nodeTypeNameFilterPattern = namePattern;
        this.refreshNodeTypeControls();
    }

    void handleNodeTypeSelected() {
        NodeTypeDefinition prevNodeType = this.selectedNodeType;
        this.selectedNodeType = this.getSelectedNodeType();
        this.getActionContributor().setNodeType(this.selectedNodeType);
        if (prevNodeType != null) {
            prevNodeType.removeListener((PropertyChangeListener)this);
        }
        if (this.selectedNodeType != null) {
            this.selectedNodeType.addListener((PropertyChangeListener)this);
        }
        this.updateEnabledState();
        if (this.selectedNodeType == null) {
            this.detailsSection.setDescription(CndMessages.cndEditorDetailsSectionDescription);
            this.propertiesSection.setDescription(CndMessages.cndEditorPropertySectionDescription);
            this.childNodeSection.setDescription(CndMessages.cndEditorChildNodeSectionDescription);
        } else {
            String name = this.selectedNodeType.getName();
            if (Utils.isEmpty((String)name)) {
                name = Messages.missingName;
            }
            this.nameEditor.setNameBeingEdited(this.selectedNodeType.getQualifiedName());
            this.detailsSection.setDescription(NLS.bind((String)CndMessages.cndEditorChildNodeSectionDescriptionWithNodeTypeName, (Object)name));
            this.propertiesSection.setDescription(NLS.bind((String)CndMessages.cndEditorPropertySectionDescriptionWithNodeTypeName, (Object)name));
            this.childNodeSection.setDescription(NLS.bind((String)CndMessages.cndEditorChildNodeSectionDescriptionWithNodeTypeName, (Object)name));
        }
        this.refreshNameControls();
        this.refreshAttributeControls();
        this.refreshSuperTypes();
        this.refreshComments();
        this.refreshPropertyViewer();
        this.refreshChildNodeViewer();
    }

    void handleOrderableChanged(boolean newValue) {
        this.getSelectedNodeType().setOrderableChildNodes(newValue);
    }

    void handlePasteChildNode() {
        assert (this.getSelectedNodeType() != null) : "paste child node is enabled when there is no node type selected";
        NodeTypeDefinition nodeTypeDefinition = this.getSelectedNodeType();
        ChildNodeDefinition childNodeDefn = (ChildNodeDefinition)this.clipboard.getContents(ChildNodeDefinitionTransfer.get());
        if (childNodeDefn == null) {
            this.pasteChildNode.setEnabled(false);
        } else {
            this.addChildNode(nodeTypeDefinition, childNodeDefn);
        }
    }

    void handlePasteNamespace() {
        NamespaceMapping namespace = (NamespaceMapping)this.clipboard.getContents(NamespaceMappingTransfer.get());
        if (namespace == null) {
            this.pasteNamespace.setEnabled(false);
        } else {
            this.addNamespace(namespace);
        }
    }

    void handlePasteNodeType() {
        NodeTypeDefinition nodeTypeDefn = (NodeTypeDefinition)this.clipboard.getContents(NodeTypeDefinitionTransfer.get());
        if (nodeTypeDefn == null) {
            this.pasteNodeType.setEnabled(false);
        } else {
            this.addNodeType(nodeTypeDefn);
        }
    }

    void handlePasteProperty() {
        assert (this.getSelectedNodeType() != null) : "paste property is enabled when there is no node type selected";
        NodeTypeDefinition nodeTypeDefinition = this.getSelectedNodeType();
        PropertyDefinition propDefn = (PropertyDefinition)this.clipboard.getContents(PropertyDefinitionTransfer.get());
        if (propDefn == null) {
            this.pasteProperty.setEnabled(false);
        } else {
            this.addProperty(nodeTypeDefinition, propDefn);
        }
    }

    void handlePrimaryItemChanged(String newPrimaryItem) {
        this.getSelectedNodeType().setPrimaryItemName(newPrimaryItem);
    }

    @Override
    protected void handlePropertyChanged(PropertyChangeEvent e) {
        if (this.childNodeViewer == null) {
            return;
        }
        Object source = e.getSource();
        String propName = e.getPropertyName();
        if (source instanceof NodeTypeDefinition) {
            if (NodeTypeDefinition.PropertyName.ABSTRACT.toString().equals(propName) || NodeTypeDefinition.PropertyName.MIXIN.toString().equals(propName) || NodeTypeDefinition.PropertyName.ORDERABLE.toString().equals(propName) || NodeTypeDefinition.PropertyName.QUERYABLE.toString().equals(propName) || NodeTypeDefinition.PropertyName.PRIMARY_ITEM.toString().equals(propName)) {
                if (NodeTypeDefinition.PropertyName.PRIMARY_ITEM.toString().equals(propName)) {
                    this.validateAttributes();
                }
            } else if (NodeTypeDefinition.PropertyName.CHILD_NODES.toString().equals(propName)) {
                this.validateChildNodes();
                this.childNodeViewer.refresh();
            } else if (NodeTypeDefinition.PropertyName.NAME.toString().equals(propName)) {
                this.validateName();
                this.nodeTypeViewer.refresh(source);
                UiUtils.pack((TableViewer[])new TableViewer[]{this.nodeTypeViewer});
            } else if (NodeTypeDefinition.PropertyName.PROPERTY_DEFINITIONS.toString().equals(propName)) {
                this.validateProperties();
                this.propertyViewer.refresh();
            } else if (NodeTypeDefinition.PropertyName.SUPERTYPES.toString().equals(propName)) {
                this.validateSuperTypes();
                this.superTypesViewer.refresh();
                if (this.shouldShowInheritedProperties()) {
                    this.propertyViewer.refresh();
                }
                if (this.shouldShowInheritedChildNodes()) {
                    this.childNodeViewer.refresh();
                }
            }
            this.getCndEditor().refreshDirtyState();
        } else if (source instanceof NamespaceMapping) {
            this.validateNamespaces();
            this.validateNodeTypes();
            this.namespaceViewer.refresh(source);
            UiUtils.pack((TableViewer[])new TableViewer[]{this.namespaceViewer});
        } else if (source instanceof CompactNodeTypeDefinition) {
            if (CompactNodeTypeDefinition.PropertyName.NAMESPACE_MAPPINGS.toString().equals(propName)) {
                this.validateNamespaces();
                this.refreshNamespaceControls();
                this.refreshNameControls();
            } else if (CompactNodeTypeDefinition.PropertyName.NODE_TYPE_DEFINITIONS.toString().equals(propName)) {
                this.refreshNodeTypeControls();
            }
        }
    }

    void handlePropertySelected() {
        boolean enableDeclaredProperty;
        boolean enable;
        boolean bl = enable = this.getSelectedNodeType() != null;
        if (this.addProperty.isEnabled() != enable) {
            this.addProperty.setEnabled(enable);
        }
        PropertyDefinition selectedProperty = this.getSelectedProperty();
        this.getActionContributor().setProperty(selectedProperty);
        boolean enableWithPropertySelected = enable && selectedProperty != null;
        boolean enableInheritedProperty = enableWithPropertySelected && !this.getSelectedNodeType().hasDeclaredPropertyDefinition(this.getSelectedProperty().getName());
        boolean bl2 = enableDeclaredProperty = enableWithPropertySelected && this.getSelectedNodeType().hasDeclaredPropertyDefinition(this.getSelectedProperty().getName());
        if (this.editProperty.isEnabled() != enableDeclaredProperty) {
            this.editProperty.setEnabled(enableDeclaredProperty);
        }
        if (this.copyProperty.isEnabled() != enableDeclaredProperty) {
            this.copyProperty.setEnabled(enableDeclaredProperty);
        }
        if (this.deleteProperty.isEnabled() != enableDeclaredProperty) {
            this.deleteProperty.setEnabled(enableDeclaredProperty);
        }
        if (this.openPropertyDeclaringNodeType.isEnabled() != enableInheritedProperty) {
            this.openPropertyDeclaringNodeType.setEnabled(enableInheritedProperty);
        }
    }

    void handleQueryableChanged(boolean newValue) {
        this.getSelectedNodeType().setQueryable(newValue);
    }

    void handleSelectPropertyDeclaringNodeType() {
        assert (this.getSelectedProperty() != null) : "handleSelectPropertyDeclaringNodeType called and no property selected";
        QualifiedName qname = this.getSelectedProperty().getDeclaringNodeTypeDefinitionName();
        NodeTypeDefinition nodeType = this.getCnd().getNodeTypeDefinition(qname.get());
        if (nodeType != null) {
            this.nodeTypeViewer.setSelection((ISelection)new StructuredSelection((Object)nodeType));
        }
    }

    void handleShowInheritedChildNodesChanged() {
        this.refreshChildNodeViewer();
    }

    void handleShowInheritedPropertiesChanged() {
        this.refreshPropertyViewer();
    }

    void handleSuperTypeSelected() {
        boolean enable;
        boolean bl = enable = this.getSelectedSuperType() != null;
        if (this.editSuperType.isEnabled() != enable) {
            this.editSuperType.setEnabled(enable);
        }
        if (this.deleteSuperType.isEnabled() != enable) {
            this.deleteSuperType.setEnabled(enable);
        }
    }

    private void populateUi() {
        this.namespaceViewer.setInput((Object)this);
        this.nodeTypeViewer.setInput((Object)this);
        UiUtils.pack((TableViewer[])new TableViewer[]{this.namespaceViewer, this.nodeTypeViewer});
        if (this.memento == null) {
            if (this.nodeTypeViewer.getTable().getItemCount() != 0) {
                this.nodeTypeViewer.getTable().select(0);
                Event e = new Event();
                e.widget = this.nodeTypeViewer.getTable();
                this.nodeTypeViewer.getTable().notifyListeners(13, e);
            }
        } else {
            String filter;
            String nodeTypeName = this.memento.getString("SELECTED_NODE_TYPE");
            if (!Utils.isEmpty((String)nodeTypeName)) {
                for (NodeTypeDefinition nodeTypeDefinition : this.getCnd().getNodeTypeDefinitions()) {
                    if (!nodeTypeName.equals(nodeTypeDefinition.getName())) continue;
                    this.nodeTypeViewer.setSelection((ISelection)new StructuredSelection((Object)nodeTypeDefinition));
                    break;
                }
            }
            if (!Utils.isEmpty((String)(filter = this.memento.getString("NODE_TYPE_FILTER")))) {
                this.txtFilter.setText(filter);
            }
        }
    }

    private void processStatus(IMessageManager msgMgr, ValidationStatus status, Control c) {
        if (status.isOk()) {
            return;
        }
        if (status instanceof MultiValidationStatus) {
            MultiValidationStatus multiStatus = (MultiValidationStatus)status;
            for (ValidationStatus embeddedStatus : multiStatus.getAll()) {
                this.processStatus(msgMgr, embeddedStatus, c);
            }
        } else {
            ErrorMessage em = new ErrorMessage();
            em.setControl(c);
            JcrUiUtils.setMessage(status, em);
            this.updateMessage(em);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.handlePropertyChanged(e);
    }

    private void refreshAttributeControls() {
        boolean notConcrete = false;
        boolean mixin = false;
        boolean orderable = false;
        boolean queryable = false;
        NodeTypeDefinition nodeTypeDefinition = this.getSelectedNodeType();
        if (nodeTypeDefinition != null) {
            String primaryItemName;
            if (nodeTypeDefinition.isAbstract()) {
                notConcrete = true;
            }
            if (nodeTypeDefinition.isMixin()) {
                mixin = true;
            }
            if (nodeTypeDefinition.hasOrderableChildNodes()) {
                orderable = true;
            }
            if (nodeTypeDefinition.isQueryable()) {
                queryable = true;
            }
            try {
                Collection currentItems = this.getCnd().getItemDefinitions(nodeTypeDefinition.getName(), true);
                for (ItemDefinition item : new ArrayList(currentItems)) {
                    if (!"*".equals(item.getQualifiedName().get())) continue;
                    currentItems.remove(item);
                }
                String[] itemNames = new String[currentItems.size() + 1];
                itemNames[0] = CndMessages.notAssignedItemChoice;
                int i = 1;
                for (ItemDefinition item : currentItems) {
                    itemNames[i++] = item.getQualifiedName().get();
                }
                if (this.cbxPrimaryItem.getItemCount() != itemNames.length || !Arrays.asList(itemNames).containsAll(Arrays.asList(this.cbxPrimaryItem.getItems()))) {
                    this.cbxPrimaryItem.setItems(itemNames);
                }
            }
            catch (Exception e) {
                Activator.getSharedInstance().getLog().log((IStatus)new Status(4, JcrUiConstants.PLUGIN_ID, NLS.bind((String)CndMessages.errorObtainingInheritedItemDefinitions, (Object)nodeTypeDefinition.getName()), (Throwable)e));
                this.cbxPrimaryItem.setItems(new String[]{CndMessages.notAssignedItemChoice});
            }
            if (Utils.isEmpty((String)(primaryItemName = nodeTypeDefinition.getPrimaryItemName()))) {
                this.cbxPrimaryItem.select(0);
            } else {
                int index = this.cbxPrimaryItem.indexOf(primaryItemName);
                if (index == -1) {
                    this.cbxPrimaryItem.add(primaryItemName);
                    this.cbxPrimaryItem.select(this.cbxPrimaryItem.getItemCount() - 1);
                } else {
                    this.cbxPrimaryItem.select(index);
                }
            }
        } else {
            this.cbxPrimaryItem.select(0);
        }
        if (this.btnAbstract.getSelection() != notConcrete) {
            this.btnAbstract.setSelection(notConcrete);
        }
        if (this.btnMixin.getSelection() != mixin) {
            this.btnMixin.setSelection(mixin);
        }
        if (this.btnOrderable.getSelection() != orderable) {
            this.btnOrderable.setSelection(orderable);
        }
        if (this.btnQueryable.getSelection() != queryable) {
            this.btnQueryable.setSelection(queryable);
        }
    }

    private void refreshChildNodeViewer() {
        if (this.childNodeViewer != null) {
            this.childNodeViewer.setInput((Object)this);
            UiUtils.pack((TableViewer[])new TableViewer[]{this.childNodeViewer});
            this.validateChildNodes();
        }
    }

    private void refreshComments() {
        NodeTypeDefinition nodeTypeDefinition = this.getSelectedNodeType();
        if (nodeTypeDefinition == null) {
            if (!Utils.isEmpty((String)this.txtComment.getText())) {
                this.txtComment.setText("");
            }
        } else {
            String comment = nodeTypeDefinition.getComment();
            if (!Utils.equivalent((String)comment, (String)this.txtComment.getText())) {
                this.txtComment.setText(comment == null ? "" : comment);
            }
        }
    }

    private void refreshNameControls() {
        NodeTypeDefinition nodeTypeDefinition = this.getSelectedNodeType();
        if (nodeTypeDefinition == null) {
            this.nameEditor.setNameBeingEdited(null);
        } else {
            this.nameEditor.setNameBeingEdited(nodeTypeDefinition.getQualifiedName());
            this.nameEditor.setValidQualifiers(this.getCnd().getNamespacePrefixes());
            this.nameEditor.setExistingQNames(this.getNodeTypeNames());
        }
    }

    private void refreshNamespaceControls() {
        this.namespaceViewer.refresh();
    }

    private void refreshNodeTypeControls() {
        String name;
        NodeTypeDefinition selectedNodeType = this.getSelectedNodeType();
        this.nodeTypeViewer.refresh();
        if (selectedNodeType != null && !Utils.isEmpty((String)(name = selectedNodeType.getName()))) {
            for (NodeTypeDefinition nodeType : this.getCnd().getNodeTypeDefinitions()) {
                if (!name.equals(nodeType.getName())) continue;
                this.nodeTypeViewer.setSelection((ISelection)new StructuredSelection((Object)nodeType));
            }
        }
    }

    private void refreshPropertyViewer() {
        if (this.propertyViewer != null) {
            this.propertyViewer.setInput((Object)this);
            UiUtils.pack((TableViewer[])new TableViewer[]{this.propertyViewer});
            this.validateProperties();
        }
    }

    private void refreshSuperTypes() {
        if (this.superTypesViewer != null) {
            this.superTypesViewer.setInput((Object)this);
            UiUtils.pack((TableViewer[])new TableViewer[]{this.superTypesViewer});
            this.validateSuperTypes();
        }
    }

    @Override
    public void saveState(IMemento memento) {
        memento.putBoolean("CHILD_NODE_SECTION_EXPANDED", this.childNodeSection.isExpanded());
        memento.putBoolean("NAMESPACE_SECTION_EXPANDED", this.namespaceSection.isExpanded());
        memento.putBoolean("PROPERTY_SECTION_EXPANDED", this.propertiesSection.isExpanded());
        NodeTypeDefinition nodeTypeDefinition = this.getSelectedNodeType();
        if (nodeTypeDefinition == null) {
            memento.putString("SELECTED_NODE_TYPE", "");
        } else {
            memento.putString("SELECTED_NODE_TYPE", nodeTypeDefinition.getName());
        }
        if (!Utils.isEmpty((String)this.nodeTypeNameFilterPattern)) {
            memento.putString("NODE_TYPE_FILTER", this.nodeTypeNameFilterPattern);
        }
    }

    @Override
    protected void setResourceReadOnly(boolean readOnly) {
        this.getActionContributor().setEditableStatus(!readOnly);
        this.updateEnabledState();
    }

    boolean shouldShowInheritedChildNodes() {
        return this.showInheritedChildNodes.isChecked();
    }

    boolean shouldShowInheritedProperties() {
        return this.showInheritedProperties.isChecked();
    }

    @Override
    protected void updateAllMessages() {
        if (this.nodeTypeViewer == null || this.nodeTypeViewer.getTable() == null || this.nodeTypeViewer.getTable().isDisposed()) {
            return;
        }
        this.nodeTypeViewer.getTable().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CndFormsEditorPage.this.validateNamespaces();
                CndFormsEditorPage.this.validateNodeTypes();
            }
        });
    }

    void updateEnabledState() {
        boolean enableDeclaredProperty;
        boolean enable;
        boolean enable2;
        boolean enableWithNodeTypeSelected;
        if (this.nodeTypeViewer == null || this.nodeTypeViewer.getTable().isDisposed()) {
            return;
        }
        boolean cndWritable = !this.getCndEditor().isReadOnly();
        boolean bl = enableWithNodeTypeSelected = cndWritable && this.getSelectedNodeType() != null;
        if (this.addNamespace.isEnabled() != cndWritable) {
            this.addNamespace.setEnabled(cndWritable);
        }
        if (this.namespaceViewer.getTable().isEnabled() != cndWritable) {
            this.namespaceViewer.getTable().setEnabled(cndWritable);
        }
        boolean selected = this.getSelectedNamespace() != null;
        boolean bl2 = enable2 = cndWritable && selected;
        if (this.editNamespace.isEnabled() != enable2) {
            this.editNamespace.setEnabled(enable2);
        }
        if (this.deleteNamespace.isEnabled() != enable2) {
            this.deleteNamespace.setEnabled(enable2);
        }
        if (this.copyNamespace.isEnabled() != selected) {
            this.copyNamespace.setEnabled(selected);
        }
        if (cndWritable) {
            boolean clipboardHasNamespace = this.clipboard.hasContents(NamespaceMappingTransfer.get());
            if (this.pasteNamespace.isEnabled() != clipboardHasNamespace) {
                this.pasteNamespace.setEnabled(clipboardHasNamespace);
            }
        } else if (this.pasteNamespace.isEnabled()) {
            this.pasteNamespace.setEnabled(false);
        }
        if (this.addNodeType.isEnabled() != cndWritable) {
            this.addNodeType.setEnabled(cndWritable);
        }
        if (this.nodeTypeViewer.getTable().isEnabled() != cndWritable) {
            this.nodeTypeViewer.getTable().setEnabled(cndWritable);
        }
        if (this.copyNodeType.isEnabled() != enableWithNodeTypeSelected) {
            this.copyNodeType.setEnabled(enableWithNodeTypeSelected);
        }
        if (this.deleteNodeType.isEnabled() != enableWithNodeTypeSelected) {
            this.deleteNodeType.setEnabled(enableWithNodeTypeSelected);
        }
        if (cndWritable) {
            boolean clipboardHasNodeType = this.clipboard.hasContents(NodeTypeDefinitionTransfer.get());
            if (this.pasteNodeType.isEnabled() != clipboardHasNodeType) {
                this.pasteNodeType.setEnabled(clipboardHasNodeType);
            }
        } else if (this.pasteNodeType.isEnabled()) {
            this.pasteNodeType.setEnabled(false);
        }
        if (this.nameEditor.isEnabled() != enableWithNodeTypeSelected) {
            this.nameEditor.setEnabled(enableWithNodeTypeSelected);
        }
        if (this.btnAbstract.isEnabled() != enableWithNodeTypeSelected) {
            this.btnAbstract.setEnabled(enableWithNodeTypeSelected);
        }
        if (this.btnMixin.isEnabled() != enableWithNodeTypeSelected) {
            this.btnMixin.setEnabled(enableWithNodeTypeSelected);
        }
        if (this.btnOrderable.isEnabled() != enableWithNodeTypeSelected) {
            this.btnOrderable.setEnabled(enableWithNodeTypeSelected);
        }
        if (this.btnQueryable.isEnabled() != enableWithNodeTypeSelected) {
            this.btnQueryable.setEnabled(enableWithNodeTypeSelected);
        }
        if (this.cbxPrimaryItem.isEnabled() != enableWithNodeTypeSelected) {
            this.cbxPrimaryItem.setEnabled(enableWithNodeTypeSelected);
        }
        if (this.addSuperType.isEnabled() != enableWithNodeTypeSelected) {
            this.addSuperType.setEnabled(enableWithNodeTypeSelected);
        }
        if (this.superTypesViewer.getTable().isEnabled() != enableWithNodeTypeSelected) {
            this.superTypesViewer.getTable().setEnabled(enableWithNodeTypeSelected);
        }
        boolean bl3 = enable = enableWithNodeTypeSelected && this.getSelectedSuperType() != null;
        if (this.editSuperType.isEnabled() != enable) {
            this.editSuperType.setEnabled(enable);
        }
        if (this.deleteSuperType.isEnabled() != enable) {
            this.deleteSuperType.setEnabled(enable);
        }
        if (this.addProperty.isEnabled() != enableWithNodeTypeSelected) {
            this.addProperty.setEnabled(enableWithNodeTypeSelected);
        }
        if (this.propertyViewer.getTable().isEnabled() != enableWithNodeTypeSelected) {
            this.propertyViewer.getTable().setEnabled(enableWithNodeTypeSelected);
        }
        boolean enableWithPropertySelected = enableWithNodeTypeSelected && this.getSelectedProperty() != null;
        boolean enableInheritedProperty = enableWithPropertySelected && !this.getSelectedNodeType().hasDeclaredPropertyDefinition(this.getSelectedProperty().getName());
        boolean bl4 = enableDeclaredProperty = enableWithPropertySelected && this.getSelectedNodeType().hasDeclaredPropertyDefinition(this.getSelectedProperty().getName());
        if (this.editProperty.isEnabled() != enableDeclaredProperty) {
            this.editProperty.setEnabled(enableDeclaredProperty);
        }
        if (this.copyProperty.isEnabled() != enableDeclaredProperty) {
            this.copyProperty.setEnabled(enableDeclaredProperty);
        }
        if (this.deleteProperty.isEnabled() != enableDeclaredProperty) {
            this.deleteProperty.setEnabled(enableDeclaredProperty);
        }
        if (cndWritable) {
            boolean clipboardHasProperty = this.clipboard.hasContents(PropertyDefinitionTransfer.get());
            if (this.pasteProperty.isEnabled() != clipboardHasProperty) {
                this.pasteProperty.setEnabled(clipboardHasProperty);
            }
        } else if (this.pasteProperty.isEnabled()) {
            this.pasteProperty.setEnabled(false);
        }
        if (this.openPropertyDeclaringNodeType.isEnabled() != enableInheritedProperty) {
            this.openPropertyDeclaringNodeType.setEnabled(enableInheritedProperty);
        }
        if (this.addChildNode.isEnabled() != enableWithNodeTypeSelected) {
            this.addChildNode.setEnabled(enableWithNodeTypeSelected);
        }
        if (this.childNodeViewer.getTable().isEnabled() != enableWithNodeTypeSelected) {
            this.childNodeViewer.getTable().setEnabled(enableWithNodeTypeSelected);
        }
        boolean bl5 = enable = enableWithNodeTypeSelected && this.getSelectedChildNode() != null;
        if (enable && this.shouldShowInheritedChildNodes()) {
            enable = this.getSelectedNodeType().hasDeclaredChildNodeDefinition(this.getSelectedChildNode().getName());
        }
        if (this.editChildNode.isEnabled() != enable) {
            this.editChildNode.setEnabled(enable);
        }
        if (this.copyChildNode.isEnabled() != enable) {
            this.copyChildNode.setEnabled(enable);
        }
        if (this.deleteChildNode.isEnabled() != enable) {
            this.deleteChildNode.setEnabled(enable);
        }
        if (cndWritable) {
            boolean clipboardHasChildNode = this.clipboard.hasContents(ChildNodeDefinitionTransfer.get());
            if (this.pasteChildNode.isEnabled() != clipboardHasChildNode) {
                this.pasteChildNode.setEnabled(clipboardHasChildNode);
            }
        } else if (this.pasteChildNode.isEnabled()) {
            this.pasteChildNode.setEnabled(false);
        }
    }

    void updateStatusBar() {
        CndEditorActionBarContributor contributor = this.getActionContributor();
        contributor.setNodeType(this.selectedNodeType);
        contributor.setNodeTypeStatusMenuManager(this.nodeTypeStatusBarMenuManager);
        contributor.setProperty(this.getSelectedProperty());
        contributor.setPropertyStatusMenuManager(this.propertyStatusBarMenuManager);
        contributor.setChildNode(this.getSelectedChildNode());
        contributor.setChildNodeStatusMenuManager(this.childNodeStatusBarMenuManager);
        contributor.getActionBars().getStatusLineManager().update(true);
    }

    private void updateMessage(ValidationStatus status, Control control) {
        IMessageManager msgMgr = this.getCndEditor().getMessageManager();
        msgMgr.setAutoUpdate(false);
        msgMgr.removeMessages(control);
        this.processStatus(msgMgr, status, control);
        msgMgr.setAutoUpdate(true);
    }

    private void validateAttributes() {
        this.validateNodeTypes();
    }

    private void validateChildNodes() {
        this.validateNodeTypes();
    }

    private void validateName() {
        this.validateNodeTypes();
    }

    void validateNamespaces() {
        MultiValidationStatus status = CndValidator.validateNamespaceMappings((Collection)this.getCnd().getNamespaceMappings());
        this.updateMessage((ValidationStatus)status, this.namespaceSection.getDescriptionControl());
    }

    void validateNodeTypes() {
        MultiValidationStatus status = new MultiValidationStatus();
        CndValidator.validateNodeTypeDefinitions((CompactNodeTypeDefinition)this.getCnd(), (boolean)true, (MultiValidationStatus)status);
        this.updateMessage((ValidationStatus)status, this.nodeTypeSection.getDescriptionControl());
    }

    private void validateProperties() {
        this.validateNodeTypes();
    }

    private void validateSuperTypes() {
        this.validateNodeTypes();
    }

    static interface ChildNodeColumnIndexes {
        public static final int ATTRIBUTES = 3;
        public static final int COMMENTS = 5;
        public static final int DECLARING_NODE_TYPE = 4;
        public static final int DEFAULT_TYPE = 2;
        public static final int NAME = 0;
        public static final int REQUIRED_TYPES = 1;
    }

    class CommentLabelProvider
    extends CheckBoxLabelProvider {
        public CommentLabelProvider(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean isChecked(Object element) {
            CommentedCndElement cndElement = (CommentedCndElement)element;
            return !Utils.isEmpty((String)cndElement.getComment());
        }
    }

    private static interface MementoKeys {
        public static final String CHILD_NODE_SECTION_EXPANDED = "CHILD_NODE_SECTION_EXPANDED";
        public static final String NAMESPACE_SECTION_EXPANDED = "NAMESPACE_SECTION_EXPANDED";
        public static final String NODE_TYPE_FILTER = "NODE_TYPE_FILTER";
        public static final String PROPERTY_SECTION_EXPANDED = "PROPERTY_SECTION_EXPANDED";
        public static final String SELECTED_NODE_TYPE = "SELECTED_NODE_TYPE";
    }

    static interface NamespaceColumnIndexes {
        public static final int COMMENT = 2;
        public static final int PREFIX = 0;
        public static final int URI = 1;
    }

    static interface PropertyColumnIndexes {
        public static final int ATTRIBUTES = 3;
        public static final int COMMENT = 6;
        public static final int CONSTRAINTS = 5;
        public static final int DECLARING_NODE_TYPE = 4;
        public static final int DEFAULT_VALUES = 2;
        public static final int NAME = 0;
        public static final int TYPE = 1;
    }
}

