/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.dnd;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.List;
import org.jboss.tools.modeshape.jcr.ItemOwnerProvider;
import org.jboss.tools.modeshape.jcr.JcrModelObject;
import org.jboss.tools.modeshape.jcr.PropertyDefinition;
import org.jboss.tools.modeshape.jcr.ui.dnd.JcrTransfer;
import org.jboss.tools.modeshape.ui.UiUtils;

public final class PropertyDefinitionTransfer
extends JcrTransfer {
    private static PropertyDefinitionTransfer _instance;

    public static PropertyDefinitionTransfer get() {
        if (_instance == null) {
            _instance = new PropertyDefinitionTransfer();
        }
        return _instance;
    }

    private PropertyDefinitionTransfer() {
        super(PropertyDefinitionTransfer.class);
    }

    @Override
    protected Class<? extends JcrModelObject> getJcrModelObjectClass() {
        return PropertyDefinition.class;
    }

    @Override
    protected JcrModelObject readFromStream(DataInputStream inStream) throws Exception {
        int defaultValuesCount;
        String ownerQualifiedName = inStream.readUTF();
        PropertyDefinition propDefn = new PropertyDefinition((ItemOwnerProvider)new JcrTransfer.OwnerProvider(ownerQualifiedName));
        propDefn.setName(inStream.readUTF());
        propDefn.setComment(inStream.readUTF());
        propDefn.setAutoCreated(inStream.readBoolean());
        propDefn.setMandatory(inStream.readBoolean());
        propDefn.setMultiple(inStream.readBoolean());
        propDefn.setFullTextSearchable(inStream.readBoolean());
        propDefn.setQueryOrderable(inStream.readBoolean());
        propDefn.setProtected(inStream.readBoolean());
        propDefn.setOnParentVersion(inStream.readInt());
        int queryOpsCount = inStream.readInt();
        if (queryOpsCount != 0) {
            String[] queryOps = new String[queryOpsCount];
            int queryOpIndex = 0;
            while (queryOpIndex < queryOpsCount) {
                queryOps[queryOpIndex] = inStream.readUTF();
                ++queryOpIndex;
            }
            propDefn.setAvailableQueryOperators(queryOps);
        }
        if ((defaultValuesCount = inStream.readInt()) != 0) {
            int defaultValueIndex = 0;
            while (defaultValueIndex < defaultValuesCount) {
                propDefn.addDefaultValue(inStream.readUTF());
                ++defaultValueIndex;
            }
        }
        propDefn.setRequiredType(inStream.readInt());
        int valueConstraintsCount = inStream.readInt();
        if (valueConstraintsCount != 0) {
            int valueConstraintIndex = 0;
            while (valueConstraintIndex < valueConstraintsCount) {
                propDefn.addValueConstraint(inStream.readUTF());
                ++valueConstraintIndex;
            }
        }
        return propDefn;
    }

    @Override
    protected void writeToStream(JcrModelObject jcrModelObject, DataOutputStream outStream) throws Exception {
        int n;
        String[] stringArray;
        assert (jcrModelObject instanceof PropertyDefinition);
        PropertyDefinition propDefn = (PropertyDefinition)jcrModelObject;
        outStream.writeUTF(propDefn.getQualifiedName().get());
        outStream.writeUTF(UiUtils.ensureNotNull((String)propDefn.getName()));
        outStream.writeUTF(UiUtils.ensureNotNull((String)propDefn.getComment()));
        outStream.writeBoolean(propDefn.isAutoCreated());
        outStream.writeBoolean(propDefn.isMandatory());
        outStream.writeBoolean(propDefn.isMultiple());
        outStream.writeBoolean(propDefn.isFullTextSearchable());
        outStream.writeBoolean(propDefn.isQueryOrderable());
        outStream.writeBoolean(propDefn.isProtected());
        outStream.writeInt(propDefn.getOnParentVersion());
        String[] queryOps = propDefn.getAvailableQueryOperators();
        if (queryOps == null || queryOps.length == 0) {
            outStream.writeInt(0);
        } else {
            outStream.writeInt(queryOps.length);
            stringArray = queryOps;
            n = queryOps.length;
            int n2 = 0;
            while (n2 < n) {
                String queryOp = stringArray[n2];
                outStream.writeUTF(queryOp);
                ++n2;
            }
        }
        List defaultValues = propDefn.getDefaultValuesAsStrings();
        if (defaultValues.isEmpty()) {
            outStream.writeInt(0);
        } else {
            int length = defaultValues.size();
            outStream.writeInt(length);
            for (String defaultValue : defaultValues) {
                outStream.writeUTF(defaultValue);
            }
        }
        outStream.writeInt(propDefn.getRequiredType());
        String[] valueConstraints = propDefn.getValueConstraints();
        if (valueConstraints == null || valueConstraints.length == 0) {
            outStream.writeInt(0);
        } else {
            outStream.writeInt(valueConstraints.length);
            stringArray = valueConstraints;
            n = valueConstraints.length;
            int n3 = 0;
            while (n3 < n) {
                String valueConstraint = stringArray[n3];
                outStream.writeUTF(valueConstraint);
                ++n3;
            }
        }
    }
}

