/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.UniqueConstraint;
import org.teiid.designer.metamodels.relational.util.RelationalUtil;
import org.teiid.designer.relational.RelationalConstants;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalForeignKey;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.ui.Messages;
import org.teiid.designer.relational.ui.UiPlugin;
import org.teiid.designer.ui.common.UILabelUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class EditForeignKeyDialog
extends TitleAreaDialog {
    private static final String EMPTY_STRING = "";
    private final String CREATE_TITLE = Messages.createForeignKeyTitle;
    private final String EDIT_TITLE = Messages.editForeignKeyTitle;
    private List<String> MULTIPLICITY_LIST;
    RelationalForeignKey originalFK;
    RelationalForeignKey editedFK;
    RelationalTable theTable;
    IFile theModelFile;
    String selectedTableName;
    String selectedKeyOrConstraint;
    TableViewer keyViewer;
    TableViewer theColumnDataViewer;
    Combo uniqueKeyMultiCombo;
    Combo foreignKeyMultiCombo;
    Button allowJoinButton;
    Set<RelationalColumn> selectedColumns = new HashSet<RelationalColumn>();
    boolean isEdit;
    boolean creatingContents = false;
    boolean processingChecks = false;

    public EditForeignKeyDialog(Shell parent, IFile theModelFile, RelationalTable theTable, RelationalForeignKey foreignKey, boolean isEdit) {
        super(parent);
        this.theModelFile = theModelFile;
        this.theTable = theTable;
        this.isEdit = isEdit;
        boolean reallyIsEdit = isEdit;
        this.originalFK = foreignKey;
        if (reallyIsEdit) {
            this.editedFK = this.originalFK.clone();
        }
        if (!reallyIsEdit) {
            this.editedFK = foreignKey;
        }
        this.MULTIPLICITY_LIST = new ArrayList<String>();
        String[] stringArray = RelationalConstants.MULTIPLICITY.AS_ARRAY;
        int n = RelationalConstants.MULTIPLICITY.AS_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            this.MULTIPLICITY_LIST.add(str);
            ++n2;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.isEdit) {
            shell.setText(this.EDIT_TITLE);
        } else {
            shell.setText(this.CREATE_TITLE);
        }
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        int n;
        this.creatingContents = true;
        if (this.isEdit) {
            this.setTitle(this.EDIT_TITLE);
        } else {
            this.setTitle(this.CREATE_TITLE);
        }
        Composite dialogComposite = (Composite)super.createDialogArea(parent);
        Composite composite = WidgetFactory.createPanel((Composite)dialogComposite);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 500;
        composite.setLayoutData((Object)gridData);
        Label label = new Label(composite, 131072);
        label.setText(UILabelUtil.getLabel((int)14));
        label.setLayoutData((Object)new GridData());
        final Text fkNameText = new Text(composite, 2052);
        fkNameText.setForeground(Display.getCurrent().getSystemColor(10));
        fkNameText.setLayoutData((Object)new GridData(768));
        fkNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = fkNameText.getText();
                if (value == null) {
                    value = EditForeignKeyDialog.EMPTY_STRING;
                }
                EditForeignKeyDialog.this.editedFK.setName(value);
                EditForeignKeyDialog.this.validate();
            }
        });
        label = new Label(composite, 131072);
        label.setText(Messages.nameInSourceLabel);
        label.setLayoutData((Object)new GridData());
        final Text fkNISText = new Text(composite, 2052);
        fkNISText.setForeground(Display.getCurrent().getSystemColor(10));
        fkNISText.setLayoutData((Object)new GridData(768));
        fkNISText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = fkNISText.getText();
                if (value == null) {
                    value = EditForeignKeyDialog.EMPTY_STRING;
                }
                EditForeignKeyDialog.this.editedFK.setNameInSource(value);
                EditForeignKeyDialog.this.validate();
            }
        });
        WidgetFactory.createLabel((Composite)composite, (String)Messages.foreignKeyMultiplicity);
        LabelProvider multipicityLP = new LabelProvider(){

            public String getText(Object source) {
                return (String)source;
            }

            public Image getImage(Object source) {
                return null;
            }
        };
        this.foreignKeyMultiCombo = WidgetFactory.createCombo((Composite)composite, (int)8, (int)832, (List)Collections.EMPTY_LIST, (Object)this.editedFK.getForeignKeyMultiplicity(), (ILabelProvider)multipicityLP, (boolean)true);
        this.foreignKeyMultiCombo.setItems(RelationalConstants.MULTIPLICITY.AS_ARRAY);
        this.foreignKeyMultiCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (EditForeignKeyDialog.this.foreignKeyMultiCombo.getSelectionIndex() > -1) {
                    EditForeignKeyDialog.this.editedFK.setForeignKeyMultiplicity(EditForeignKeyDialog.this.foreignKeyMultiCombo.getItem(EditForeignKeyDialog.this.foreignKeyMultiCombo.getSelectionIndex()));
                    EditForeignKeyDialog.this.validate();
                }
            }
        });
        WidgetUtil.setComboItems((Combo)this.foreignKeyMultiCombo, this.MULTIPLICITY_LIST, (ILabelProvider)multipicityLP, (boolean)true);
        WidgetFactory.createLabel((Composite)composite, (String)Messages.uniqueKeyMultiplicity);
        this.uniqueKeyMultiCombo = WidgetFactory.createCombo((Composite)composite, (int)8, (int)832, (List)Collections.EMPTY_LIST, (Object)this.editedFK.getPrimaryKeyMultiplicity(), (ILabelProvider)multipicityLP, (boolean)true);
        this.uniqueKeyMultiCombo.setItems(RelationalConstants.MULTIPLICITY.AS_ARRAY);
        this.uniqueKeyMultiCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (EditForeignKeyDialog.this.uniqueKeyMultiCombo.getSelectionIndex() > -1) {
                    EditForeignKeyDialog.this.editedFK.setPrimaryKeyMultiplicity(EditForeignKeyDialog.this.uniqueKeyMultiCombo.getItem(EditForeignKeyDialog.this.uniqueKeyMultiCombo.getSelectionIndex()));
                    EditForeignKeyDialog.this.validate();
                }
            }
        });
        WidgetUtil.setComboItems((Combo)this.uniqueKeyMultiCombo, this.MULTIPLICITY_LIST, (ILabelProvider)multipicityLP, (boolean)true);
        this.allowJoinButton = new Button(composite, 32);
        this.allowJoinButton.setText(Messages.allowJoinLabel);
        this.allowJoinButton.setToolTipText(Messages.allowJoinTooltip);
        this.allowJoinButton.setSelection(this.editedFK.isAllowJoin());
        this.allowJoinButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditForeignKeyDialog.this.editedFK.setAllowJoin(EditForeignKeyDialog.this.allowJoinButton.getSelection());
                EditForeignKeyDialog.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group keysGroup = WidgetFactory.createGroup((Composite)dialogComposite, (String)Messages.selectPrimaryKeyOrUniqueConstraint, (int)0, (int)2, (int)2);
        GridData gd = new GridData(1808);
        gd.heightHint = 140;
        gd.widthHint = 500;
        keysGroup.setLayoutData((Object)gd);
        Table table = new Table((Composite)keysGroup, 2852);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        table.setLayout((Layout)new TableLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.keyViewer = new TableViewer(table);
        gd = new GridData(1808);
        gd.heightHint = 160;
        gd.horizontalSpan = 2;
        this.keyViewer.getControl().setLayoutData((Object)gd);
        this.keyViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return true;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray(new Object[0]);
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }
        });
        this.keyViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                String name = EditForeignKeyDialog.EMPTY_STRING;
                if (element instanceof UniqueConstraint) {
                    name = String.valueOf(name) + ((UniqueConstraint)element).getTable().getName();
                    name = String.valueOf(name) + ": " + ((UniqueConstraint)element).getName();
                } else {
                    name = String.valueOf(name) + ((PrimaryKey)element).getTable().getName();
                    name = String.valueOf(name) + ": " + ((PrimaryKey)element).getName();
                }
                return name;
            }

            public Image getImage(Object element) {
                if (element instanceof UniqueConstraint) {
                    return UiPlugin.getDefault().getImage("icons/full/obj16/unique-constraint.png");
                }
                if (element instanceof PrimaryKey) {
                    return UiPlugin.getDefault().getImage("icons/full/obj16/primary-key.png");
                }
                return null;
            }
        });
        this.keyViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int n;
                TableItem tableItem;
                boolean wasChecked;
                if (EditForeignKeyDialog.this.processingChecks) {
                    return;
                }
                EditForeignKeyDialog.this.processingChecks = true;
                if (e.detail == 32 && (wasChecked = (tableItem = (TableItem)e.item).getChecked())) {
                    TableItem[] tableItemArray = EditForeignKeyDialog.this.keyViewer.getTable().getItems();
                    n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item != tableItem) {
                            item.setChecked(false);
                        }
                        ++n2;
                    }
                }
                String tblName = EditForeignKeyDialog.EMPTY_STRING;
                String keyName = EditForeignKeyDialog.EMPTY_STRING;
                boolean foundCheckedItem = false;
                TableItem[] tableItemArray = EditForeignKeyDialog.this.keyViewer.getTable().getItems();
                int n3 = tableItemArray.length;
                n = 0;
                while (n < n3) {
                    TableItem item = tableItemArray[n];
                    if (item.getChecked()) {
                        foundCheckedItem = true;
                        EObject selectedKey = (EObject)item.getData();
                        if (selectedKey instanceof UniqueConstraint) {
                            tblName = ((UniqueConstraint)selectedKey).getTable().getName();
                            keyName = ((UniqueConstraint)selectedKey).getName();
                        } else {
                            tblName = ((PrimaryKey)selectedKey).getTable().getName();
                            keyName = ((PrimaryKey)selectedKey).getName();
                        }
                        EditForeignKeyDialog.this.editedFK.setUniqueKeyName(keyName);
                        EditForeignKeyDialog.this.editedFK.setUniqueKeyTableName(tblName);
                    }
                    ++n;
                }
                if (!foundCheckedItem) {
                    EditForeignKeyDialog.this.editedFK.setUniqueKeyName(keyName);
                    EditForeignKeyDialog.this.editedFK.setUniqueKeyTableName(tblName);
                }
                EditForeignKeyDialog.this.processingChecks = false;
                EditForeignKeyDialog.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ModelResource mr = ModelUtilities.getModelResource((Object)this.theModelFile);
        ArrayList keys = new ArrayList();
        if (mr != null) {
            try {
                keys.addAll(RelationalUtil.findUniqueKeys((Object)mr.getEmfResource()));
            }
            catch (ModelWorkspaceException ex) {
                ex.printStackTrace();
            }
        }
        this.keyViewer.setInput(keys);
        Group theColumnsGroup = WidgetFactory.createGroup((Composite)dialogComposite, (String)Messages.selectColumnReferencesToFK, (int)0, (int)1, (int)1);
        gd = new GridData(1808);
        gd.heightHint = 120;
        gd.widthHint = 500;
        theColumnsGroup.setLayoutData((Object)gd);
        Table tableWidget = new Table((Composite)theColumnsGroup, 2850);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        table.setLayout((Layout)new TableLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.theColumnDataViewer = new TableViewer(tableWidget);
        gd = new GridData(1808);
        gd.heightHint = 160;
        gd.horizontalSpan = 2;
        this.theColumnDataViewer.getControl().setLayoutData((Object)gd);
        this.theColumnDataViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return !EditForeignKeyDialog.this.theTable.getColumns().isEmpty();
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof RelationalTable) {
                    return EditForeignKeyDialog.this.theTable.getColumns().toArray(new Object[0]);
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }
        });
        this.theColumnDataViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditForeignKeyDialog.this.editedFK.getColumns().clear();
                TableItem[] tableItemArray = EditForeignKeyDialog.this.theColumnDataViewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        EditForeignKeyDialog.this.editedFK.addColumn((RelationalColumn)item.getData());
                    }
                    ++n2;
                }
                EditForeignKeyDialog.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.theColumnDataViewer.setLabelProvider((IBaseLabelProvider)new ColumnDataLabelProvider(0));
        this.theColumnDataViewer.setInput((Object)this.theTable);
        for (RelationalColumn col : this.editedFK.getColumns()) {
            TableItem[] tableItemArray = this.theColumnDataViewer.getTable().getItems();
            n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getData() == col) {
                    item.setChecked(true);
                }
                ++n2;
            }
        }
        if (this.editedFK.getUniqueKeyName() != null && this.editedFK.getUniqueKeyTableName() != null) {
            String name = EMPTY_STRING;
            name = String.valueOf(name) + this.editedFK.getUniqueKeyTableName();
            name = String.valueOf(name) + ": " + this.editedFK.getUniqueKeyName();
            int index = 0;
            int selectedIndex = -1;
            TableItem[] tableItemArray = this.keyViewer.getTable().getItems();
            int n3 = tableItemArray.length;
            n = 0;
            while (n < n3) {
                TableItem item = tableItemArray[n];
                if (item.getData() instanceof EObject) {
                    EObject value = (EObject)item.getData();
                    String keyName = EMPTY_STRING;
                    if (value instanceof UniqueConstraint) {
                        keyName = String.valueOf(keyName) + ((UniqueConstraint)value).getTable().getName();
                        keyName = String.valueOf(keyName) + ": " + ((UniqueConstraint)value).getName();
                    } else {
                        keyName = String.valueOf(keyName) + ((PrimaryKey)value).getTable().getName();
                        keyName = String.valueOf(keyName) + ": " + ((PrimaryKey)value).getName();
                    }
                    if (keyName.equalsIgnoreCase(name)) {
                        selectedIndex = index;
                        item.setChecked(true);
                    }
                }
                if (selectedIndex > -1) break;
                ++index;
                ++n;
            }
            if (selectedIndex > -1) {
                this.keyViewer.getTable().select(selectedIndex);
            }
        }
        this.setMessage(Messages.newForeignKeyMessage);
        if (this.editedFK.getName() != null) {
            fkNameText.setText(this.editedFK.getName());
        }
        if (this.editedFK.getNameInSource() != null) {
            fkNISText.setText(this.editedFK.getNameInSource());
        }
        if (this.editedFK.getForeignKeyMultiplicity() != null) {
            WidgetUtil.setComboText((Combo)this.foreignKeyMultiCombo, (Object)this.editedFK.getForeignKeyMultiplicity(), (ILabelProvider)multipicityLP);
        }
        if (this.editedFK.getPrimaryKeyMultiplicity() != null) {
            WidgetUtil.setComboText((Combo)this.uniqueKeyMultiCombo, (Object)this.editedFK.getPrimaryKeyMultiplicity(), (ILabelProvider)multipicityLP);
        }
        this.creatingContents = false;
        return composite;
    }

    private void validate() {
        if (this.creatingContents) {
            return;
        }
        this.editedFK.validate();
        boolean enable = true;
        this.setMessage(Messages.newForeignKeyMessage);
        if (this.editedFK.getName() == null || this.editedFK.getName().trim().length() == 0) {
            enable = false;
            this.setErrorMessage(this.editedFK.getStatus().getMessage());
        } else if (this.editedFK.getStatus().getSeverity() < 4) {
            this.setErrorMessage(null);
        } else if (this.editedFK.getStatus().getSeverity() == 2) {
            this.setMessage(this.editedFK.getStatus().getMessage(), 2);
        } else if (this.editedFK.getStatus().getSeverity() == 4) {
            this.setErrorMessage(this.editedFK.getStatus().getMessage());
        }
        this.getButton(0).setEnabled(enable);
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(true);
    }

    protected void okPressed() {
        if (this.isEdit) {
            this.originalFK.inject((RelationalReference)this.editedFK);
        }
        super.okPressed();
    }

    public String getTableName() {
        return this.selectedTableName;
    }

    public String getKeyOrConstraintName() {
        return this.selectedKeyOrConstraint;
    }

    class ColumnDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ColumnDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof RelationalColumn) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((RelationalColumn)element).getName();
                    }
                    case 1: {
                        return ((RelationalColumn)element).getDatatype();
                    }
                    case 2: {
                        return Integer.toString(((RelationalColumn)element).getLength());
                    }
                }
            }
            return EditForeignKeyDialog.EMPTY_STRING;
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/column.png");
            }
            return null;
        }
    }
}

