/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.edit;

import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.model.RelationalView;
import org.teiid.designer.relational.ui.Messages;
import org.teiid.designer.relational.ui.edit.RelationalEditorPanel;
import org.teiid.designer.relational.ui.edit.RelationalIndexEditorPanel;
import org.teiid.designer.relational.ui.edit.RelationalProcedureEditorPanel;
import org.teiid.designer.relational.ui.edit.RelationalTableEditorPanel;
import org.teiid.designer.relational.ui.editor.EditRelationalObjectDialogModel;
import org.teiid.designer.ui.common.eventsupport.IDialogStatusListener;

public class RelationalDialogModel
extends EditRelationalObjectDialogModel {
    public RelationalDialogModel(RelationalReference relationalObject, IFile modelFile) {
        super(relationalObject, modelFile);
    }

    @Override
    public RelationalEditorPanel getEditorPanel(IDialogStatusListener statusListener, Composite parent) {
        if (this.relationalObject instanceof RelationalTable) {
            return new RelationalTableEditorPanel(parent, this, statusListener);
        }
        if (this.relationalObject instanceof RelationalProcedure) {
            return new RelationalProcedureEditorPanel(parent, this, statusListener);
        }
        if (this.relationalObject instanceof RelationalIndex) {
            return new RelationalIndexEditorPanel(parent, this, statusListener);
        }
        return null;
    }

    @Override
    public String getDialogTitle() {
        if (this.relationalObject instanceof RelationalView) {
            return Messages.createRelationalViewTitle;
        }
        if (this.relationalObject instanceof RelationalTable) {
            return Messages.createRelationalTableTitle;
        }
        if (this.relationalObject instanceof RelationalProcedure) {
            RelationalProcedure procedure = (RelationalProcedure)this.relationalObject;
            if (procedure.isSourceFunction()) {
                return Messages.createRelationalSourceFunctionTitle;
            }
            if (procedure.isFunction()) {
                return Messages.createRelationalUserDefinedFunctionTitle;
            }
            if (procedure.isNativeQueryProcedure()) {
                return Messages.createRelationalNativeQueryProcedureTitle;
            }
            return Messages.createRelationalProcedureTitle;
        }
        if (this.relationalObject instanceof RelationalIndex) {
            return Messages.createRelationalIndexTitle;
        }
        return NLS.bind((String)Messages.unsupportedObjectType, (Object)this.relationalObject.getClass().toString());
    }

    @Override
    public String getHelpText() {
        if (this.relationalObject instanceof RelationalView) {
            return Messages.createRelationalViewHelpText;
        }
        if (this.relationalObject instanceof RelationalTable) {
            return Messages.createRelationalTableHelpText;
        }
        if (this.relationalObject instanceof RelationalProcedure) {
            RelationalProcedure procedure = (RelationalProcedure)this.relationalObject;
            if (procedure.isSourceFunction()) {
                return Messages.createRelationalSourceFunctionHelpText;
            }
            if (procedure.isFunction()) {
                return Messages.createRelationalUserDefinedFunctionHelpText;
            }
            if (procedure.isNativeQueryProcedure()) {
                return Messages.createRelationalNativeQueryProcedureHelpText;
            }
            return Messages.createRelationalProcedureHelpText;
        }
        if (this.relationalObject instanceof RelationalIndex) {
            return Messages.createRelationalIndexHelpText;
        }
        return NLS.bind((String)Messages.unsupportedObjectType, (Object)this.relationalObject.getClass().toString());
    }
}

