/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.edit;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.ui.Messages;
import org.teiid.designer.relational.ui.editor.EditRelationalObjectDialogModel;
import org.teiid.designer.relational.ui.util.RelationalUiUtil;
import org.teiid.designer.ui.common.UILabelUtil;
import org.teiid.designer.ui.common.eventsupport.IDialogStatusListener;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;

public abstract class RelationalEditorPanel {
    protected static final String EMPTY_STRING = "";
    protected final EditRelationalObjectDialogModel dialogModel;
    protected IStatus currentStatus;
    protected IDialogStatusListener statusListener;
    private boolean canFinish;
    private Text modelNameText;
    private Text nameText;
    private Text nameInSourceText;
    private StyledTextEditor descriptionTextEditor;
    private boolean synchronizing = false;
    private Shell shell;

    public RelationalEditorPanel(Composite parent, EditRelationalObjectDialogModel dialogModel, IDialogStatusListener statusListener) {
        this.dialogModel = dialogModel;
        this.statusListener = statusListener;
        this.createPanel(parent);
        this.shell = parent.getShell();
        this.synchronizeUI();
        this.nameText.setFocus();
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected Composite createNameGroup(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)2, (int)2);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false);
        GridDataFactory.fillDefaults().grab(true, false).minSize(-1, 120).applyTo((Control)thePanel);
        Label label = new Label(thePanel, 0);
        label.setText(Messages.modelFileLabel);
        GridDataFactory.fillDefaults().align(16384, 1).applyTo((Control)label);
        this.modelNameText = new Text(thePanel, 2052);
        this.modelNameText.setBackground(Display.getCurrent().getSystemColor(19));
        this.modelNameText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.modelNameText);
        if (this.getModelFile() != null) {
            this.modelNameText.setText(this.getModelFile().getName());
        }
        label = new Label(thePanel, 0);
        label.setText(UILabelUtil.getLabel((int)14));
        this.nameText = new Text(thePanel, 2052);
        this.nameText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameText);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = RelationalEditorPanel.this.nameText.getText();
                if (value == null) {
                    value = RelationalEditorPanel.EMPTY_STRING;
                }
                RelationalEditorPanel.this.getRelationalReference().setName(value);
                RelationalEditorPanel.this.handleInfoChanged();
            }
        });
        label = new Label(thePanel, 0);
        label.setText(Messages.nameInSourceLabel);
        this.nameInSourceText = new Text(thePanel, 2052);
        this.nameInSourceText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameInSourceText);
        this.nameInSourceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = RelationalEditorPanel.this.nameInSourceText.getText();
                if (value == null) {
                    value = RelationalEditorPanel.EMPTY_STRING;
                }
                RelationalEditorPanel.this.getRelationalReference().setNameInSource(value);
                RelationalEditorPanel.this.handleInfoChanged();
            }
        });
        return thePanel;
    }

    protected void handleInfoChanged() {
        if (this.synchronizing) {
            return;
        }
        this.validate();
        this.synchronizeUI();
    }

    protected TabFolder createTabFolder(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 2176);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tabFolder);
        return tabFolder;
    }

    protected Composite createDescriptionPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)3);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        Group descGroup = WidgetFactory.createGroup((Composite)thePanel, (String)UILabelUtil.getLabel((int)7), (int)1808, (int)3);
        this.descriptionTextEditor = new StyledTextEditor((Composite)descGroup, 2882);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 40).minSize(-1, 30).applyTo((Control)this.descriptionTextEditor.getTextWidget());
        this.descriptionTextEditor.setText(EMPTY_STRING);
        this.descriptionTextEditor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RelationalEditorPanel.this.getRelationalReference().setDescription(RelationalEditorPanel.this.descriptionTextEditor.getText());
            }
        });
        return thePanel;
    }

    protected void createDescriptionTab(TabFolder folderParent) {
        Composite thePanel = this.createDescriptionPanel((Composite)folderParent);
        TabItem descriptionTab = new TabItem(folderParent, 0);
        descriptionTab.setControl((Control)thePanel);
        descriptionTab.setText(UILabelUtil.getLabel((int)7));
        descriptionTab.setImage(RelationalUiUtil.getDescriptionImage(Status.OK_STATUS));
    }

    protected abstract void createPanel(Composite var1);

    protected boolean isSynchronizing() {
        return this.synchronizing;
    }

    protected abstract void synchronizeExtendedUI();

    protected final void synchronizeUI() {
        if (this.synchronizing) {
            return;
        }
        this.synchronizing = true;
        if (this.getRelationalReference().getName() != null) {
            if (WidgetUtil.widgetValueChanged((Text)this.nameText, (String)this.getRelationalReference().getName())) {
                this.nameText.setText(this.getRelationalReference().getName());
            }
        } else if (WidgetUtil.widgetValueChanged((Text)this.nameText, (String)EMPTY_STRING)) {
            this.nameText.setText(EMPTY_STRING);
        }
        if (this.getRelationalReference().getNameInSource() != null) {
            if (WidgetUtil.widgetValueChanged((Text)this.nameInSourceText, (String)this.getRelationalReference().getNameInSource())) {
                this.nameInSourceText.setText(this.getRelationalReference().getNameInSource());
            }
        } else if (WidgetUtil.widgetValueChanged((Text)this.nameInSourceText, (String)EMPTY_STRING)) {
            this.nameInSourceText.setText(EMPTY_STRING);
        }
        if (this.descriptionTextEditor != null) {
            if (this.getRelationalReference().getDescription() != null) {
                if (!StringUtilities.equals((String)this.descriptionTextEditor.getText(), (String)this.getRelationalReference().getDescription())) {
                    this.descriptionTextEditor.setText(this.getRelationalReference().getDescription());
                }
            } else {
                this.descriptionTextEditor.setText(EMPTY_STRING);
            }
        }
        this.synchronizeExtendedUI();
        this.synchronizing = false;
    }

    protected void validate() {
    }

    protected void setStatus(IStatus status) {
        this.currentStatus = status;
        this.statusListener.notifyStatusChanged(this.currentStatus);
    }

    protected RelationalReference getRelationalReference() {
        return this.dialogModel.getRelationalObject();
    }

    protected IFile getModelFile() {
        return this.dialogModel.getModelFile();
    }

    protected final void setCanFinish(boolean value) {
        this.canFinish = value;
    }

    public boolean canFinish() {
        return this.canFinish;
    }
}

