/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.edit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.relational.RelationalConstants;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalModelFactory;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.ui.Messages;
import org.teiid.designer.relational.ui.UiPlugin;
import org.teiid.designer.relational.ui.edit.RelationalEditorPanel;
import org.teiid.designer.relational.ui.editor.EditRelationalObjectDialogModel;
import org.teiid.designer.relational.ui.util.RelationalUiUtil;
import org.teiid.designer.ui.common.UILabelUtil;
import org.teiid.designer.ui.common.eventsupport.IDialogStatusListener;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.SelectFromEObjectListDialog;

public class RelationalIndexEditorPanel
extends RelationalEditorPanel
implements RelationalConstants {
    private TabItem generalPropertiesTab;
    private TabItem referencedColumnsTab;
    private Button autoUpdateCB;
    private Button nullableCB;
    private Button uniqueCB;
    private Text filterConditionText;
    private Text tableReferenceText;
    private Button browseForTableButton;
    private TableViewerBuilder columnsViewer;

    public RelationalIndexEditorPanel(Composite parent, EditRelationalObjectDialogModel dialogModel, IDialogStatusListener statusListener) {
        super(parent, dialogModel, statusListener);
        this.synchronizeUI();
    }

    protected RelationalIndex getRelationalReference() {
        return (RelationalIndex)super.getRelationalReference();
    }

    @Override
    protected void createPanel(Composite parent) {
        this.createNameGroup(parent);
        TabFolder tabFolder = this.createTabFolder(parent);
        this.createReferencedColumnsTab(tabFolder);
        this.createPropertiestab(tabFolder);
        this.createDescriptionTab(tabFolder);
    }

    private void createPropertiestab(TabFolder folderParent) {
        Composite thePanel = this.createPropertiesPanel((Composite)folderParent);
        this.generalPropertiesTab = new TabItem(folderParent, 0);
        this.generalPropertiesTab.setControl((Control)thePanel);
        this.generalPropertiesTab.setText(UILabelUtil.getLabel((int)6));
        this.generalPropertiesTab.setImage(RelationalUiUtil.getRelationalImage(13, ModelType.PHYSICAL, Status.OK_STATUS));
    }

    private void createReferencedColumnsTab(TabFolder folderParent) {
        Composite thePanel = this.createReferencedColumnsPanel((Composite)folderParent);
        this.referencedColumnsTab = new TabItem(folderParent, 0);
        this.referencedColumnsTab.setControl((Control)thePanel);
        this.referencedColumnsTab.setText(Messages.referencedColumnsLabel);
        this.referencedColumnsTab.setImage(RelationalUiUtil.getRelationalImage(7, ModelType.PHYSICAL, Status.OK_STATUS));
    }

    @Override
    protected void synchronizeExtendedUI() {
        if (this.getRelationalReference().getFilterCondition() != null) {
            if (WidgetUtil.widgetValueChanged((Text)this.filterConditionText, (String)this.getRelationalReference().getFilterCondition())) {
                this.filterConditionText.setText(this.getRelationalReference().getFilterCondition());
            }
        } else if (WidgetUtil.widgetValueChanged((Text)this.filterConditionText, (String)"")) {
            this.filterConditionText.setText("");
        }
        if (WidgetUtil.widgetValueChanged((Button)this.autoUpdateCB, (boolean)this.getRelationalReference().isAutoUpdate())) {
            this.autoUpdateCB.setSelection(this.getRelationalReference().isAutoUpdate());
        }
        if (WidgetUtil.widgetValueChanged((Button)this.uniqueCB, (boolean)this.getRelationalReference().isUnique())) {
            this.uniqueCB.setSelection(this.getRelationalReference().isUnique());
        }
        if (WidgetUtil.widgetValueChanged((Button)this.nullableCB, (boolean)this.getRelationalReference().isNullable())) {
            this.nullableCB.setSelection(this.getRelationalReference().isNullable());
        }
        this.generalPropertiesTab.setImage(RelationalUiUtil.getRelationalImage(13, this.getRelationalReference().getModelType(), this.getRelationalReference().getStatus()));
    }

    private Composite createPropertiesPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)2);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().applyTo((Control)thePanel);
        this.autoUpdateCB = new Button(thePanel, 131104);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.autoUpdateCB);
        this.autoUpdateCB.setText(Messages.autoUpdateLabel);
        this.autoUpdateCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalIndexEditorPanel.this.getRelationalReference().setAutoUpdate(RelationalIndexEditorPanel.this.autoUpdateCB.getSelection());
                RelationalIndexEditorPanel.this.handleInfoChanged();
            }
        });
        this.nullableCB = new Button(thePanel, 131104);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.nullableCB);
        this.nullableCB.setText(Messages.nullableLabel);
        this.nullableCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalIndexEditorPanel.this.getRelationalReference().setNullable(RelationalIndexEditorPanel.this.nullableCB.getSelection());
                RelationalIndexEditorPanel.this.handleInfoChanged();
            }
        });
        this.uniqueCB = new Button(thePanel, 131104);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.uniqueCB);
        this.uniqueCB.setText(Messages.uniqueLabel);
        this.uniqueCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalIndexEditorPanel.this.getRelationalReference().setUnique(RelationalIndexEditorPanel.this.uniqueCB.getSelection());
                RelationalIndexEditorPanel.this.handleInfoChanged();
            }
        });
        Label label = new Label(thePanel, 0);
        label.setText(Messages.filterConditionLabel);
        this.filterConditionText = new Text(thePanel, 2052);
        this.filterConditionText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.filterConditionText);
        this.filterConditionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = RelationalIndexEditorPanel.this.filterConditionText.getText();
                if (value == null) {
                    value = "";
                }
                RelationalIndexEditorPanel.this.getRelationalReference().setFilterCondition(value);
                RelationalIndexEditorPanel.this.handleInfoChanged();
            }
        });
        return thePanel;
    }

    private Composite createReferencedColumnsPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)3);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        Label label = new Label(thePanel, 0);
        label.setText(Messages.tableReferenceLabel);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.tableReferenceText = new Text(thePanel, 2052);
        this.tableReferenceText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.tableReferenceText);
        this.tableReferenceText.setEditable(false);
        this.tableReferenceText.setBackground(label.getBackground());
        this.browseForTableButton = WidgetFactory.createButton((Composite)thePanel, (String)UILabelUtil.getLabel((int)0));
        this.browseForTableButton.setToolTipText(Messages.browseModelToSelectTableForIndexTooltipText);
        this.browseForTableButton.setEnabled(true);
        GridDataFactory.fillDefaults().hint(30, -1).applyTo((Control)this.browseForTableButton);
        this.browseForTableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                RelationalIndexEditorPanel.this.handleBrowseWorkspaceForTablePressed();
            }
        });
        this.columnsViewer = new TableViewerBuilder(thePanel, 2850);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).hint(-1, 150).applyTo((Control)this.columnsViewer.getTableComposite());
        TableViewerColumn column = this.columnsViewer.createColumn(16384, 100, 40, false);
        column.getColumn().setText(String.valueOf(Messages.columnNameLabel) + "          ");
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(0));
        this.columnsViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                return true;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof RelationalTable) {
                    return ((RelationalTable)inputElement).getColumns().toArray(new Object[0]);
                }
                return new Object[0];
            }

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }
        });
        if (this.getRelationalReference() != null) {
            for (RelationalColumn col : this.getRelationalReference().getColumns()) {
                TableItem[] tableItemArray = this.columnsViewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getData() == col) {
                        item.setChecked(true);
                    }
                    ++n2;
                }
            }
        }
        this.columnsViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RelationalIndexEditorPanel.this.getRelationalReference().getColumns().clear();
                TableItem[] tableItemArray = RelationalIndexEditorPanel.this.columnsViewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getChecked()) {
                        RelationalIndexEditorPanel.this.getRelationalReference().addColumn((RelationalColumn)item.getData());
                    }
                    ++n2;
                }
                RelationalIndexEditorPanel.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return thePanel;
    }

    @Override
    protected void validate() {
        this.getRelationalReference().validate();
        this.setCanFinish(this.getRelationalReference().nameIsValid());
        IStatus currentStatus = this.getRelationalReference().getStatus();
        if (currentStatus.isOK()) {
            this.setStatus(Status.OK_STATUS);
        } else {
            this.setStatus(currentStatus);
        }
    }

    private void handleBrowseWorkspaceForTablePressed() {
        ModelResource mr = ModelUtilities.getModelResourceForIFile((IFile)this.getModelFile(), (boolean)true);
        List childList = new ArrayList();
        try {
            childList = mr.getEObjects();
        }
        catch (ModelWorkspaceException ex) {
            ex.printStackTrace();
        }
        ArrayList<EObject> tablesOnlyList = new ArrayList<EObject>();
        for (EObject child : childList) {
            if (!(child instanceof Table)) continue;
            tablesOnlyList.add(child);
        }
        SelectFromEObjectListDialog sdDialog = this.createTableSelectionDialog(tablesOnlyList);
        sdDialog.open();
        if (sdDialog.getReturnCode() == 0) {
            Object[] selections = sdDialog.getResult();
            EObject tableObject = (EObject)selections[0];
            RelationalTable relTable = (RelationalTable)RelationalModelFactory.INSTANCE.getRelationalObject(tableObject);
            this.tableReferenceText.setText(relTable.getName());
            this.getRelationalReference().setRelationalTable(relTable);
            this.getRelationalReference().setUsesExistingTable(true);
            this.columnsViewer.setInput((Object)relTable);
            this.handleInfoChanged();
        }
    }

    private SelectFromEObjectListDialog createTableSelectionDialog(List<EObject> tableList) {
        String title = Messages.tableSelectionTitle;
        String message = Messages.selectExistingTableForIndexInitialMessage;
        SelectFromEObjectListDialog dialog = new SelectFromEObjectListDialog(this.getShell(), tableList, false, title, message, (LabelProvider)ModelUtilities.getModelObjectLabelProvider());
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0 || selection[0] == null || !(selection[0] instanceof Table)) {
                    return new StatusInfo("org.teiid.designer.relational.ui", 4, Messages.noTableSelectedMessage);
                }
                return new StatusInfo("org.teiid.designer.relational.ui");
            }
        });
        return dialog;
    }

    class ColumnDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ColumnDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof RelationalColumn) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((RelationalColumn)element).getName();
                    }
                }
            }
            return "";
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/column.png");
            }
            return null;
        }
    }
}

