/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.relational.RelationalConstants;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalForeignKey;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalPrimaryKey;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.model.RelationalUniqueConstraint;
import org.teiid.designer.relational.model.RelationalView;
import org.teiid.designer.relational.ui.Messages;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.relational.ui.UiPlugin;
import org.teiid.designer.relational.ui.edit.EditForeignKeyDialog;
import org.teiid.designer.relational.ui.edit.EditIndexDialog;
import org.teiid.designer.relational.ui.edit.EditUniqueConstraintDialog;
import org.teiid.designer.relational.ui.edit.RelationalDialogModel;
import org.teiid.designer.relational.ui.edit.RelationalEditorPanel;
import org.teiid.designer.relational.ui.util.RelationalUiUtil;
import org.teiid.designer.ui.common.UILabelUtil;
import org.teiid.designer.ui.common.eventsupport.IDialogStatusListener;
import org.teiid.designer.ui.common.table.ComboBoxEditingSupport;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.text.StyledTextEditor;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.viewsupport.DatatypeUtilities;

public class RelationalTableEditorPanel
extends RelationalEditorPanel
implements RelationalConstants {
    private List<String> MULTIPLICITY_LIST = new ArrayList<String>();
    private TabItem generalPropertiesTab;
    private TabItem columnsTab;
    private TabItem primaryKeyTab;
    private TabItem uniqueConstraintTab;
    private TabItem foreignKeysTab;
    private TabItem nativeQueryTab;
    private TabItem indexesTab;
    private Button materializedCB;
    private Button supportsUpdateCB;
    private Button isSystemTableCB;
    private Button includePrimaryKeyCB;
    private Button findTableReferenceButton;
    private Label materializedTableLabel;
    private Text cardinalityText;
    private Text materializedTableText;
    private Text primaryKeyNameText;
    private Text primaryKeyNISText;
    private Text nativeQueryHelpText;
    private StyledTextEditor nativeQueryTextEditor;
    private Button addColumnButton;
    private Button deleteColumnButton;
    private Button upColumnButton;
    private Button downColumnButton;
    private Button changePkColumnsButton;
    private Button addFKButton;
    private Button editFKButton;
    private Button deleteFKButton;
    private Button addUCButton;
    private Button editUCButton;
    private Button deleteUCButton;
    private Button addIndexButton;
    private Button deleteIndexButton;
    private Button editIndexButton;
    private TableViewerBuilder columnsViewer;
    private TableViewerBuilder pkColumnsViewer;
    private TableViewerBuilder fkViewer;
    private TableViewerBuilder uniqueConstraintsViewer;
    private TableViewerBuilder indexesViewer;
    private boolean finishedStartup = false;
    private boolean validationPerformed = false;
    private int HEIGHT_HINT_80 = 80;

    public RelationalTableEditorPanel(Composite parent, RelationalDialogModel dialogModel, IDialogStatusListener statusListener) {
        super(parent, dialogModel, statusListener);
        String[] stringArray = RelationalConstants.MULTIPLICITY.AS_ARRAY;
        int n = RelationalConstants.MULTIPLICITY.AS_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            this.MULTIPLICITY_LIST.add(str);
            ++n2;
        }
        this.finishedStartup = true;
    }

    protected RelationalTable getRelationalReference() {
        return (RelationalTable)super.getRelationalReference();
    }

    private boolean isPhysicalModel() {
        return this.getRelationalReference().getModelType() == ModelType.PHYSICAL;
    }

    private boolean isRelationalView() {
        return this.getRelationalReference() instanceof RelationalView;
    }

    @Override
    protected void createPanel(Composite parent) {
        this.createNameGroup(parent);
        TabFolder tabFolder = this.createTabFolder(parent);
        this.createGeneralPropertiesTab(tabFolder);
        this.createColumnsTab(tabFolder);
        this.createPrimaryKeyTab(tabFolder);
        this.createUniqueConstraintTab(tabFolder);
        this.createForeignKeysTab(tabFolder);
        this.createIndexesTab(tabFolder);
        this.createNativeQueryTab(tabFolder);
    }

    private void createGeneralPropertiesTab(TabFolder folderParent) {
        Composite thePanel = this.createPropertiesPanel((Composite)folderParent);
        this.generalPropertiesTab = new TabItem(folderParent, 0);
        this.generalPropertiesTab.setControl((Control)thePanel);
        this.generalPropertiesTab.setText(UILabelUtil.getLabel((int)6));
        this.generalPropertiesTab.setImage(RelationalUiUtil.getRelationalImage(3, ModelType.PHYSICAL, Status.OK_STATUS));
    }

    private void createColumnsTab(TabFolder folderParent) {
        Composite thePanel = this.createColumnTableGroup((Composite)folderParent);
        this.columnsTab = new TabItem(folderParent, 0);
        this.columnsTab.setControl((Control)thePanel);
        this.columnsTab.setText(Messages.columnsLabel);
        this.columnsTab.setImage(RelationalUiUtil.getRelationalImage(7, ModelType.PHYSICAL, Status.OK_STATUS));
    }

    private void createPrimaryKeyTab(TabFolder folderParent) {
        if (this.isRelationalView()) {
            return;
        }
        Composite thePanel = this.createPrimaryKeyPanel((Composite)folderParent);
        this.primaryKeyTab = new TabItem(folderParent, 0);
        this.primaryKeyTab.setControl((Control)thePanel);
        this.primaryKeyTab.setText(Messages.primaryKeyLabel);
        this.primaryKeyTab.setImage(RelationalUiUtil.getRelationalImage(8, ModelType.PHYSICAL, Status.OK_STATUS));
    }

    private void createUniqueConstraintTab(TabFolder folderParent) {
        if (this.isRelationalView()) {
            return;
        }
        Composite thePanel = this.createUniqueConstraintPanel((Composite)folderParent);
        this.uniqueConstraintTab = new TabItem(folderParent, 0);
        this.uniqueConstraintTab.setControl((Control)thePanel);
        this.uniqueConstraintTab.setText(Messages.uniqueConstraintLabel);
        this.uniqueConstraintTab.setImage(RelationalUiUtil.getRelationalImage(10, ModelType.PHYSICAL, Status.OK_STATUS));
    }

    private void createForeignKeysTab(TabFolder folderParent) {
        if (this.isRelationalView()) {
            return;
        }
        Composite thePanel = this.createForeignKeysPanel((Composite)folderParent);
        this.foreignKeysTab = new TabItem(folderParent, 0);
        this.foreignKeysTab.setControl((Control)thePanel);
        this.foreignKeysTab.setText(Messages.foreignKeysLabel);
        this.foreignKeysTab.setImage(RelationalUiUtil.getRelationalImage(9, ModelType.PHYSICAL, Status.OK_STATUS));
    }

    private void createIndexesTab(TabFolder folderParent) {
        if (this.isRelationalView()) {
            return;
        }
        Composite thePanel = this.createIndexesPanel((Composite)folderParent);
        this.indexesTab = new TabItem(folderParent, 0);
        this.indexesTab.setControl((Control)thePanel);
        this.indexesTab.setText(Messages.indexesLabel);
        this.indexesTab.setImage(RelationalUiUtil.getRelationalImage(13, ModelType.PHYSICAL, Status.OK_STATUS));
    }

    private void createNativeQueryTab(TabFolder folderParent) {
        if (this.isRelationalView()) {
            return;
        }
        Composite thePanel = this.createNativeQueryPanel((Composite)folderParent);
        this.nativeQueryTab = new TabItem(folderParent, 0);
        this.nativeQueryTab.setControl((Control)thePanel);
        this.nativeQueryTab.setText(Messages.nativeQueryLabel);
        this.nativeQueryTab.setImage(RelationalUiUtil.getNativeSQLImage(Status.OK_STATUS));
    }

    @Override
    protected void synchronizeExtendedUI() {
        this.synchronizePropertiesTab();
        this.synchronizeColumnsTab();
        this.synchronizePrimaryKeyTab();
        this.synchronizeForeignKeyTab();
        this.synchronizeUniqueConstraintTab();
        this.synchronizeIndexTab();
        this.synchronizeNativeQueryTab();
        if (this.finishedStartup) {
            this.setNativeQueryEnablement(!this.isRelationalView());
            this.setKeyTabsEnablement(!this.isRelationalView());
        }
    }

    private void synchronizePropertiesTab() {
        if (this.generalPropertiesTab == null) {
            return;
        }
        if (WidgetUtil.widgetValueChanged((Text)this.cardinalityText, (int)this.getRelationalReference().getCardinality())) {
            this.cardinalityText.setText(Integer.toString(this.getRelationalReference().getCardinality()));
        }
        if (this.materializedCB != null) {
            boolean isMaterialized = this.getRelationalReference().isMaterialized();
            if (WidgetUtil.widgetValueChanged((Button)this.materializedCB, (boolean)isMaterialized)) {
                this.materializedCB.setSelection(isMaterialized);
            }
            this.materializedTableText.setEnabled(isMaterialized);
            this.findTableReferenceButton.setEnabled(isMaterialized);
            if (WidgetUtil.widgetValueChanged((Button)this.materializedCB, (boolean)this.getRelationalReference().getSupportsUpdate())) {
                this.supportsUpdateCB.setSelection(this.getRelationalReference().getSupportsUpdate());
            }
        }
        if (WidgetUtil.widgetValueChanged((Button)this.isSystemTableCB, (boolean)this.getRelationalReference().isSystem())) {
            this.isSystemTableCB.setSelection(this.getRelationalReference().isSystem());
        }
        this.generalPropertiesTab.setImage(RelationalUiUtil.getRelationalImage(3, this.getRelationalReference().getModelType(), Status.OK_STATUS));
    }

    private void synchronizeColumnsTab() {
        this.columnsViewer.getTable().removeAll();
        IStatus maxStatus = Status.OK_STATUS;
        for (RelationalColumn row : this.getRelationalReference().getColumns()) {
            if (row.getStatus().getSeverity() > maxStatus.getSeverity()) {
                maxStatus = row.getStatus();
            }
            this.columnsViewer.add((Object)row);
        }
        this.columnsTab.setImage(RelationalUiUtil.getRelationalImage(7, this.getRelationalReference().getModelType(), maxStatus));
    }

    private void synchronizeForeignKeyTab() {
        if (this.foreignKeysTab == null) {
            return;
        }
        IStatus maxStatus = Status.OK_STATUS;
        this.fkViewer.getTable().removeAll();
        for (RelationalForeignKey row : this.getRelationalReference().getForeignKeys()) {
            if (row.getStatus().getSeverity() > maxStatus.getSeverity()) {
                maxStatus = row.getStatus();
            }
            this.fkViewer.add((Object)row);
        }
        this.foreignKeysTab.setImage(RelationalUiUtil.getRelationalImage(9, this.getRelationalReference().getModelType(), maxStatus));
    }

    private void synchronizePrimaryKeyTab() {
        if (this.primaryKeyTab == null) {
            return;
        }
        if (this.getRelationalReference().getPrimaryKey() == null) {
            if (WidgetUtil.widgetValueChanged((Button)this.includePrimaryKeyCB, (boolean)false)) {
                this.includePrimaryKeyCB.setSelection(false);
            }
            this.primaryKeyNameText.setEnabled(false);
            if (WidgetUtil.widgetValueChanged((Text)this.primaryKeyNameText, (String)"")) {
                this.primaryKeyNameText.setText("");
            }
            this.primaryKeyNISText.setEnabled(false);
            if (WidgetUtil.widgetValueChanged((Text)this.primaryKeyNISText, (String)"")) {
                this.primaryKeyNISText.setText("");
            }
            this.changePkColumnsButton.setEnabled(false);
            this.pkColumnsViewer.getTable().removeAll();
            this.pkColumnsViewer.getTable().setEnabled(false);
            this.primaryKeyTab.setImage(UiPlugin.getDefault().getImage("icons/full/obj16/primary-key.png"));
        } else {
            this.pkColumnsViewer.getTable().setEnabled(true);
            if (WidgetUtil.widgetValueChanged((Button)this.includePrimaryKeyCB, (boolean)true)) {
                this.includePrimaryKeyCB.setSelection(true);
            }
            this.primaryKeyNameText.setEnabled(true);
            if (this.getRelationalReference().getPrimaryKey().getName() != null && WidgetUtil.widgetValueChanged((Text)this.primaryKeyNameText, (String)this.getRelationalReference().getPrimaryKey().getName())) {
                this.primaryKeyNameText.setText(this.getRelationalReference().getPrimaryKey().getName());
            }
            this.primaryKeyNISText.setEnabled(true);
            if (this.getRelationalReference().getPrimaryKey().getNameInSource() != null && WidgetUtil.widgetValueChanged((Text)this.primaryKeyNISText, (String)this.getRelationalReference().getPrimaryKey().getNameInSource())) {
                this.primaryKeyNISText.setText(this.getRelationalReference().getPrimaryKey().getNameInSource());
            }
            this.pkColumnsViewer.getTable().removeAll();
            if (!this.getRelationalReference().getPrimaryKey().getColumns().isEmpty()) {
                for (RelationalColumn column : this.getRelationalReference().getPrimaryKey().getColumns()) {
                    this.pkColumnsViewer.add((Object)column);
                }
            }
            this.changePkColumnsButton.setEnabled(true);
            this.primaryKeyTab.setImage(RelationalUiUtil.getRelationalImage(8, this.getRelationalReference().getModelType(), this.getRelationalReference().getPrimaryKey().getStatus()));
        }
    }

    private void synchronizeUniqueConstraintTab() {
        if (this.uniqueConstraintTab == null) {
            return;
        }
        if (this.getRelationalReference().getUniqueConstraints().isEmpty()) {
            this.uniqueConstraintsViewer.getTable().removeAll();
            this.uniqueConstraintsViewer.getTable().setEnabled(false);
        } else {
            this.uniqueConstraintsViewer.getTable().setEnabled(true);
            this.uniqueConstraintsViewer.getTable().removeAll();
            if (!this.getRelationalReference().getUniqueConstraints().isEmpty()) {
                for (RelationalUniqueConstraint column : this.getRelationalReference().getUniqueConstraints()) {
                    this.uniqueConstraintsViewer.add((Object)column);
                }
            }
            IStatus ucStatus = Status.OK_STATUS;
            for (RelationalUniqueConstraint constraint : this.getRelationalReference().getUniqueConstraints()) {
                if (constraint.getStatus().getSeverity() <= ucStatus.getSeverity()) continue;
                ucStatus = constraint.getStatus();
            }
            this.uniqueConstraintTab.setImage(RelationalUiUtil.getRelationalImage(10, this.getRelationalReference().getModelType(), ucStatus));
        }
    }

    private void synchronizeIndexTab() {
        if (this.indexesTab == null) {
            return;
        }
        IStatus maxStatus = Status.OK_STATUS;
        this.indexesViewer.getTable().removeAll();
        for (RelationalIndex row : this.getRelationalReference().getIndexes()) {
            if (row.getStatus().getSeverity() > maxStatus.getSeverity()) {
                maxStatus = row.getStatus();
            }
            this.indexesViewer.add((Object)row);
        }
        this.indexesTab.setImage(RelationalUiUtil.getRelationalImage(13, this.getRelationalReference().getModelType(), maxStatus));
    }

    private void synchronizeNativeQueryTab() {
        if (this.nativeQueryTab == null) {
            return;
        }
        if (this.getRelationalReference().getNativeQuery() != null) {
            if (!StringUtilities.equals((String)this.nativeQueryTextEditor.getText(), (String)this.getRelationalReference().getNativeQuery())) {
                this.nativeQueryTextEditor.setText(this.getRelationalReference().getNativeQuery());
            }
        } else {
            this.nativeQueryTextEditor.setText("");
        }
    }

    private void setNativeQueryEnablement(boolean enable) {
    }

    private void setKeyTabsEnablement(boolean enable) {
        this.addFKButton.setEnabled(enable);
        this.editFKButton.setEnabled(false);
        this.deleteFKButton.setEnabled(false);
        this.includePrimaryKeyCB.setEnabled(enable);
        this.addUCButton.setEnabled(enable);
        this.editUCButton.setEnabled(false);
        this.deleteUCButton.setEnabled(false);
        this.addIndexButton.setEnabled(enable);
        this.editIndexButton.setEnabled(false);
        this.deleteIndexButton.setEnabled(false);
        IStructuredSelection selection = (IStructuredSelection)this.uniqueConstraintsViewer.getSelection();
        boolean value = !selection.isEmpty();
        this.editUCButton.setEnabled(value);
        this.deleteUCButton.setEnabled(value);
        selection = (IStructuredSelection)this.fkViewer.getSelection();
        value = !selection.isEmpty();
        this.editFKButton.setEnabled(value);
        this.deleteFKButton.setEnabled(value);
        selection = (IStructuredSelection)this.indexesViewer.getSelection();
        value = !selection.isEmpty();
        this.editIndexButton.setEnabled(value);
        this.deleteIndexButton.setEnabled(value);
    }

    private Composite createPropertiesPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)3);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        Composite cardinalityPanel = new Composite(thePanel, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)cardinalityPanel);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(cardinalityPanel);
        Label label = new Label(cardinalityPanel, 0);
        label.setText(Messages.cardinalityLabel);
        this.cardinalityText = new Text(cardinalityPanel, 2052);
        this.cardinalityText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.cardinalityText);
        this.cardinalityText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (RelationalTableEditorPanel.this.isSynchronizing()) {
                    return;
                }
                if (!RelationalTableEditorPanel.this.cardinalityText.getText().isEmpty()) {
                    try {
                        int value = Integer.parseInt(RelationalTableEditorPanel.this.cardinalityText.getText());
                        RelationalTableEditorPanel.this.getRelationalReference().setCardinality(value);
                        RelationalTableEditorPanel.this.handleInfoChanged();
                    }
                    catch (NumberFormatException numberFormatException) {
                        MessageDialog.openError((Shell)RelationalTableEditorPanel.this.getShell(), (String)Messages.cardinalityErrorTitle, (String)Messages.cardinalityMustBeAnInteger);
                        return;
                    }
                }
            }
        });
        Composite checkButtonPanel = new Composite(thePanel, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)checkButtonPanel);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(checkButtonPanel);
        this.supportsUpdateCB = new Button(checkButtonPanel, 131104);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.supportsUpdateCB);
        this.supportsUpdateCB.setText(Messages.supportsUpdateLabel);
        this.supportsUpdateCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalTableEditorPanel.this.getRelationalReference().setSupportsUpdate(RelationalTableEditorPanel.this.supportsUpdateCB.getSelection());
                RelationalTableEditorPanel.this.handleInfoChanged();
            }
        });
        this.isSystemTableCB = new Button(checkButtonPanel, 131104);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.isSystemTableCB);
        this.isSystemTableCB.setText(Messages.systemTableLabel);
        this.isSystemTableCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalTableEditorPanel.this.getRelationalReference().setSystem(RelationalTableEditorPanel.this.isSystemTableCB.getSelection());
                RelationalTableEditorPanel.this.handleInfoChanged();
            }
        });
        if (this.isPhysicalModel()) {
            this.materializedCB = new Button(thePanel, 131104);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.materializedCB);
            this.materializedCB.setText(Messages.materializedLabel);
            this.materializedCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RelationalTableEditorPanel.this.getRelationalReference().setMaterialized(RelationalTableEditorPanel.this.materializedCB.getSelection());
                    if (!RelationalTableEditorPanel.this.materializedCB.getSelection()) {
                        RelationalTableEditorPanel.this.getRelationalReference().setMaterializedTable(null);
                    }
                    RelationalTableEditorPanel.this.handleInfoChanged();
                }
            });
            Composite materializedPanel = new Composite(thePanel, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)materializedPanel);
            GridLayoutFactory.fillDefaults().numColumns(3).applyTo(materializedPanel);
            this.materializedTableLabel = new Label(materializedPanel, 131072);
            this.materializedTableLabel.setText(Messages.tableReferenceLabel);
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)this.materializedTableLabel);
            this.materializedTableText = new Text(materializedPanel, 2052);
            this.materializedTableText.setForeground(Display.getCurrent().getSystemColor(10));
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.materializedTableText);
            this.findTableReferenceButton = new Button(materializedPanel, 8);
            this.findTableReferenceButton.setText(UILabelUtil.getLabel((int)0));
            GridDataFactory.fillDefaults().hint(30, -1).applyTo((Control)this.findTableReferenceButton);
            this.findTableReferenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                }
            });
        }
        this.createDescriptionPanel(thePanel);
        return thePanel;
    }

    private Composite createPrimaryKeyPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)2);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        if (this.isRelationalView()) {
            Text pkHelpText = new Text(thePanel, 72);
            pkHelpText.setBackground(parent.getBackground());
            pkHelpText.setForeground(Display.getCurrent().getSystemColor(10));
            GridDataFactory.fillDefaults().align(4, 1).hint(250, this.HEIGHT_HINT_80).span(2, 1).applyTo((Control)pkHelpText);
            pkHelpText.setText(Messages.primaryKeysNotSupportedForViews);
        }
        this.includePrimaryKeyCB = new Button(thePanel, 131104);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(2, 1).applyTo((Control)this.includePrimaryKeyCB);
        this.includePrimaryKeyCB.setText(UILabelUtil.getLabel((int)9));
        this.includePrimaryKeyCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RelationalTableEditorPanel.this.includePrimaryKeyCB.getSelection()) {
                    if (RelationalTableEditorPanel.this.getRelationalReference().getPrimaryKey() == null) {
                        RelationalPrimaryKey key = new RelationalPrimaryKey();
                        if (RelationalTableEditorPanel.this.primaryKeyNameText.getText() != null) {
                            key.setName(RelationalTableEditorPanel.this.primaryKeyNameText.getText());
                        }
                        RelationalTableEditorPanel.this.getRelationalReference().setPrimaryKey(key);
                    }
                } else {
                    RelationalTableEditorPanel.this.getRelationalReference().setPrimaryKey(null);
                }
                RelationalTableEditorPanel.this.handleInfoChanged();
            }
        });
        Label label = new Label(thePanel, 131072);
        label.setText(UILabelUtil.getLabel((int)14));
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.primaryKeyNameText = new Text(thePanel, 2052);
        this.primaryKeyNameText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().applyTo((Control)this.primaryKeyNameText);
        this.primaryKeyNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = RelationalTableEditorPanel.this.primaryKeyNameText.getText();
                if (value == null) {
                    value = "";
                }
                if (RelationalTableEditorPanel.this.getRelationalReference().getPrimaryKey() != null) {
                    RelationalPrimaryKey key = RelationalTableEditorPanel.this.getRelationalReference().getPrimaryKey();
                    key.setName(value);
                }
                RelationalTableEditorPanel.this.handleInfoChanged();
            }
        });
        label = new Label(thePanel, 131072);
        label.setText(Messages.nameInSourceLabel);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.primaryKeyNISText = new Text(thePanel, 2052);
        this.primaryKeyNISText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().applyTo((Control)this.primaryKeyNISText);
        this.primaryKeyNISText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = RelationalTableEditorPanel.this.primaryKeyNISText.getText();
                if (value == null) {
                    value = "";
                }
                if (RelationalTableEditorPanel.this.getRelationalReference().getPrimaryKey() != null) {
                    RelationalPrimaryKey key = RelationalTableEditorPanel.this.getRelationalReference().getPrimaryKey();
                    key.setNameInSource(value);
                }
                RelationalTableEditorPanel.this.handleInfoChanged();
            }
        });
        Composite buttonPanel = new Composite(thePanel, 0);
        GridLayoutFactory.fillDefaults().applyTo(buttonPanel);
        GridDataFactory.fillDefaults().align(16384, 1).applyTo((Control)buttonPanel);
        this.changePkColumnsButton = new Button(buttonPanel, 8);
        this.changePkColumnsButton.setText(UILabelUtil.getLabel((int)11));
        GridDataFactory.fillDefaults().applyTo((Control)this.changePkColumnsButton);
        this.changePkColumnsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectColumnsDialog dialog = new SelectColumnsDialog(RelationalTableEditorPanel.this.getShell(), RelationalTableEditorPanel.this.getRelationalReference(), true);
                int result = dialog.open();
                if (result == 0) {
                    Collection<RelationalColumn> selectedColumns = dialog.getSelectedColumns();
                    if (!selectedColumns.isEmpty()) {
                        RelationalTableEditorPanel.this.getRelationalReference().getPrimaryKey().setColumns(selectedColumns);
                    } else {
                        RelationalTableEditorPanel.this.getRelationalReference().getPrimaryKey().setColumns(Collections.emptyList());
                    }
                }
                RelationalTableEditorPanel.this.handleInfoChanged();
            }
        });
        this.pkColumnsViewer = new TableViewerBuilder(thePanel, 2820);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, this.HEIGHT_HINT_80).applyTo((Control)this.pkColumnsViewer.getTableComposite());
        TableViewerColumn column = this.pkColumnsViewer.createColumn(16384, 100, 40, true);
        column.getColumn().setText(Messages.columnNameLabel);
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(0));
        if (this.getRelationalReference() != null && this.getRelationalReference().getPrimaryKey() != null) {
            for (RelationalColumn row : this.getRelationalReference().getPrimaryKey().getColumns()) {
                this.columnsViewer.add((Object)row);
            }
        }
        return thePanel;
    }

    private Composite createUniqueConstraintPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)2);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        if (this.isRelationalView()) {
            Text ucHelpText = new Text(thePanel, 72);
            ucHelpText.setBackground(parent.getBackground());
            ucHelpText.setForeground(Display.getCurrent().getSystemColor(10));
            GridDataFactory.fillDefaults().align(4, 1).hint(250, this.HEIGHT_HINT_80).span(2, 1).applyTo((Control)ucHelpText);
            ucHelpText.setText(Messages.uniqueConstraintsNotSupportedForViews);
        }
        Composite buttonPanel = new Composite(thePanel, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(buttonPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        this.addUCButton = new Button(buttonPanel, 8);
        this.addUCButton.setText(UILabelUtil.getLabel((int)1));
        GridDataFactory.fillDefaults().applyTo((Control)this.addUCButton);
        this.addUCButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalUniqueConstraint newUC = new RelationalUniqueConstraint();
                EditUniqueConstraintDialog dialog = new EditUniqueConstraintDialog(RelationalTableEditorPanel.this.getShell(), RelationalTableEditorPanel.this.getRelationalReference(), newUC, false);
                int result = dialog.open();
                if (result == 0) {
                    RelationalTableEditorPanel.this.getRelationalReference().addUniqueConstraint(newUC);
                }
                RelationalTableEditorPanel.this.handleInfoChanged();
            }
        });
        this.editUCButton = new Button(buttonPanel, 8);
        this.editUCButton.setText(UILabelUtil.getLabel((int)13));
        GridDataFactory.fillDefaults().applyTo((Control)this.editUCButton);
        this.editUCButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalUniqueConstraint uc = null;
                IStructuredSelection selection = (IStructuredSelection)RelationalTableEditorPanel.this.uniqueConstraintsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalUniqueConstraint) {
                        uc = (RelationalUniqueConstraint)obj;
                        break;
                    }
                    ++n2;
                }
                if (uc != null) {
                    EditUniqueConstraintDialog dialog = new EditUniqueConstraintDialog(RelationalTableEditorPanel.this.getShell(), RelationalTableEditorPanel.this.getRelationalReference(), uc, true);
                    dialog.open();
                    RelationalTableEditorPanel.this.handleInfoChanged();
                    RelationalTableEditorPanel.this.editUCButton.setEnabled(false);
                }
            }
        });
        this.editUCButton.setEnabled(false);
        this.deleteUCButton = new Button(buttonPanel, 8);
        this.deleteUCButton.setText(UILabelUtil.getLabel((int)2));
        GridDataFactory.fillDefaults().applyTo((Control)this.deleteUCButton);
        this.deleteUCButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalUniqueConstraint uc = null;
                IStructuredSelection selection = (IStructuredSelection)RelationalTableEditorPanel.this.uniqueConstraintsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalUniqueConstraint) {
                        uc = (RelationalUniqueConstraint)obj;
                        break;
                    }
                    ++n2;
                }
                if (uc != null) {
                    RelationalTableEditorPanel.this.getRelationalReference().removeUniqueConstraint(uc);
                    RelationalTableEditorPanel.this.deleteUCButton.setEnabled(false);
                    RelationalTableEditorPanel.this.editUCButton.setEnabled(false);
                    RelationalTableEditorPanel.this.handleInfoChanged();
                }
            }
        });
        this.deleteUCButton.setEnabled(false);
        this.uniqueConstraintsViewer = new TableViewerBuilder(thePanel, 2820);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, this.HEIGHT_HINT_80).applyTo((Control)this.uniqueConstraintsViewer.getTableComposite());
        TableViewerColumn column = this.uniqueConstraintsViewer.createColumn(16384, 100, 40, false);
        column.getColumn().setText(Messages.uniqueConstraintsLabel);
        column.setLabelProvider((CellLabelProvider)new UniqueConstraintLabelProvider(0));
        if (this.getRelationalReference() != null && this.getRelationalReference().getUniqueConstraints() != null) {
            for (RelationalUniqueConstraint row : this.getRelationalReference().getUniqueConstraints()) {
                this.uniqueConstraintsViewer.add((Object)row);
            }
        }
        this.uniqueConstraintsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)RelationalTableEditorPanel.this.uniqueConstraintsViewer.getSelection();
                boolean enable = !selection.isEmpty();
                RelationalTableEditorPanel.this.editUCButton.setEnabled(enable);
                RelationalTableEditorPanel.this.deleteUCButton.setEnabled(enable);
            }
        });
        return thePanel;
    }

    private Composite createForeignKeysPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)2);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        if (this.isRelationalView()) {
            Text fkHelpText = new Text(thePanel, 72);
            fkHelpText.setBackground(parent.getBackground());
            fkHelpText.setForeground(Display.getCurrent().getSystemColor(10));
            GridDataFactory.fillDefaults().align(4, 1).hint(250, this.HEIGHT_HINT_80).span(2, 1).applyTo((Control)fkHelpText);
            fkHelpText.setText(Messages.foreignKeysNotSupportedForViews);
        }
        Composite buttonPanel = new Composite(thePanel, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(buttonPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        this.addFKButton = new Button(buttonPanel, 8);
        this.addFKButton.setText(UILabelUtil.getLabel((int)1));
        GridDataFactory.fillDefaults().applyTo((Control)this.addFKButton);
        this.addFKButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalForeignKey newFK = new RelationalForeignKey();
                EditForeignKeyDialog dialog = new EditForeignKeyDialog(RelationalTableEditorPanel.this.getShell(), RelationalTableEditorPanel.this.getModelFile(), RelationalTableEditorPanel.this.getRelationalReference(), newFK, false);
                int result = dialog.open();
                if (result == 0) {
                    RelationalTableEditorPanel.this.getRelationalReference().addForeignKey(newFK);
                }
                RelationalTableEditorPanel.this.handleInfoChanged();
            }
        });
        this.editFKButton = new Button(buttonPanel, 8);
        this.editFKButton.setText(UILabelUtil.getLabel((int)13));
        GridDataFactory.fillDefaults().applyTo((Control)this.editFKButton);
        this.editFKButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalForeignKey fk = null;
                IStructuredSelection selection = (IStructuredSelection)RelationalTableEditorPanel.this.fkViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalForeignKey) {
                        fk = (RelationalForeignKey)obj;
                        break;
                    }
                    ++n2;
                }
                if (fk != null) {
                    EditForeignKeyDialog dialog = new EditForeignKeyDialog(RelationalTableEditorPanel.this.getShell(), RelationalTableEditorPanel.this.getModelFile(), RelationalTableEditorPanel.this.getRelationalReference(), fk, true);
                    int result = dialog.open();
                    RelationalTableEditorPanel.this.handleInfoChanged();
                }
            }
        });
        this.editFKButton.setEnabled(false);
        this.deleteFKButton = new Button(buttonPanel, 8);
        this.deleteFKButton.setText(UILabelUtil.getLabel((int)2));
        GridDataFactory.fillDefaults().applyTo((Control)this.deleteFKButton);
        this.deleteFKButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalForeignKey fk = null;
                IStructuredSelection selection = (IStructuredSelection)RelationalTableEditorPanel.this.fkViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalForeignKey) {
                        fk = (RelationalForeignKey)obj;
                        break;
                    }
                    ++n2;
                }
                if (fk != null) {
                    RelationalTableEditorPanel.this.getRelationalReference().removeForeignKey(fk);
                    RelationalTableEditorPanel.this.deleteFKButton.setEnabled(false);
                    RelationalTableEditorPanel.this.handleInfoChanged();
                }
            }
        });
        this.deleteFKButton.setEnabled(false);
        this.fkViewer = new TableViewerBuilder(thePanel, 2820);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, this.HEIGHT_HINT_80).applyTo((Control)this.fkViewer.getTableComposite());
        TableViewerColumn column = this.fkViewer.createColumn(16384, 100, 40, false);
        column.getColumn().setText(Messages.fkNameLabel);
        column.setLabelProvider((CellLabelProvider)new FKDataLabelProvider(0));
        if (this.getRelationalReference() != null) {
            for (RelationalForeignKey row : this.getRelationalReference().getForeignKeys()) {
                this.fkViewer.add((Object)row);
            }
        }
        this.fkViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)RelationalTableEditorPanel.this.fkViewer.getSelection();
                boolean enable = !selection.isEmpty();
                RelationalTableEditorPanel.this.editFKButton.setEnabled(enable);
                RelationalTableEditorPanel.this.deleteFKButton.setEnabled(enable);
            }
        });
        return thePanel;
    }

    private Composite createIndexesPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)2);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        if (this.isRelationalView()) {
            Text indexesHelpText = new Text(thePanel, 72);
            indexesHelpText.setBackground(parent.getBackground());
            indexesHelpText.setForeground(Display.getCurrent().getSystemColor(10));
            GridDataFactory.fillDefaults().align(4, 1).hint(250, this.HEIGHT_HINT_80).span(2, 1).applyTo((Control)indexesHelpText);
            indexesHelpText.setText(Messages.indexesNotSupportedForViews);
        }
        Composite buttonPanel = new Composite(thePanel, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(buttonPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        this.addIndexButton = new Button(buttonPanel, 8);
        this.addIndexButton.setText(UILabelUtil.getLabel((int)1));
        GridDataFactory.fillDefaults().applyTo((Control)this.addIndexButton);
        this.addIndexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalIndex newIndex = new RelationalIndex();
                EditIndexDialog dialog = new EditIndexDialog(RelationalTableEditorPanel.this.getShell(), RelationalTableEditorPanel.this.getRelationalReference(), newIndex, false);
                int result = dialog.open();
                if (result == 0) {
                    RelationalTableEditorPanel.this.getRelationalReference().addIndex(newIndex);
                }
                RelationalTableEditorPanel.this.handleInfoChanged();
            }
        });
        this.editIndexButton = new Button(buttonPanel, 8);
        this.editIndexButton.setText(UILabelUtil.getLabel((int)13));
        GridDataFactory.fillDefaults().applyTo((Control)this.editIndexButton);
        this.editIndexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalIndex index = null;
                IStructuredSelection selection = (IStructuredSelection)RelationalTableEditorPanel.this.indexesViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalIndex) {
                        index = (RelationalIndex)obj;
                        break;
                    }
                    ++n2;
                }
                if (index != null) {
                    EditIndexDialog dialog = new EditIndexDialog(RelationalTableEditorPanel.this.getShell(), RelationalTableEditorPanel.this.getRelationalReference(), index, true);
                    int result = dialog.open();
                    RelationalTableEditorPanel.this.handleInfoChanged();
                }
            }
        });
        this.editIndexButton.setEnabled(false);
        this.deleteIndexButton = new Button(buttonPanel, 8);
        this.deleteIndexButton.setText(UILabelUtil.getLabel((int)2));
        GridDataFactory.fillDefaults().applyTo((Control)this.deleteIndexButton);
        this.deleteIndexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalIndex index = null;
                IStructuredSelection selection = (IStructuredSelection)RelationalTableEditorPanel.this.indexesViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalIndex) {
                        index = (RelationalIndex)obj;
                        break;
                    }
                    ++n2;
                }
                if (index != null) {
                    RelationalTableEditorPanel.this.getRelationalReference().removeIndex(index);
                    RelationalTableEditorPanel.this.deleteIndexButton.setEnabled(false);
                    RelationalTableEditorPanel.this.handleInfoChanged();
                }
            }
        });
        this.deleteIndexButton.setEnabled(false);
        this.indexesViewer = new TableViewerBuilder(thePanel, 2820);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, this.HEIGHT_HINT_80).applyTo((Control)this.indexesViewer.getTableComposite());
        TableViewerColumn column = this.indexesViewer.createColumn(16384, 100, 40, false);
        column.getColumn().setText(Messages.indexLabel);
        column.setLabelProvider((CellLabelProvider)new IndexDataLabelProvider(0));
        if (this.getRelationalReference() != null && this.getRelationalReference().getIndexes() != null) {
            for (RelationalIndex row : this.getRelationalReference().getIndexes()) {
                this.indexesViewer.add((Object)row);
            }
        }
        this.indexesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)RelationalTableEditorPanel.this.indexesViewer.getSelection();
                boolean enable = !selection.isEmpty();
                RelationalTableEditorPanel.this.editIndexButton.setEnabled(enable);
                RelationalTableEditorPanel.this.deleteIndexButton.setEnabled(enable);
            }
        });
        return thePanel;
    }

    private Composite createNativeQueryPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)3);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)thePanel);
        this.nativeQueryHelpText = new Text(thePanel, 72);
        this.nativeQueryHelpText.setBackground(parent.getBackground());
        this.nativeQueryHelpText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().align(4, 1).hint(250, 40).applyTo((Control)this.nativeQueryHelpText);
        this.nativeQueryHelpText.setText(Messages.nativeQueryHelpText);
        Group descGroup = WidgetFactory.createGroup((Composite)thePanel, (String)Messages.sqlLabel, (int)1808, (int)3);
        this.nativeQueryTextEditor = new StyledTextEditor((Composite)descGroup, 2882);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200).minSize(-1, 30).applyTo((Control)this.nativeQueryTextEditor.getTextWidget());
        this.nativeQueryTextEditor.setText("");
        this.nativeQueryTextEditor.getTextWidget().setBackground(Display.getCurrent().getSystemColor(1));
        this.nativeQueryTextEditor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RelationalTableEditorPanel.this.getRelationalReference().setNativeQuery(RelationalTableEditorPanel.this.nativeQueryTextEditor.getText());
                RelationalTableEditorPanel.this.handleInfoChanged();
            }
        });
        return thePanel;
    }

    private Composite createColumnTableGroup(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        Composite buttonPanel = WidgetFactory.createPanel((Composite)thePanel, (int)0, (int)1, (int)4);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(buttonPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        this.addColumnButton = new Button(buttonPanel, 8);
        this.addColumnButton.setText(UILabelUtil.getLabel((int)1));
        GridDataFactory.fillDefaults().applyTo((Control)this.addColumnButton);
        this.addColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalTableEditorPanel.this.getRelationalReference().createColumn();
                RelationalTableEditorPanel.this.handleInfoChanged();
            }
        });
        this.deleteColumnButton = new Button(buttonPanel, 8);
        this.deleteColumnButton.setText(UILabelUtil.getLabel((int)2));
        GridDataFactory.fillDefaults().applyTo((Control)this.deleteColumnButton);
        this.deleteColumnButton.setEnabled(false);
        this.deleteColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalColumn column = null;
                IStructuredSelection selection = (IStructuredSelection)RelationalTableEditorPanel.this.columnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalColumn) {
                        column = (RelationalColumn)obj;
                        break;
                    }
                    ++n2;
                }
                if (column != null) {
                    RelationalTableEditorPanel.this.getRelationalReference().removeColumn(column);
                    RelationalTableEditorPanel.this.deleteColumnButton.setEnabled(false);
                    RelationalTableEditorPanel.this.handleInfoChanged();
                }
            }
        });
        this.upColumnButton = new Button(buttonPanel, 8);
        this.upColumnButton.setText(UILabelUtil.getLabel((int)4));
        GridDataFactory.fillDefaults().applyTo((Control)this.upColumnButton);
        this.upColumnButton.setEnabled(false);
        this.upColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalColumn info = null;
                IStructuredSelection selection = (IStructuredSelection)RelationalTableEditorPanel.this.columnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalColumn) {
                        info = (RelationalColumn)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = RelationalTableEditorPanel.this.columnsViewer.getTable().getSelectionIndex();
                    RelationalTableEditorPanel.this.getRelationalReference().moveColumnUp(info);
                    RelationalTableEditorPanel.this.handleInfoChanged();
                    RelationalTableEditorPanel.this.columnsViewer.getTable().select(selectedIndex - 1);
                    RelationalTableEditorPanel.this.downColumnButton.setEnabled(RelationalTableEditorPanel.this.getRelationalReference().canMoveColumnDown(info));
                    RelationalTableEditorPanel.this.upColumnButton.setEnabled(RelationalTableEditorPanel.this.getRelationalReference().canMoveColumnUp(info));
                }
            }
        });
        this.downColumnButton = new Button(buttonPanel, 8);
        this.downColumnButton.setText(UILabelUtil.getLabel((int)5));
        GridDataFactory.fillDefaults().applyTo((Control)this.downColumnButton);
        this.downColumnButton.setEnabled(false);
        this.downColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalColumn info = null;
                IStructuredSelection selection = (IStructuredSelection)RelationalTableEditorPanel.this.columnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalColumn) {
                        info = (RelationalColumn)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = RelationalTableEditorPanel.this.columnsViewer.getTable().getSelectionIndex();
                    RelationalTableEditorPanel.this.getRelationalReference().moveColumnDown(info);
                    RelationalTableEditorPanel.this.handleInfoChanged();
                    RelationalTableEditorPanel.this.columnsViewer.getTable().select(selectedIndex + 1);
                    RelationalTableEditorPanel.this.downColumnButton.setEnabled(RelationalTableEditorPanel.this.getRelationalReference().canMoveColumnDown(info));
                    RelationalTableEditorPanel.this.upColumnButton.setEnabled(RelationalTableEditorPanel.this.getRelationalReference().canMoveColumnUp(info));
                }
            }
        });
        this.columnsViewer = new TableViewerBuilder(thePanel, 68356);
        TableViewerColumn column = this.columnsViewer.createColumn(16384, 30, 40, true);
        column.getColumn().setText(Messages.columnNameLabel);
        column.setEditingSupport((EditingSupport)new ColumnNameEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(0));
        column = this.columnsViewer.createColumn(16384, 30, 40, true);
        column.getColumn().setText(Messages.dataTypeLabel);
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(1));
        column.setEditingSupport((EditingSupport)new DatatypeEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        column = this.columnsViewer.createColumn(16384, 30, 40, true);
        column.getColumn().setText(Messages.lengthLabel);
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(2));
        column.setEditingSupport((EditingSupport)new ColumnWidthEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        if (this.getRelationalReference() != null) {
            for (RelationalColumn row : this.getRelationalReference().getColumns()) {
                this.columnsViewer.add((Object)row);
            }
        }
        this.columnsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    RelationalTableEditorPanel.this.deleteColumnButton.setEnabled(false);
                    RelationalTableEditorPanel.this.upColumnButton.setEnabled(false);
                    RelationalTableEditorPanel.this.downColumnButton.setEnabled(false);
                } else {
                    boolean enable = true;
                    Object[] objs = sel.toArray();
                    RelationalColumn columnInfo = null;
                    Object[] objectArray = objs;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (!(obj instanceof RelationalColumn)) {
                            enable = false;
                            break;
                        }
                        columnInfo = (RelationalColumn)obj;
                        ++n2;
                    }
                    if (objs.length == 0) {
                        enable = false;
                    }
                    RelationalTableEditorPanel.this.deleteColumnButton.setEnabled(enable);
                    if (enable) {
                        RelationalTableEditorPanel.this.upColumnButton.setEnabled(RelationalTableEditorPanel.this.getRelationalReference().canMoveColumnUp(columnInfo));
                        RelationalTableEditorPanel.this.downColumnButton.setEnabled(RelationalTableEditorPanel.this.getRelationalReference().canMoveColumnDown(columnInfo));
                    }
                }
            }
        });
        return thePanel;
    }

    @Override
    protected void validate() {
        this.getRelationalReference().validate();
        this.setCanFinish(this.getRelationalReference().nameIsValid());
        IStatus currentStatus = this.getRelationalReference().getStatus();
        if (currentStatus.isOK()) {
            this.setStatus(Status.OK_STATUS);
        } else {
            this.setStatus(currentStatus);
        }
        this.validationPerformed = true;
    }

    @Override
    public boolean canFinish() {
        if (!this.validationPerformed && this.getRelationalReference().getName() != null) {
            return true;
        }
        if (this.validationPerformed) {
            return this.getRelationalReference().getName() != null;
        }
        return false;
    }

    class ColumnDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ColumnDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof RelationalColumn) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((RelationalColumn)element).getName();
                    }
                    case 1: {
                        return ((RelationalColumn)element).getDatatype();
                    }
                    case 2: {
                        return Integer.toString(((RelationalColumn)element).getLength());
                    }
                }
            }
            return "";
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/column.png");
            }
            return null;
        }
    }

    class ColumnNameEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public ColumnNameEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof RelationalColumn) {
                return ((RelationalColumn)element).getName();
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof RelationalColumn) {
                String oldValue = ((RelationalColumn)element).getName();
                String newValue = (String)value;
                if (newValue != null && newValue.length() > 0 && !newValue.equalsIgnoreCase(oldValue)) {
                    ((RelationalColumn)element).setName(newValue);
                    RelationalTableEditorPanel.this.columnsViewer.getTableViewer().refresh(element);
                    RelationalTableEditorPanel.this.handleInfoChanged();
                }
            }
        }
    }

    class ColumnWidthEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public ColumnWidthEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof RelationalColumn) {
                return Integer.toString(((RelationalColumn)element).getLength());
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof RelationalColumn) {
                int oldValue;
                int newValue = oldValue = ((RelationalColumn)element).getLength();
                try {
                    newValue = Integer.parseInt((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                if (newValue != oldValue) {
                    ((RelationalColumn)element).setLength(newValue);
                    RelationalTableEditorPanel.this.columnsViewer.getTableViewer().refresh(element);
                }
            }
        }
    }

    class DatatypeEditingSupport
    extends ComboBoxEditingSupport {
        private String[] datatypes;

        public DatatypeEditingSupport(ColumnViewer viewer) {
            super(viewer);
            Collection unsortedTypes = new ArrayList();
            try {
                unsortedTypes = DatatypeUtilities.getAllDesignTimeTypeNames();
            }
            catch (ModelerCoreException e) {
                UiConstants.Util.log((Throwable)e);
            }
            ArrayList<Object> dTypes = new ArrayList<Object>();
            Object[] sortedStrings = unsortedTypes.toArray(new String[unsortedTypes.size()]);
            Arrays.sort(sortedStrings);
            Object[] objectArray = sortedStrings;
            int n = sortedStrings.length;
            int n2 = 0;
            while (n2 < n) {
                Object dType = objectArray[n2];
                dTypes.add(dType);
                ++n2;
            }
            this.datatypes = dTypes.toArray(new String[dTypes.size()]);
        }

        protected String getElementValue(Object element) {
            return ((RelationalColumn)element).getDatatype();
        }

        protected String[] refreshItems(Object element) {
            return this.datatypes;
        }

        protected void setElementValue(Object element, String newValue) {
            ((RelationalColumn)element).setDatatype(newValue);
        }
    }

    class FKDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public FKDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof RelationalForeignKey) {
                switch (this.columnNumber) {
                    case 0: {
                        if (!(element instanceof RelationalForeignKey)) break;
                        return ((RelationalForeignKey)element).getName();
                    }
                }
            }
            return "";
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/foreign-key.png");
            }
            return null;
        }
    }

    class IndexDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public IndexDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof RelationalIndex) {
                switch (this.columnNumber) {
                    case 0: {
                        if (!(element instanceof RelationalIndex)) break;
                        RelationalIndex index = (RelationalIndex)element;
                        String value = index.getName();
                        if (!index.getColumns().isEmpty()) {
                            int i = 0;
                            value = String.valueOf(value) + " : ";
                            for (RelationalColumn col : index.getColumns()) {
                                value = String.valueOf(value) + col.getName();
                                if (++i >= index.getColumns().size()) continue;
                                value = String.valueOf(value) + ", ";
                            }
                        }
                        return value;
                    }
                }
            }
            return "";
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/index.png");
            }
            return null;
        }
    }

    class SelectColumnsDialog
    extends TitleAreaDialog {
        private final String TITLE;
        private RelationalTable theTable;
        TableViewer columnDataViewer;
        private Set<RelationalColumn> selectedColumns;

        public SelectColumnsDialog(Shell parent, RelationalTable theTable, boolean isPrimaryKeyColumns) {
            super(parent);
            this.TITLE = Messages.selectColumnsTitle;
            this.selectedColumns = new HashSet<RelationalColumn>();
            this.theTable = theTable;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this.TITLE);
        }

        protected void setShellStyle(int newShellStyle) {
            super.setShellStyle(newShellStyle | 0x10 | 0x400);
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitle(Messages.selectColumnsSubTitle);
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayoutFactory.fillDefaults().applyTo(composite);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
            Group columnsGroup = WidgetFactory.createGroup((Composite)composite, (String)Messages.selectColumnsTitle, (int)0, (int)1, (int)2);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)columnsGroup);
            Table table = new Table((Composite)columnsGroup, 2850);
            table.setHeaderVisible(false);
            table.setLinesVisible(true);
            table.setLayout((Layout)new TableLayout());
            this.columnDataViewer = new TableViewer(table);
            GridDataFactory.fillDefaults().grab(true, false).hint(-1, 100).span(2, 1).applyTo(this.columnDataViewer.getControl());
            this.columnDataViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public boolean hasChildren(Object element) {
                    return !SelectColumnsDialog.this.theTable.getColumns().isEmpty();
                }

                public Object getParent(Object element) {
                    return null;
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof RelationalTable) {
                        return SelectColumnsDialog.this.theTable.getColumns().toArray(new Object[0]);
                    }
                    return new Object[0];
                }

                public Object[] getChildren(Object parentElement) {
                    return new Object[0];
                }
            });
            this.columnDataViewer.setLabelProvider((IBaseLabelProvider)new ColumnDataLabelProvider(0));
            this.columnDataViewer.setInput((Object)this.theTable);
            for (RelationalColumn col : this.theTable.getPrimaryKey().getColumns()) {
                TableItem[] tableItemArray = this.columnDataViewer.getTable().getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (item.getData() == col) {
                        item.setChecked(true);
                    }
                    ++n2;
                }
            }
            this.setMessage(Messages.selectColumnsMessage);
            return composite;
        }

        public void create() {
            super.create();
            this.getButton(0).setEnabled(true);
        }

        protected void okPressed() {
            TableItem[] tableItemArray = this.columnDataViewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    this.selectedColumns.add((RelationalColumn)item.getData());
                }
                ++n2;
            }
            super.okPressed();
        }

        public Collection<RelationalColumn> getSelectedColumns() {
            return this.selectedColumns;
        }
    }

    class UniqueConstraintLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public UniqueConstraintLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof RelationalUniqueConstraint) {
                switch (this.columnNumber) {
                    case 0: {
                        if (!(element instanceof RelationalUniqueConstraint)) break;
                        RelationalUniqueConstraint index = (RelationalUniqueConstraint)element;
                        String value = index.getName();
                        if (!index.getColumns().isEmpty()) {
                            int i = 0;
                            value = String.valueOf(value) + " : ";
                            for (RelationalColumn col : index.getColumns()) {
                                value = String.valueOf(value) + col.getName();
                                if (++i >= index.getColumns().size()) continue;
                                value = String.valueOf(value) + ", ";
                            }
                        }
                        return value;
                    }
                }
            }
            return "";
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/unique-constraint.png");
            }
            return null;
        }
    }
}

