/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.extension;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.ModelExtensionAssistantAggregator;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionConstants;
import org.teiid.designer.metamodels.relational.extension.RestModelExtensionConstants;
import org.teiid.designer.relational.ui.Messages;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.relational.ui.UiPlugin;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class RelationalExtensionVersionResolution
implements IMarkerResolution {
    private String medID;

    public RelationalExtensionVersionResolution(String medID) {
        this.medID = medID;
    }

    public String getLabel() {
        return Messages.upgradeRelationalExtensionsLabel;
    }

    public void run(IMarker marker) {
        IResource resource = marker.getResource();
        if (ModelUtilities.isModelFile((IResource)resource)) {
            final IFile theFile = (IFile)resource;
            final ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)theFile, (boolean)false);
            if (editor != null && editor.isDirty()) {
                boolean saveEditor = MessageDialog.openQuestion((Shell)RelationalExtensionVersionResolution.getShell(), (String)Messages.quickFixModelDirtyTitle, (String)Messages.quickFixModelDirtyMsg);
                if (!saveEditor) {
                    return;
                }
                UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                        RelationalExtensionVersionResolution.this.fixModelMed(theFile);
                    }
                });
                return;
            }
            UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    RelationalExtensionVersionResolution.this.fixModelMed(theFile);
                }
            });
        }
    }

    private void fixModelMed(IFile modelFile) {
        String nsPrefix;
        ModelExtensionAssistantAggregator aggregator = ExtensionPlugin.getInstance().getModelExtensionAssistantAggregator();
        try {
            aggregator.getSupportedNamespacePrefixes((Object)modelFile);
        }
        catch (Exception e) {
            UiConstants.Util.log(4, (Throwable)e, NLS.bind((String)Messages.getSupportedPrefixesErrorMsg, (Object)modelFile.getName()));
            return;
        }
        boolean modelNeedsSave = false;
        ModelExtensionAssistant assistant = null;
        if (this.medID.equalsIgnoreCase("relational")) {
            nsPrefix = RelationalModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix();
            assistant = ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(nsPrefix);
        } else if (this.medID.equalsIgnoreCase("rest")) {
            nsPrefix = RestModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix();
            assistant = ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(nsPrefix);
        }
        if (assistant == null) {
            UiConstants.Util.log(4, String.valueOf(this.medID) + " MED not found in model" + modelFile.getName());
            return;
        }
        ModelObjectExtensionAssistant mAssistant = (ModelObjectExtensionAssistant)assistant;
        try {
            mAssistant.getModelExtensionDefinition((Object)modelFile);
        }
        catch (Exception e) {
            UiConstants.Util.log(4, (Throwable)e, NLS.bind((String)Messages.getModelMedErrorMsg, (Object)modelFile.getName()));
            return;
        }
        boolean medChanged = true;
        if (medChanged) {
            try {
                mAssistant.saveModelExtensionDefinition((Object)modelFile);
            }
            catch (Exception e) {
                UiConstants.Util.log(4, (Throwable)e, NLS.bind((String)Messages.saveModelMedErrorMsg, (Object)modelFile.getName()));
            }
            modelNeedsSave = true;
        }
        if (modelNeedsSave) {
            try {
                ModelResource mdlResc = ModelUtilities.getModelResourceForIFile((IFile)modelFile, (boolean)false);
                if (mdlResc != null) {
                    mdlResc.save((IProgressMonitor)new NullProgressMonitor(), true);
                }
                modelFile.deleteMarkers("org.teiid.designer.relational.ui.medMarker", true, 2);
                modelFile.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                UiConstants.Util.log(4, (Throwable)e, NLS.bind((String)Messages.saveModelErrorMsg, (Object)modelFile.getName()));
            }
        }
    }

    private void fixMedFile(IFile medFile) {
    }

    private boolean updateMed(ModelExtensionDefinition med) {
        boolean wasChanged = false;
        return wasChanged;
    }

    private ModelExtensionDefinition parse(InputStream mxdContents) {
        ModelExtensionDefinition med = null;
        try {
            med = ExtensionPlugin.getInstance().parse(mxdContents);
        }
        catch (Exception exception) {
            UiConstants.Util.log((Object)Messages.medFileParseErrorMsg);
        }
        return med;
    }

    private static Shell getShell() {
        return UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }
}

