/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.textimport;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.jdbc.relational.impl.RelationalModelProcessorImpl;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.util.RelationalTypeMapping;

public class AllRelationalModelProcessor
extends RelationalModelProcessorImpl {
    private static final String VARCHAR2_TYPE_NAME = "VARCHAR2";
    private static final String NVARCHAR2_TYPE_NAME = "NVARCHAR2";
    private static final String TIMESTAMP_TYPE_NAME = "TIMESTAMP(";

    public AllRelationalModelProcessor(RelationalFactory factory, RelationalTypeMapping mapping) {
        super(factory, mapping);
        this.setDatatypeManager(ModelerCore.getWorkspaceDatatypeManager());
    }

    protected EObject findType(int jdbcType, String typeName, int length, int precision, int scale, List problems) {
        EObject result = null;
        if (typeName.startsWith(TIMESTAMP_TYPE_NAME)) {
            result = this.findBuiltinType("timestamp", problems);
        }
        if (result != null) {
            return result;
        }
        return super.findType(jdbcType, typeName, length, precision, scale, problems);
    }

    protected EObject findType(String jdbcTypeName, List problems) {
        String standardName = jdbcTypeName;
        if (VARCHAR2_TYPE_NAME.equalsIgnoreCase(jdbcTypeName) || NVARCHAR2_TYPE_NAME.equalsIgnoreCase(jdbcTypeName)) {
            standardName = "VARCHAR";
        }
        return super.findType(standardName, problems);
    }

    protected boolean isFixedLength(int type, String typeName) {
        if (NVARCHAR2_TYPE_NAME.equalsIgnoreCase(typeName)) {
            return false;
        }
        return super.isFixedLength(type, typeName);
    }
}

