/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.textimport;

import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.util.RelationalTypeMappingImpl;
import org.teiid.designer.relational.ui.textimport.AllRelationalModelProcessor;
import org.teiid.designer.relational.ui.textimport.BaseTableRowObject;
import org.teiid.designer.relational.ui.textimport.ColumnRowObject;
import org.teiid.designer.relational.ui.textimport.IndexRowObject;
import org.teiid.designer.tools.textimport.ui.wizards.AbstractRowObject;
import org.teiid.designer.tools.textimport.ui.wizards.IRowObject;

public class RelationalRowFactory {
    private static final String NUMBER = "NUMBER";
    public static final int UNKNOWN = -1;
    public static final int CATALOG = 2;
    public static final int SCHEMA = 3;
    public static final int BASE_TABLE = 10;
    public static final int VIEW = 11;
    public static final int INDEX = 12;
    public static final int COLUMN = 13;
    public static final int UNIQUE_KEY = 14;
    public static final int PRIMARY_KEY = 15;
    public static final String BASE_TABLE_STRING = "TABLE";
    public static final String VIEW_STRING = "VIEW";
    public static final String INDEX_STRING = "INDEX";
    public static final String COLUMN_STRING = "COLUMN";
    public static final String UNIQUE_KEY_STRING = "UNIQUEKEY";
    public static final String PRIMARY_KEY_STRING = "PRIMARYKEY";
    public static final String SCHEMA_STRING = "SCHEMA";
    public static final String CATALOG_STRING = "CATALOG";
    private static final char COMMA = ',';
    private static final AllRelationalModelProcessor processor = new AllRelationalModelProcessor(RelationalFactory.eINSTANCE, RelationalTypeMappingImpl.getInstance());

    public IRowObject createRowObject(String rawString) {
        AbstractRowObject newRowObject = null;
        int commaIndex = rawString.indexOf(44);
        if (commaIndex == -1 || commaIndex >= rawString.length()) {
            return null;
        }
        String typeString = rawString.substring(0, commaIndex).trim();
        String restOfRow = rawString.substring(commaIndex + 1);
        int objectType = this.getObjectType(typeString);
        switch (objectType) {
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 10: {
                newRowObject = new BaseTableRowObject(restOfRow);
                break;
            }
            case 12: {
                newRowObject = new IndexRowObject(restOfRow);
                break;
            }
            case 13: {
                newRowObject = new ColumnRowObject(restOfRow);
            }
        }
        if (newRowObject != null) {
            newRowObject.setRawString(rawString);
            newRowObject.parseRow();
        }
        return newRowObject;
    }

    private int getObjectType(String type) {
        if (type.equals(BASE_TABLE_STRING)) {
            return 10;
        }
        if (type.equals(VIEW_STRING)) {
            return 11;
        }
        if (type.equals(COLUMN_STRING)) {
            return 13;
        }
        if (type.equals(INDEX_STRING)) {
            return 12;
        }
        if (type.equals(UNIQUE_KEY_STRING)) {
            return 14;
        }
        if (type.equals(PRIMARY_KEY_STRING)) {
            return 15;
        }
        if (type.equals(SCHEMA_STRING)) {
            return 3;
        }
        if (type.equals(CATALOG_STRING)) {
            return 2;
        }
        return -1;
    }

    public static EObject getDataType(String someType, int length, int precision, int scale) {
        EObject bidt = null;
        LinkedList problems = new LinkedList();
        bidt = someType.equalsIgnoreCase(NUMBER) ? processor.findType(2, someType, length, precision, scale, problems) : processor.findType(someType, problems);
        return bidt;
    }
}

