/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.textimport;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.uml.UmlDiagramAspect;
import org.teiid.designer.core.metamodel.aspect.uml.UmlPackage;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class RelationalTableLocationSelectionValidator
implements ISelectionStatusValidator,
UiConstants {
    private StatusInfo stStatus;
    private static final String WRONG_CLASS_ERROR_MSG = Util.getString("RelationalTableLocationSelectionValidator.wrongClassErrorMessage.text", new Object[0]);
    private static final String CONTAINER_READONLY_ERROR_MSG = Util.getString("RelationalTableLocationSelectionValidator.containerReadOnlyErrorMessage.text", new Object[0]);
    private static final String CONTAINER_OBJECT_READONLY_ERROR_MSG = Util.getString("RelationalTableLocationSelectionValidator.containerObjectReadOnlyErrorMessage.text", new Object[0]);
    private static final String CONTAINER_MODEL_READONLY_ERROR_MSG = Util.getString("RelationalTableLocationSelectionValidator.containerModelReadOnlyErrorMessage.text", new Object[0]);
    private static final String NOTHING_SELECTED = Util.getString("RelationalTableLocationSelectionValidator.wrongClassErrorMessage.text", new Object[0]);

    public IStatus validate(Object[] selection) {
        if (selection == null || selection.length == 0) {
            return new StatusInfo("org.teiid.designer.relational.ui", 4, NOTHING_SELECTED);
        }
        boolean bAllAreValid = true;
        int i = 0;
        while (i < selection.length) {
            if (!(this.isRelationshipContainer(selection[i]) || this.isRelationshipModelResource(selection[i]) || this.isContainer(selection[i]))) {
                bAllAreValid = false;
                this.stStatus = new StatusInfo("org.teiid.designer.relational.ui", 4, WRONG_CLASS_ERROR_MSG);
                break;
            }
            ++i;
        }
        if (bAllAreValid) {
            i = 0;
            while (i < selection.length) {
                if (!this.containerIsModifiable(selection[i])) {
                    Object theSelection = selection[i];
                    String msg = CONTAINER_READONLY_ERROR_MSG;
                    if (theSelection instanceof ModelResource) {
                        msg = CONTAINER_MODEL_READONLY_ERROR_MSG;
                    } else if (theSelection instanceof IFile) {
                        msg = CONTAINER_MODEL_READONLY_ERROR_MSG;
                    } else if (this.isRelationshipContainer(selection[i])) {
                        msg = CONTAINER_OBJECT_READONLY_ERROR_MSG;
                    }
                    bAllAreValid = false;
                    this.stStatus = new StatusInfo("org.teiid.designer.relational.ui", 4, msg);
                    break;
                }
                ++i;
            }
        }
        if (bAllAreValid) {
            this.stStatus = new StatusInfo("org.teiid.designer.relational.ui", 0, "");
        }
        return this.stStatus;
    }

    private boolean isRelationshipContainer(Object oSelection) {
        ModelResource mr;
        boolean bResult = false;
        if (oSelection instanceof EObject && (mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)oSelection))) != null) {
            try {
                UmlDiagramAspect dAspect;
                MetamodelDescriptor descriptor = mr.getPrimaryMetamodelDescriptor();
                if (descriptor != null && descriptor.getNamespaceURI().equals("http://www.metamatrix.com/metamodels/Relational") && (dAspect = AspectManager.getUmlDiagramAspect((EObject)((EObject)oSelection))) instanceof UmlPackage) {
                    bResult = true;
                }
            }
            catch (ModelWorkspaceException mwe) {
                ModelerCore.Util.log(4, (Throwable)mwe, mwe.getMessage());
            }
        }
        return bResult;
    }

    private boolean isRelationshipModelResource(Object oSelection) {
        boolean bResult = false;
        if (oSelection instanceof IResource) {
            try {
                MetamodelDescriptor descriptor;
                ModelResource mr;
                IResource resource = (IResource)oSelection;
                if (ModelUtilities.isModelFile((IResource)resource) && (mr = ModelUtil.getModelResource((IFile)((IFile)resource), (boolean)true)) != null && ModelUtilities.isVirtual((ModelResource)mr) && (descriptor = mr.getPrimaryMetamodelDescriptor()) != null && descriptor.getNamespaceURI().equals("http://www.metamatrix.com/metamodels/Relational")) {
                    bResult = true;
                }
            }
            catch (ModelWorkspaceException mwe) {
                ModelerCore.Util.log(4, (Throwable)mwe, mwe.getMessage());
            }
        }
        return bResult;
    }

    private boolean isContainer(Object oSelection) {
        return oSelection instanceof IContainer;
    }

    private boolean containerIsModifiable(Object oSelection) {
        boolean bResult = false;
        ModelResource mr = null;
        if (this.isRelationshipModelResource(oSelection)) {
            try {
                mr = ModelUtil.getModelResource((IFile)((IFile)oSelection), (boolean)true);
            }
            catch (ModelWorkspaceException mwe) {
                ModelerCore.Util.log(4, (Throwable)mwe, mwe.getMessage());
            }
        } else if (this.isRelationshipContainer(oSelection)) {
            mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)oSelection));
        } else if (this.isContainer(oSelection)) {
            return !ModelUtil.isIResourceReadOnly((IResource)((IContainer)oSelection));
        }
        bResult = !ModelUtilities.isReadOnly((ModelResource)mr);
        return bResult;
    }
}

