/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.webservice;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.relational.ui.webservice.WebServiceRelationalModelWizardPage;
import org.teiid.designer.ui.wizards.INewModelWizardContributor;

public class WebServiceRelationalModelContributor
implements INewModelWizardContributor {
    public static final String RELATIONAL_PACKAGE_URI = "http://www.metamatrix.com/metamodels/Relational";
    public static final RelationalFactory factory = RelationalFactory.eINSTANCE;
    public static final DatatypeManager datatypeManager = ModelerCore.getWorkspaceDatatypeManager();
    private static boolean isTransactionable = ModelerCore.getPlugin() != null;
    private IWizardPage[] pages;
    private WebServiceRelationalModelWizardPage webServiceProcedures;

    public boolean canFinishEarly(IWizardPage theCurrentPage) {
        return false;
    }

    public void createWizardPages(ISelection selection, IResource targetResource, IPath targetFilePath, MetamodelDescriptor descriptor, boolean isVirtual) {
        this.pages = new IWizardPage[1];
        this.webServiceProcedures = new WebServiceRelationalModelWizardPage("webServiceProceduresPage");
        this.pages[0] = this.webServiceProcedures;
    }

    public void currentPageChanged(IWizardPage page) {
    }

    public void doCancel() {
    }

    public void doFinish(ModelResource modelResource, IProgressMonitor monitor) {
        block11: {
            String transactionName = UiConstants.Util.getString("WebServiceRelationalModelContributor.transactionName", new Object[0]);
            boolean started = ModelerCore.startTxn((String)transactionName, (Object)this);
            boolean succeeded = false;
            try {
                try {
                    if (this.webServiceProcedures.doGenerateInvoke()) {
                        this.addInvokeProcedure(modelResource);
                    }
                    if (this.webServiceProcedures.doGenerateInvokeHttp()) {
                        this.addInvokeHttpProcedure(modelResource);
                    }
                    succeeded = true;
                }
                catch (Exception ex) {
                    String message = UiConstants.Util.getString("WebServiceRelationalModelContributor.doFinishError", (Object)modelResource.getItemName());
                    UiConstants.Util.log(4, (Throwable)ex, message);
                    if (!started) break block11;
                    if (succeeded) {
                        ModelerCore.commitTxn();
                        break block11;
                    }
                    ModelerCore.rollbackTxn();
                }
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    private void addInvokeProcedure(ModelResource mr) throws ModelerCoreException {
        EObject stringType = datatypeManager.findDatatype("string");
        EObject booleanType = datatypeManager.findDatatype("boolean");
        EObject xmlLiteralType = datatypeManager.findDatatype("XMLLiteral");
        Procedure proc = factory.createProcedure();
        proc.setName("invoke");
        ProcedureParameter param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("binding");
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (stringType != null) {
            param.setType(stringType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("action");
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (stringType != null) {
            param.setType(stringType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("request");
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (xmlLiteralType != null) {
            param.setType(xmlLiteralType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("endpoint");
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (stringType != null) {
            param.setType(stringType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("stream");
        param.setDirection(DirectionKind.IN_LITERAL);
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (booleanType != null) {
            param.setType(booleanType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("result");
        param.setProcedure(proc);
        param.setDirection(DirectionKind.RETURN_LITERAL);
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (xmlLiteralType != null) {
            param.setType(xmlLiteralType);
        }
        this.addValue(mr, proc, this.getModelResourceContents(mr));
    }

    private void addInvokeHttpProcedure(ModelResource mr) throws ModelerCoreException {
        EObject stringType = datatypeManager.findDatatype("string");
        EObject blobType = datatypeManager.findDatatype("blob");
        EObject booleanType = datatypeManager.findDatatype("boolean");
        EObject objectType = datatypeManager.findDatatype("object");
        EObject clobType = datatypeManager.findDatatype("clob");
        Procedure proc = factory.createProcedure();
        proc.setName("invokeHttp");
        ProcedureParameter param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("action");
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (stringType != null) {
            param.setType(stringType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("request");
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (objectType != null) {
            param.setType(objectType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("endpoint");
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (objectType != null) {
            param.setType(stringType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("stream");
        param.setDirection(DirectionKind.IN_LITERAL);
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (booleanType != null) {
            param.setType(booleanType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("result");
        param.setProcedure(proc);
        param.setDirection(DirectionKind.RETURN_LITERAL);
        if (blobType != null) {
            param.setType(blobType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("contentType");
        param.setDirection(DirectionKind.OUT_LITERAL);
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (stringType != null) {
            param.setType(stringType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("headers");
        param.setDirection(DirectionKind.OUT_LITERAL);
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (stringType != null) {
            param.setType(clobType);
        }
        this.addValue(mr, proc, this.getModelResourceContents(mr));
    }

    private void addValue(Object owner, Object value, EList feature) {
        try {
            if (isTransactionable) {
                ModelerCore.getModelEditor().addValue(owner, value, feature);
            } else {
                feature.add(value);
            }
        }
        catch (ModelerCoreException err) {
            UiConstants.Util.log(4, (Throwable)err, UiConstants.Util.getString("FlatFileRelationalModelContributor.addValueError", new Object[]{value, owner}));
        }
    }

    private EList getModelResourceContents(ModelResource resource) {
        EList eList = null;
        try {
            eList = resource.getEmfResource().getContents();
        }
        catch (ModelWorkspaceException e) {
            UiConstants.Util.log(4, (Throwable)e, UiConstants.Util.getString("FlatFileRelationalModelContributor.getModelContentsError", (Object)resource.getItemName()));
        }
        return eList;
    }

    public IWizardPage[] getWizardPages() {
        return this.pages;
    }

    public void inputChanged(ISelection selection, IResource targetResource, MetamodelDescriptor descriptor, boolean isVirtual) {
    }

    public ModelResource getSelectedModelResource() {
        return null;
    }

    public boolean copyAllDescriptions() {
        return false;
    }
}

