/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.progress.IProgressConstants;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.relational.ui.UiPlugin;
import org.teiid.designer.relational.ui.textimport.RelationalModelSelectorDialog;
import org.teiid.designer.relational.ui.textimport.RelationalTableLocationSelectionValidator;
import org.teiid.designer.relational.ui.wizards.RelationalObjectProcessor;
import org.teiid.designer.tools.textimport.ui.wizards.AbstractObjectProcessor;
import org.teiid.designer.tools.textimport.ui.wizards.ITextImportMainPage;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.IListPanelController;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class ImportRelationalTablesMainPage
extends WizardDataTransferPage
implements IListPanelController,
ITextImportMainPage {
    public static final String IMPORT_ID = ImportRelationalTablesMainPage.getString("textImport.comboText");
    public static final String IMPORT_DESC = ImportRelationalTablesMainPage.getString("textImport.descriptionText");
    public static final String IMPORT_DATA = ImportRelationalTablesMainPage.getString("textImport.sampleData");
    protected Combo sourceNameField;
    protected Button sourceBrowseButton;
    private Text modelFolderNameField;
    private Button modelFolderBrowseButton;
    private Button chkDefaultToString;
    private boolean useStringDefaultDatatype = false;
    private EObject defaultDatatype;
    private int defaultLength = 255;
    private ListViewer listViewer;
    private ModelResource targetResource;
    private Object targetLocation;
    private Collection rows = Collections.EMPTY_LIST;
    RelationalObjectProcessor relationalObjectProcessor = new RelationalObjectProcessor();
    boolean entryChanged = false;
    private boolean initializing = false;
    public static final int OPEN_READ = 1;
    private static final String BROWSE_SHORTHAND = "Browse...";
    private static final String FILE_IMPORT_MASK = "*.csv;*.txt";
    private static final String I18N_PREFIX = "ImportRelationalTablesMainPage";
    private static final String SEPARATOR = ".";
    private static final String INITIAL_MESSAGE = ImportRelationalTablesMainPage.getString("initialMessage");
    private static final String PAGE_TITLE = ImportRelationalTablesMainPage.getString("pageTitle");
    private static final String STORE_SOURCE_NAMES_ID = ImportRelationalTablesMainPage.getString("storeSourceNamesId");
    private static final int LARGE_ROWS = 10000;

    static String getString(String id) {
        return UiConstants.Util.getString("ImportRelationalTablesMainPage." + id, new Object[0]);
    }

    public ImportRelationalTablesMainPage(IStructuredSelection selection) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
    }

    public ImportRelationalTablesMainPage() {
        this(null);
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    public void handleEvent(Event event) {
        if (!this.initializing) {
            boolean validate = false;
            if (event.widget == this.sourceBrowseButton) {
                this.handleSourceBrowseButtonPressed();
                validate = true;
            }
            if (event.widget == this.modelFolderBrowseButton) {
                this.handleModelFolderBrowseButtonPressed();
                validate = true;
            }
            if (event.widget == this.sourceNameField || event.widget == this.modelFolderNameField) {
                validate = true;
            }
            if (validate) {
                this.setCompletionStatus();
            }
            this.updateWidgetEnablements();
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createSourceGroup(composite);
        this.createDestinationGroup(composite);
        this.createWorkspaceListGroup(composite);
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(false);
        this.setMessage(INITIAL_MESSAGE);
        this.setControl((Control)composite);
    }

    protected void createSourceGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setFont(parent.getFont());
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label(sourceContainerGroup, 0);
        groupLabel.setText(ImportRelationalTablesMainPage.getString("groupLabel"));
        groupLabel.setFont(parent.getFont());
        this.sourceNameField = new Combo(sourceContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceNameField.setFont(parent.getFont());
        this.sourceNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportRelationalTablesMainPage.this.updateFromSourceField();
                ImportRelationalTablesMainPage.this.setCompletionStatus();
            }
        });
        this.sourceNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                ImportRelationalTablesMainPage.this.entryChanged = true;
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.sourceNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ImportRelationalTablesMainPage.this.entryChanged) {
                    ImportRelationalTablesMainPage.this.entryChanged = false;
                }
            }
        });
        this.sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.sourceBrowseButton.setText(ImportRelationalTablesMainPage.getString("browse_1"));
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.sourceBrowseButton);
    }

    private void createWorkspaceListGroup(Composite parent) {
        Label messageLabel = new Label(parent, 0);
        messageLabel.setText(ImportRelationalTablesMainPage.getString("modelListMessage"));
        messageLabel.setFont(parent.getFont());
        this.listViewer = new ListViewer(parent);
        GridData data = new GridData(1808);
        this.listViewer.getControl().setLayoutData((Object)data);
    }

    protected void createDestinationGroup(Composite parent) {
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        containerGroup.setFont(parent.getFont());
        Label resourcesLabel = new Label(containerGroup, 0);
        resourcesLabel.setText(ImportRelationalTablesMainPage.getString("targetLocation"));
        resourcesLabel.setFont(parent.getFont());
        this.modelFolderNameField = new Text(containerGroup, 2052);
        this.modelFolderNameField.addListener(24, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.modelFolderNameField.setLayoutData((Object)data);
        this.modelFolderNameField.setFont(parent.getFont());
        this.modelFolderNameField.setEditable(false);
        this.modelFolderBrowseButton = new Button(containerGroup, 8);
        this.modelFolderBrowseButton.setText(BROWSE_SHORTHAND);
        this.modelFolderBrowseButton.setLayoutData((Object)new GridData(256));
        this.modelFolderBrowseButton.addListener(13, (Listener)this);
        this.modelFolderBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.modelFolderBrowseButton);
    }

    protected void createOptionsGroup(Composite parent) {
        Group optionsGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        optionsGroup.setText(ImportRelationalTablesMainPage.getString("options"));
        optionsGroup.setFont(parent.getFont());
        WidgetFactory.createLabel((Composite)optionsGroup, (int)0, (String)ImportRelationalTablesMainPage.getString("label.defaultToString"));
        this.chkDefaultToString = WidgetFactory.createCheckBox((Composite)optionsGroup, (String)"", (int)0, (int)1);
        this.chkDefaultToString.setToolTipText(ImportRelationalTablesMainPage.getString("checkbox.defaultToString"));
        this.chkDefaultToString.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                ImportRelationalTablesMainPage.this.handleDefaultToStringSelected(theEvent);
            }
        });
    }

    void handleDefaultToStringSelected(SelectionEvent theEvent) {
        this.useStringDefaultDatatype = ((Button)theEvent.getSource()).getSelection();
        if (this.useStringDefaultDatatype) {
            try {
                this.defaultDatatype = ModelerCore.getWorkspaceDatatypeManager().findDatatype("STRING");
            }
            catch (ModelerCoreException modelerCoreException) {}
        }
    }

    protected void handleSourceBrowseButtonPressed() {
        String selectedFile = this.queryFileToImport();
        this.clearListViewer();
        if (selectedFile != null && !selectedFile.equals(this.sourceNameField.getText())) {
            this.sourceNameField.setText(selectedFile);
            this.rows = this.relationalObjectProcessor.loadLinesFromFile(this.sourceNameField.getText());
            this.loadListViewer(this.rows);
        }
    }

    protected void updateFromSourceField() {
        this.clearListViewer();
        this.rows = this.relationalObjectProcessor.loadLinesFromFile(this.sourceNameField.getText());
        this.loadListViewer(this.rows);
    }

    protected String queryFileToImport() {
        FileDialog dialog = new FileDialog(this.sourceNameField.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{FILE_IMPORT_MASK});
        String currentSourceString = this.sourceNameField.getText();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        return dialog.open();
    }

    protected void handleModelFolderBrowseButtonPressed() {
        Object[] oSelectedObjects;
        RelationalModelSelectorDialog mwdDialog = new RelationalModelSelectorDialog(UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell());
        mwdDialog.setValidator(new RelationalTableLocationSelectionValidator());
        mwdDialog.setAllowMultiple(false);
        mwdDialog.open();
        if (mwdDialog.getReturnCode() == 0 && (oSelectedObjects = mwdDialog.getResult()).length > 0) {
            this.setObjectLocation(oSelectedObjects[0]);
        }
    }

    private void setObjectLocation(Object oLocation) {
        if (oLocation instanceof IFile) {
            this.modelFolderNameField.setText(((IFile)oLocation).getName());
            try {
                this.targetResource = ModelUtil.getModelResource((IFile)((IFile)oLocation), (boolean)false);
                this.targetLocation = this.targetResource;
            }
            catch (ModelWorkspaceException modelWorkspaceException) {}
        } else if (oLocation instanceof EObject) {
            EObject eObj = (EObject)oLocation;
            this.targetLocation = eObj;
            this.targetResource = ModelUtilities.getModelResourceForModelObject((EObject)eObj);
            String locationStr = String.valueOf(this.targetResource.getItemName()) + '/' + ModelObjectUtilities.getRelativePath((EObject)eObj);
            this.modelFolderNameField.setText(locationStr);
        } else if (oLocation instanceof ModelResource) {
            this.targetResource = (ModelResource)oLocation;
            this.targetLocation = this.targetResource;
            String locationStr = this.targetResource.getItemName();
            this.modelFolderNameField.setText(locationStr);
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void setMessage(String newMessage) {
        super.setMessage(newMessage);
    }

    boolean setCompletionStatus() {
        if (this.validateSource() && this.validateDestination()) {
            this.setErrorMessage(null);
            this.setMessage(INITIAL_MESSAGE);
            this.setPageComplete(true);
            return true;
        }
        this.setPageComplete(false);
        return false;
    }

    private boolean validateDestination() {
        if (this.targetResource == null) {
            this.setErrorMessage(ImportRelationalTablesMainPage.getString("noValidLocationSelectedMessage"));
            return false;
        }
        return true;
    }

    private boolean validateSource() {
        if (this.sourceNameField == null) {
            this.setErrorMessage(ImportRelationalTablesMainPage.getString("noValidSourceSelectedMessage"));
            return false;
        }
        return true;
    }

    public boolean finish() {
        this.saveWidgetValues();
        Collection tableRows = this.relationalObjectProcessor.createRowObjsFromStrings(this.rows);
        if (!tableRows.isEmpty() && this.relationalObjectProcessor.confirmLargeImport(this.getShell(), tableRows.size(), 10000)) {
            this.generateWithJob(tableRows);
        }
        return true;
    }

    boolean execute(Collection tableRows, IProgressMonitor monitor) {
        boolean succeeded;
        block16: {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)ImportRelationalTablesMainPage.getString("transactionTitle"), (Object)((Object)this));
            succeeded = false;
            try {
                try {
                    this.relationalObjectProcessor.generateObjsFromRowObjs(this.targetResource, this.targetLocation, tableRows, this.useStringDefaultDatatype, this.defaultDatatype, this.defaultLength);
                    succeeded = true;
                }
                catch (Exception ex) {
                    UiConstants.Util.log(4, (Throwable)ex, ImportRelationalTablesMainPage.getString("importError"));
                    if (requiredStart) {
                        if (succeeded && !monitor.isCanceled()) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (requiredStart) {
                    if (succeeded && !monitor.isCanceled()) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                throw throwable;
            }
            if (requiredStart) {
                if (succeeded && !monitor.isCanceled()) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        if (succeeded) {
            ModelEditorManager.activate((ModelResource)this.targetResource, (boolean)true);
            ArrayList otherModifiedResources = new ArrayList(this.relationalObjectProcessor.getOtherModifiedResources());
            Iterator iter = otherModifiedResources.iterator();
            while (iter.hasNext()) {
                ModelEditorManager.activate((ModelResource)((ModelResource)iter.next()), (boolean)true);
            }
        }
        return succeeded;
    }

    private boolean generateWithJob(final Collection tableRows) {
        final String message = ImportRelationalTablesMainPage.getString("progressTitle");
        Job job = new Job(message){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(message, tableRows.size());
                    if (!monitor.isCanceled()) {
                        ImportRelationalTablesMainPage.this.relationalObjectProcessor.setProgressMonitor(monitor);
                        ImportRelationalTablesMainPage.this.execute(tableRows, monitor);
                    }
                    monitor.done();
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    return new Status(0, "org.teiid.designer.relational.ui", 0, AbstractObjectProcessor.FINISHED, null);
                }
                catch (Exception e) {
                    UiConstants.Util.log((Throwable)e);
                    return new Status(4, "org.teiid.designer.relational.ui", 4, ImportRelationalTablesMainPage.getString("createError"), (Throwable)e);
                }
            }
        };
        job.setSystem(false);
        job.setUser(true);
        job.setProperty(IProgressConstants.KEEP_PROPERTY, (Object)Boolean.TRUE);
        job.schedule();
        return true;
    }

    private void clearListViewer() {
        List contents = this.listViewer.getList();
        Object[] items = contents.getItems();
        this.listViewer.remove(items);
    }

    private void loadListViewer(Collection rows) {
        for (String rowStr : rows) {
            this.listViewer.add((Object)rowStr);
        }
    }

    public Object[] addButtonSelected() {
        return null;
    }

    public void downButtonSelected(IStructuredSelection selection) {
    }

    public Object editButtonSelected(IStructuredSelection selection) {
        return null;
    }

    public void itemsSelected(IStructuredSelection selection) {
    }

    public Object[] removeButtonSelected(IStructuredSelection selection) {
        return null;
    }

    public void upButtonSelected(IStructuredSelection selection) {
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        WidgetUtil.removeMissingResources((IDialogSettings)settings, (String)STORE_SOURCE_NAMES_ID);
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                this.sourceNameField.add(sourceNames[i]);
                ++i;
            }
        }
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.sourceNameField.getText());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
        }
    }

    public String getComboText() {
        return IMPORT_ID;
    }

    public String getDescriptionText() {
        return IMPORT_DESC;
    }

    public String getSampleDataText() {
        return IMPORT_DATA;
    }

    public String getType() {
        return IMPORT_ID;
    }
}

