/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.progress.IProgressConstants;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.relational.ui.UiPlugin;
import org.teiid.designer.relational.ui.textimport.RelationalModelSelectorDialog;
import org.teiid.designer.relational.ui.wizards.RelationalModelLocationSelectionValidator;
import org.teiid.designer.relational.ui.wizards.RelationalModelXmlTextFileProcessor;
import org.teiid.designer.tools.textimport.ui.wizards.AbstractObjectProcessor;
import org.teiid.designer.tools.textimport.ui.wizards.ITextImportMainPage;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.ListContentProvider;
import org.teiid.designer.ui.common.widget.IListPanelController;
import org.teiid.designer.ui.editors.ModelEditorManager;

public class RelationalModelTextImporterMainPage
extends WizardDataTransferPage
implements IListPanelController,
ITextImportMainPage {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(RelationalModelTextImporterMainPage.class);
    public static final String IMPORT_ID = RelationalModelTextImporterMainPage.getString("textImport.comboText");
    public static final String IMPORT_DESC = RelationalModelTextImporterMainPage.getString("textImport.descriptionText");
    public static final String IMPORT_DATA = RelationalModelTextImporterMainPage.getString("textImport.sampleData");
    protected Combo sourceNameField;
    protected Button sourceBrowseButton;
    private Text modelFolderNameField;
    private Button modelFolderBrowseButton;
    private ListViewer listViewer;
    private ModelResource targetResource;
    private Object targetLocation;
    private Collection rows = Collections.EMPTY_LIST;
    RelationalModelXmlTextFileProcessor relationalProcessor = new RelationalModelXmlTextFileProcessor();
    boolean entryChanged = false;
    private boolean initializing = false;
    public static final int OPEN_READ = 1;
    private static final String BROWSE_SHORTHAND = "Browse...";
    private static final String FILE_IMPORT_MASK = "*.xml";
    private static final String INITIAL_MESSAGE = RelationalModelTextImporterMainPage.getString("initialMessage");
    private static final String PAGE_TITLE = RelationalModelTextImporterMainPage.getString("pageTitle");
    private static final String STORE_SOURCE_NAMES_ID = RelationalModelTextImporterMainPage.getString("storeSourceNamesId");
    static final String OVERWRITE_TITLE = UiConstants.Util.getString("OverwriteObjectsDialog.duplicateObjectsExistTitle", new Object[0]);
    static final String OVERWRITE_OPTIONS = UiConstants.Util.getString("OverwriteObjectsDialog.optionsGroup", new Object[0]);
    static final String OVERWRITE_REPLACE = UiConstants.Util.getString("OverwriteObjectsDialog.replaceExistingObjectsButton", new Object[0]);
    static final String OVERWRITE_CREATE = UiConstants.Util.getString("OverwriteObjectsDialog.createNewObjectsButton", new Object[0]);
    static final String OVERWRITE_CANCEL = UiConstants.Util.getString("OverwriteObjectsDialog.cancelImportButton", new Object[0]);
    static final String OVERWRITE_DUPLICATE_OBJECTS = UiConstants.Util.getString("OverwriteObjectsDialog.duplicateObjectsGroup", new Object[0]);

    static String getString(String id) {
        return UiConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    static String getString(String id, Object param) {
        return UiConstants.Util.getString(String.valueOf(I18N_PREFIX) + id, param);
    }

    public RelationalModelTextImporterMainPage(IStructuredSelection selection) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
    }

    public RelationalModelTextImporterMainPage() {
        this(null);
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    public void handleEvent(Event event) {
        if (!this.initializing) {
            boolean validate = false;
            if (event.widget == this.sourceBrowseButton) {
                this.handleSourceBrowseButtonPressed();
                validate = true;
            }
            if (event.widget == this.modelFolderBrowseButton) {
                this.handleModelFolderBrowseButtonPressed();
                validate = true;
            }
            if (event.widget == this.sourceNameField || event.widget == this.modelFolderNameField) {
                validate = true;
            }
            if (validate) {
                this.setCompletionStatus();
            }
            this.updateWidgetEnablements();
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createSourceGroup(composite);
        this.createDestinationGroup(composite);
        this.createWorkspaceListGroup(composite);
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(false);
        this.setMessage(INITIAL_MESSAGE);
        this.setControl((Control)composite);
    }

    protected void createSourceGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setFont(parent.getFont());
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label(sourceContainerGroup, 0);
        groupLabel.setText(RelationalModelTextImporterMainPage.getString("groupLabel"));
        groupLabel.setFont(parent.getFont());
        this.sourceNameField = new Combo(sourceContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceNameField.setFont(parent.getFont());
        this.sourceNameField.setBackground(sourceContainerGroup.getBackground());
        this.sourceNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalModelTextImporterMainPage.this.updateFromSourceField();
                RelationalModelTextImporterMainPage.this.setCompletionStatus();
            }
        });
        this.sourceNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                RelationalModelTextImporterMainPage.this.entryChanged = true;
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.sourceNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (RelationalModelTextImporterMainPage.this.entryChanged) {
                    RelationalModelTextImporterMainPage.this.entryChanged = false;
                }
            }
        });
        this.sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.sourceBrowseButton.setText(RelationalModelTextImporterMainPage.getString("browse_1"));
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.sourceBrowseButton);
    }

    private void createWorkspaceListGroup(Composite parent) {
        Label messageLabel = new Label(parent, 0);
        messageLabel.setText(RelationalModelTextImporterMainPage.getString("modelListMessage"));
        messageLabel.setFont(parent.getFont());
        this.listViewer = new ListViewer(parent);
        GridData data = new GridData(1808);
        this.listViewer.getControl().setLayoutData((Object)data);
    }

    protected void createDestinationGroup(Composite parent) {
        Composite containerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        containerGroup.setFont(parent.getFont());
        Label resourcesLabel = new Label(containerGroup, 0);
        resourcesLabel.setText(RelationalModelTextImporterMainPage.getString("targetLocation"));
        resourcesLabel.setFont(parent.getFont());
        this.modelFolderNameField = new Text(containerGroup, 2052);
        this.modelFolderNameField.addListener(24, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.modelFolderNameField.setLayoutData((Object)data);
        this.modelFolderNameField.setFont(parent.getFont());
        this.modelFolderNameField.setEditable(false);
        this.modelFolderNameField.setBackground(containerGroup.getBackground());
        this.modelFolderBrowseButton = new Button(containerGroup, 8);
        this.modelFolderBrowseButton.setText(BROWSE_SHORTHAND);
        this.modelFolderBrowseButton.setLayoutData((Object)new GridData(256));
        this.modelFolderBrowseButton.addListener(13, (Listener)this);
        this.modelFolderBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.modelFolderBrowseButton);
    }

    protected void createOptionsGroup(Composite parent) {
    }

    protected void handleSourceBrowseButtonPressed() {
        String selectedFile = this.queryFileToImport();
        this.clearListViewer();
        if (selectedFile != null && !selectedFile.equals(this.sourceNameField.getText())) {
            this.sourceNameField.setText(selectedFile);
            this.rows = this.relationalProcessor.loadLinesFromFile(this.sourceNameField.getText());
            this.loadListViewer(this.rows);
        }
    }

    protected void updateFromSourceField() {
        this.clearListViewer();
        this.rows = this.relationalProcessor.loadLinesFromFile(this.sourceNameField.getText());
        this.loadListViewer(this.rows);
    }

    protected String queryFileToImport() {
        FileDialog dialog = new FileDialog(this.sourceNameField.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{FILE_IMPORT_MASK});
        String currentSourceString = this.sourceNameField.getText();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        return dialog.open();
    }

    protected void handleModelFolderBrowseButtonPressed() {
        Object[] oSelectedObjects;
        RelationalModelSelectorDialog mwdDialog = new RelationalModelSelectorDialog(UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell());
        mwdDialog.setValidator(new RelationalModelLocationSelectionValidator());
        mwdDialog.setAllowMultiple(false);
        mwdDialog.open();
        if (mwdDialog.getReturnCode() == 0 && (oSelectedObjects = mwdDialog.getResult()).length > 0) {
            this.setObjectLocation(oSelectedObjects[0]);
        }
    }

    private void setObjectLocation(Object oLocation) {
        if (oLocation instanceof IFile) {
            this.modelFolderNameField.setText(((IFile)oLocation).getName());
            try {
                this.targetResource = ModelUtil.getModelResource((IFile)((IFile)oLocation), (boolean)false);
                this.targetLocation = this.targetResource;
            }
            catch (ModelWorkspaceException modelWorkspaceException) {}
        } else if (oLocation instanceof ModelResource) {
            this.targetResource = (ModelResource)oLocation;
            this.targetLocation = this.targetResource;
            String locationStr = this.targetResource.getItemName();
            this.modelFolderNameField.setText(locationStr);
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void setMessage(String newMessage) {
        super.setMessage(newMessage);
    }

    boolean setCompletionStatus() {
        if (this.validateSource() && this.validateProcessor() && this.validateDestination()) {
            this.setErrorMessage(null);
            if (this.relationalProcessor.getStatusInfo().isOK()) {
                this.setMessage(INITIAL_MESSAGE);
            } else if (this.relationalProcessor.getStatusInfo().isWarning()) {
                this.setMessage(this.relationalProcessor.getStatusInfo().getMessage(), 2);
            }
            this.setPageComplete(true);
            return true;
        }
        this.setPageComplete(false);
        return false;
    }

    private boolean validateDestination() {
        if (this.targetResource == null) {
            this.setErrorMessage(RelationalModelTextImporterMainPage.getString("noValidLocationSelectedMessage"));
            return false;
        }
        return true;
    }

    private boolean validateSource() {
        if (this.sourceNameField == null) {
            this.setErrorMessage(RelationalModelTextImporterMainPage.getString("noValidSourceSelectedMessage", this.sourceNameField));
            return false;
        }
        return true;
    }

    private boolean validateProcessor() {
        if (this.relationalProcessor.getStatusInfo().isError()) {
            this.setErrorMessage(this.relationalProcessor.getStatusInfo().getMessage());
            return false;
        }
        if (this.relationalProcessor.getStatusInfo().isWarning()) {
            this.setErrorMessage(null);
            this.setMessage(this.relationalProcessor.getStatusInfo().getMessage());
            return true;
        }
        return true;
    }

    public boolean finish() {
        this.saveWidgetValues();
        boolean doGenerate = this.checkModelForExistingChildren();
        if (doGenerate) {
            this.generateWithJob();
        }
        return true;
    }

    private boolean checkModelForExistingChildren() {
        EList children;
        ArrayList<RelationalReference> existingChildrenRefs;
        ArrayList<String> existingChildrenNames;
        ArrayList<EObject> existingChildren;
        block5: {
            existingChildren = new ArrayList<EObject>();
            existingChildrenNames = new ArrayList<String>();
            existingChildrenRefs = new ArrayList<RelationalReference>();
            children = this.targetResource.getEmfResource().getContents();
            if (!children.isEmpty() && this.relationalProcessor.getRelationalModel() != null) break block5;
            return false;
        }
        try {
            for (EObject child : children) {
                String name = ModelerCore.getModelEditor().getName(child);
                if (name == null || !this.relationalProcessor.getRelationalModel().hasChild(name) || existingChildrenNames.contains(name)) continue;
                existingChildrenRefs.add(this.relationalProcessor.getRelationalModel().getChildWithName(name));
                existingChildren.add(child);
                existingChildrenNames.add(name);
            }
        }
        catch (ModelWorkspaceException modelWorkspaceException) {}
        if (!existingChildren.isEmpty()) {
            OverwriteObjectsDialog depDialog = new OverwriteObjectsDialog(Display.getCurrent().getActiveShell(), existingChildrenRefs, this.relationalProcessor);
            int result = depDialog.open();
            return result == 0;
        }
        return true;
    }

    boolean execute(IProgressMonitor monitor) {
        boolean succeeded;
        block15: {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)RelationalModelTextImporterMainPage.getString("transactionTitle"), (Object)((Object)this));
            succeeded = false;
            try {
                try {
                    this.relationalProcessor.buildModel(this.targetResource, monitor);
                    succeeded = true;
                }
                catch (Exception ex) {
                    UiConstants.Util.log(4, (Throwable)ex, RelationalModelTextImporterMainPage.getString("importError"));
                    if (requiredStart) {
                        if (succeeded && !monitor.isCanceled()) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (requiredStart) {
                    if (succeeded && !monitor.isCanceled()) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                throw throwable;
            }
            if (requiredStart) {
                if (succeeded && !monitor.isCanceled()) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        if (succeeded) {
            ModelEditorManager.activate((ModelResource)this.targetResource, (boolean)true);
        }
        return succeeded;
    }

    private boolean generateWithJob() {
        final String message = RelationalModelTextImporterMainPage.getString("progressTitle");
        Job job = new Job(message){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(message, RelationalModelTextImporterMainPage.this.relationalProcessor.getRelationalModel().getChildren().size() + 2);
                    if (!monitor.isCanceled()) {
                        RelationalModelTextImporterMainPage.this.relationalProcessor.setProgressMonitor(monitor);
                        RelationalModelTextImporterMainPage.this.execute(monitor);
                    }
                    monitor.done();
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    return new Status(0, "org.teiid.designer.relational.ui", 0, AbstractObjectProcessor.FINISHED, null);
                }
                catch (Exception e) {
                    UiConstants.Util.log((Throwable)e);
                    return new Status(4, "org.teiid.designer.relational.ui", 4, RelationalModelTextImporterMainPage.getString("createError"), (Throwable)e);
                }
            }
        };
        job.setSystem(false);
        job.setUser(true);
        job.setProperty(IProgressConstants.KEEP_PROPERTY, (Object)Boolean.TRUE);
        job.schedule();
        return true;
    }

    private void clearListViewer() {
        List contents = this.listViewer.getList();
        Object[] items = contents.getItems();
        this.listViewer.remove(items);
    }

    private void loadListViewer(Collection rows) {
        for (String rowStr : rows) {
            this.listViewer.add((Object)rowStr);
        }
    }

    public Object[] addButtonSelected() {
        return null;
    }

    public void downButtonSelected(IStructuredSelection selection) {
    }

    public Object editButtonSelected(IStructuredSelection selection) {
        return null;
    }

    public void itemsSelected(IStructuredSelection selection) {
    }

    public Object[] removeButtonSelected(IStructuredSelection selection) {
        return null;
    }

    public void upButtonSelected(IStructuredSelection selection) {
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        WidgetUtil.removeMissingResources((IDialogSettings)settings, (String)STORE_SOURCE_NAMES_ID);
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                this.sourceNameField.add(sourceNames[i]);
                ++i;
            }
        }
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.sourceNameField.getText());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
        }
    }

    public String getComboText() {
        return IMPORT_ID;
    }

    public String getDescriptionText() {
        return IMPORT_DESC;
    }

    public String getSampleDataText() {
        return IMPORT_DATA;
    }

    public String getType() {
        return IMPORT_ID;
    }

    class OverwriteObjectsDialog
    extends SelectionDialog {
        private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
        private static final int SIZING_SELECTION_WIDGET_WIDTH = 350;
        RelationalModelXmlTextFileProcessor processor;
        private ILabelProvider labelProvider;
        CheckboxTableViewer listViewer;
        private CLabel statusLine;
        Collection<RelationalReference> duplicateObjs;
        private int proccessType;
        private Button replaceOptionButton;
        private Button createOptionButton;
        private Button cancelOptionButton;

        public OverwriteObjectsDialog(Shell shell, Collection<RelationalReference> duplicateObjs, RelationalModelXmlTextFileProcessor processor) {
            super(shell);
            this.proccessType = 1;
            this.setTitle(OVERWRITE_TITLE);
            this.labelProvider = new RelationalReferenceLabelProvider();
            this.processor = processor;
            this.duplicateObjs = new ArrayList<RelationalReference>(duplicateObjs);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(272));
            Font font = parent.getFont();
            composite.setFont(font);
            this.createMessageArea(composite);
            Group optionsGroup = WidgetFactory.createGroup((Composite)parent, (String)OVERWRITE_OPTIONS, (int)2052);
            optionsGroup.setLayoutData((Object)new GridData(272));
            this.replaceOptionButton = WidgetFactory.createRadioButton((Composite)optionsGroup, (String)OVERWRITE_REPLACE, (boolean)true);
            this.replaceOptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    OverwriteObjectsDialog.this.processWidgetSelected();
                    OverwriteObjectsDialog.this.checkStatus();
                }
            });
            this.createOptionButton = WidgetFactory.createRadioButton((Composite)optionsGroup, (String)OVERWRITE_CREATE, (boolean)false);
            this.createOptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    OverwriteObjectsDialog.this.processWidgetSelected();
                    OverwriteObjectsDialog.this.checkStatus();
                }
            });
            this.cancelOptionButton = WidgetFactory.createRadioButton((Composite)optionsGroup, (String)OVERWRITE_CANCEL, (boolean)false);
            this.cancelOptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    OverwriteObjectsDialog.this.processWidgetSelected();
                    OverwriteObjectsDialog.this.checkStatus();
                }
            });
            Group duplicateObjectsGroup = WidgetFactory.createGroup((Composite)parent, (String)OVERWRITE_DUPLICATE_OBJECTS, (int)4);
            duplicateObjectsGroup.setLayoutData((Object)new GridData(272));
            this.listViewer = CheckboxTableViewer.newCheckList((Composite)duplicateObjectsGroup, (int)2048);
            GridData data = new GridData(1808);
            data.heightHint = 250;
            data.widthHint = 350;
            this.listViewer.getTable().setLayoutData((Object)data);
            this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.listViewer.setContentProvider((IContentProvider)new ListContentProvider());
            this.listViewer.getControl().setFont(font);
            this.listViewer.setSorter(new ViewerSorter(){});
            this.addSelectionButtons((Composite)duplicateObjectsGroup);
            this.initializeViewer();
            this.checkInitialSelections();
            this.getViewer().addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    OverwriteObjectsDialog.this.checkStatus();
                }
            });
            this.statusLine = new CLabel((Composite)duplicateObjectsGroup, 16384);
            this.statusLine.setLayoutData((Object)new GridData(768));
            this.statusLine.setText("");
            this.statusLine.setImage(null);
            this.statusLine.setFont(parent.getFont());
            return composite;
        }

        private void addSelectionButtons(Composite composite) {
            Composite buttonComposite = new Composite(composite, 131072);
            buttonComposite.setFont(composite.getFont());
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            buttonComposite.setLayout((Layout)layout);
            GridData data = new GridData(640);
            data.grabExcessHorizontalSpace = true;
            composite.setData((Object)data);
            Button selectButton = this.createButton(buttonComposite, 18, InternalUiConstants.Widgets.SELECT_ALL_BUTTON, false);
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OverwriteObjectsDialog.this.listViewer.setAllChecked(true);
                    OverwriteObjectsDialog.this.checkStatus();
                }
            };
            selectButton.addSelectionListener((SelectionListener)listener);
            Button deselectButton = this.createButton(buttonComposite, 19, InternalUiConstants.Widgets.DESELECT_ALL_BUTTON, false);
            listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OverwriteObjectsDialog.this.listViewer.setAllChecked(false);
                    OverwriteObjectsDialog.this.checkStatus();
                }
            };
            deselectButton.addSelectionListener((SelectionListener)listener);
        }

        void processWidgetSelected() {
            this.proccessType = this.replaceOptionButton.getSelection() ? 1 : (this.createOptionButton.getSelection() ? 0 : -1);
        }

        private void checkInitialSelections() {
            int nItems = this.listViewer.getTable().getItemCount();
            int i = 0;
            while (i < nItems) {
                this.listViewer.setChecked(this.listViewer.getElementAt(i), true);
                ++i;
            }
            this.processWidgetSelected();
            this.checkStatus();
        }

        void checkStatus() {
            int nItemsChecked = 0;
            int nItems = this.listViewer.getTable().getItemCount();
            int i = 0;
            while (i < nItems) {
                RelationalReference element = (RelationalReference)this.listViewer.getElementAt(i);
                if (this.listViewer.getChecked((Object)element)) {
                    ++nItemsChecked;
                    element.setDoProcessType(this.proccessType);
                } else {
                    element.setDoProcessType(-1);
                }
                ++i;
            }
            if (nItemsChecked == 0) {
                this.setStatus((IStatus)new Status(2, "org.teiid.designer.relational", RelationalModelTextImporterMainPage.getString("noDuplicateObjectsWillBeProcessed")));
            }
        }

        protected CheckboxTableViewer getViewer() {
            return this.listViewer;
        }

        private void initializeViewer() {
            this.listViewer.setInput(this.duplicateObjs);
        }

        protected void okPressed() {
            Object[] children = ((IStructuredContentProvider)this.listViewer.getContentProvider()).getElements(this.duplicateObjs);
            if (children != null) {
                ArrayList<Object> list = new ArrayList<Object>();
                int i = 0;
                while (i < children.length) {
                    Object element = children[i];
                    if (this.listViewer.getChecked(element)) {
                        list.add(element);
                    }
                    ++i;
                }
                this.setResult(list);
            }
            super.okPressed();
        }

        public void create() {
            this.setShellStyle(this.getShellStyle() | 0x10);
            super.create();
        }

        private void setStatus(IStatus status) {
            if (status != null) {
                String message = status.getMessage();
                if (message != null && message.length() > 0) {
                    this.statusLine.setText(message);
                    this.statusLine.setImage(this.findImage(status));
                    this.statusLine.setBackground(JFaceColors.getErrorBackground((Display)this.statusLine.getDisplay()));
                }
            } else {
                this.statusLine.setText("");
                this.statusLine.setImage(null);
            }
            if (status == null || status.isOK()) {
                this.getButton(0).setEnabled(true);
            } else {
                this.getButton(0).setEnabled(false);
            }
        }

        private Image findImage(IStatus status) {
            if (status.isOK()) {
                return null;
            }
            if (status.matches(4)) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            if (status.matches(2)) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            if (status.matches(1)) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
            return null;
        }
    }

    class RelationalReferenceLabelProvider
    implements ILabelProvider {
        RelationalReferenceLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof RelationalReference) {
                return ((RelationalReference)element).getName();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

