/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.wizards;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.relational.RelationalConstants;
import org.teiid.designer.relational.model.RelationalAccessPattern;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalForeignKey;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalModelFactory;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalPrimaryKey;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalProcedureResultSet;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.model.RelationalUniqueConstraint;
import org.teiid.designer.relational.model.RelationalView;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.relational.ui.textimport.RelationalRowFactory;
import org.teiid.designer.tools.textimport.ui.wizards.AbstractObjectProcessor;
import org.teiid.designer.tools.textimport.ui.wizards.IRowObject;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RelationalModelXmlTextFileProcessor
extends AbstractObjectProcessor
implements RelationalConstants {
    static final String TAG_RELATIONAL_MODEL = "relational-model";
    static final String TAG_TABLE = "table";
    static final String TAG_COLUMN = "column";
    static final String TAG_VIEW = "view";
    static final String TAG_PRIMARY_KEY = "primary-key";
    static final String TAG_UNIQUE_CONSTRAINT = "unique-constraint";
    static final String TAG_FOREIGN_KEY = "foreign-key";
    static final String TAG_ACCESS_PATTERN = "access-pattern";
    static final String TAG_PROCEDURE = "procedure";
    static final String TAG_PARAMETER = "parameter";
    static final String TAG_RESULT_SET = "result-set";
    static final String TAG_INDEX = "index";
    static final String TAG_COLUMN_REFERENCE = "column-reference";
    static final String TAG_COLUMN_TABLE_REFERENCE = "column-table-reference";
    private static final String KEY_NAME = "name";
    private static final String KEY_TABLE_NAME = "tableName";
    public StatusInfo statusInfo = new StatusInfo("org.teiid.designer.relational");
    private IProgressMonitor monitor;
    private RelationalModel relationalModel;

    public void buildModel(ModelResource targetResource, IProgressMonitor progressMonitor) {
        RelationalModelFactory factory = new RelationalModelFactory();
        factory.build(targetResource, this.relationalModel, progressMonitor);
    }

    public RelationalModel getRelationalModel() {
        return this.relationalModel;
    }

    public Collection loadLinesFromFile(String fileStr) {
        Collection lines = super.loadLinesFromFile(fileStr);
        this.relationalModel = this.parseFile(fileStr);
        return lines;
    }

    /*
     * Could not resolve type clashes
     */
    private RelationalModel parseFile(String xmlFileUrl) {
        Path filePath = new Path(xmlFileUrl);
        String fileName = filePath.lastSegment();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.statusInfo = new StatusInfo("org.teiid.designer.relational");
        RelationalModel relModel = new RelationalModel("bogus");
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            Document document = db.parse(xmlFileUrl);
            Element root = document.getDocumentElement();
            if (this.getTagWithoutPrefix(root.getTagName()).equalsIgnoreCase(TAG_RELATIONAL_MODEL)) {
                NodeList children = root.getChildNodes();
                ArrayList<Node> indexNodes = new ArrayList<Node>();
                if (children != null && children.getLength() > 0) {
                    int i = 0;
                    while (i < children.getLength()) {
                        Node child = children.item(i);
                        String name = this.getTagWithoutPrefix(child.getNodeName());
                        int type = this.getType(name);
                        switch (type) {
                            case 3: {
                                Properties props = this.getProperties(child.getAttributes());
                                RelationalTable table = new RelationalTable();
                                relModel.addChild((RelationalReference)table);
                                table.setProperties(props);
                                Iterator primaryKeyElement = null;
                                Iterator uniqueConstraintElement = null;
                                ArrayList accessPatternNodes = new ArrayList();
                                ArrayList foreignKeyNodes = new ArrayList();
                                NodeList tableChildren = child.getChildNodes();
                                if (tableChildren != null && tableChildren.getLength() > 0) {
                                    int j = 0;
                                    while (j < tableChildren.getLength()) {
                                        Iterator tableChild = tableChildren.item(j);
                                        String tableChildName = this.getTagWithoutPrefix(tableChild.getNodeName());
                                        int tableChildType = this.getType(tableChildName);
                                        switch (tableChildType) {
                                            case 7: {
                                                Properties columnProps = this.getProperties(tableChild.getAttributes());
                                                RelationalColumn column = new RelationalColumn();
                                                table.addColumn(column);
                                                column.setProperties(columnProps);
                                                break;
                                            }
                                            case 8: {
                                                primaryKeyElement = tableChild;
                                                break;
                                            }
                                            case 10: {
                                                uniqueConstraintElement = tableChild;
                                                break;
                                            }
                                            case 11: {
                                                accessPatternNodes.add(tableChild);
                                                break;
                                            }
                                            case 9: {
                                                foreignKeyNodes.add(tableChild);
                                            }
                                        }
                                        ++j;
                                    }
                                }
                                this.processPrimaryKey((Node)((Object)primaryKeyElement), table);
                                this.processUniqueConstraint((Node)((Object)uniqueConstraintElement), table);
                                for (Node apNode : accessPatternNodes) {
                                    this.processAccessPattern(apNode, table);
                                }
                                for (Node fkNode : foreignKeyNodes) {
                                    this.processForeignKey(fkNode, table);
                                }
                                break;
                            }
                            case 4: {
                                Properties props = this.getProperties(child.getAttributes());
                                RelationalView view = new RelationalView();
                                relModel.addChild((RelationalReference)view);
                                view.setProperties(props);
                                ArrayList<Object> accessPatternNodes = new ArrayList<Object>();
                                NodeList tableChildren = child.getChildNodes();
                                if (tableChildren != null && tableChildren.getLength() > 0) {
                                    int j = 0;
                                    while (j < tableChildren.getLength()) {
                                        Node tableChild = tableChildren.item(j);
                                        String tableChildName = this.getTagWithoutPrefix(tableChild.getNodeName());
                                        int tableChildType = this.getType(tableChildName);
                                        switch (tableChildType) {
                                            case 7: {
                                                Properties columnProps = this.getProperties(tableChild.getAttributes());
                                                RelationalColumn column = new RelationalColumn();
                                                view.addColumn(column);
                                                column.setProperties(columnProps);
                                                break;
                                            }
                                            case 11: {
                                                accessPatternNodes.add(tableChild);
                                            }
                                        }
                                        ++j;
                                    }
                                }
                                for (Node apNode : accessPatternNodes) {
                                    this.processAccessPattern(apNode, (RelationalTable)view);
                                }
                                break;
                            }
                            case 5: {
                                Properties props = this.getProperties(child.getAttributes());
                                RelationalProcedure proc = new RelationalProcedure();
                                relModel.addChild((RelationalReference)proc);
                                proc.setProperties(props);
                                NodeList procChildren = child.getChildNodes();
                                if (procChildren == null || procChildren.getLength() <= 0) break;
                                int j = 0;
                                while (j < procChildren.getLength()) {
                                    Node procChild = procChildren.item(j);
                                    String tableChildName = this.getTagWithoutPrefix(procChild.getNodeName());
                                    int tableChildType = this.getType(tableChildName);
                                    switch (tableChildType) {
                                        case 6: {
                                            Properties paramProps = this.getProperties(procChild.getAttributes());
                                            RelationalParameter param = new RelationalParameter();
                                            proc.addParameter(param);
                                            param.setProperties(paramProps);
                                            break;
                                        }
                                        case 12: {
                                            Properties rsProps = this.getProperties(procChild.getAttributes());
                                            RelationalProcedureResultSet resultSet = new RelationalProcedureResultSet();
                                            resultSet.setProperties(rsProps);
                                            proc.setResultSet(resultSet);
                                            NodeList rsChildren = procChild.getChildNodes();
                                            if (rsChildren == null || rsChildren.getLength() <= 0) break;
                                            int k = 0;
                                            while (k < rsChildren.getLength()) {
                                                Node rsChild = rsChildren.item(k);
                                                String rsChildName = this.getTagWithoutPrefix(rsChild.getNodeName());
                                                int rsChildType = this.getType(rsChildName);
                                                switch (rsChildType) {
                                                    case 7: {
                                                        Properties columnProps = this.getProperties(rsChild.getAttributes());
                                                        RelationalColumn column = new RelationalColumn();
                                                        column.setProperties(columnProps);
                                                        resultSet.addColumn(column);
                                                    }
                                                }
                                                ++k;
                                            }
                                            break;
                                        }
                                    }
                                    ++j;
                                }
                                break;
                            }
                            case 13: {
                                indexNodes.add(child);
                                break;
                            }
                            default: {
                                if (name.equalsIgnoreCase("#text")) break;
                                String message = UiConstants.Util.getString("RelationalModelXmlTextFileProcessor.importRelationalModelHasBugsElement", (Object)name);
                                this.statusInfo.setWarning(message);
                            }
                        }
                        ++i;
                    }
                }
                for (Node indexNode : indexNodes) {
                    Properties props = this.getProperties(indexNode.getAttributes());
                    RelationalIndex index = new RelationalIndex();
                    relModel.addChild((RelationalReference)index);
                    index.setProperties(props);
                    NodeList indexChildren = indexNode.getChildNodes();
                    if (indexChildren == null || indexChildren.getLength() <= 0) continue;
                    int j = 0;
                    while (j < indexChildren.getLength()) {
                        Node indexChild = indexChildren.item(j);
                        String indexChildName = this.getTagWithoutPrefix(indexChild.getNodeName());
                        if (indexChildName.equalsIgnoreCase(TAG_COLUMN_TABLE_REFERENCE)) {
                            String tableName = indexChild.getAttributes().getNamedItem(KEY_TABLE_NAME).getNodeValue();
                            String colName = indexChild.getAttributes().getNamedItem(KEY_NAME).getNodeValue();
                            for (RelationalReference child : relModel.getChildren()) {
                                if (child.getType() != 3 || !child.getName().equalsIgnoreCase(tableName)) continue;
                                for (RelationalColumn column : ((RelationalTable)child).getColumns()) {
                                    if (!column.getName().equalsIgnoreCase(colName)) continue;
                                    index.addColumn(column);
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
        }
        catch (ParserConfigurationException pce) {
            String title = UiConstants.Util.getString("RelationalModelXmlTextFileProcessor.importRelationalModelXmlParsingError.title", new Object[0]);
            String message = String.valueOf(UiConstants.Util.getString("RelationalModelXmlTextFileProcessor.importRelationalModelXmlParsingError", (Object)fileName)) + pce.getMessage();
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            this.statusInfo.setError(message);
            relModel = null;
        }
        catch (SAXException se) {
            String title = UiConstants.Util.getString("RelationalModelXmlTextFileProcessor.importRelationalModelXmlParsingError.title", new Object[0]);
            String message = String.valueOf(UiConstants.Util.getString("RelationalModelXmlTextFileProcessor.importRelationalModelXmlParsingError", (Object)fileName)) + se.getMessage();
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            this.statusInfo.setError(message);
            relModel = null;
        }
        catch (IOException ioe) {
            String title = UiConstants.Util.getString("RelationalModelXmlTextFileProcessor.importRelationalModelXmlParsingError.title", new Object[0]);
            String message = String.valueOf(UiConstants.Util.getString("RelationalModelXmlTextFileProcessor.importRelationalModelXmlParsingError", (Object)fileName)) + ioe.getMessage();
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            this.statusInfo.setError(message);
            relModel = null;
        }
        return relModel;
    }

    private void processPrimaryKey(Node primaryKeyNode, RelationalTable table) {
        if (primaryKeyNode == null) {
            return;
        }
        Properties pkProps = this.getProperties(primaryKeyNode.getAttributes());
        RelationalPrimaryKey pk = new RelationalPrimaryKey();
        pk.setProperties(pkProps);
        table.setPrimaryKey(pk);
        NodeList pkChildren = primaryKeyNode.getChildNodes();
        if (pkChildren != null && pkChildren.getLength() > 0) {
            int j = 0;
            while (j < pkChildren.getLength()) {
                Node pkChild = pkChildren.item(j);
                String pkChildName = this.getTagWithoutPrefix(pkChild.getNodeName());
                if (pkChildName.equalsIgnoreCase(TAG_COLUMN_REFERENCE)) {
                    String colName = pkChild.getAttributes().getNamedItem(KEY_NAME).getNodeValue();
                    for (RelationalColumn column : table.getColumns()) {
                        if (!column.getName().equalsIgnoreCase(colName)) continue;
                        pk.addColumn(column);
                    }
                }
                ++j;
            }
        }
    }

    private void processForeignKey(Node foreignKeyNode, RelationalTable table) {
        if (foreignKeyNode == null) {
            return;
        }
        Properties fkProps = this.getProperties(foreignKeyNode.getAttributes());
        RelationalForeignKey fk = new RelationalForeignKey();
        fk.setProperties(fkProps);
        table.addForeignKey(fk);
        NodeList fkChildren = foreignKeyNode.getChildNodes();
        if (fkChildren != null && fkChildren.getLength() > 0) {
            int j = 0;
            while (j < fkChildren.getLength()) {
                Node fkChild = fkChildren.item(j);
                String pkChildName = this.getTagWithoutPrefix(fkChild.getNodeName());
                if (pkChildName.equalsIgnoreCase(TAG_COLUMN_REFERENCE)) {
                    String colName = fkChild.getAttributes().getNamedItem(KEY_NAME).getNodeValue();
                    for (RelationalColumn column : table.getColumns()) {
                        if (!column.getName().equalsIgnoreCase(colName)) continue;
                        fk.addColumn(column);
                    }
                }
                ++j;
            }
        }
    }

    private void processAccessPattern(Node accessPatternNode, RelationalTable table) {
        if (accessPatternNode == null) {
            return;
        }
        Properties acProps = this.getProperties(accessPatternNode.getAttributes());
        RelationalAccessPattern ac = new RelationalAccessPattern();
        ac.setProperties(acProps);
        table.addAccessPattern(ac);
        NodeList acChildren = accessPatternNode.getChildNodes();
        if (acChildren != null && acChildren.getLength() > 0) {
            int j = 0;
            while (j < acChildren.getLength()) {
                Node acChild = acChildren.item(j);
                String acChildName = this.getTagWithoutPrefix(acChild.getNodeName());
                if (acChildName.equalsIgnoreCase(TAG_COLUMN_REFERENCE)) {
                    String colName = acChild.getAttributes().getNamedItem(KEY_NAME).getNodeValue();
                    for (RelationalColumn column : table.getColumns()) {
                        if (!column.getName().equalsIgnoreCase(colName)) continue;
                        ac.addColumn(column);
                    }
                }
                ++j;
            }
        }
    }

    private void processUniqueConstraint(Node uniqueConstraintNode, RelationalTable table) {
        if (uniqueConstraintNode == null) {
            return;
        }
        Properties ucProps = this.getProperties(uniqueConstraintNode.getAttributes());
        RelationalUniqueConstraint uc = new RelationalUniqueConstraint();
        uc.setProperties(ucProps);
        table.setUniqueConstraint(uc);
        NodeList ucChildren = uniqueConstraintNode.getChildNodes();
        if (ucChildren != null && ucChildren.getLength() > 0) {
            int j = 0;
            while (j < ucChildren.getLength()) {
                Node ucChild = ucChildren.item(j);
                String ucChildName = this.getTagWithoutPrefix(ucChild.getNodeName());
                if (ucChildName.equalsIgnoreCase(TAG_COLUMN_REFERENCE)) {
                    String colName = ucChild.getAttributes().getNamedItem(KEY_NAME).getNodeValue();
                    for (RelationalColumn column : table.getColumns()) {
                        if (!column.getName().equalsIgnoreCase(colName)) continue;
                        uc.addColumn(column);
                    }
                }
                ++j;
            }
        }
    }

    private Properties getProperties(NamedNodeMap attributeMap) {
        Properties props = new Properties();
        if (attributeMap != null && attributeMap.getLength() > 0) {
            int i = 0;
            while (i < attributeMap.getLength()) {
                Node item = attributeMap.item(i);
                props.put(item.getNodeName(), item.getNodeValue());
                ++i;
            }
        }
        return props;
    }

    public Collection createRowObjsFromStrings(Collection rowStrings) {
        Iterator iter = rowStrings.iterator();
        String nextStr = null;
        RelationalRowFactory factory = new RelationalRowFactory();
        ArrayList<IRowObject> stringRows = new ArrayList<IRowObject>();
        IRowObject nextRow = null;
        while (iter.hasNext()) {
            nextStr = (String)iter.next();
            nextRow = factory.createRowObject(nextStr);
            if (nextRow != null && nextRow.isValid()) {
                stringRows.add(nextRow);
                continue;
            }
            this.logParsingError(nextStr);
        }
        return stringRows;
    }

    private int getType(String objType) {
        if (objType.trim().equalsIgnoreCase("ACCESS-PATTERN")) {
            return 11;
        }
        if (objType.trim().equalsIgnoreCase("CATALOG")) {
            return 2;
        }
        if (objType.trim().equalsIgnoreCase("COLUMN")) {
            return 7;
        }
        if (objType.trim().equalsIgnoreCase("FOREIGN-KEY")) {
            return 9;
        }
        if (objType.trim().equalsIgnoreCase("INDEX")) {
            return 13;
        }
        if (objType.trim().equalsIgnoreCase("MODEL")) {
            return 0;
        }
        if (objType.trim().equalsIgnoreCase("PARAMETER")) {
            return 6;
        }
        if (objType.trim().equalsIgnoreCase("PRIMARY-KEY")) {
            return 8;
        }
        if (objType.trim().equalsIgnoreCase("PROCEDURE")) {
            return 5;
        }
        if (objType.trim().equalsIgnoreCase("RESULT-SET")) {
            return 12;
        }
        if (objType.trim().equalsIgnoreCase("SCHEMA")) {
            return 1;
        }
        if (objType.trim().equalsIgnoreCase("TABLE")) {
            return 3;
        }
        if (objType.trim().equalsIgnoreCase("UNIQUE-CONSTRAINT")) {
            return 10;
        }
        if (objType.trim().equalsIgnoreCase("VIEW")) {
            return 4;
        }
        return -1;
    }

    private String getTagWithoutPrefix(String tagStr) {
        int indexOfColon = tagStr.indexOf(58);
        if (indexOfColon < 0) {
            return tagStr;
        }
        return tagStr.substring(indexOfColon + 1);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public StatusInfo getStatusInfo() {
        return this.statusInfo;
    }
}

