/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.m2e;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.util.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.configurator.MojoExecutionBuildParticipant;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.Validator;
import org.sonatype.plexus.build.incremental.BuildContext;

public class SwitchYardBuildParticipant
extends MojoExecutionBuildParticipant {
    private static final String SWITCHYARD_DEFAULT_OUTPUT_FILE_PATH = "META-INF/switchyard.xml";

    public SwitchYardBuildParticipant(MojoExecution execution) {
        super(execution, true);
    }

    public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
        Resource[] resources;
        File outputDirectory = this.getOutputDirectory();
        File outputFile = this.getOutputFile(outputDirectory);
        if (6 == kind) {
            return this.performBuild(outputFile, kind, monitor);
        }
        BuildContext buildContext = this.getBuildContext();
        Resource[] resourceArray = resources = this.getResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            File testFile;
            Resource resource = resourceArray[n2];
            if (resource.getDirectory() != null && (testFile = new File(resource.getDirectory(), SWITCHYARD_DEFAULT_OUTPUT_FILE_PATH).getCanonicalFile()).exists() && buildContext.hasDelta(testFile)) {
                return this.performBuild(outputFile, kind, monitor);
            }
            ++n2;
        }
        File[] scanDirectories = this.getScanDirectories(outputDirectory);
        String outputFilePath = outputFile.getCanonicalPath();
        File[] fileArray = scanDirectories;
        int n3 = scanDirectories.length;
        int n4 = 0;
        while (n4 < n3) {
            File scanDirectory = fileArray[n4];
            Scanner scanner = buildContext.newScanner(scanDirectory);
            String scanPath = scanDirectory.getCanonicalPath();
            String[] excludes = null;
            if (outputFilePath.startsWith(scanPath)) {
                excludes = new String[]{outputFilePath.substring(scanPath.length())};
                scanner.setExcludes(excludes);
            }
            scanner.scan();
            String[] includedFiles = scanner.getIncludedFiles();
            if (includedFiles != null && includedFiles.length > 0 || this.checkRefreshedFiles(scanDirectory, outputFile)) {
                return this.performBuild(outputFile, kind, monitor);
            }
            scanner = buildContext.newDeleteScanner(scanDirectory);
            if (excludes != null) {
                scanner.setExcludes(excludes);
            }
            scanner.scan();
            includedFiles = scanner.getIncludedFiles();
            if (includedFiles != null && includedFiles.length > 0) {
                return this.performBuild(outputFile, kind, monitor);
            }
            ++n4;
        }
        return null;
    }

    private Set<IProject> performBuild(File outputFile, int kind, IProgressMonitor monitor) throws Exception {
        Set result = super.build(kind, monitor);
        IFile workspaceOutputFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(outputFile.getAbsolutePath()));
        if (workspaceOutputFile != null) {
            try {
                workspaceOutputFile.refreshLocal(0, monitor);
            }
            catch (CoreException e) {
                e.fillInStackTrace();
            }
        }
        IProject project = this.getMavenProjectFacade().getProject();
        IPath[] iPathArray = this.getMavenProjectFacade().getResourceLocations();
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath resourceFolder = iPathArray[n2];
            IFile sourceFile = project.getFile(resourceFolder.append(SWITCHYARD_DEFAULT_OUTPUT_FILE_PATH));
            if (sourceFile.exists()) {
                ValidationFramework.getDefault().validate(sourceFile, monitor);
                break;
            }
            ++n2;
        }
        return result;
    }

    private boolean checkRefreshedFiles(File scanDirectory, File outputFile) {
        if (scanDirectory == null) {
            return false;
        }
        Path scanPath = new Path(scanDirectory.getCanonicalPath());
        for (File refreshed : this.getRefreshedFiles()) {
            if (refreshed == null) continue;
            try {
                if (!scanDirectory.equals(refreshed) && (refreshed.isDirectory() || refreshed.equals(outputFile) || !scanPath.isPrefixOf((IPath)new Path(refreshed.getCanonicalPath())))) continue;
                return true;
            }
            catch (Exception e) {
                try {
                    e.fillInStackTrace();
                }
                catch (Exception e2) {
                    e2.fillInStackTrace();
                    break;
                }
            }
        }
        return false;
    }

    private Collection<File> getRefreshedFiles() {
        BuildContext buildContext = this.getBuildContext();
        try {
            Method getFilesMethod = buildContext.getClass().getMethod("getFiles", new Class[0]);
            return (Collection)getFilesMethod.invoke((Object)buildContext, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptySet();
        }
    }

    private File getOutputDirectory() throws CoreException {
        File outputDirectory = (File)MavenPlugin.getMaven().getMojoParameterValue(this.getMavenProjectFacade().getMavenProject(), this.getMojoExecution(), "_project_build_outputDirectory", File.class, (IProgressMonitor)new NullProgressMonitor());
        if (outputDirectory == null) {
            outputDirectory = (File)MavenPlugin.getMaven().getMojoParameterValue(this.getMavenProjectFacade().getMavenProject(), this.getMojoExecution(), "outputDirectory", File.class, (IProgressMonitor)new NullProgressMonitor());
        }
        return outputDirectory;
    }

    private File getOutputFile(File outputDirectory) throws CoreException {
        File outputFile = (File)MavenPlugin.getMaven().getMojoParameterValue(this.getMavenProjectFacade().getMavenProject(), this.getMojoExecution(), "_outputFile", File.class, (IProgressMonitor)new NullProgressMonitor());
        if (outputFile == null && (outputFile = (File)MavenPlugin.getMaven().getMojoParameterValue(this.getMavenProjectFacade().getMavenProject(), this.getMojoExecution(), "outputFile", File.class, (IProgressMonitor)new NullProgressMonitor())) == null) {
            outputFile = new File(outputDirectory, SWITCHYARD_DEFAULT_OUTPUT_FILE_PATH);
        }
        return outputFile;
    }

    private Resource[] getResources() throws CoreException {
        Resource[] resources = (Resource[])MavenPlugin.getMaven().getMojoParameterValue(this.getMavenProjectFacade().getMavenProject(), this.getMojoExecution(), "_project_resources", Resource[].class, (IProgressMonitor)new NullProgressMonitor());
        if ((resources == null || resources.length == 0) && (resources = (Resource[])MavenPlugin.getMaven().getMojoParameterValue(this.getMavenProjectFacade().getMavenProject(), this.getMojoExecution(), "resources", Resource[].class, (IProgressMonitor)new NullProgressMonitor())) == null) {
            return new Resource[0];
        }
        return resources;
    }

    private File[] getScanDirectories(File outputDirectory) throws CoreException {
        File[] scanDirectories = (File[])MavenPlugin.getMaven().getMojoParameterValue(this.getMavenProjectFacade().getMavenProject(), this.getMojoExecution(), "_scanDirectories", File[].class, (IProgressMonitor)new NullProgressMonitor());
        if (!(scanDirectories != null && scanDirectories.length != 0 || (scanDirectories = (File[])MavenPlugin.getMaven().getMojoParameterValue(this.getMavenProjectFacade().getMavenProject(), this.getMojoExecution(), "scanDirectories", File[].class, (IProgressMonitor)new NullProgressMonitor())) != null && scanDirectories.length != 0)) {
            return new File[]{outputDirectory};
        }
        return scanDirectories;
    }

    public void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        IProject project = this.getMavenProjectFacade().getProject();
        IPath[] iPathArray = this.getMavenProjectFacade().getResourceLocations();
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath resourceFolder = iPathArray[n2];
            IFile sourceFile = project.getFile(resourceFolder.append(SWITCHYARD_DEFAULT_OUTPUT_FILE_PATH));
            if (sourceFile.exists()) {
                Validator[] validatorArray = ValidationFramework.getDefault().getValidatorsFor((IResource)sourceFile);
                int n3 = validatorArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Validator validator = validatorArray[n4];
                    ValidationFramework.getDefault().clearMessages((IResource)sourceFile, validator.getId());
                    ++n4;
                }
                break;
            }
            ++n2;
        }
    }
}

