/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFResourceMapping;
import org.eclipse.emf.compare.ide.ui.internal.logical.IdenticalResourceMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.internal.merge.MergeDependenciesUtil;
import org.eclipse.emf.compare.internal.utils.Graph;
import org.eclipse.emf.compare.internal.utils.PruningIterator;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.IResourceMappingMerger;
import org.eclipse.team.core.mapping.provider.MergeStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFResourceMappingMerger
implements IResourceMappingMerger {
    public IStatus merge(IMergeContext mergeContext, IProgressMonitor monitor) throws CoreException {
        ResourceMapping[] emfMappings = this.getEMFMappings(mergeContext);
        this.log(0, "EMFResourceMappingMerger.startingModelMerge", emfMappings);
        if (emfMappings.length <= 0) {
            return new Status(4, "org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString("EMFResourceMappingMerger.mergeFailedGeneric"));
        }
        IStatus hasInvalidMappings = this.validateMappings(emfMappings);
        if (hasInvalidMappings.getSeverity() != 0) {
            return hasInvalidMappings;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)emfMappings.length);
        try {
            HashSet<ResourceMapping> failingMappings = new HashSet<ResourceMapping>();
            ResourceMapping[] resourceMappingArray = emfMappings;
            int n = emfMappings.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceMapping mapping = resourceMappingArray[n2];
                this.mergeMapping(mapping, mergeContext, failingMappings, (IProgressMonitor)subMonitor.newChild(1));
                ++n2;
            }
            if (!failingMappings.isEmpty()) {
                ResourceMapping[] failingArray = failingMappings.toArray(new ResourceMapping[failingMappings.size()]);
                MergeStatus mergeStatus = new MergeStatus("org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString("EMFResourceMappingMerger.mergeFailedConflicts"), failingArray);
                return mergeStatus;
            }
            this.log(0, "EMFResourceMappingMerger.successfulModelMerge", emfMappings);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void log(int statusCode, String key, ResourceMapping[] emfMappings) {
        List<IResource> iResources = this.getInvolvedIResources(emfMappings);
        String message = EMFCompareIDEUIMessages.getString(key, String.valueOf(iResources.size()));
        this.log(statusCode, message, iResources);
    }

    private void log(int statusCode, String message, Collection<IResource> iResources) {
        MultiStatus multiStatus = new MultiStatus("org.eclipse.emf.compare.ide.ui", 0, message, null);
        for (IResource iResource : iResources) {
            Status childStatus = new Status(statusCode, "org.eclipse.emf.compare.ide.ui", iResource.getFullPath().toOSString());
            multiStatus.add((IStatus)childStatus);
        }
        this.log((IStatus)multiStatus);
    }

    private List<IResource> getInvolvedIResources(ResourceMapping[] emfMappings) {
        ArrayList<IResource> iResources = new ArrayList<IResource>();
        ResourceMapping[] resourceMappingArray = emfMappings;
        int n = emfMappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            if (mapping instanceof EMFResourceMapping) {
                SynchronizationModel syncModel = ((EMFResourceMapping)mapping).getLatestModel();
                for (IResource iResource : syncModel.getResources()) {
                    iResources.add(iResource);
                }
            }
            ++n2;
        }
        return iResources;
    }

    private void log(IStatus status) {
        EMFCompareIDEUIPlugin.getDefault().getLog().log(status);
    }

    private void mergeMapping(ResourceMapping mapping, IMergeContext mergeContext, Set<ResourceMapping> failingMappings, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        SynchronizationModel syncModel = ((EMFResourceMapping)mapping).getLatestModel();
        IdenticalResourceMinimizer minimizer = new IdenticalResourceMinimizer();
        minimizer.minimize(syncModel, (IProgressMonitor)subMonitor.newChild(1));
        IComparisonScope scope = ComparisonScopeBuilder.create(syncModel, (IProgressMonitor)subMonitor.newChild(3));
        EMFCompare.Builder builder = EMFCompare.builder();
        EMFCompareBuilderConfigurator.createDefault().configure(builder);
        Comparison comparison = builder.build().compare(scope, BasicMonitor.toMonitor((IProgressMonitorWithBlocking)SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (int)10)));
        IMerger.Registry mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        if (this.hasRealConflict(comparison)) {
            Graph differencesGraph = MergeDependenciesUtil.mapDifferences((Comparison)comparison, (IMerger.Registry)mergerRegistry, (boolean)true, null);
            PruningIterator iterator = differencesGraph.breadthFirstIterator();
            Monitor emfMonitor = BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor.newChild(5));
            while (iterator.hasNext()) {
                Diff next = (Diff)iterator.next();
                if (EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)next)) {
                    iterator.prune();
                    continue;
                }
                if (next.getState() == DifferenceState.MERGED) continue;
                IMerger merger = mergerRegistry.getHighestRankingMerger(next);
                merger.copyRightToLeft(next, emfMonitor);
            }
            this.save(scope.getLeft());
            failingMappings.add(mapping);
        } else {
            MarkNewResourceAsMergedListener listener = new MarkNewResourceAsMergedListener(mergeContext);
            TrackAddedAndRemovedResourcesListener resourceTracker = new TrackAddedAndRemovedResourcesListener();
            try {
                IDiff diff;
                IPath fullPath;
                scope.getLeft().eAdapters().add((Object)listener);
                scope.getLeft().eAdapters().add((Object)resourceTracker);
                BatchMerger merger = new BatchMerger(mergerRegistry, EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT));
                merger.copyAllRightToLeft((Iterable)comparison.getDifferences(), BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor.newChild(3)));
                this.save(scope.getLeft());
                for (IStorage storage : syncModel.getLeftTraversal().getStorages()) {
                    fullPath = ResourceUtil.getFixedPath((IStorage)storage);
                    if (fullPath == null) {
                        EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString("EMFResourceMappingMerger.mergeIncomplete")));
                        continue;
                    }
                    diff = mergeContext.getDiffTree().getDiff(fullPath);
                    if (diff == null) continue;
                    if (2 == diff.getKind() && !resourceTracker.containsRemovedResource(fullPath)) {
                        mergeContext.merge(diff, false, (IProgressMonitor)subMonitor.newChild(1));
                        continue;
                    }
                    mergeContext.markAsMerged(diff, true, (IProgressMonitor)subMonitor.newChild(1));
                }
                for (IStorage rightStorage : syncModel.getRightTraversal().getStorages()) {
                    fullPath = ResourceUtil.getFixedPath((IStorage)rightStorage);
                    if (fullPath == null || (diff = mergeContext.getDiffTree().getDiff(fullPath)) == null || 1 != diff.getKind() || resourceTracker.containsAddedResource(fullPath)) continue;
                    mergeContext.merge(diff, false, (IProgressMonitor)subMonitor.newChild(1));
                }
            }
            finally {
                scope.getLeft().eAdapters().remove((Object)listener);
                scope.getLeft().eAdapters().remove((Object)resourceTracker);
            }
        }
        subMonitor.setWorkRemaining(0);
    }

    private IStatus validateMappings(ResourceMapping[] mappings) {
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            if (mapping instanceof EMFResourceMapping && mapping.getModelObject() instanceof SynchronizationModel) {
                SynchronizationModel model = (SynchronizationModel)mapping.getModelObject();
                if (model.getDiagnostic().getSeverity() >= 2) {
                    return BasicDiagnostic.toIStatus((Diagnostic)model.getDiagnostic());
                }
            } else {
                return new Status(4, "org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString("EMFResourceMappingMerger.mergeFailedInvalidMapping"));
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private void save(Notifier notifier) {
        if (notifier instanceof ResourceSet) {
            ResourceUtil.saveAllResources((ResourceSet)((ResourceSet)notifier), (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"));
        } else if (notifier instanceof Resource) {
            ResourceUtil.saveResource((Resource)((Resource)notifier), (Map)ImmutableMap.of((Object)"SAVE_ONLY_IF_CHANGED", (Object)"MEMORY_BUFFER"));
        }
    }

    private boolean hasRealConflict(Comparison comparison) {
        for (Conflict conflict : comparison.getConflicts()) {
            if (conflict.getKind() != ConflictKind.REAL) continue;
            return true;
        }
        return false;
    }

    public ISchedulingRule getMergeRule(IMergeContext context) {
        ResourceMapping[] emfMappings = this.getEMFMappings(context);
        LinkedHashSet<IProject> impactedProjects = new LinkedHashSet<IProject>();
        ResourceMapping[] resourceMappingArray = emfMappings;
        int n = emfMappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            impactedProjects.addAll(Arrays.asList(mapping.getProjects()));
            ++n2;
        }
        return MultiRule.combine((ISchedulingRule[])impactedProjects.toArray(new ISchedulingRule[impactedProjects.size()]));
    }

    private ResourceMapping[] getEMFMappings(IMergeContext context) {
        return context.getScope().getMappings("org.eclipse.emf.compare.model.provider");
    }

    public IStatus validateMerge(IMergeContext mergeContext, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    private static class MarkNewResourceAsMergedListener
    extends AdapterImpl {
        private final IMergeContext mergeContext;

        public MarkNewResourceAsMergedListener(IMergeContext mergeContext) {
            this.mergeContext = mergeContext;
        }

        public void notifyChanged(Notification msg) {
            Resource newResource;
            URI uri;
            if (msg.getEventType() == 3 && msg.getNewValue() instanceof Resource && (uri = (newResource = (Resource)msg.getNewValue()).getURI()).isPlatformResource()) {
                String path = uri.toPlatformString(true);
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
                IDiff diff = this.mergeContext.getDiffTree().getDiff((IResource)file);
                try {
                    this.mergeContext.markAsMerged(diff, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    EMFCompareIDEUIPlugin.getDefault().log(e);
                }
            }
        }
    }

    private static class TrackAddedAndRemovedResourcesListener
    extends AdapterImpl {
        private final Set<String> addedResources = new HashSet<String>();
        private final Set<String> removedResources = new HashSet<String>();

        private TrackAddedAndRemovedResourcesListener() {
        }

        public void notifyChanged(Notification msg) {
            Resource newResource;
            URI uri;
            int notificationType = msg.getEventType();
            if (notificationType != 3 && notificationType != 4) {
                return;
            }
            if (msg.getNewValue() instanceof Resource && (uri = (newResource = (Resource)msg.getNewValue()).getURI()).isPlatformResource()) {
                String path = uri.toPlatformString(true);
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
                String stringRepresentation = this.getStringRepresentation(file.getFullPath());
                if (msg.getEventType() == 3) {
                    this.addedResources.add(stringRepresentation);
                } else if (msg.getEventType() == 4) {
                    this.removedResources.add(stringRepresentation);
                }
            }
        }

        private String getStringRepresentation(IPath path) {
            return path.toPortableString();
        }

        public boolean containsAddedResource(IPath path) {
            return this.addedResources.contains(this.getStringRepresentation(path));
        }

        public boolean containsRemovedResource(IPath path) {
            return this.removedResources.contains(this.getStringRepresentation(path));
        }
    }
}

