/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.LoggingUtil;
import org.teiid.designer.extension.ExtensionConstants;
import org.teiid.designer.extension.Messages;
import org.teiid.designer.extension.ModelExtensionAssistantAggregator;
import org.teiid.designer.extension.definition.ExtendableMetaclassNameProvider;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionParser;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistantFactory;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;

public class ExtensionPlugin
extends Plugin
implements ExtensionConstants {
    private static ExtensionPlugin plugin;
    public static PluginUtil Util;
    private static IPath runtimePath;
    private ModelExtensionAssistantAggregator assistantAggregator;
    private Map<String, ExtendableMetaclassNameProvider> metaclassNameProvidersMap;
    private ModelObjectExtensionAssistantFactory modelObjectAssistantFactory;
    private ModelExtensionRegistry registry;
    private File schemaFile;

    static {
        Util = new LoggingUtil(PLUGIN_ID);
    }

    public static ExtensionPlugin getInstance() {
        return plugin;
    }

    public ModelObjectExtensionAssistant createDefaultModelObjectExtensionAssistant() {
        if (this.modelObjectAssistantFactory == null) {
            this.loadModelObjectExtensionAssistantFactories();
            if (this.modelObjectAssistantFactory == null) {
                this.modelObjectAssistantFactory = new ModelObjectExtensionAssistantFactory(){

                    @Override
                    public String getModelObjectType() {
                        return "NO MODEL OBJECT ASSISTANT FACTORY FOUND";
                    }

                    @Override
                    public ModelObjectExtensionAssistant createAssistant() {
                        Util.log(4, Messages.modelObjectExtensionAssistantFactoryNotFound);
                        return new ModelObjectExtensionAssistantAdapter();
                    }
                };
            }
        }
        return this.modelObjectAssistantFactory.createAssistant();
    }

    public ModelObjectExtensionAssistant createDefaultModelObjectExtensionAssistant(String namespacePrefix) {
        CoreArgCheck.isNotEmpty((String)namespacePrefix, (String)"namespacePrefix is empty");
        ModelObjectExtensionAssistant assistant = this.createDefaultModelObjectExtensionAssistant();
        assistant.createModelExtensionDefinition(namespacePrefix, null, null, null, null, null);
        return assistant;
    }

    public ModelExtensionAssistantAggregator getModelExtensionAssistantAggregator() {
        if (this.assistantAggregator == null) {
            this.initializeMedRegistry();
        }
        return this.assistantAggregator;
    }

    public ModelExtensionRegistry getRegistry() {
        if (this.registry == null) {
            this.initializeMedRegistry();
        }
        return this.registry;
    }

    private void initializeMedRegistry() {
        try {
            this.registry = new ModelExtensionRegistry(this.getMedSchema());
            this.loadExtensibleMetamodelUriClassnameMap();
            this.registry.setMetamodelUris(this.metaclassNameProvidersMap.keySet());
            this.assistantAggregator = new ModelExtensionAssistantAggregator(this.registry);
            this.loadBuiltInMeds();
            this.loadDefinedMeds();
        }
        catch (Exception e) {
            Util.log((Throwable)e);
        }
    }

    public ExtendableMetaclassNameProvider getMetaclassNameProvider(String metaclassUri) {
        if (this.metaclassNameProvidersMap == null) {
            this.initializeMedRegistry();
        }
        return this.metaclassNameProvidersMap.get(metaclassUri);
    }

    public boolean isModelExtensionDefinitionRelated(Object modelObject) {
        for (String namespacePrefix : this.registry.getAllNamespacePrefixes()) {
            ModelExtensionAssistant assistant = this.registry.getModelExtensionAssistant(namespacePrefix);
            try {
                if (!(assistant instanceof ModelObjectExtensionAssistant) || !((ModelObjectExtensionAssistant)assistant).isModelExtensionDefinitionRelated(modelObject)) continue;
                return true;
            }
            catch (Exception e) {
                Util.log((Throwable)e);
            }
        }
        return false;
    }

    public File getMedSchema() throws Exception {
        if (this.schemaFile == null) {
            Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
            URL url = bundle.getEntry("modelExtension.xsd");
            if (url == null) {
                throw new Exception(NLS.bind((String)Messages.definitionSchemaFileNotFoundInWorkspace, (Object)PLUGIN_ID));
            }
            this.schemaFile = new File(FileLocator.toFileURL((URL)url).getFile());
            if (!this.schemaFile.exists()) {
                throw new Exception(NLS.bind((String)Messages.definitionSchemaFileNotFoundInFilesystem, (Object)PLUGIN_ID));
            }
        }
        return this.schemaFile;
    }

    private void loadExtensibleMetamodelUriClassnameMap() {
        IConfigurationElement[] configElements;
        String EXT_PT = String.valueOf(PLUGIN_ID) + ".extensibleMetamodelProvider";
        this.metaclassNameProvidersMap = new HashMap<String, ExtendableMetaclassNameProvider>();
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_PT);
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String metamodelUri;
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                String sElementName = configElement.getName();
                String pluginId = configElement.getNamespaceIdentifier();
                if ("definition".equals(sElementName) && (metamodelUri = configElement.getAttribute("metamodelUri")) != null && metamodelUri.trim().length() != 0) {
                    this.metaclassNameProvidersMap.put(metamodelUri, null);
                    Object provider = null;
                    try {
                        provider = configElement.createExecutableExtension("metaclassProviderClass");
                    }
                    catch (Exception exception) {
                        Util.log(4, NLS.bind((String)Messages.problemConstructingMetaclassNameProviderClass, (Object)ModelExtensionAssistant.class.getSimpleName(), (Object)pluginId));
                        break block6;
                    }
                    Object metaClassnameProvider = provider;
                    if (metaClassnameProvider != null && !(metaClassnameProvider instanceof ExtendableMetaclassNameProvider)) {
                        Util.log(4, NLS.bind((String)Messages.incorrectMetaclassNameProviderClass, (Object)metaClassnameProvider.getClass().getName(), (Object)pluginId));
                    } else {
                        this.metaclassNameProvidersMap.put(metamodelUri, (ExtendableMetaclassNameProvider)metaClassnameProvider);
                    }
                }
            }
            ++n2;
        }
    }

    private void loadBuiltInMeds() throws Exception {
        String EXT_PT = String.valueOf(PLUGIN_ID) + ".modelExtensionProvider";
        try {
            IConfigurationElement[] configElements;
            IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_PT);
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                block14: {
                    IConfigurationElement configElement = iConfigurationElementArray[n2];
                    String pluginId = configElement.getNamespaceIdentifier();
                    try {
                        ModelExtensionDefinition definition;
                        Path path;
                        String tempPath = configElement.getAttribute("path");
                        if (CoreStringUtil.isEmpty((String)tempPath)) {
                            Util.log(4, NLS.bind((String)Messages.missingDefinitionPath, (Object)pluginId, (Object)"path"));
                            break block14;
                        }
                        Bundle bundle = Platform.getBundle((String)pluginId);
                        URL url = FileLocator.find((Bundle)bundle, (IPath)(path = new Path(tempPath)), null);
                        if (url == null) {
                            Util.log(4, NLS.bind((String)Messages.definitionFileNotFoundInWorkspace, (Object)path, (Object)pluginId));
                            break block14;
                        }
                        File defnFile = new File(FileLocator.toFileURL((URL)url).getFile());
                        if (!defnFile.isFile() || !defnFile.exists()) {
                            Util.log(4, NLS.bind((String)Messages.definitionFileNotFoundInFilesystem, (Object)path, (Object)pluginId));
                            break block14;
                        }
                        Object tempAssistant = null;
                        try {
                            tempAssistant = configElement.createExecutableExtension("className");
                        }
                        catch (Exception exception) {
                            Util.log(4, NLS.bind((String)Messages.problemConstructingModelExtensionAssistantClass, (Object)ModelExtensionAssistant.class.getSimpleName(), (Object)pluginId));
                            break block14;
                        }
                        Object assistant = tempAssistant;
                        if (assistant != null && !(assistant instanceof ModelExtensionAssistant)) {
                            Util.log(4, NLS.bind((String)Messages.incorrectModelExtensionAssistantClass, (Object)assistant.getClass().getName(), (Object)pluginId));
                            break block14;
                        }
                        try {
                            definition = this.getRegistry().addDefinition(new FileInputStream(defnFile), (ModelExtensionAssistant)assistant);
                        }
                        catch (Exception ex) {
                            Util.log(4, (Throwable)ex, NLS.bind((String)Messages.errorProcessingDefinitionFile, (Object)path, (Object)pluginId));
                            throw ex;
                        }
                        if (definition != null) {
                            definition.markAsBuiltIn();
                        }
                    }
                    catch (Exception e) {
                        Util.log(4, (Throwable)e, NLS.bind((String)Messages.errorProcessingModelExtension, (Object)pluginId));
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Util.log(4, (Throwable)e, NLS.bind((String)Messages.errorProcessingExtensionPoint, (Object)EXT_PT));
            throw e;
        }
    }

    private void loadModelObjectExtensionAssistantFactories() {
        String EXT_PT = String.valueOf(PLUGIN_ID) + ".modelObjectExtensionAssistantFactory";
        try {
            IConfigurationElement[] configElements;
            IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_PT);
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    IConfigurationElement configElement = iConfigurationElementArray[n2];
                    String pluginId = configElement.getNamespaceIdentifier();
                    try {
                        Object tempFactory = null;
                        try {
                            tempFactory = configElement.createExecutableExtension("className");
                        }
                        catch (Exception exception) {
                            Util.log(4, NLS.bind((String)Messages.problemConstructingModelExtensionAssistantFactoryClass, (Object)ModelObjectExtensionAssistantFactory.class.getSimpleName(), (Object)pluginId));
                            break block8;
                        }
                        Object factory = tempFactory;
                        if (factory != null && !(factory instanceof ModelObjectExtensionAssistantFactory)) {
                            Util.log(4, NLS.bind((String)Messages.incorrectModelExtensionAssistantFactoryClass, (Object)factory.getClass().getName(), (Object)pluginId));
                            break block8;
                        }
                        this.modelObjectAssistantFactory = (ModelObjectExtensionAssistantFactory)factory;
                        break;
                    }
                    catch (Exception e) {
                        Util.log(4, (Throwable)e, NLS.bind((String)Messages.errorProcessingModelExtensionAssistantFactory, (Object)pluginId));
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Util.log(4, (Throwable)e, NLS.bind((String)Messages.errorProcessingExtensionPoint, (Object)EXT_PT));
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ((LoggingUtil)Util).initializePlatformLogger((Plugin)this);
        try {
            this.schemaFile = this.getMedSchema();
        }
        catch (Exception e) {
            Util.log((Throwable)e);
            throw e;
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.saveDefinedMeds();
        }
        finally {
            super.stop(context);
        }
    }

    public ModelExtensionDefinition parse(InputStream medFileStream) throws Exception {
        ModelExtensionDefinitionParser parser = new ModelExtensionDefinitionParser(this.getMedSchema());
        return parser.parse(medFileStream, this.createDefaultModelObjectExtensionAssistant());
    }

    private void saveDefinedMeds() {
        if (this.registry != null) {
            this.registry.saveDefinedDefinitions(this.getUserDefinitionsPath());
        }
    }

    private void loadDefinedMeds() throws CoreException {
        if (this.registry != null) {
            IStatus status = this.registry.restoreDefinedDefinitions(this.getUserDefinitionsPath());
            if (!status.isOK()) {
                Util.log(status);
            }
            if (status.getSeverity() == 4) {
                throw new CoreException(status);
            }
        }
    }

    public String getUserDefinitionsPath() {
        return this.getRuntimePath().toFile().getAbsolutePath();
    }

    public IPath getRuntimePath() {
        if (runtimePath == null) {
            runtimePath = ExtensionPlugin.getInstance().getStateLocation();
        }
        return (IPath)runtimePath.clone();
    }

    protected static class ModelObjectExtensionAssistantAdapter
    extends ModelObjectExtensionAssistant {
        protected ModelObjectExtensionAssistantAdapter() {
        }

        @Override
        public void cleanupModelResourceMEDs(Object modelResource) throws Exception {
        }

        @Override
        public ModelExtensionDefinition getModelExtensionDefinition(Object modelObject) throws Exception {
            return null;
        }

        @Override
        public String getOverriddenValue(Object modelObject, String propId) throws Exception {
            return null;
        }

        @Override
        public Properties getOverriddenValues(Object modelObject) throws Exception {
            return new Properties();
        }

        @Override
        public String getPropertyValue(Object modelObject, String propId) throws Exception {
            return null;
        }

        @Override
        public Properties getPropertyValues(Object modelObject) throws Exception {
            return new Properties();
        }

        @Override
        public Collection<String> getSupportedNamespaces(Object modelObject) throws Exception {
            return Collections.emptyList();
        }

        @Override
        public boolean hasExtensionProperties(File file) throws Exception {
            return false;
        }

        @Override
        public boolean hasExtensionProperties(Object modelObject) throws Exception {
            return false;
        }

        @Override
        public boolean isModelExtensionDefinitionRelated(Object modelObject) throws Exception {
            return false;
        }

        @Override
        public void removeModelExtensionDefinition(Object modelObject) throws Exception {
        }

        @Override
        public void removeProperty(Object modelObject, String propId) throws Exception {
        }

        @Override
        public void saveModelExtensionDefinition(Object modelObject) throws Exception {
        }

        @Override
        public void setPropertyValue(Object modelObject, String propId, String newValue) throws Exception {
        }

        @Override
        public boolean supportsMedOperation(String proposedOperationName, Object context) {
            return false;
        }

        @Override
        public boolean supportsMyNamespace(Object modelObject) throws Exception {
            return false;
        }

        @Override
        public boolean supportsProperty(Object modelObject, String propId) throws Exception {
            return false;
        }
    }

    public static class MxdResourceCollectorVisitor
    implements IResourceVisitor {
        List<IFile> resources = new ArrayList<IFile>();

        public boolean visit(IResource resource) {
            if (!resource.exists() || resource.getType() != 1) {
                return true;
            }
            if ("mxd".equalsIgnoreCase(resource.getFileExtension())) {
                this.resources.add((IFile)resource);
            }
            return true;
        }

        public Collection<IFile> getFileResources() {
            return Collections.unmodifiableCollection(this.resources);
        }
    }
}

