/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;

public class ModelExtensionAssistantAggregator {
    private final ModelExtensionRegistry registry;

    public ModelExtensionAssistantAggregator(ModelExtensionRegistry registry) {
        CoreArgCheck.isNotNull((Object)registry, (String)"registry is null");
        this.registry = registry;
    }

    public ModelObjectExtensionAssistant getModelObjectExtensionAssistant(String namespacePrefix) {
        ModelExtensionAssistant assistant = this.registry.getModelExtensionAssistant(namespacePrefix);
        if (assistant instanceof ModelObjectExtensionAssistant) {
            return (ModelObjectExtensionAssistant)assistant;
        }
        return null;
    }

    public Properties getOverriddenValues(Object modelObject) throws Exception {
        Properties props = new Properties();
        for (String namespacePrefix : this.registry.getAllNamespacePrefixes()) {
            ModelObjectExtensionAssistant assistant = this.getModelObjectExtensionAssistant(namespacePrefix);
            if (assistant == null || !assistant.supportsMyNamespace(modelObject)) continue;
            props.putAll((Map<?, ?>)assistant.getOverriddenValues(modelObject));
        }
        return props;
    }

    public Collection<ModelExtensionPropertyDefinition> getPropertyDefinitions(Object modelObject) throws Exception {
        String metaclassName = modelObject.getClass().getName();
        Collection<ModelExtensionAssistant> assistants = this.registry.getModelExtensionAssistants(metaclassName);
        if (assistants.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModelExtensionPropertyDefinition> propDefns = new ArrayList<ModelExtensionPropertyDefinition>();
        for (ModelExtensionAssistant assistant : assistants) {
            if (assistant instanceof ModelObjectExtensionAssistant) {
                propDefns.addAll(((ModelObjectExtensionAssistant)assistant).getPropertyDefinitions(modelObject));
                continue;
            }
            propDefns.addAll(assistant.getModelExtensionDefinition().getPropertyDefinitions(metaclassName));
        }
        return propDefns;
    }

    public Properties getPropertyValues(Object modelObject) throws Exception {
        Properties props = new Properties();
        for (String namespacePrefix : this.registry.getAllNamespacePrefixes()) {
            ModelObjectExtensionAssistant assistant = this.getModelObjectExtensionAssistant(namespacePrefix);
            if (assistant == null || !assistant.supportsMyNamespace(modelObject)) continue;
            props.putAll((Map<?, ?>)assistant.getPropertyValues(modelObject));
        }
        return props;
    }

    public Collection<String> getSupportedNamespacePrefixes(Object modelObject) throws Exception {
        ModelObjectExtensionAssistant assistant = ExtensionPlugin.getInstance().createDefaultModelObjectExtensionAssistant();
        return assistant.getSupportedNamespaces(modelObject);
    }

    public boolean hasExtensionProperties(File file) throws Exception {
        for (String namespacePrefix : this.registry.getAllNamespacePrefixes()) {
            ModelObjectExtensionAssistant assistant = this.getModelObjectExtensionAssistant(namespacePrefix);
            if (assistant == null || !assistant.hasExtensionProperties(file)) continue;
            return true;
        }
        return false;
    }

    public boolean hasExtensionProperties(Object modelObject) throws Exception {
        for (String namespacePrefix : this.registry.getAllNamespacePrefixes()) {
            ModelObjectExtensionAssistant assistant = this.getModelObjectExtensionAssistant(namespacePrefix);
            if (assistant == null || !assistant.hasExtensionProperties(modelObject)) continue;
            return true;
        }
        return false;
    }
}

