/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.convertor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.core.designer.util.StringUtilities;

public interface MxdConstants
extends StringConstants {
    public static final String EXTENSION_METADATA_PROP = "ExtensionMetadataProperty";
    public static final String TEIID_PACKAGE = "org.teiid.metadata";
    public static final String DESIGNER_PACKAGE = "org.teiid.designer.metamodels.relational.impl";
    public static final String IMPL = "Impl";

    public static enum AnnotationProperties {
        APPLICABLE,
        ADVANCED,
        DATATYPE,
        DISPLAY,
        DESCRIPTION,
        REQUIRED;


        public Object getId() {
            return this.name().toLowerCase();
        }

        public static AnnotationProperties findKey(String id) {
            AnnotationProperties[] annotationPropertiesArray = AnnotationProperties.values();
            int n = annotationPropertiesArray.length;
            int n2 = 0;
            while (n2 < n) {
                AnnotationProperties property = annotationPropertiesArray[n2];
                if (property.getId().equals(id)) {
                    return property;
                }
                ++n2;
            }
            throw new IllegalStateException("Annotation property with id " + id + " does not exist");
        }
    }

    public static enum TargetObjectMappings {
        TABLE,
        PROCEDURE,
        COLUMN;

        private final String className = StringUtilities.upperCaseFirstChar((String)this.name().toLowerCase());

        public String getDesignerClass() {
            if (TABLE.name().equals(this.name())) {
                return "org.teiid.designer.metamodels.relational.impl.Base" + this.className + MxdConstants.IMPL;
            }
            return "org.teiid.designer.metamodels.relational.impl." + this.className + MxdConstants.IMPL;
        }

        public String getTeiidClass() {
            return "org.teiid.metadata." + this.className;
        }

        public String getAnnotationClass() {
            return String.valueOf(this.className) + "." + "class";
        }
    }

    public static enum ValidDataTypes {
        BIG_INTEGER(BigInteger.class),
        BIG_DECIMAL(BigDecimal.class),
        BLOB(Blob.class),
        BOOLEAN(Boolean.class),
        BYTE(Byte.class),
        CHAR(Character.TYPE),
        CLOB(Clob.class),
        DATE(Date.class),
        DOUBLE(Double.class),
        FLOAT(Float.class),
        INTEGER(Integer.class),
        LONG(Long.class),
        OBJECT(Object.class),
        SHORT(Short.TYPE),
        STRING(String.class),
        TIME(Time.class),
        TIMESTAMP(Timestamp.class),
        XML("xml");

        private final String id;

        private ValidDataTypes(String id) {
            this.id = id.toLowerCase();
        }

        private ValidDataTypes(Class<?> dataClass) {
            this(dataClass.getSimpleName());
        }

        public String id() {
            return this.id;
        }

        public static boolean validateDataType(String dataType) {
            ValidDataTypes[] validDataTypesArray = ValidDataTypes.values();
            int n = validDataTypesArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValidDataTypes validDataType = validDataTypesArray[n2];
                if (validDataType.id().equals(dataType)) {
                    return true;
                }
                ++n2;
            }
            throw new IllegalStateException("The data type " + dataType + " is not recognised");
        }
    }
}

