/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.convertor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.teiid.designer.extension.convertor.MxdConstants;
import org.teiid.designer.extension.convertor.mxd.DisplayType;
import org.teiid.designer.extension.convertor.mxd.MetaclassType;
import org.teiid.designer.extension.convertor.mxd.ObjectFactory;
import org.teiid.designer.extension.convertor.mxd.PropertyType;

public class TranslatorAnnotationVisitor
extends ASTVisitor
implements MxdConstants {
    private final ObjectFactory factory = new ObjectFactory();
    private final Context context = new Context();
    private final Map<String, MetaclassType> metaclassTypeMap = new HashMap<String, MetaclassType>();

    public Collection<MetaclassType> getMetaclasses() {
        return this.metaclassTypeMap.values();
    }

    private boolean isExtMetadataAnnotation(Object node) {
        if (!(node instanceof Annotation)) {
            return false;
        }
        return "ExtensionMetadataProperty".equals(((Annotation)node).getTypeName().toString());
    }

    private boolean toBoolean(String value) {
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }

    private MetaclassType getMetaclassType(String name) {
        if (name == null) {
            throw new IllegalStateException("The MetaclassType name cannot be null");
        }
        MetaclassType metaclassType = this.metaclassTypeMap.get(name);
        if (metaclassType == null) {
            metaclassType = this.factory.createMetaclassType();
            if (MxdConstants.TargetObjectMappings.TABLE.getAnnotationClass().equals(name)) {
                metaclassType.setName(MxdConstants.TargetObjectMappings.TABLE.getDesignerClass());
            } else if (MxdConstants.TargetObjectMappings.PROCEDURE.getAnnotationClass().equals(name)) {
                metaclassType.setName(MxdConstants.TargetObjectMappings.PROCEDURE.getDesignerClass());
            } else if (MxdConstants.TargetObjectMappings.COLUMN.getAnnotationClass().equals(name)) {
                metaclassType.setName(MxdConstants.TargetObjectMappings.COLUMN.getDesignerClass());
            } else {
                throw new IllegalStateException("Unsupported MetaclassType " + name);
            }
            this.metaclassTypeMap.put(name, metaclassType);
        }
        return metaclassType;
    }

    public boolean visit(FieldDeclaration node) {
        for (Object modifier : node.modifiers()) {
            if (!this.isExtMetadataAnnotation(modifier)) continue;
            return true;
        }
        return false;
    }

    private Map<MxdConstants.AnnotationProperties, String> getAnnotationProperties(NormalAnnotation node) {
        HashMap<MxdConstants.AnnotationProperties, String> valueMap = new HashMap<MxdConstants.AnnotationProperties, String>();
        for (Object obj : node.values()) {
            if (!(obj instanceof MemberValuePair)) continue;
            MemberValuePair annoValuePair = (MemberValuePair)obj;
            String id = annoValuePair.getName().toString();
            MxdConstants.AnnotationProperties key = MxdConstants.AnnotationProperties.findKey(id);
            valueMap.put(key, annoValuePair.getValue().toString());
        }
        return valueMap;
    }

    public boolean visit(NormalAnnotation node) {
        String[] appClasses;
        if (!this.isExtMetadataAnnotation(node)) {
            return false;
        }
        if (!(node.getParent() instanceof FieldDeclaration)) {
            return false;
        }
        FieldDeclaration parent = (FieldDeclaration)node.getParent();
        Map<MxdConstants.AnnotationProperties, String> properties = this.getAnnotationProperties(node);
        String appProperty = properties.get((Object)MxdConstants.AnnotationProperties.APPLICABLE);
        if (appProperty == null) {
            throw new IllegalStateException("An annotation " + node.getTypeName() + " does not contain an applicable property");
        }
        String[] stringArray = appClasses = appProperty.replaceAll("[{|}| ]", "").split(",");
        int n = appClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String dataType;
            String displayName;
            String appClass = stringArray[n2];
            MetaclassType metaclassType = this.getMetaclassType(appClass);
            PropertyType propertyType = this.factory.createPropertyType();
            metaclassType.getProperty().add(propertyType);
            propertyType.setAdvanced(this.toBoolean(properties.get((Object)MxdConstants.AnnotationProperties.ADVANCED)));
            propertyType.setRequired(this.toBoolean(properties.get((Object)MxdConstants.AnnotationProperties.REQUIRED)));
            String description = properties.get((Object)MxdConstants.AnnotationProperties.DESCRIPTION);
            if (description != null) {
                DisplayType descriptionType = this.factory.createDisplayType();
                descriptionType.setValue(description);
                propertyType.getDescription().add(descriptionType);
            }
            if ((displayName = properties.get((Object)MxdConstants.AnnotationProperties.DISPLAY)) != null) {
                displayName = displayName.replaceAll("\"", "");
                DisplayType displayType = this.factory.createDisplayType();
                displayType.setValue(displayName);
                propertyType.getDisplay().add(displayType);
            }
            if ((dataType = properties.get((Object)MxdConstants.AnnotationProperties.DATATYPE)) != null) {
                dataType = dataType.toLowerCase().split("\\.")[0];
                MxdConstants.ValidDataTypes.validateDataType(dataType);
                propertyType.setType(dataType);
            }
            this.context.add(parent, propertyType);
            ++n2;
        }
        return true;
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (!(node.getParent() instanceof FieldDeclaration)) {
            return false;
        }
        FieldDeclaration parent = (FieldDeclaration)node.getParent();
        List<PropertyType> properties = this.context.get(parent);
        if (properties == null) {
            throw new IllegalStateException("No properties found for the field " + parent.toString());
        }
        String name = node.getInitializer().toString();
        String[] segments = name.split("\\+");
        name = segments[segments.length - 1];
        name = name.replaceAll("[\"| ]", "");
        for (PropertyType property : properties) {
            property.setName(name);
        }
        return false;
    }

    public boolean visit(CompilationUnit node) {
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        return true;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        return false;
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        return false;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    public boolean visit(ArrayAccess node) {
        return false;
    }

    public boolean visit(ArrayCreation node) {
        return false;
    }

    public boolean visit(ArrayInitializer node) {
        return false;
    }

    public boolean visit(ArrayType node) {
        return false;
    }

    public boolean visit(AssertStatement node) {
        return false;
    }

    public boolean visit(Assignment node) {
        return false;
    }

    public boolean visit(Block node) {
        return false;
    }

    public boolean visit(BlockComment node) {
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        return false;
    }

    public boolean visit(BreakStatement node) {
        return false;
    }

    public boolean visit(CastExpression node) {
        return false;
    }

    public boolean visit(CatchClause node) {
        return false;
    }

    public boolean visit(CharacterLiteral node) {
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        return false;
    }

    public boolean visit(ConditionalExpression node) {
        return false;
    }

    public boolean visit(ConstructorInvocation node) {
        return false;
    }

    public boolean visit(ContinueStatement node) {
        return false;
    }

    public boolean visit(DoStatement node) {
        return false;
    }

    public boolean visit(EmptyStatement node) {
        return false;
    }

    public boolean visit(EnhancedForStatement node) {
        return false;
    }

    public boolean visit(EnumConstantDeclaration node) {
        return false;
    }

    public boolean visit(EnumDeclaration node) {
        return false;
    }

    public boolean visit(ExpressionStatement node) {
        return false;
    }

    public boolean visit(FieldAccess node) {
        return false;
    }

    public boolean visit(ForStatement node) {
        return false;
    }

    public boolean visit(IfStatement node) {
        return false;
    }

    public boolean visit(ImportDeclaration node) {
        return false;
    }

    public boolean visit(InfixExpression node) {
        return false;
    }

    public boolean visit(InstanceofExpression node) {
        return false;
    }

    public boolean visit(Initializer node) {
        return false;
    }

    public boolean visit(LabeledStatement node) {
        return false;
    }

    public boolean visit(LineComment node) {
        return false;
    }

    public boolean visit(MarkerAnnotation node) {
        return false;
    }

    public boolean visit(MemberRef node) {
        return false;
    }

    public boolean visit(MemberValuePair node) {
        return false;
    }

    public boolean visit(MethodRef node) {
        return false;
    }

    public boolean visit(MethodRefParameter node) {
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        return false;
    }

    public boolean visit(MethodInvocation node) {
        return false;
    }

    public boolean visit(Modifier node) {
        return false;
    }

    public boolean visit(NullLiteral node) {
        return false;
    }

    public boolean visit(NumberLiteral node) {
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        return false;
    }

    public boolean visit(ParameterizedType node) {
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        return false;
    }

    public boolean visit(PostfixExpression node) {
        return false;
    }

    public boolean visit(PrefixExpression node) {
        return false;
    }

    public boolean visit(PrimitiveType node) {
        return false;
    }

    public boolean visit(QualifiedName node) {
        return false;
    }

    public boolean visit(QualifiedType node) {
        return false;
    }

    public boolean visit(ReturnStatement node) {
        return false;
    }

    public boolean visit(SimpleName node) {
        return false;
    }

    public boolean visit(SimpleType node) {
        return false;
    }

    public boolean visit(SingleMemberAnnotation node) {
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        return false;
    }

    public boolean visit(StringLiteral node) {
        return false;
    }

    public boolean visit(SuperConstructorInvocation node) {
        return false;
    }

    public boolean visit(SuperFieldAccess node) {
        return false;
    }

    public boolean visit(SuperMethodInvocation node) {
        return false;
    }

    public boolean visit(SwitchCase node) {
        return false;
    }

    public boolean visit(SwitchStatement node) {
        return false;
    }

    public boolean visit(SynchronizedStatement node) {
        return false;
    }

    public boolean visit(TagElement node) {
        return false;
    }

    public boolean visit(TextElement node) {
        return false;
    }

    public boolean visit(ThisExpression node) {
        return false;
    }

    public boolean visit(ThrowStatement node) {
        return false;
    }

    public boolean visit(TryStatement node) {
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        return false;
    }

    public boolean visit(TypeLiteral node) {
        return false;
    }

    public boolean visit(TypeParameter node) {
        return false;
    }

    public boolean visit(UnionType node) {
        return false;
    }

    public boolean visit(VariableDeclarationExpression node) {
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        return false;
    }

    public boolean visit(WhileStatement node) {
        return false;
    }

    public boolean visit(WildcardType node) {
        return false;
    }

    private class Context {
        private Map<FieldDeclaration, List<PropertyType>> cache = new HashMap<FieldDeclaration, List<PropertyType>>();

        private Context() {
        }

        public void add(FieldDeclaration parent, PropertyType propertyType) {
            List<PropertyType> properties = this.cache.get(parent);
            if (properties == null) {
                properties = new ArrayList<PropertyType>();
                this.cache.put(parent, properties);
            }
            properties.add(propertyType);
        }

        public List<PropertyType> get(FieldDeclaration parent) {
            return this.cache.get(parent);
        }
    }
}

