/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.extension.definition;

import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.extension.ExtensionConstants;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelExtensionDefinitionHeader;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinitionImpl;
import org.teiid.designer.extension.properties.Translation;

public abstract class ModelExtensionAssistant
implements ExtensionConstants {
    private ModelExtensionDefinition definition;

    public boolean addSupportedModelType(String modelType) {
        CoreArgCheck.isNotEmpty((String)modelType, (String)"modelType is empty");
        assert (this.definition != null) : "model extension definition is null";
        return this.definition.addModelType(modelType);
    }

    public void addPropertyDefinition(String metaclassName, ModelExtensionPropertyDefinition propertyDefinition) {
        assert (this.definition != null) : "model extension definition is null";
        this.definition.addPropertyDefinition(metaclassName, propertyDefinition);
    }

    public ModelExtensionDefinition createModelExtensionDefinition(String namespacePrefix, String namespaceUri, String metamodelUri, Set<String> modelTypes, String description, String version) {
        if (this.definition == null || !this.definition.isBuiltIn()) {
            this.definition = new ModelExtensionDefinition(this, namespacePrefix, namespaceUri, metamodelUri, description, version);
            if (modelTypes != null && !modelTypes.isEmpty()) {
                for (String modelType : modelTypes) {
                    this.addSupportedModelType(modelType);
                }
            }
        }
        return this.definition;
    }

    public ModelExtensionDefinition createModelExtensionDefinition(ModelExtensionDefinitionHeader medHeader) {
        CoreArgCheck.isNotNull((Object)medHeader, (String)"ModelExtensionDefinitionHeader is null");
        return this.createModelExtensionDefinition(medHeader.getNamespacePrefix(), medHeader.getNamespaceUri(), medHeader.getMetamodelUri(), medHeader.getSupportedModelTypes(), medHeader.getDescription(), String.valueOf(medHeader.getVersion()));
    }

    public ModelExtensionPropertyDefinition createPropertyDefinition(String simpleId, String runtimeType, String required, String defaultValue, String fixedValue, String advanced, String masked, String index, Set<String> allowedValues, Set<Translation> descriptions, Set<Translation> displayNames) {
        assert (this.definition != null) : "model extension definition is null";
        return new ModelExtensionPropertyDefinitionImpl(this.definition, simpleId, runtimeType, required, defaultValue, fixedValue, advanced, masked, index, allowedValues, descriptions, displayNames);
    }

    public ModelExtensionDefinition getModelExtensionDefinition() {
        return this.definition;
    }

    public final String getNamespacePrefix() {
        return this.definition.getNamespacePrefix();
    }

    public boolean supportsMedOperation(String proposedOperationName, Object context) {
        CoreArgCheck.isNotEmpty((String)proposedOperationName, (String)"proposedOperationName is empty");
        return !"DELETE_MED_FROM_REGISTRY".equals(proposedOperationName) || !this.getModelExtensionDefinition().isBuiltIn();
    }

    public abstract void applyMedIfNecessary(IResource var1) throws Exception;
}

